/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard;

import javax.swing.JPanel;
import org.netbeans.modules.apisupport.project.ui.wizard.NewModuleProjectData;
import org.netbeans.modules.apisupport.project.ui.wizard.NewNbModuleWizardIterator;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

public abstract class BasicVisualPanel
extends JPanel {
    private WizardDescriptor settings;

    protected BasicVisualPanel(WizardDescriptor wizardDescriptor) {
        this.settings = wizardDescriptor;
    }

    public final WizardDescriptor getSettings() {
        return this.settings;
    }

    protected final void setError(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.setMessage(string);
        this.setValid(false);
    }

    protected final void setWarning(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.setMessage(string);
        this.setValid(true);
    }

    protected final void markInvalid() {
        this.setMessage(null);
        this.setValid(false);
    }

    protected final void markValid() {
        this.setMessage(null);
        this.setValid(true);
    }

    private final void setMessage(String string) {
        this.settings.putProperty("WizardPanel_errorMessage", (Object)string);
    }

    private final void setValid(boolean bl) {
        this.firePropertyChange("valid", null, (Object)bl);
    }

    protected static abstract class NewTemplatePanel
    extends BasicVisualPanel {
        private final NewModuleProjectData data;

        NewTemplatePanel(NewModuleProjectData newModuleProjectData) {
            super(newModuleProjectData.getSettings());
            String string;
            this.data = newModuleProjectData;
            switch (newModuleProjectData.getWizardType()) {
                case SUITE: {
                    string = "emptySuite";
                    break;
                }
                case APPLICATION: {
                    string = "emptyApplication";
                    break;
                }
                case MODULE: 
                case SUITE_COMPONENT: {
                    string = "emptyModule";
                    break;
                }
                case LIBRARY_MODULE: {
                    string = "libraryModule";
                    break;
                }
                default: {
                    assert (false) : "Unknown wizard type = " + (Object)((Object)newModuleProjectData.getWizardType());
                    string = "";
                }
            }
            newModuleProjectData.getSettings().putProperty("NewProjectWizard_Title", (Object)NbBundle.getMessage(BasicVisualPanel.class, (String)("Templates/Project/APISupport/" + string)));
        }

        protected NewModuleProjectData getData() {
            return this.data;
        }

        protected boolean isSuiteWizard() {
            return this.getData().getWizardType() == NewNbModuleWizardIterator.Type.SUITE || this.getData().getWizardType() == NewNbModuleWizardIterator.Type.APPLICATION;
        }

        protected boolean isSuiteComponentWizard() {
            return this.getData().getWizardType() == NewNbModuleWizardIterator.Type.SUITE_COMPONENT;
        }

        protected boolean isLibraryWizard() {
            return this.getData().getWizardType() == NewNbModuleWizardIterator.Type.LIBRARY_MODULE;
        }
    }
}

