/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.netbeans.modules.apisupport.project.ui.customizer.SplashComponentPreview;

final class DragManager
implements DragGestureListener,
DragSourceListener,
DropTargetListener,
MouseMotionListener {
    private JComponent component;
    private DragGestureRecognizer dRecognizer;
    private DragSource dSource;
    private DropTarget dTarget;
    private int translateX;
    private int translateY;
    private final Cursor oCursor;
    List<DragItem> allItems = new ArrayList<DragItem>();
    private DragItem activeDragItem = null;

    DragManager(JComponent jComponent) {
        this.component = jComponent;
        this.dSource = new DragSource();
        this.dRecognizer = this.dSource.createDefaultDragGestureRecognizer(this.component, 2, this);
        this.dTarget = new DropTarget(this.component, 2, this);
        jComponent.addMouseMotionListener(this);
        this.oCursor = jComponent.getCursor();
    }

    DragItem createNewItem() {
        DragItem dragItem = new DragItem();
        this.allItems.add(dragItem);
        return dragItem;
    }

    void setTranslate(int n, int n2) {
        this.translateX = -n;
        this.translateY = -n2;
        SplashComponentPreview splashComponentPreview = (SplashComponentPreview)this.component;
        Rectangle rectangle = new Rectangle(new Dimension(splashComponentPreview.image.getWidth(null), splashComponentPreview.image.getHeight(null)));
        for (DragItem dragItem : this.allItems) {
            dragItem.setBounds(rectangle);
        }
    }

    public void paint(Graphics graphics) {
        graphics.setXORMode(Color.white);
        for (DragItem dragItem : this.allItems) {
            dragItem.paint(graphics);
        }
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        Point point = dragGestureEvent.getDragOrigin();
        DragItem dragItem = this.getDragItem(this.transformMousePoint(point));
        if (dragItem != null) {
            this.activeDragItem = dragItem;
            this.activeDragItem.setGesturePoint(point);
            Cursor cursor = this.activeDragItem.getCursor();
            assert (cursor != null);
            dragGestureEvent.startDrag(cursor, new StringSelection(""), this);
            this.component.repaint();
        }
    }

    private Point transformMousePoint(Point point) {
        return new Point(point.x + this.translateX, point.y + this.translateY);
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        if (!dragSourceDropEvent.getDropSuccess() && this.activeDragItem != null) {
            this.activeDragItem.dragAccepted();
        }
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        this.dragOverImpl(dropTargetDragEvent.getLocation());
    }

    private void dragOverImpl(Point point) {
        if (this.activeDragItem != null) {
            this.activeDragItem.recalculateSize(point);
            this.activeDragItem.updateSize();
            this.activeDragItem.scroll(this.component);
            this.component.repaint();
        }
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        if (dropTargetDropEvent.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            dropTargetDropEvent.dropComplete(true);
            if (this.activeDragItem != null) {
                this.activeDragItem.dragAccepted();
            }
        } else {
            dropTargetDropEvent.rejectDrop();
        }
        this.component.setCursor(this.oCursor);
        this.activeDragItem = null;
        this.component.repaint();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.activeDragItem = null;
        DragItem dragItem = null;
        for (DragItem dragItem2 : this.allItems) {
            if (!dragItem2.contains(this.transformMousePoint(mouseEvent.getPoint()))) continue;
            dragItem = dragItem2;
            break;
        }
        if (dragItem != null) {
            Cursor cursor = dragItem.getCursor();
            this.component.setCursor(cursor);
        } else {
            this.component.setCursor(this.oCursor);
        }
    }

    DragItem getDragItem(Point point) {
        DragItem dragItem = null;
        for (DragItem dragItem2 : this.allItems) {
            if (!dragItem2.contains(point)) continue;
            dragItem = dragItem2;
            break;
        }
        return dragItem;
    }

    private static interface Mode {
        public boolean contains(Point var1);

        public void updateSize(Rectangle var1);

        public void recalculateSize(Point var1);

        public void paint(Graphics var1);

        public Cursor getCursor();
    }

    static class DragItem
    implements Mode {
        private Point gesturePoint = new Point();
        private Rectangle rectangle = new Rectangle();
        private Rectangle currentDragRect = new Rectangle();
        private Mode dragMode;
        private DropHandler dHandler;
        private Rectangle bounds;
        private Mode[] allmodes = new Mode[9];
        private boolean enabled = true;

        DragItem() {
            this.allmodes[0] = new OneSideScaleMode(5);
            this.allmodes[1] = new OneSideScaleMode(7);
            this.allmodes[2] = new OneSideScaleMode(8);
            this.allmodes[3] = new OneSideScaleMode(6);
            this.allmodes[4] = new ScaleMode(0);
            this.allmodes[5] = new ScaleMode(1);
            this.allmodes[6] = new ScaleMode(2);
            this.allmodes[7] = new ScaleMode(3);
            this.allmodes[8] = new MoveMode();
        }

        void setDropHandler(DropHandler dropHandler) {
            this.dHandler = dropHandler;
        }

        public void dragAccepted() {
            if (this.dHandler != null) {
                this.dHandler.dragAccepted(this.rectangle, this.currentDragRect);
            }
        }

        void setRectangle(Rectangle rectangle) {
            this.rectangle.setBounds(rectangle);
            this.currentDragRect.setBounds(rectangle);
            this.updateSize(rectangle);
        }

        void setGesturePoint(Point point) {
            this.gesturePoint = point;
        }

        Point getGesturePoint() {
            return this.gesturePoint;
        }

        public boolean contains(Point point) {
            Mode mode = null;
            if (this.isEnabled()) {
                for (int i = 0; i < this.allmodes.length; ++i) {
                    if (!this.allmodes[i].contains(point)) continue;
                    mode = this.allmodes[i];
                    break;
                }
            }
            this.dragMode = mode;
            return mode != null;
        }

        public void updateSize() {
            this.updateSize(this.currentDragRect);
        }

        public void updateSize(Rectangle rectangle) {
            for (int i = 0; i < this.allmodes.length; ++i) {
                this.allmodes[i].updateSize(rectangle);
            }
        }

        public void recalculateSize(Point point) {
            if (this.dragMode != null && !point.equals(this.gesturePoint)) {
                Rectangle rectangle = new Rectangle();
                rectangle.setBounds(this.currentDragRect);
                this.dragMode.recalculateSize(point);
                int n = this.currentDragRect.x;
                int n2 = this.currentDragRect.y;
                int n3 = this.currentDragRect.width;
                int n4 = this.currentDragRect.height;
                if (this.bounds != null && !this.bounds.contains(this.currentDragRect)) {
                    if (n4 + n2 > this.bounds.height + this.bounds.y) {
                        if (n2 == rectangle.y) {
                            n4 = this.bounds.height + this.bounds.y - n2;
                        } else {
                            n2 = this.bounds.height + this.bounds.y - n4;
                        }
                    }
                    if (n3 + n > this.bounds.width + this.bounds.x) {
                        if (n == rectangle.x) {
                            n3 = this.bounds.width + this.bounds.x - n;
                        } else {
                            n = this.bounds.width + this.bounds.x - n3;
                        }
                    }
                    if (n < this.bounds.x) {
                        n = this.bounds.x;
                    }
                    if (n2 < this.bounds.y) {
                        n2 = this.bounds.y;
                    }
                    this.currentDragRect.setBounds(n, n2, n3, n4);
                }
                if (n3 <= 3 || n4 <= 3 && !(this.dragMode instanceof MoveMode)) {
                    this.currentDragRect.setBounds(rectangle);
                }
            }
        }

        public void scroll(JComponent jComponent) {
            jComponent.scrollRectToVisible(this.currentDragRect);
        }

        void setBounds(Rectangle rectangle) {
            this.bounds = rectangle;
        }

        public void paint(Graphics graphics) {
            if (this.isEnabled()) {
                for (int i = 0; i < this.allmodes.length; ++i) {
                    this.allmodes[i].paint(graphics);
                }
            }
        }

        public Cursor getCursor() {
            return this.dragMode != null ? this.dragMode.getCursor() : null;
        }

        boolean isEnabled() {
            return this.enabled;
        }

        void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        private class OneSideScaleMode
        implements Mode {
            static final int N_RESIZE_MODE = 5;
            static final int E_RESIZE_MODE = 6;
            static final int S_RESIZE_MODE = 7;
            static final int W_RESIZE_MODE = 8;
            private int resizeMode = -1;
            private Rectangle rec = new Rectangle();

            OneSideScaleMode(int n) {
                this.resizeMode = n;
            }

            public boolean contains(Point point) {
                assert (this.resizeMode != -1);
                assert (this.rec != null);
                return this.rec.contains(point);
            }

            public void updateSize(Rectangle rectangle) {
                assert (this.resizeMode != -1);
                int n = 5;
                switch (this.resizeMode) {
                    case 5: {
                        this.rec = new Rectangle(rectangle.x + n, rectangle.y - 2 * n, rectangle.width - n, 2 * n);
                        break;
                    }
                    case 6: {
                        this.rec = new Rectangle(rectangle.x + rectangle.width, rectangle.y + n, 2 * n, rectangle.height - n);
                        break;
                    }
                    case 7: {
                        this.rec = new Rectangle(rectangle.x + n, rectangle.y + rectangle.height, rectangle.width - n, 2 * n);
                        break;
                    }
                    case 8: {
                        this.rec = new Rectangle(rectangle.x - 2 * n, rectangle.y + n, 2 * n, rectangle.height - n);
                    }
                }
            }

            public void paint(Graphics graphics) {
                assert (this.resizeMode != -1);
                assert (this.rec != null);
                int n = 5;
                Graphics2D graphics2D = (Graphics2D)graphics;
                Stroke stroke = graphics2D.getStroke();
                graphics2D.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{3.0f}, 0.0f));
                Rectangle2D rectangle2D = this.rec.getBounds2D();
                Line2D.Double double_ = null;
                switch (this.resizeMode) {
                    case 5: {
                        double_ = new Line2D.Double(rectangle2D.getMinX(), rectangle2D.getMaxY(), rectangle2D.getMaxX() - (double)n, rectangle2D.getMaxY());
                        break;
                    }
                    case 6: {
                        double_ = new Line2D.Double(rectangle2D.getMinX(), rectangle2D.getMinY(), rectangle2D.getMinX(), rectangle2D.getMaxY() - (double)n);
                        break;
                    }
                    case 7: {
                        double_ = new Line2D.Double(rectangle2D.getMinX(), rectangle2D.getMinY(), rectangle2D.getMaxX() - (double)n, rectangle2D.getMinY());
                        break;
                    }
                    case 8: {
                        double_ = new Line2D.Double(rectangle2D.getMaxX(), rectangle2D.getMinY(), rectangle2D.getMaxX(), rectangle2D.getMaxY() - (double)n);
                    }
                }
                graphics2D.draw(double_);
                graphics2D.setStroke(stroke);
            }

            public Cursor getCursor() {
                assert (this.resizeMode != -1);
                assert (this.rec != null);
                Cursor cursor = null;
                switch (this.resizeMode) {
                    case 5: {
                        cursor = Cursor.getPredefinedCursor(8);
                        break;
                    }
                    case 6: {
                        cursor = Cursor.getPredefinedCursor(11);
                        break;
                    }
                    case 7: {
                        cursor = Cursor.getPredefinedCursor(9);
                        break;
                    }
                    case 8: {
                        cursor = Cursor.getPredefinedCursor(10);
                    }
                }
                assert (cursor != null);
                return cursor;
            }

            public void recalculateSize(Point point) {
                int n = point.x - ((DragItem)DragItem.this).gesturePoint.x;
                int n2 = point.y - ((DragItem)DragItem.this).gesturePoint.y;
                switch (this.resizeMode) {
                    case 5: {
                        DragItem.this.currentDragRect.setBounds(((DragItem)DragItem.this).rectangle.x, ((DragItem)DragItem.this).rectangle.y + n2, ((DragItem)DragItem.this).rectangle.width, ((DragItem)DragItem.this).rectangle.height - n2);
                        break;
                    }
                    case 6: {
                        DragItem.this.currentDragRect.setBounds(((DragItem)DragItem.this).rectangle.x, ((DragItem)DragItem.this).rectangle.y, ((DragItem)DragItem.this).rectangle.width + n, ((DragItem)DragItem.this).rectangle.height);
                        break;
                    }
                    case 7: {
                        DragItem.this.currentDragRect.setBounds(((DragItem)DragItem.this).rectangle.x, ((DragItem)DragItem.this).rectangle.y, ((DragItem)DragItem.this).rectangle.width, ((DragItem)DragItem.this).rectangle.height + n2);
                        break;
                    }
                    case 8: {
                        DragItem.this.currentDragRect.setBounds(((DragItem)DragItem.this).rectangle.x + n, ((DragItem)DragItem.this).rectangle.y, ((DragItem)DragItem.this).rectangle.width - n, ((DragItem)DragItem.this).rectangle.height);
                    }
                }
            }
        }

        private class ScaleMode
        implements Mode {
            static final int NW_RESIZE_MODE = 0;
            static final int NE_RESIZE_MODE = 1;
            static final int SW_RESIZE_MODE = 2;
            static final int SE_RESIZE_MODE = 3;
            private int resizeMode = -1;
            private Rectangle rec = new Rectangle();

            ScaleMode(int n) {
                this.resizeMode = n;
            }

            public boolean contains(Point point) {
                assert (this.resizeMode != -1);
                assert (this.rec != null);
                return this.rec.contains(point);
            }

            public void updateSize(Rectangle rectangle) {
                assert (this.resizeMode != -1);
                int n = Math.min(Math.min(5, rectangle.width / 5), Math.min(5, rectangle.height / 5));
                Dimension dimension = new Dimension(n * 2, n * 2);
                Point point = new Point(rectangle.x - n, rectangle.y - n);
                switch (this.resizeMode) {
                    case 0: {
                        this.rec = new Rectangle(point, dimension);
                        break;
                    }
                    case 1: {
                        this.rec = new Rectangle(new Point(point.x + rectangle.width, point.y), dimension);
                        break;
                    }
                    case 2: {
                        this.rec = new Rectangle(new Point(point.x, point.y + rectangle.height), dimension);
                        break;
                    }
                    case 3: {
                        this.rec = new Rectangle(new Point(point.x + rectangle.width, point.y + rectangle.height), dimension);
                    }
                }
            }

            public void paint(Graphics graphics) {
                assert (this.resizeMode != -1);
                assert (this.rec != null);
                graphics.fillRect(this.rec.x, this.rec.y, this.rec.width, this.rec.height);
            }

            public Cursor getCursor() {
                assert (this.resizeMode != -1);
                assert (this.rec != null);
                Cursor cursor = null;
                switch (this.resizeMode) {
                    case 0: {
                        cursor = Cursor.getPredefinedCursor(6);
                        break;
                    }
                    case 1: {
                        cursor = Cursor.getPredefinedCursor(7);
                        break;
                    }
                    case 2: {
                        cursor = Cursor.getPredefinedCursor(4);
                        break;
                    }
                    case 3: {
                        cursor = Cursor.getPredefinedCursor(5);
                    }
                }
                assert (cursor != null);
                return cursor;
            }

            public void recalculateSize(Point point) {
                int n = point.x - ((DragItem)DragItem.this).gesturePoint.x;
                int n2 = point.y - ((DragItem)DragItem.this).gesturePoint.y;
                switch (this.resizeMode) {
                    case 0: {
                        DragItem.this.currentDragRect.setBounds(((DragItem)DragItem.this).rectangle.x + n, ((DragItem)DragItem.this).rectangle.y + n2, ((DragItem)DragItem.this).rectangle.width - n, ((DragItem)DragItem.this).rectangle.height - n2);
                        break;
                    }
                    case 1: {
                        DragItem.this.currentDragRect.setBounds(((DragItem)DragItem.this).rectangle.x, ((DragItem)DragItem.this).rectangle.y + n2, ((DragItem)DragItem.this).rectangle.width + n, ((DragItem)DragItem.this).rectangle.height - n2);
                        break;
                    }
                    case 2: {
                        DragItem.this.currentDragRect.setBounds(((DragItem)DragItem.this).rectangle.x + n, ((DragItem)DragItem.this).rectangle.y, ((DragItem)DragItem.this).rectangle.width - n, ((DragItem)DragItem.this).rectangle.height + n2);
                        break;
                    }
                    case 3: {
                        DragItem.this.currentDragRect.setBounds(((DragItem)DragItem.this).rectangle.x, ((DragItem)DragItem.this).rectangle.y, ((DragItem)DragItem.this).rectangle.width + n, ((DragItem)DragItem.this).rectangle.height + n2);
                    }
                }
            }
        }

        private class MoveMode
        implements Mode {
            private MoveMode() {
            }

            public boolean contains(Point point) {
                return DragItem.this.currentDragRect != null && DragItem.this.currentDragRect.contains(point);
            }

            public void updateSize(Rectangle rectangle) {
            }

            public void paint(Graphics graphics) {
            }

            public Cursor getCursor() {
                return Cursor.getPredefinedCursor(13);
            }

            public void recalculateSize(Point point) {
                DragItem.this.currentDragRect.setBounds(point.x - ((DragItem)DragItem.this).gesturePoint.x + ((DragItem)DragItem.this).rectangle.x, point.y - ((DragItem)DragItem.this).gesturePoint.y + ((DragItem)DragItem.this).rectangle.y, ((DragItem)DragItem.this).rectangle.width, ((DragItem)DragItem.this).rectangle.height);
            }
        }
    }

    static interface DropHandler {
        public void dragAccepted(Rectangle var1, Rectangle var2);
    }
}

