/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.apisupport.project.ui.customizer.NbPropertyPanel;
import org.netbeans.modules.apisupport.project.ui.customizer.SingleModuleProperties;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

final class CustomizerCompiling
extends NbPropertyPanel.Single {
    private JCheckBox debug;
    private JCheckBox deprecation;
    private JTextField options;
    private JLabel optionsLabel;

    CustomizerCompiling(SingleModuleProperties singleModuleProperties, ProjectCustomizer.Category category) {
        super(singleModuleProperties, CustomizerCompiling.class, category);
        this.initComponents();
        this.initAccessibility();
        this.refresh();
    }

    void refresh() {
        this.debug.setSelected(this.getBooleanProperty("build.compiler.debug"));
        this.deprecation.setSelected(this.getBooleanProperty("build.compiler.deprecation"));
        this.options.setText(this.getProperty("javac.compilerargs"));
        NbPlatform nbPlatform = this.getProperties().getActivePlatform();
        this.options.setEnabled(nbPlatform == null || nbPlatform.getHarnessVersion() >= 2);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        if ("javac.compilerargs".equals(propertyChangeEvent.getPropertyName())) {
            this.options.setText(this.getProperty("javac.compilerargs"));
        }
        if ("nbPlatform".equals(propertyChangeEvent.getPropertyName())) {
            NbPlatform nbPlatform = this.getProperties().getActivePlatform();
            this.options.setEnabled(nbPlatform == null || nbPlatform.getHarnessVersion() >= 2);
        }
    }

    public void store() {
        this.setBooleanProperty("build.compiler.debug", this.debug.isSelected());
        this.setBooleanProperty("build.compiler.deprecation", this.deprecation.isSelected());
        this.setProperty("javac.compilerargs", this.options.getText());
    }

    private void initComponents() {
        this.deprecation = new JCheckBox();
        this.debug = new JCheckBox();
        this.optionsLabel = new JLabel();
        this.options = new JTextField();
        Mnemonics.setLocalizedText((AbstractButton)this.deprecation, (String)NbBundle.getMessage(CustomizerCompiling.class, (String)"CTL_ReportDeprecation"));
        Mnemonics.setLocalizedText((AbstractButton)this.debug, (String)NbBundle.getMessage(CustomizerCompiling.class, (String)"CTL_GenerateDebugInfo"));
        this.optionsLabel.setLabelFor(this.options);
        Mnemonics.setLocalizedText((JLabel)this.optionsLabel, (String)NbBundle.getMessage(CustomizerCompiling.class, (String)"LBL_additional_compiler_options"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.debug).add((Component)this.deprecation).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.optionsLabel).addPreferredGap(0).add((Component)this.options, -1, 193, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.debug).addPreferredGap(0).add((Component)this.deprecation).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.optionsLabel).add((Component)this.options, -2, -1, -2)).addContainerGap(233, Short.MAX_VALUE)));
        this.options.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerCompiling.class, (String)"ACS_AdditionalCompilerOptions"));
        this.options.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerCompiling.class, (String)"ACSD_AdditionalCompilerOptions"));
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage(CustomizerCompiling.class, (String)string);
    }

    private void initAccessibility() {
        this.debug.getAccessibleContext().setAccessibleDescription(CustomizerCompiling.getMessage("ACSD_Debug"));
        this.deprecation.getAccessibleContext().setAccessibleDescription(CustomizerCompiling.getMessage("ACSD_Deprecation"));
    }
}

