/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.apache.tools.ant.module.api.support.TargetLister;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.ui.ModuleActions;
import org.openide.ErrorManager;
import org.openide.awt.Actions;
import org.openide.awt.DynamicMenuContent;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.actions.Presenter;

public final class XTestProjectMenuItem
extends AbstractAction
implements Presenter.Popup,
ContextAwareAction {
    public static final String NAME = NbBundle.getBundle(XTestProjectMenuItem.class).getString("CTL_MenuItem_XTest");
    private static final String RUN_TEST_DIST = "runtests-dist";
    private Lookup context;

    public XTestProjectMenuItem() {
        this((Lookup)null);
    }

    public XTestProjectMenuItem(Lookup lookup) {
        super(NAME);
        this.context = lookup;
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public JMenuItem getPopupPresenter() {
        return new XTestProjectMenuItems();
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new XTestProjectMenuItem(lookup);
    }

    private Action[] actions() {
        Project project = (Project)this.context.lookup(Project.class);
        if (project == null) {
            return null;
        }
        if (project.getLookup().lookup(ModuleActions.class) == null) {
            return null;
        }
        ArrayList<AbstractAction> arrayList = new ArrayList<AbstractAction>();
        String[] stringArray = XTestProjectMenuItem.findTestTypes(project);
        if (stringArray.length <= 0) {
            return null;
        }
        arrayList.add(this.createAction(NbBundle.getMessage(XTestProjectMenuItem.class, (String)"CTL_MenuItem_Clean"), project, "", new String[]{"realclean"}, false));
        arrayList.add(null);
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(this.createAction(NbBundle.getMessage(XTestProjectMenuItem.class, (String)"CTL_MenuItem_BuildTests", (Object)stringArray[i]), project, stringArray[i], new String[]{"buildtests"}, false));
            arrayList.add(this.createAction(NbBundle.getMessage(XTestProjectMenuItem.class, (String)"CTL_MenuItem_RunTests", (Object)stringArray[i]), project, stringArray[i], new String[]{"runtests"}, true));
            arrayList.add(this.createAction(NbBundle.getMessage(XTestProjectMenuItem.class, (String)"CTL_MenuItem_RunTestsDist", (Object)stringArray[i]), project, stringArray[i], new String[]{RUN_TEST_DIST}, true));
            if (XTestProjectMenuItem.targetExists(XTestProjectMenuItem.findTestBuildXml(project), "coverage")) {
                arrayList.add(this.createAction(NbBundle.getMessage(XTestProjectMenuItem.class, (String)"CTL_MenuItem_MeasureCoverage", (Object)stringArray[i]), project, stringArray[i], new String[]{"coverage"}, true));
            }
            if (stringArray.length - 1 <= i) continue;
            arrayList.add(null);
        }
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    private AbstractAction createAction(String string, final Project project, final String string2, final String[] stringArray, final boolean bl) {
        return new AbstractAction(string){

            public boolean isEnabled() {
                if (XTestProjectMenuItem.RUN_TEST_DIST.equals(stringArray[0])) {
                    NbModuleProject nbModuleProject = (NbModuleProject)project.getLookup().lookup(NbModuleProject.class);
                    return nbModuleProject != null && nbModuleProject.getNbrootFile("nbbuild") != null;
                }
                if (XTestProjectMenuItem.this.context.lookup(new Lookup.Template(Project.class)).allInstances().size() == 1) {
                    return XTestProjectMenuItem.findTestBuildXml(project) != null;
                }
                return false;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Properties properties = new Properties();
                properties.setProperty("xtest.testtype", string2);
                try {
                    if (stringArray[0].equals(XTestProjectMenuItem.RUN_TEST_DIST)) {
                        this.runTestDist();
                    } else {
                        ExecutorTask executorTask = ActionUtils.runTarget((FileObject)XTestProjectMenuItem.findTestBuildXml(project), (String[])stringArray, (Properties)properties);
                        executorTask.addTaskListener(new TaskListener(){

                            public void taskFinished(Task task) {
                                if (((ExecutorTask)task).result() == 0 && bl) {
                                    if (stringArray[0].equals("coverage")) {
                                        XTestProjectMenuItem.showCoverageResults(project);
                                    } else {
                                        XTestProjectMenuItem.showTestResults(project);
                                    }
                                }
                            }
                        });
                    }
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }

            private void runTestDist() throws IOException {
                Properties properties = new Properties();
                final NbModuleProject nbModuleProject = (NbModuleProject)project.getLookup().lookup(NbModuleProject.class);
                FileObject fileObject = nbModuleProject.getNbrootFileObject("nbbuild/build.xml");
                properties.put("config.modules.test", nbModuleProject.getPathWithinNetBeansOrg());
                if (fileObject != null) {
                    ExecutorTask executorTask = ActionUtils.runTarget((FileObject)fileObject, (String[])new String[]{"build-test-dist"}, (Properties)properties);
                    executorTask.waitFinished();
                    if (executorTask.result() == 0) {
                        String string = "nbbuild/build/testdist/" + string2 + "/xtest-all-" + string2 + ".xml";
                        properties.clear();
                        File file = nbModuleProject.getNbrootFile("nbbuild/netbeans");
                        properties.put("netbeans.dest.dir", file.getCanonicalPath());
                        executorTask = ActionUtils.runTarget((FileObject)nbModuleProject.getNbrootFileObject(string), (String[])new String[]{"all"}, (Properties)properties);
                        executorTask.addTaskListener(new TaskListener(){

                            public void taskFinished(Task task) {
                                XTestProjectMenuItem.showBrowser(nbModuleProject.getNbrootFileObject("nbbuild/build/testdist/" + string2 + "/results/index.html"));
                            }
                        });
                    }
                }
            }
        };
    }

    private static boolean targetExists(FileObject fileObject, String string) {
        Iterator iterator;
        DataObject dataObject;
        if (fileObject == null) {
            return false;
        }
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            ErrorManager.getDefault().notify((Throwable)dataObjectNotFoundException);
            return false;
        }
        AntProjectCookie antProjectCookie = (AntProjectCookie)dataObject.getCookie(AntProjectCookie.class);
        try {
            iterator = TargetLister.getTargets((AntProjectCookie)antProjectCookie).iterator();
        }
        catch (IOException iOException) {
            Logger.getAnonymousLogger().fine(iOException.getMessage());
            return false;
        }
        while (iterator.hasNext()) {
            if (!((TargetLister.Target)iterator.next()).getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    private static FileObject findTestBuildXml(Project project) {
        return project.getProjectDirectory().getFileObject("test/build.xml");
    }

    private static void showTestResults(Project project) {
        XTestProjectMenuItem.showBrowser(project.getProjectDirectory().getFileObject("test/results/index.html"));
    }

    private static void showCoverageResults(Project project) {
        XTestProjectMenuItem.showBrowser(project.getProjectDirectory().getFileObject("test/coverage/coverage.html"));
    }

    private static void showBrowser(FileObject fileObject) {
        if (fileObject != null) {
            try {
                HtmlBrowser.URLDisplayer.getDefault().showURL(fileObject.getURL());
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                ErrorManager.getDefault().notify((Throwable)fileStateInvalidException);
            }
        }
    }

    private static String[] findTestTypes(Project project) {
        FileObject fileObject = project.getProjectDirectory().getFileObject("test");
        if (fileObject == null) {
            return new String[0];
        }
        FileObject[] fileObjectArray = fileObject.getChildren();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            if (!fileObjectArray[i].getExt().equalsIgnoreCase("xml") || !fileObjectArray[i].getName().matches("build-.*")) continue;
            String string = fileObjectArray[i].getName().substring(fileObjectArray[i].getName().indexOf(45) + 1);
            if (project.getProjectDirectory().getFileObject("test/cfg-" + string + ".xml") == null) continue;
            arrayList.add(string);
        }
        Object[] objectArray = arrayList.toArray(new String[arrayList.size()]);
        Arrays.sort(objectArray);
        return objectArray;
    }

    class XTestProjectMenuItems
    extends JMenuItem
    implements DynamicMenuContent {
        XTestProjectMenuItems() {
        }

        public JComponent[] getMenuPresenters() {
            Action[] actionArray = XTestProjectMenuItem.this.actions();
            if (actionArray == null) {
                return new JComponent[0];
            }
            JMenu jMenu = new JMenu();
            Mnemonics.setLocalizedText((AbstractButton)jMenu, (String)NAME);
            for (int i = 0; i < actionArray.length; ++i) {
                Action action = actionArray[i];
                if (action == null) {
                    jMenu.add(new JSeparator());
                    continue;
                }
                JMenuItem jMenuItem = new JMenuItem();
                Actions.connect((JMenuItem)jMenuItem, (Action)actionArray[i], (boolean)false);
                jMenu.add(jMenuItem);
            }
            return new JComponent[]{jMenu};
        }

        public JComponent[] synchMenuPresenters(JComponent[] jComponentArray) {
            return jComponentArray;
        }
    }
}

