/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JSeparator;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.ui.ModuleOperations;
import org.netbeans.modules.apisupport.project.ui.ModuleUISettings;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.customizer.CustomizerProviderImpl;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteProperties;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.FindAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModuleActions
implements ActionProvider {
    private final NbModuleProject project;
    private final Map<String, String[]> globalCommands = new HashMap<String, String[]>();
    private final String[] supportedActions;
    private static final Pattern SRCDIRJAVA = Pattern.compile("\\.java$");
    private static final String SUBST = "Test.java";

    static Action[] getProjectActions(NbModuleProject nbModuleProject) {
        Object object;
        boolean bl;
        ArrayList<Action> arrayList = new ArrayList<Action>();
        arrayList.add(CommonProjectActions.newFileAction());
        arrayList.add(null);
        arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"build", (String)NbBundle.getMessage(ModuleActions.class, (String)"ACTION_build"), null));
        arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"rebuild", (String)NbBundle.getMessage(ModuleActions.class, (String)"ACTION_rebuild"), null));
        arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"clean", (String)NbBundle.getMessage(ModuleActions.class, (String)"ACTION_clean"), null));
        arrayList.add(null);
        boolean bl2 = bl = Util.getModuleType(nbModuleProject) == NbModuleProvider.NETBEANS_ORG;
        if (bl) {
            object = nbModuleProject.getPathWithinNetBeansOrg();
            arrayList.add(ModuleActions.createMasterAction(nbModuleProject, new String[]{"init", "all-" + (String)object}, NbBundle.getMessage(ModuleActions.class, (String)"ACTION_build_with_deps")));
            arrayList.add(ModuleActions.createMasterAction(nbModuleProject, new String[]{"init", "all-" + (String)object, "tryme"}, NbBundle.getMessage(ModuleActions.class, (String)"ACTION_build_with_deps_tryme")));
        } else {
            arrayList.add(ModuleActions.createSimpleAction(nbModuleProject, new String[]{"run"}, NbBundle.getMessage(ModuleActions.class, (String)"ACTION_run")));
        }
        arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"debug", (String)NbBundle.getMessage(ModuleActions.class, (String)"ACTION_debug"), null));
        ModuleActions.addFromLayers(arrayList, "Projects/Profiler_Actions_temporary");
        if (nbModuleProject.supportsUnitTests()) {
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"test", (String)NbBundle.getMessage(ModuleActions.class, (String)"ACTION_test"), null));
        }
        arrayList.add(null);
        if (bl) {
            arrayList.add(ModuleActions.createCheckBundleAction(nbModuleProject, NbBundle.getMessage(ModuleActions.class, (String)"ACTION_unused_bundle_keys")));
            arrayList.add(null);
        }
        arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"run", (String)NbBundle.getMessage(ModuleActions.class, (String)"ACTION_reload"), null));
        arrayList.add(ModuleActions.createReloadInIDEAction(nbModuleProject, new String[]{"reload-in-ide"}, NbBundle.getMessage(ModuleActions.class, (String)"ACTION_reload_in_ide")));
        arrayList.add(ModuleActions.createSimpleAction(nbModuleProject, new String[]{"nbm"}, NbBundle.getMessage(ModuleActions.class, (String)"ACTION_nbm")));
        arrayList.add(null);
        arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"javadoc", (String)NbBundle.getMessage(ModuleActions.class, (String)"ACTION_javadoc"), null));
        arrayList.add(ModuleActions.createArchAction(nbModuleProject));
        arrayList.add(null);
        arrayList.add(CommonProjectActions.setAsMainProjectAction());
        arrayList.add(CommonProjectActions.openSubprojectsAction());
        arrayList.add(CommonProjectActions.closeProjectAction());
        arrayList.add(null);
        arrayList.add(CommonProjectActions.renameProjectAction());
        arrayList.add(CommonProjectActions.moveProjectAction());
        arrayList.add(CommonProjectActions.copyProjectAction());
        arrayList.add(CommonProjectActions.deleteProjectAction());
        arrayList.add(null);
        arrayList.add((Action)SystemAction.get(FindAction.class));
        object = Lookups.forPath((String)"Projects/Actions").lookupAll(Object.class);
        if (!object.isEmpty()) {
            arrayList.add(null);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof Action) {
                    arrayList.add((Action)e);
                    continue;
                }
                if (!(e instanceof JSeparator)) continue;
                arrayList.add(null);
            }
        }
        arrayList.add(null);
        arrayList.add(CommonProjectActions.customizeProjectAction());
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    private static void addFromLayers(List<Action> list, String string) {
        Lookup lookup = Lookups.forPath((String)string);
        for (Object e : lookup.lookupAll(Object.class)) {
            if (e instanceof Action) {
                list.add((Action)e);
                continue;
            }
            if (!(e instanceof JSeparator)) continue;
            list.add(null);
        }
    }

    public ModuleActions(NbModuleProject nbModuleProject) {
        this.project = nbModuleProject;
        HashSet<String> hashSet = new HashSet<String>();
        this.globalCommands.put("build", new String[]{"netbeans"});
        this.globalCommands.put("clean", new String[]{"clean"});
        this.globalCommands.put("rebuild", new String[]{"clean", "netbeans"});
        this.globalCommands.put("debug", new String[]{"debug"});
        this.globalCommands.put("run", new String[]{"reload"});
        this.globalCommands.put("profile", new String[]{"profile"});
        this.globalCommands.put("javadoc", new String[]{"javadoc-nb"});
        if (nbModuleProject.supportsUnitTests()) {
            this.globalCommands.put("test", new String[]{"test"});
        }
        hashSet.addAll(this.globalCommands.keySet());
        hashSet.add("compile.single");
        hashSet.add("debug.fix");
        if (nbModuleProject.supportsUnitTests()) {
            hashSet.add("test.single");
            hashSet.add("debug.test.single");
            hashSet.add("run.single");
            hashSet.add("debug.single");
        }
        if (nbModuleProject.getFunctionalTestSourceDirectory() != null) {
            hashSet.add("run.single");
        }
        if (nbModuleProject.getPerformanceTestSourceDirectory() != null) {
            hashSet.add("run.single");
        }
        hashSet.add("rename");
        hashSet.add("move");
        hashSet.add("copy");
        hashSet.add("delete");
        this.supportedActions = hashSet.toArray(new String[hashSet.size()]);
    }

    public String[] getSupportedActions() {
        return this.supportedActions;
    }

    private static FileObject findBuildXml(NbModuleProject nbModuleProject) {
        return nbModuleProject.getProjectDirectory().getFileObject("build.xml");
    }

    private static FileObject findTestBuildXml(NbModuleProject nbModuleProject) {
        return nbModuleProject.getProjectDirectory().getFileObject("test/build.xml");
    }

    private static FileObject findMasterBuildXml(NbModuleProject nbModuleProject) {
        return nbModuleProject.getNbrootFileObject("nbbuild/build.xml");
    }

    public boolean isActionEnabled(String string, Lookup lookup) {
        if ("delete".equals(string) || "rename".equals(string) || "move".equals(string) || "copy".equals(string)) {
            return true;
        }
        if (string.equals("compile.single")) {
            return ModuleActions.findBuildXml(this.project) != null && (this.findSources(lookup) != null || this.findTestSources(lookup, false) != null);
        }
        if (string.equals("test.single")) {
            return ModuleActions.findBuildXml(this.project) != null && this.findTestSourcesForSources(lookup) != null;
        }
        if (string.equals("debug.test.single")) {
            FileObject[] fileObjectArray = this.findTestSourcesForSources(lookup);
            return ModuleActions.findBuildXml(this.project) != null && fileObjectArray != null && fileObjectArray.length == 1;
        }
        if (string.equals("run.single")) {
            FileObject[] fileObjectArray = this.findFunctionalTestSources(lookup);
            if (fileObjectArray != null && fileObjectArray.length == 1 && ModuleActions.findTestBuildXml(this.project) != null) {
                return true;
            }
            fileObjectArray = this.findPerformanceTestSources(lookup);
            if (fileObjectArray != null && fileObjectArray.length == 1 && ModuleActions.findTestBuildXml(this.project) != null) {
                return true;
            }
            fileObjectArray = this.findTestSources(lookup, false);
            return fileObjectArray != null;
        }
        if (string.equals("debug.single")) {
            FileObject[] fileObjectArray = this.findTestSources(lookup, false);
            return fileObjectArray != null && fileObjectArray.length == 1;
        }
        if (string.equals("debug.fix")) {
            FileObject[] fileObjectArray = this.findSources(lookup);
            if (fileObjectArray != null && fileObjectArray.length == 1 && ModuleActions.findBuildXml(this.project) != null) {
                return true;
            }
            fileObjectArray = this.findTestSources(lookup, false);
            return fileObjectArray != null && fileObjectArray.length == 1 && ModuleActions.findBuildXml(this.project) != null;
        }
        return ModuleActions.findBuildXml(this.project) != null;
    }

    private FileObject[] findSources(Lookup lookup) {
        FileObject fileObject = this.project.getSourceDirectory();
        if (fileObject != null) {
            FileObject[] fileObjectArray = ActionUtils.findSelectedFiles((Lookup)lookup, (FileObject)fileObject, (String)".java", (boolean)true);
            return fileObjectArray;
        }
        return null;
    }

    private FileObject[] findTestSources(Lookup lookup, boolean bl) {
        FileObject[] fileObjectArray;
        FileObject[] fileObjectArray2;
        FileObject fileObject;
        FileObject fileObject2 = this.project.getTestSourceDirectory();
        if (fileObject2 != null && (fileObject = ActionUtils.findSelectedFiles((Lookup)lookup, (FileObject)fileObject2, (String)".java", (boolean)true)) != null) {
            return fileObject;
        }
        if (bl && fileObject2 != null && (fileObject = this.project.getSourceDirectory()) != null && (fileObjectArray2 = ActionUtils.findSelectedFiles((Lookup)lookup, (FileObject)fileObject, (String)".java", (boolean)true)) != null && (fileObjectArray = ActionUtils.regexpMapFiles((FileObject[])fileObjectArray2, (FileObject)fileObject, (Pattern)SRCDIRJAVA, (FileObject)fileObject2, (String)SUBST, (boolean)true)) != null) {
            return fileObjectArray;
        }
        return null;
    }

    private FileObject[] findTestSourcesForSources(Lookup lookup) {
        FileObject[] fileObjectArray = this.findSources(lookup);
        if (fileObjectArray == null) {
            return null;
        }
        FileObject fileObject = this.project.getTestSourceDirectory();
        FileObject fileObject2 = this.project.getSourceDirectory();
        return ActionUtils.regexpMapFiles((FileObject[])fileObjectArray, (FileObject)fileObject2, (Pattern)SRCDIRJAVA, (FileObject)fileObject, (String)SUBST, (boolean)true);
    }

    private FileObject[] findFunctionalTestSources(Lookup lookup) {
        FileObject fileObject = this.project.getFunctionalTestSourceDirectory();
        if (fileObject != null) {
            FileObject[] fileObjectArray = ActionUtils.findSelectedFiles((Lookup)lookup, (FileObject)fileObject, (String)".java", (boolean)true);
            return fileObjectArray;
        }
        return null;
    }

    private FileObject[] findPerformanceTestSources(Lookup lookup) {
        FileObject fileObject = this.project.getPerformanceTestSourceDirectory();
        if (fileObject != null) {
            FileObject[] fileObjectArray = ActionUtils.findSelectedFiles((Lookup)lookup, (FileObject)fileObject, (String)".java", (boolean)true);
            return fileObjectArray;
        }
        return null;
    }

    public void invokeAction(String string, Lookup lookup) throws IllegalArgumentException {
        String[] stringArray;
        Properties properties;
        FileObject[] fileObjectArray;
        if ("delete".equals(string)) {
            if (ModuleOperations.canRun(this.project, true)) {
                DefaultProjectOperations.performDefaultDeleteOperation((Project)this.project);
            }
            return;
        }
        if ("rename".equals(string)) {
            if (ModuleOperations.canRun(this.project, true)) {
                DefaultProjectOperations.performDefaultRenameOperation((Project)this.project, null);
            }
            return;
        }
        if ("move".equals(string)) {
            if (ModuleOperations.canRun(this.project, true)) {
                DefaultProjectOperations.performDefaultMoveOperation((Project)this.project);
            }
            return;
        }
        if ("copy".equals(string)) {
            if (ModuleOperations.canRun(this.project, true)) {
                DefaultProjectOperations.performDefaultCopyOperation((Project)this.project);
            }
            return;
        }
        if (!ModuleActions.verifySufficientlyNewHarness(this.project)) {
            return;
        }
        FileObject fileObject = null;
        if (string.equals("compile.single")) {
            fileObjectArray = this.findSources(lookup);
            properties = new Properties();
            if (fileObjectArray != null) {
                properties.setProperty("javac.includes", ActionUtils.antIncludesList((FileObject[])fileObjectArray, (FileObject)this.project.getSourceDirectory()));
                stringArray = new String[]{"compile-single"};
            } else {
                fileObjectArray = this.findTestSources(lookup, false);
                properties.setProperty("javac.includes", ActionUtils.antIncludesList((FileObject[])fileObjectArray, (FileObject)this.project.getTestSourceDirectory()));
                stringArray = new String[]{"compile-test-single"};
            }
        } else if (string.equals("test.single")) {
            properties = new Properties();
            fileObjectArray = this.findTestSourcesForSources(lookup);
            stringArray = this.setupTestSingle(properties, fileObjectArray);
        } else if (string.equals("debug.test.single")) {
            properties = new Properties();
            fileObjectArray = this.findTestSourcesForSources(lookup);
            stringArray = this.setupDebugTestSingle(properties, fileObjectArray);
        } else if (string.equals("run.single")) {
            fileObjectArray = this.findFunctionalTestSources(lookup);
            if (fileObjectArray != null) {
                String string2 = FileUtil.getRelativePath((FileObject)this.project.getFunctionalTestSourceDirectory(), (FileObject)fileObjectArray[0]);
                properties = new Properties();
                properties.setProperty("xtest.testtype", "qa-functional");
                properties.setProperty("classname", string2.substring(0, string2.length() - 5).replace('/', '.'));
                stringArray = new String[]{"internal-execution"};
                fileObject = ModuleActions.findTestBuildXml(this.project);
            } else {
                fileObjectArray = this.findPerformanceTestSources(lookup);
                if (fileObjectArray != null) {
                    String string3 = FileUtil.getRelativePath((FileObject)this.project.getPerformanceTestSourceDirectory(), (FileObject)fileObjectArray[0]);
                    properties = new Properties();
                    properties.setProperty("xtest.testtype", "qa-performance");
                    properties.setProperty("classname", string3.substring(0, string3.length() - 5).replace('/', '.'));
                    stringArray = new String[]{"internal-execution"};
                    fileObject = ModuleActions.findTestBuildXml(this.project);
                } else {
                    fileObjectArray = this.findTestSources(lookup, false);
                    properties = new Properties();
                    stringArray = this.setupTestSingle(properties, fileObjectArray);
                }
            }
        } else if (string.equals("debug.single")) {
            fileObjectArray = this.findTestSources(lookup, false);
            properties = new Properties();
            stringArray = this.setupDebugTestSingle(properties, fileObjectArray);
        } else if (string.equals("debug.fix")) {
            fileObjectArray = this.findSources(lookup);
            String string4 = null;
            if (fileObjectArray != null) {
                string4 = FileUtil.getRelativePath((FileObject)this.project.getSourceDirectory(), (FileObject)fileObjectArray[0]);
                assert (string4 != null);
                assert (string4.endsWith(".java"));
                stringArray = new String[]{"debug-fix-nb"};
            } else {
                fileObjectArray = this.findTestSources(lookup, false);
                string4 = FileUtil.getRelativePath((FileObject)this.project.getTestSourceDirectory(), (FileObject)fileObjectArray[0]);
                assert (string4 != null);
                assert (string4.endsWith(".java"));
                stringArray = new String[]{"debug-fix-test-nb"};
            }
            String string5 = string4.substring(0, string4.length() - 5);
            properties = new Properties();
            properties.setProperty("fix.class", string5);
            fileObject = ModuleActions.findBuildXml(this.project);
        } else {
            if (string.equals("javadoc") && !this.project.supportsJavadoc()) {
                this.promptForPublicPackagesToDocument();
                return;
            }
            properties = null;
            stringArray = this.globalCommands.get(string);
            if (stringArray == null) {
                throw new IllegalArgumentException(string);
            }
        }
        if (fileObject == null) {
            fileObject = ModuleActions.findBuildXml(this.project);
        }
        try {
            ActionUtils.runTarget((FileObject)fileObject, (String[])stringArray, (Properties)properties);
        }
        catch (IOException iOException) {
            Util.err.notify((Throwable)iOException);
        }
    }

    private void promptForPublicPackagesToDocument() {
        if (UIUtil.showAcceptCancelDialog(NbBundle.getMessage(ModuleActions.class, (String)"TITLE_javadoc_disabled"), NbBundle.getMessage(ModuleActions.class, (String)"ERR_javadoc_disabled"), NbBundle.getMessage(ModuleActions.class, (String)"LBL_configure_pubpkg"), null, 2)) {
            CustomizerProviderImpl customizerProviderImpl = (CustomizerProviderImpl)this.project.getLookup().lookup(CustomizerProviderImpl.class);
            customizerProviderImpl.showCustomizer("Versioning", "publicPackages");
        }
    }

    private static boolean verifySufficientlyNewHarness(NbModuleProject nbModuleProject) {
        NbPlatform nbPlatform = nbModuleProject.getPlatform(false);
        if (nbPlatform != null && nbPlatform.getHarnessVersion() != 0 && nbPlatform.getHarnessVersion() < nbModuleProject.getMinimumHarnessVersion()) {
            ModuleActions.promptForNewerHarness();
            return false;
        }
        return true;
    }

    static void promptForNewerHarness() {
        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(ModuleActions.class, (String)"ERR_harness_too_old"), 0);
        message.setTitle(NbBundle.getMessage(ModuleActions.class, (String)"TITLE_harness_too_old"));
        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
    }

    private String[] setupTestSingle(Properties properties, FileObject[] fileObjectArray) {
        properties.setProperty("test.includes", ActionUtils.antIncludesList((FileObject[])fileObjectArray, (FileObject)this.project.getTestSourceDirectory()));
        return new String[]{"test-single"};
    }

    private String[] setupDebugTestSingle(Properties properties, FileObject[] fileObjectArray) {
        String string = FileUtil.getRelativePath((FileObject)this.project.getTestSourceDirectory(), (FileObject)fileObjectArray[0]);
        properties.setProperty("test.class", string.substring(0, string.length() - 5).replace('/', '.'));
        return new String[]{"debug-test-single-nb"};
    }

    private static Action createSimpleAction(final NbModuleProject nbModuleProject, final String[] stringArray, String string) {
        return new AbstractAction(string){

            public boolean isEnabled() {
                return ModuleActions.findBuildXml(nbModuleProject) != null;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (!ModuleActions.verifySufficientlyNewHarness(nbModuleProject)) {
                    return;
                }
                try {
                    ActionUtils.runTarget((FileObject)ModuleActions.findBuildXml(nbModuleProject), (String[])stringArray, null);
                }
                catch (IOException iOException) {
                    Util.err.notify((Throwable)iOException);
                }
            }
        };
    }

    private static Action createMasterAction(final NbModuleProject nbModuleProject, final String[] stringArray, String string) {
        return new AbstractAction(string){

            public boolean isEnabled() {
                return ModuleActions.findMasterBuildXml(nbModuleProject) != null;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ActionUtils.runTarget((FileObject)ModuleActions.findMasterBuildXml(nbModuleProject), (String[])stringArray, null);
                }
                catch (IOException iOException) {
                    Util.err.notify((Throwable)iOException);
                }
            }
        };
    }

    private static Action createCheckBundleAction(final NbModuleProject nbModuleProject, String string) {
        return new AbstractAction(string){

            public boolean isEnabled() {
                return this.findMonitorXml() != null && nbModuleProject.getPathWithinNetBeansOrg() != null;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Properties properties = new Properties();
                properties.put("modules", nbModuleProject.getPathWithinNetBeansOrg());
                properties.put("fixedmodules", "");
                try {
                    ActionUtils.runTarget((FileObject)this.findMonitorXml(), (String[])new String[]{"check-bundle-usage"}, (Properties)properties);
                }
                catch (IOException iOException) {
                    Util.err.notify((Throwable)iOException);
                }
            }

            private FileObject findMonitorXml() {
                return nbModuleProject.getNbrootFileObject("nbbuild/monitor.xml");
            }
        };
    }

    private static Action createReloadInIDEAction(final NbModuleProject nbModuleProject, final String[] stringArray, String string) {
        return new AbstractAction(string){

            public boolean isEnabled() {
                if (ModuleActions.findBuildXml(nbModuleProject) == null) {
                    return false;
                }
                NbModuleProvider.NbModuleType nbModuleType = Util.getModuleType(nbModuleProject);
                if (nbModuleType == NbModuleProvider.NETBEANS_ORG) {
                    return true;
                }
                if (nbModuleType == NbModuleProvider.STANDALONE) {
                    NbPlatform nbPlatform = nbModuleProject.getPlatform(false);
                    return nbPlatform != null && nbPlatform.isDefault();
                }
                assert (nbModuleType == NbModuleProvider.SUITE_COMPONENT) : nbModuleType;
                try {
                    SuiteProject suiteProject = SuiteUtils.findSuite(nbModuleProject);
                    if (suiteProject == null) {
                        return false;
                    }
                    NbPlatform nbPlatform = suiteProject.getPlatform(false);
                    if (nbPlatform == null || !nbPlatform.isDefault()) {
                        return false;
                    }
                    return SuiteProperties.getArrayProperty(suiteProject.getEvaluator(), "enabled.clusters").length == 0 && SuiteProperties.getArrayProperty(suiteProject.getEvaluator(), "disabled.clusters").length == 0 && SuiteProperties.getArrayProperty(suiteProject.getEvaluator(), "disabled.modules").length == 0;
                }
                catch (IOException iOException) {
                    Util.err.notify(1, (Throwable)iOException);
                    return false;
                }
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (!ModuleActions.verifySufficientlyNewHarness(nbModuleProject)) {
                    return;
                }
                if (ModuleUISettings.getDefault().getConfirmReloadInIDE()) {
                    NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(ModuleActions.class, (String)"LBL_reload_in_ide_confirm"), NbBundle.getMessage(ModuleActions.class, (String)"LBL_reload_in_ide_confirm_title"), 2);
                    if (DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation) != NotifyDescriptor.OK_OPTION) {
                        return;
                    }
                    ModuleUISettings.getDefault().setConfirmReloadInIDE(false);
                }
                try {
                    ActionUtils.runTarget((FileObject)ModuleActions.findBuildXml(nbModuleProject), (String[])stringArray, null);
                }
                catch (IOException iOException) {
                    Util.err.notify((Throwable)iOException);
                }
            }
        };
    }

    private static Action createArchAction(final NbModuleProject nbModuleProject) {
        return new AbstractAction(NbBundle.getMessage(ModuleActions.class, (String)"ACTION_arch")){

            public boolean isEnabled() {
                return ModuleActions.findBuildXml(nbModuleProject) != null;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (!ModuleActions.verifySufficientlyNewHarness(nbModuleProject)) {
                    return;
                }
                ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Void>(){

                    public Void run() {
                        String string = "javadoc.arch";
                        if (nbModuleProject.evaluator().getProperty(string) == null) {
                            EditableProperties editableProperties = nbModuleProject.getHelper().getProperties("nbproject/project.properties");
                            editableProperties.setProperty(string, "${basedir}/arch.xml");
                            nbModuleProject.getHelper().putProperties("nbproject/project.properties", editableProperties);
                            try {
                                ProjectManager.getDefault().saveProject((Project)nbModuleProject);
                            }
                            catch (IOException iOException) {
                                Util.err.notify((Throwable)iOException);
                            }
                        }
                        return null;
                    }
                });
                try {
                    ActionUtils.runTarget((FileObject)ModuleActions.findBuildXml(nbModuleProject), (String[])new String[]{"arch-nb"}, null);
                }
                catch (IOException iOException) {
                    Util.err.notify((Throwable)iOException);
                }
            }
        };
    }
}

