/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.queries;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.java.queries.JavadocForBinaryQueryImplementation;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.modules.InstalledFileLocator;

public final class GlobalJavadocForBinaryImpl
implements JavadocForBinaryQueryImplementation {
    public JavadocForBinaryQuery.Result findJavadoc(URL uRL) {
        try {
            if (uRL.getProtocol().equals("jar")) {
                return this.findForBinaryRoot(uRL);
            }
            return this.findForSourceRoot(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            throw new AssertionError((Object)malformedURLException);
        }
    }

    private JavadocForBinaryQuery.Result findForBinaryRoot(URL uRL) throws MalformedURLException, MalformedURLException {
        String string;
        File file;
        URL uRL2 = FileUtil.getArchiveFile((URL)uRL);
        if (!uRL2.getProtocol().equals("file")) {
            Util.err.log(uRL + " is not an archive file.");
            return null;
        }
        if (uRL2.toExternalForm().endsWith("/xtest/lib/junit.jar")) {
            file = InstalledFileLocator.getDefault().locate("modules/ext/junit-3.8.2.jar", "org.netbeans.modules.junit", false);
            if (file == null) {
                file = InstalledFileLocator.getDefault().locate("modules/ext/junit-3.8.1.jar", "org.netbeans.modules.junit", false);
            }
            if (file != null) {
                return JavadocForBinaryQuery.findJavadoc((URL)FileUtil.getArchiveRoot((URL)file.toURI().toURL()));
            }
        }
        if (!(string = (file = new File(URI.create(uRL2.toExternalForm()))).getName()).endsWith(".jar")) {
            Util.err.log(file + " is not a *.jar");
            return null;
        }
        String string2 = string.substring(0, string.length() - 4);
        NbPlatform nbPlatform = null;
        for (NbPlatform nbPlatform2 : NbPlatform.getPlatforms()) {
            if (!file.getAbsolutePath().startsWith(nbPlatform2.getDestDir().getAbsolutePath())) continue;
            nbPlatform = nbPlatform2;
            break;
        }
        if (nbPlatform == null) {
            Util.err.log(file + " does not correspond to a known platform");
            return null;
        }
        return this.findByDashedCNB(string2, nbPlatform);
    }

    private JavadocForBinaryQuery.Result findForSourceRoot(URL uRL) throws MalformedURLException {
        NbModuleProject nbModuleProject;
        Project project;
        try {
            project = FileOwnerQuery.getOwner((URI)uRL.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new AssertionError((Object)uRISyntaxException);
        }
        if (project != null && (nbModuleProject = (NbModuleProject)project.getLookup().lookup(NbModuleProject.class)) != null) {
            String string = nbModuleProject.getCodeNameBase();
            for (NbPlatform nbPlatform : NbPlatform.getPlatforms()) {
                JavadocForBinaryQuery.Result result = this.findByDashedCNB(string.replace('.', '-'), nbPlatform);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    private JavadocForBinaryQuery.Result findByDashedCNB(String string, NbPlatform nbPlatform) throws MalformedURLException {
        final ArrayList<URL> arrayList = new ArrayList<URL>();
        URL[] uRLArray = nbPlatform.getJavadocRoots();
        Util.err.log("Platform in " + nbPlatform.getDestDir() + " claimed to have Javadoc roots " + Arrays.asList(uRLArray));
        for (URL uRL : uRLArray) {
            arrayList.add(uRL);
            arrayList.add(new URL(uRL, string + '/'));
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            URL uRL = (URL)iterator.next();
            if (URLMapper.findFileObject((URL)uRL) != null) continue;
            Util.err.log("No such Javadoc candidate URL " + uRL);
            iterator.remove();
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return new JavadocForBinaryQuery.Result(){

            public URL[] getRoots() {
                return arrayList.toArray(new URL[arrayList.size()]);
            }

            public void addChangeListener(ChangeListener changeListener) {
            }

            public void removeChangeListener(ChangeListener changeListener) {
            }
        };
    }
}

