/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.impl.wadl;

import com.sun.research.ws.wadl.Application;
import com.sun.research.ws.wadl.Method;
import com.sun.research.ws.wadl.Param;
import com.sun.research.ws.wadl.ParamStyle;
import com.sun.research.ws.wadl.RepresentationType;
import com.sun.research.ws.wadl.Request;
import com.sun.research.ws.wadl.Resource;
import com.sun.research.ws.wadl.Resources;
import com.sun.research.ws.wadl.Response;
import com.sun.ws.rest.api.model.AbstractResource;
import com.sun.ws.rest.api.model.AbstractResourceMethod;
import com.sun.ws.rest.api.model.AbstractSubResourceLocator;
import com.sun.ws.rest.api.model.AbstractSubResourceMethod;
import com.sun.ws.rest.api.model.Parameter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.MediaType;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WadlGenerator {
    public static Application generate(Set<AbstractResource> resources) {
        Application wadlApplication = new Application();
        Resources wadlResources = new Resources();
        for (AbstractResource r : resources) {
            Resource wadlResource = WadlGenerator.generateResource(r);
            wadlResources.getResource().add(wadlResource);
        }
        wadlApplication.setResources(wadlResources);
        return wadlApplication;
    }

    public static Application generate(AbstractResource resource) {
        Application wadlApplication = new Application();
        Resources wadlResources = new Resources();
        Resource wadlResource = WadlGenerator.generateResource(resource);
        wadlResources.getResource().add(wadlResource);
        wadlApplication.setResources(wadlResources);
        return wadlApplication;
    }

    public static Application generate(AbstractResource resource, String path) {
        Application wadlApplication = new Application();
        Resources wadlResources = new Resources();
        Resource wadlResource = WadlGenerator.generateSubResource(resource, path);
        wadlResources.getResource().add(wadlResource);
        wadlApplication.setResources(wadlResources);
        return wadlApplication;
    }

    private static Method generateMethod(Map<String, Param> wadlResourceParams, AbstractResourceMethod m) {
        Response wadlResponse;
        Method wadlMethod = new Method();
        wadlMethod.setName(m.getHttpMethod());
        Request wadlRequest = WadlGenerator.generateRequest(m, wadlResourceParams);
        if (wadlRequest != null) {
            wadlMethod.setRequest(wadlRequest);
        }
        if ((wadlResponse = WadlGenerator.generateResponse(m)) != null) {
            wadlMethod.setResponse(wadlResponse);
        }
        return wadlMethod;
    }

    private static Request generateRequest(AbstractResourceMethod m, Map<String, Param> wadlResourceParams) {
        if (m.getParameters().size() == 0) {
            return null;
        }
        Request wadlRequest = new Request();
        for (Parameter p : m.getParameters()) {
            if (p.getSource() == Parameter.Source.ENTITY) {
                for (MediaType mediaType : m.getSupportedInputTypes()) {
                    RepresentationType wadlRepresentation = new RepresentationType();
                    wadlRepresentation.setMediaType(mediaType.toString());
                    wadlRequest.getRepresentation().add(wadlRepresentation);
                }
                continue;
            }
            Param wadlParam = WadlGenerator.generateParam(p);
            if (wadlParam == null) continue;
            if (wadlParam.getStyle() == ParamStyle.TEMPLATE) {
                wadlResourceParams.put(wadlParam.getName(), wadlParam);
                continue;
            }
            wadlRequest.getParam().add(wadlParam);
        }
        if (wadlRequest.getRepresentation().size() + wadlRequest.getParam().size() == 0) {
            return null;
        }
        return wadlRequest;
    }

    private static Param generateParam(Parameter p) {
        Class<?> pClass;
        if (p.getSource() == Parameter.Source.ENTITY || p.getSource() == Parameter.Source.CONTEXT) {
            return null;
        }
        Param wadlParam = new Param();
        wadlParam.setName(p.getSourceName());
        switch (p.getSource()) {
            case QUERY: {
                wadlParam.setStyle(ParamStyle.QUERY);
                break;
            }
            case MATRIX: {
                wadlParam.setStyle(ParamStyle.MATRIX);
                break;
            }
            case URI: {
                wadlParam.setStyle(ParamStyle.TEMPLATE);
                break;
            }
            case HEADER: {
                wadlParam.setStyle(ParamStyle.HEADER);
                break;
            }
        }
        if (p.hasDefaultValue()) {
            wadlParam.setDefault(p.getDefaultValue());
        }
        if ((pClass = p.getParameterClass()).isArray()) {
            wadlParam.setRepeating(true);
            pClass = pClass.getComponentType();
        }
        if (pClass.equals(Integer.TYPE) || pClass.equals(Integer.class)) {
            wadlParam.setType(new QName("http://www.w3.org/2001/XMLSchema", "int", "xs"));
        } else if (pClass.equals(Boolean.TYPE) || pClass.equals(Boolean.class)) {
            wadlParam.setType(new QName("http://www.w3.org/2001/XMLSchema", "boolean", "xs"));
        } else if (pClass.equals(Long.TYPE) || pClass.equals(Long.class)) {
            wadlParam.setType(new QName("http://www.w3.org/2001/XMLSchema", "long", "xs"));
        } else if (pClass.equals(Short.TYPE) || pClass.equals(Short.class)) {
            wadlParam.setType(new QName("http://www.w3.org/2001/XMLSchema", "short", "xs"));
        } else if (pClass.equals(Byte.TYPE) || pClass.equals(Byte.class)) {
            wadlParam.setType(new QName("http://www.w3.org/2001/XMLSchema", "byte", "xs"));
        } else if (pClass.equals(Float.TYPE) || pClass.equals(Float.class)) {
            wadlParam.setType(new QName("http://www.w3.org/2001/XMLSchema", "float", "xs"));
        } else if (pClass.equals(Double.TYPE) || pClass.equals(Double.class)) {
            wadlParam.setType(new QName("http://www.w3.org/2001/XMLSchema", "double", "xs"));
        } else {
            wadlParam.setType(new QName("http://www.w3.org/2001/XMLSchema", "string", "xs"));
        }
        return wadlParam;
    }

    private static Resource generateResource(AbstractResource r) {
        Resource wadlSubResource;
        Resource wadlResource = new Resource();
        if (r.isRootResource()) {
            wadlResource.setPath(r.getUriPath().getValue());
        }
        HashMap<String, Param> wadlResourceParams = new HashMap<String, Param>();
        for (AbstractResourceMethod m : r.getResourceMethods()) {
            Method wadlMethod = WadlGenerator.generateMethod(wadlResourceParams, m);
            wadlResource.getMethodOrResource().add(wadlMethod);
        }
        for (Param wadlParam : wadlResourceParams.values()) {
            wadlResource.getParam().add(wadlParam);
        }
        HashMap<String, Resource> wadlSubResources = new HashMap<String, Resource>();
        HashMap wadlSubResourcesParams = new HashMap();
        for (AbstractSubResourceMethod m : r.getSubResourceMethods()) {
            String template = m.getUriPath().getValue();
            Resource wadlSubResource2 = (Resource)wadlSubResources.get(template);
            HashMap wadlSubResourceParams = (HashMap)wadlSubResourcesParams.get(template);
            if (wadlSubResource2 == null) {
                wadlSubResource2 = new Resource();
                wadlSubResource2.setPath(template);
                wadlSubResources.put(template, wadlSubResource2);
                wadlSubResourceParams = new HashMap();
                wadlSubResourcesParams.put(template, wadlSubResourceParams);
                wadlResource.getMethodOrResource().add(wadlSubResource2);
            }
            Method wadlMethod = WadlGenerator.generateMethod(wadlSubResourceParams, m);
            wadlSubResource2.getMethodOrResource().add(wadlMethod);
        }
        for (String template : wadlSubResources.keySet()) {
            wadlSubResource = (Resource)wadlSubResources.get(template);
            Map wadlSubResourceParams = (Map)wadlSubResourcesParams.get(template);
            for (Param wadlParam : wadlSubResourceParams.values()) {
                wadlSubResource.getParam().add(wadlParam);
            }
        }
        for (AbstractSubResourceLocator l : r.getSubResourceLocators()) {
            wadlSubResource = new Resource();
            wadlSubResource.setPath(l.getUriPath().getValue());
            for (Parameter p : l.getParameters()) {
                Param wadlParam;
                wadlParam = WadlGenerator.generateParam(p);
                wadlSubResource.getParam().add(wadlParam);
            }
            wadlResource.getMethodOrResource().add(wadlSubResource);
        }
        return wadlResource;
    }

    private static Resource generateSubResource(AbstractResource r, String path) {
        Resource wadlResource = new Resource();
        if (r.isRootResource()) {
            StringBuilder b = new StringBuilder(r.getUriPath().getValue());
            if (!r.getUriPath().getValue().endsWith("/") && !path.startsWith("/")) {
                b.append("/");
            }
            b.append(path);
            wadlResource.setPath(b.toString());
        }
        HashMap<String, Param> wadlSubResourceParams = new HashMap<String, Param>();
        for (AbstractSubResourceMethod m : r.getSubResourceMethods()) {
            String template = m.getUriPath().getValue();
            if (!template.equals(path)) continue;
            Method wadlMethod = WadlGenerator.generateMethod(wadlSubResourceParams, m);
            wadlResource.getMethodOrResource().add(wadlMethod);
        }
        for (Param wadlParam : wadlSubResourceParams.values()) {
            wadlResource.getParam().add(wadlParam);
        }
        return wadlResource;
    }

    private static Response generateResponse(AbstractResourceMethod m) {
        if (m.getMethod().getReturnType() == Void.TYPE) {
            return null;
        }
        Response wadlResponse = new Response();
        for (MediaType mediaType : m.getSupportedOutputTypes()) {
            RepresentationType wadlRepresentation = new RepresentationType();
            wadlRepresentation.setMediaType(mediaType.toString());
            JAXBElement element = new JAXBElement(new QName("http://research.sun.com/wadl/2006/10", "representation"), RepresentationType.class, (Object)wadlRepresentation);
            wadlResponse.getRepresentationOrFault().add((JAXBElement<RepresentationType>)element);
        }
        return wadlResponse;
    }
}

