/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.impl.provider.entity;

import com.sun.ws.rest.impl.ImplMessages;
import com.sun.ws.rest.impl.provider.entity.AbstractTypeEntityProvider;
import com.sun.ws.rest.impl.util.ThrowHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONObjectProvider
extends AbstractTypeEntityProvider<JSONObject> {
    @Override
    public boolean supports(Class<?> type) {
        return type == JSONObject.class;
    }

    public JSONObject readFrom(Class<JSONObject> o, MediaType mediaType, MultivaluedMap<String, String> headers, InputStream is) throws IOException {
        try {
            return new JSONObject(this.readFromAsString(is));
        }
        catch (JSONException je) {
            throw ThrowHelper.withInitCause((Exception)((Object)je), new IOException(ImplMessages.ERROR_PARSING_JSON_OBJECT()));
        }
    }

    public void writeTo(JSONObject jsonObject, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        try {
            OutputStreamWriter writer = new OutputStreamWriter(entityStream);
            jsonObject.write((Writer)writer);
            writer.write("\n");
            writer.flush();
        }
        catch (JSONException je) {
            throw ThrowHelper.withInitCause((Exception)((Object)je), new IOException(ImplMessages.ERROR_WRITING_JSON_OBJECT()));
        }
    }
}

