/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.impl.provider.entity;

import com.sun.ws.rest.api.representation.FormURLEncodedProperties;
import com.sun.ws.rest.impl.provider.entity.AbstractTypeEntityProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.StringTokenizer;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FormURLEncodedProvider
extends AbstractTypeEntityProvider<FormURLEncodedProperties> {
    @Override
    public boolean supports(Class type) {
        return type == FormURLEncodedProperties.class;
    }

    public FormURLEncodedProperties readFrom(Class<FormURLEncodedProperties> type, MediaType mediaType, MultivaluedMap<String, String> headers, InputStream entityStream) throws IOException {
        String encoded = this.readFromAsString(entityStream);
        FormURLEncodedProperties map = new FormURLEncodedProperties();
        StringTokenizer tokenizer = new StringTokenizer(encoded, "&");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            int idx = token.indexOf(61);
            if (idx < 0) {
                map.put(URLDecoder.decode(token, "UTF-8"), null);
                continue;
            }
            if (idx <= 0) continue;
            map.put(URLDecoder.decode(token.substring(0, idx), "UTF-8"), URLDecoder.decode(token.substring(idx + 1), "UTF-8"));
        }
        return map;
    }

    public void writeTo(FormURLEncodedProperties t, MediaType mediaType, MultivaluedMap<String, Object> headers, OutputStream entityStream) throws IOException {
        StringBuilder sb = new StringBuilder();
        int cnt = 0;
        for (String key : t.keySet()) {
            if (cnt++ > 0) {
                sb.append('&');
            }
            sb.append(URLEncoder.encode(key, "UTF-8"));
            String value = (String)t.get(key);
            if (value == null) continue;
            sb.append('=');
            sb.append(URLEncoder.encode(value, "UTF-8"));
        }
        entityStream.write(sb.toString().getBytes());
    }
}

