/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.impl.modelapi.validation;

import com.sun.ws.rest.api.core.HttpRequestContext;
import com.sun.ws.rest.api.core.HttpResponseContext;
import com.sun.ws.rest.api.model.AbstractResource;
import com.sun.ws.rest.api.model.AbstractResourceConstructor;
import com.sun.ws.rest.api.model.AbstractResourceMethod;
import com.sun.ws.rest.api.model.AbstractSubResourceLocator;
import com.sun.ws.rest.api.model.AbstractSubResourceMethod;
import com.sun.ws.rest.api.model.ResourceModelIssue;
import com.sun.ws.rest.impl.ImplMessages;
import com.sun.ws.rest.impl.modelapi.validation.AbstractModelValidator;

public class BasicValidator
extends AbstractModelValidator {
    public void visitAbstractResource(AbstractResource resource) {
        if (resource.getResourceMethods().size() + resource.getSubResourceMethods().size() + resource.getSubResourceLocators().size() == 0) {
            this.issueList.add(new ResourceModelIssue(resource, ImplMessages.ERROR_NO_SUB_RES_METHOD_LOCATOR_FOUND(resource.getResourceClass()), false));
        }
        if (resource.isRootResource() && (null == resource.getUriPath() || null == resource.getUriPath().getValue())) {
            this.issueList.add(new ResourceModelIssue(resource, ImplMessages.ERROR_RES_URI_PATH_INVALID(resource.getResourceClass(), resource.getUriPath()), true));
        }
    }

    public void visitAbstractResourceMethod(AbstractResourceMethod method) {
        if (!this.isRequestResponseMethod(method) && "GET".equals(method.getHttpMethod()) && Void.TYPE == method.getMethod().getReturnType()) {
            this.issueList.add(new ResourceModelIssue(method, ImplMessages.ERROR_GET_RETURNS_VOID(method.getMethod()), true));
        }
    }

    public void visitAbstractSubResourceMethod(AbstractSubResourceMethod method) {
        this.visitAbstractResourceMethod(method);
        if (null == method.getUriPath() || null == method.getUriPath().getValue() || method.getUriPath().getValue().length() == 0) {
            this.issueList.add(new ResourceModelIssue(method, ImplMessages.ERROR_SUBRES_METHOD_URI_PATH_INVALID(method.getMethod(), method.getUriPath()), true));
        }
    }

    public void visitAbstractSubResourceLocator(AbstractSubResourceLocator locator) {
        if (Void.TYPE == locator.getMethod().getReturnType()) {
            this.issueList.add(new ResourceModelIssue(locator, ImplMessages.ERROR_SUBRES_LOC_RETURNS_VOID(locator.getMethod()), true));
        }
        if (null == locator.getUriPath() || null == locator.getUriPath().getValue() || locator.getUriPath().getValue().length() == 0) {
            this.issueList.add(new ResourceModelIssue(locator, ImplMessages.ERROR_SUBRES_LOC_URI_PATH_INVALID(locator.getMethod(), locator.getUriPath()), true));
        }
    }

    public void visitAbstractResourceConstructor(AbstractResourceConstructor constructor) {
    }

    private boolean isRequestResponseMethod(AbstractResourceMethod method) {
        return method.getMethod().getParameterTypes().length == 2 && HttpRequestContext.class == method.getMethod().getParameterTypes()[0] && HttpResponseContext.class == method.getMethod().getParameterTypes()[1];
    }
}

