/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.impl.model.parameter;

import com.sun.ws.rest.api.model.Parameter;
import com.sun.ws.rest.impl.model.parameter.HeaderParameterProcessor;
import com.sun.ws.rest.impl.model.parameter.HttpContextParameterProcessor;
import com.sun.ws.rest.impl.model.parameter.MatrixParameterProcessor;
import com.sun.ws.rest.impl.model.parameter.ParameterProcessor;
import com.sun.ws.rest.impl.model.parameter.QueryParameterProcessor;
import com.sun.ws.rest.impl.model.parameter.UriParameterProcessor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ParameterProcessorFactory {
    private static final Map<Parameter.Source, ParameterProcessor> S2P_MAP = ParameterProcessorFactory.createMap();

    private static Map<Parameter.Source, ParameterProcessor> createMap() {
        HashMap<Parameter.Source, ParameterProcessor> map = new HashMap<Parameter.Source, ParameterProcessor>();
        map.put(Parameter.Source.CONTEXT, new HttpContextParameterProcessor());
        map.put(Parameter.Source.HEADER, new HeaderParameterProcessor());
        map.put(Parameter.Source.QUERY, new QueryParameterProcessor());
        map.put(Parameter.Source.MATRIX, new MatrixParameterProcessor());
        map.put(Parameter.Source.URI, new UriParameterProcessor());
        return Collections.unmodifiableMap(map);
    }

    public static ParameterProcessor createParameterProcessor(Parameter.Source source) {
        if (S2P_MAP.containsKey((Object)source)) {
            return S2P_MAP.get((Object)source);
        }
        return null;
    }
}

