/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.impl.model.method.dispatch;

import com.sun.ws.rest.api.model.AbstractResourceMethod;
import com.sun.ws.rest.impl.ImplMessages;
import com.sun.ws.rest.impl.model.method.dispatch.ResourceMethodDispatchProvider;
import com.sun.ws.rest.spi.dispatch.RequestDispatcher;
import com.sun.ws.rest.spi.service.ServiceFinder;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedList;
import java.util.logging.Logger;

public final class ResourceMethodDispatcherFactory {
    private static final Logger LOGGER = Logger.getLogger(ResourceMethodDispatcherFactory.class.getName());

    public static RequestDispatcher create(AbstractResourceMethod abstractResourceMethod) {
        LinkedList<ResourceMethodDispatchProvider> rmdps = new LinkedList<ResourceMethodDispatchProvider>();
        for (ResourceMethodDispatchProvider rmdp : ServiceFinder.find(ResourceMethodDispatchProvider.class, true)) {
            rmdps.addFirst(rmdp);
        }
        for (ResourceMethodDispatchProvider rmdp : rmdps) {
            try {
                RequestDispatcher d = rmdp.create(abstractResourceMethod);
                if (d == null) continue;
                return d;
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter();
                sw.write(ImplMessages.ERROR_PROCESSING_METHOD(abstractResourceMethod.getMethod(), rmdp.getClass().getName()));
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                pw.flush();
                LOGGER.severe(sw.toString());
            }
        }
        return null;
    }
}

