/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.impl.http.header.reader;

import com.sun.ws.rest.impl.http.header.HttpDateFormat;
import com.sun.ws.rest.impl.http.header.QualityFactor;
import com.sun.ws.rest.impl.http.header.reader.HttpHeaderListAdapter;
import com.sun.ws.rest.impl.http.header.reader.HttpHeaderReaderImpl;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HttpHeaderReader {
    private static final Comparator<QualityFactor> QUALITY_COMPARATOR = new Comparator<QualityFactor>(){

        @Override
        public int compare(QualityFactor o1, QualityFactor o2) {
            return o2.getQuality() - o1.getQuality();
        }
    };

    public abstract boolean hasNext();

    public abstract boolean hasNextSeparator(char var1, boolean var2);

    public abstract Event next() throws ParseException;

    public abstract Event next(boolean var1) throws ParseException;

    public abstract Event getEvent();

    public abstract String getEventValue();

    public abstract String getRemainder();

    public abstract int getIndex();

    public String nextToken() throws ParseException {
        Event e = this.next(false);
        if (e != Event.Token) {
            throw new ParseException("Next event is not a Token", this.getIndex());
        }
        return this.getEventValue();
    }

    public char nextSeparator() throws ParseException {
        Event e = this.next(false);
        if (e != Event.Separator) {
            throw new ParseException("Next event is not a Separator", this.getIndex());
        }
        return this.getEventValue().charAt(0);
    }

    public void nextSeparator(char c) throws ParseException {
        Event e = this.next(false);
        if (e != Event.Separator) {
            throw new ParseException("Next event is not a Separator", this.getIndex());
        }
        if (c != this.getEventValue().charAt(0)) {
            throw new ParseException("Expected separator '" + c + "' instead of '" + this.getEventValue().charAt(0) + "'", this.getIndex());
        }
    }

    public String nextQuotedString() throws ParseException {
        Event e = this.next(false);
        if (e != Event.QuotedString) {
            throw new ParseException("Next event is not a Quoted String", this.getIndex());
        }
        return this.getEventValue();
    }

    public String nextTokenOrQuotedString() throws ParseException {
        Event e = this.next(false);
        if (e != Event.Token && e != Event.QuotedString) {
            throw new ParseException("Next event is not a Token or a Quoted String, " + this.getEventValue(), this.getIndex());
        }
        return this.getEventValue();
    }

    public static HttpHeaderReader newHttpHeaderReader(String header) {
        return new HttpHeaderReaderImpl(header);
    }

    public static HttpHeaderReader newHttpHeaderReader(String header, boolean processComments) {
        return new HttpHeaderReaderImpl(header, processComments);
    }

    public static Date readDate(String date) throws ParseException {
        ParseException pe = null;
        for (SimpleDateFormat f : HttpDateFormat.getDateFormats()) {
            try {
                return f.parse(date);
            }
            catch (ParseException e) {
                pe = pe == null ? e : pe;
            }
        }
        throw pe;
    }

    public static int readQualityFactor(String q) throws ParseException {
        char wholeNumber;
        char c;
        if (q == null || q.length() == 0) {
            throw new ParseException("Quality value cannot be null or an empty String", 0);
        }
        int index = 0;
        int length = q.length();
        if (length > 5) {
            throw new ParseException("Quality value is greater than the maximum length, 5", 0);
        }
        if ((c = (wholeNumber = q.charAt(index++))) == '0' || c == '1') {
            if (index == length) {
                return (c - 48) * 1000;
            }
            if ((c = q.charAt(index++)) != '.') {
                throw new ParseException("Error parsing Quality value: a decimal place is expected rather than '" + c + "'", index);
            }
            if (index == length) {
                return (c - 48) * 1000;
            }
        } else if (c == '.') {
            if (index == length) {
                throw new ParseException("Error parsing Quality value: a decimal numeral is expected after the decimal point", index);
            }
        } else {
            throw new ParseException("Error parsing Quality value: a decimal numeral '0' or '1' is expected rather than '" + c + "'", index);
        }
        int value = 0;
        int exponent = 100;
        while (index < length) {
            if ((c = q.charAt(index++)) >= '0' && c <= '9') {
                value += (c - 48) * exponent;
                exponent /= 10;
                continue;
            }
            throw new ParseException("Error parsing Quality value: a decimal numeral is expected rather than '" + c + "'", index);
        }
        if (wholeNumber == '1' && value > 0) {
            throw new ParseException("The Quality value, " + q + ", is greater than 1", index);
        }
        return value;
    }

    public static int readQualityFactorParameter(HttpHeaderReader reader) throws ParseException {
        int q = -1;
        while (reader.hasNext()) {
            reader.nextSeparator(';');
            if (!reader.hasNext()) {
                return 1000;
            }
            String name = reader.nextToken();
            reader.nextSeparator('=');
            String value = reader.nextTokenOrQuotedString();
            if (q != -1 || !name.equalsIgnoreCase("q")) continue;
            q = HttpHeaderReader.readQualityFactor(value);
        }
        return q == -1 ? 1000 : q;
    }

    public static Map<String, String> readParameters(HttpHeaderReader reader) throws ParseException {
        LinkedHashMap<String, String> m = null;
        while (reader.hasNext()) {
            reader.nextSeparator(';');
            if (!reader.hasNext()) break;
            String name = reader.nextToken();
            reader.nextSeparator('=');
            String value = reader.nextTokenOrQuotedString();
            if (m == null) {
                m = new LinkedHashMap<String, String>();
            }
            m.put(name.toLowerCase(), value);
        }
        return m;
    }

    public static <T> List<T> readList(ListElementCreator<T> c, String header) throws ParseException {
        ArrayList<T> l = new ArrayList<T>();
        HttpHeaderReaderImpl reader = new HttpHeaderReaderImpl(header);
        HttpHeaderListAdapter adapter = new HttpHeaderListAdapter(reader);
        while (((HttpHeaderReader)reader).hasNext()) {
            l.add(c.create(adapter));
            adapter.reset();
            if (!((HttpHeaderReader)reader).hasNext()) continue;
            ((HttpHeaderReader)reader).next();
        }
        return l;
    }

    public static <T extends QualityFactor> List<T> readAcceptableList(ListElementCreator<T> c, String header) throws ParseException {
        List<T> l = HttpHeaderReader.readList(c, header);
        Collections.sort(l, QUALITY_COMPARATOR);
        return l;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ListElementCreator<T> {
        public T create(HttpHeaderReader var1) throws ParseException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Event {
        Token,
        QuotedString,
        Comment,
        Separator,
        Control;

    }
}

