/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.api.uri;

import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UriPattern {
    public static final UriPattern EMPTY = new UriPattern();
    private final String regex;
    private final Pattern regexPattern;

    private UriPattern() {
        this(null);
    }

    public UriPattern(String regex) {
        if (regex == null || regex.length() == 0) {
            this.regex = "";
            this.regexPattern = null;
        } else {
            this.regex = regex;
            this.regexPattern = Pattern.compile(regex);
        }
    }

    public final String getRegex() {
        return this.regex;
    }

    public final boolean match(CharSequence uri, List<String> groupValues) {
        if (groupValues == null) {
            throw new IllegalArgumentException();
        }
        if (uri == null || uri.length() == 0) {
            return this.regexPattern == null;
        }
        if (this.regexPattern == null) {
            return false;
        }
        Matcher m = this.regexPattern.matcher(uri);
        if (!m.matches()) {
            return false;
        }
        groupValues.clear();
        for (int i = 1; i <= m.groupCount(); ++i) {
            groupValues.add(m.group(i));
        }
        return true;
    }

    public final boolean match(CharSequence uri, List<String> groupNames, Map<String, String> groupValues) {
        if (groupValues == null) {
            throw new IllegalArgumentException();
        }
        if (uri == null || uri.length() == 0) {
            return this.regexPattern == null;
        }
        if (this.regexPattern == null) {
            return false;
        }
        Matcher m = this.regexPattern.matcher(uri);
        if (!m.matches()) {
            return false;
        }
        groupValues.clear();
        int i = 1;
        for (String name : groupNames) {
            String previousValue = groupValues.get(name);
            String currentValue = m.group(i++);
            if (previousValue != null && !previousValue.equals(currentValue)) {
                return false;
            }
            groupValues.put(name, currentValue);
        }
        return true;
    }

    public final int hashCode() {
        return this.regex.hashCode();
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UriPattern that = (UriPattern)obj;
        return this.regex == that.regex || this.regex != null && this.regex.equals(that.regex);
    }

    public final String toString() {
        return this.regex;
    }
}

