/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.api.uri;

import com.sun.ws.rest.impl.MultivaluedMapImpl;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UriComponent {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String[] SCHEME = new String[]{"0-9", "A-Z", "a-z", "+", "-", "."};
    private static final String[] UNRESERVED = new String[]{"0-9", "A-Z", "a-z", "-", ".", "_", "~"};
    private static final String[] SUB_DELIMS = new String[]{"!", "$", "&", "'", "(", ")", "*", "+", ",", ";", "="};
    private static final boolean[][] ENCODING_TABLES = UriComponent.creatingEncodingTables();
    private static final Charset UTF_8_CHARSET = Charset.forName("UTF-8");
    private static final int[] HEX_TABLE = UriComponent.createHexTable();

    private UriComponent() {
    }

    public static void validate(String s, Type t) {
        UriComponent.validate(s, t, false);
    }

    public static void validate(String s, Type t, boolean template) {
        int i = UriComponent._valid(s, t, template);
        if (i > -1) {
            throw new IllegalArgumentException("The string '" + s + "' for the URI component " + (Object)((Object)t) + " contains an invalid character, '" + s.charAt(i) + "', at index " + i);
        }
    }

    public static boolean valid(String s, Type t) {
        return UriComponent.valid(s, t, false);
    }

    public static boolean valid(String s, Type t, boolean template) {
        return UriComponent._valid(s, t, template) == -1;
    }

    private static int _valid(String s, Type t, boolean template) {
        boolean[] table = ENCODING_TABLES[t.ordinal()];
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if ((c >= '\u0080' || c == '%' || table[c]) && c < '\u0080' || template && (c == '{' || c == '}')) continue;
            return i;
        }
        return -1;
    }

    public static String encode(String s, Type t) {
        return UriComponent.encode(s, t, false);
    }

    public static String encode(String s, Type t, boolean template) {
        boolean[] table = ENCODING_TABLES[t.ordinal()];
        StringBuilder sb = null;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c < '\u0080' && table[c]) {
                if (sb == null) continue;
                sb.append(c);
                continue;
            }
            if (template && (c == '{' || c == '}')) {
                if (sb == null) continue;
                sb.append(c);
                continue;
            }
            if (sb == null) {
                sb = new StringBuilder();
                sb.append(s.substring(0, i));
            }
            if (c < '\u0080') {
                UriComponent.appendPercentEncodedOctet(sb, c);
                continue;
            }
            UriComponent.appendUTF8EncodedCharacter(sb, c);
        }
        return sb == null ? s : sb.toString();
    }

    private static void appendPercentEncodedOctet(StringBuilder sb, int b) {
        sb.append('%');
        sb.append(HEX_DIGITS[b >> 4]);
        sb.append(HEX_DIGITS[b & 0xF]);
    }

    private static void appendUTF8EncodedCharacter(StringBuilder sb, char c) {
        ByteBuffer bb = UTF_8_CHARSET.encode("" + c);
        while (bb.hasRemaining()) {
            UriComponent.appendPercentEncodedOctet(sb, bb.get() & 0xFF);
        }
    }

    private static boolean[][] creatingEncodingTables() {
        boolean[][] tables = new boolean[Type.values().length][];
        ArrayList<String> l = new ArrayList<String>();
        l.addAll(Arrays.asList(SCHEME));
        tables[Type.SCHEME.ordinal()] = UriComponent.creatingEncodingTable(l);
        l.clear();
        l.addAll(Arrays.asList(UNRESERVED));
        l.addAll(Arrays.asList(SUB_DELIMS));
        tables[Type.HOST.ordinal()] = UriComponent.creatingEncodingTable(l);
        tables[Type.PORT.ordinal()] = UriComponent.creatingEncodingTable(Arrays.asList("0-9"));
        l.add(":");
        tables[Type.USER_INFO.ordinal()] = UriComponent.creatingEncodingTable(l);
        l.add("@");
        tables[Type.PATH_SEGMENT.ordinal()] = UriComponent.creatingEncodingTable(l);
        l.add("/");
        tables[Type.PATH.ordinal()] = UriComponent.creatingEncodingTable(l);
        l.add("?");
        tables[Type.QUERY.ordinal()] = UriComponent.creatingEncodingTable(l);
        tables[Type.FRAGMENT.ordinal()] = tables[Type.QUERY.ordinal()];
        return tables;
    }

    private static boolean[] creatingEncodingTable(List<String> allowed) {
        boolean[] table = new boolean[128];
        for (String range : allowed) {
            if (range.length() == 1) {
                table[range.charAt((int)0)] = true;
                continue;
            }
            if (range.length() != 3 || range.charAt(1) != '-') continue;
            for (int i = range.charAt(0); i <= range.charAt(2); ++i) {
                table[i] = true;
            }
        }
        return table;
    }

    public static String decode(String s, Type t) {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        int n = s.length();
        if (n == 0) {
            return s;
        }
        if (s.indexOf(37) < 0) {
            return s;
        }
        if (n < 2) {
            throw new IllegalArgumentException("Malformed percent-encoded octet at index 1");
        }
        if (s.charAt(n - 2) == '%') {
            throw new IllegalArgumentException("Malformed percent-encoded octet at index " + (n - 2));
        }
        return t != Type.HOST ? UriComponent.decode(s, n) : UriComponent.decodeHost(s, n);
    }

    public static MultivaluedMap<String, String> decodeQuery(URI u, boolean decode) {
        return UriComponent.decodeQuery(u.getRawQuery(), decode);
    }

    public static MultivaluedMap<String, String> decodeQuery(String q, boolean decode) {
        MultivaluedMapImpl queryParameters = new MultivaluedMapImpl();
        if (q == null || q.length() == 0) {
            return queryParameters;
        }
        for (String s : q.split("&")) {
            if (s.length() == 0) continue;
            String[] keyVal = s.split("=");
            try {
                String key;
                String string = key = decode ? URLDecoder.decode(keyVal[0], "UTF-8") : keyVal[0];
                if (key.length() == 0) continue;
                String val = keyVal.length == 2 ? (decode ? URLDecoder.decode(keyVal[1], "UTF-8") : keyVal[1]) : "";
                queryParameters.add(key, val);
            }
            catch (UnsupportedEncodingException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
        return queryParameters;
    }

    private static String decode(String s, int n) {
        StringBuilder sb = new StringBuilder(n);
        ByteBuffer bb = ByteBuffer.allocate(1);
        int i = 0;
        while (i < n) {
            char c;
            if ((c = s.charAt(i++)) != '%') {
                sb.append(c);
                continue;
            }
            bb = UriComponent.decodePercentEncodedOctets(s, i, bb);
            i = UriComponent.decodeOctets(i, bb, sb);
        }
        return sb.toString();
    }

    private static String decodeHost(String s, int n) {
        StringBuilder sb = new StringBuilder(n);
        ByteBuffer bb = ByteBuffer.allocate(1);
        boolean betweenBrackets = false;
        int i = 0;
        while (i < n) {
            char c;
            if ((c = s.charAt(i++)) == '[') {
                betweenBrackets = true;
            } else if (betweenBrackets && c == ']') {
                betweenBrackets = false;
            }
            if (c != '%' || betweenBrackets) {
                sb.append(c);
                continue;
            }
            bb = UriComponent.decodePercentEncodedOctets(s, i, bb);
            i = UriComponent.decodeOctets(i, bb, sb);
        }
        return sb.toString();
    }

    private static ByteBuffer decodePercentEncodedOctets(String s, int i, ByteBuffer bb) {
        bb.clear();
        while (true) {
            bb.put((byte)(UriComponent.decodeHex(s, i++) << 4 | UriComponent.decodeHex(s, i++)));
            if (i == s.length() || s.charAt(i++) != '%') break;
            if (bb.position() != bb.capacity()) continue;
            bb.flip();
            ByteBuffer bb_new = ByteBuffer.allocate(s.length() / 3);
            bb_new.put(bb);
            bb = bb_new;
        }
        bb.flip();
        return bb;
    }

    private static int decodeOctets(int i, ByteBuffer bb, StringBuilder sb) {
        if (bb.limit() == 1 && (bb.get(0) & 0xFF) < 128) {
            sb.append((char)bb.get(0));
            return i + 2;
        }
        CharBuffer cb = UTF_8_CHARSET.decode(bb);
        sb.append(cb.toString());
        return i + bb.limit() * 3 - 1;
    }

    private static int decodeHex(String s, int i) {
        int v = UriComponent.decodeHex(s.charAt(i));
        if (v == -1) {
            throw new IllegalArgumentException("Malformed percent-encoded octet at index " + i + ", invalid hexadecimal digit '" + s.charAt(i) + "'");
        }
        return v;
    }

    private static int[] createHexTable() {
        int c;
        int[] table = new int[128];
        Arrays.fill(table, -1);
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            table[c] = c - 48;
        }
        for (c = 65; c <= 70; c = (int)((char)(c + 1))) {
            table[c] = c - 65 + 10;
        }
        for (c = 97; c <= 102; c = (int)((char)(c + 1))) {
            table[c] = c - 97 + 10;
        }
        return table;
    }

    private static int decodeHex(char c) {
        return c < '\u0080' ? HEX_TABLE[c] : -1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        SCHEME,
        USER_INFO,
        HOST,
        PORT,
        PATH,
        PATH_SEGMENT,
        QUERY,
        FRAGMENT;

    }
}

