/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.api.model;

import com.sun.ws.rest.api.model.AbstractModelComponent;
import com.sun.ws.rest.api.model.AbstractModelVisitor;
import com.sun.ws.rest.api.model.AbstractResourceConstructor;
import com.sun.ws.rest.api.model.AbstractResourceMethod;
import com.sun.ws.rest.api.model.AbstractSubResourceLocator;
import com.sun.ws.rest.api.model.AbstractSubResourceMethod;
import com.sun.ws.rest.api.model.UriPathAnnotated;
import com.sun.ws.rest.api.model.UriPathValue;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractResource
implements UriPathAnnotated,
AbstractModelComponent {
    private Class<?> resourceClass;
    private UriPathValue uriPath;
    private List<AbstractResourceMethod> resourceMethods;
    private List<AbstractSubResourceMethod> subResourceMethods;
    private List<AbstractSubResourceLocator> subResourceLocators;
    private List<AbstractResourceConstructor> constructors;

    public AbstractResource(Class<?> resourceClass) {
        this(resourceClass, null);
    }

    public AbstractResource(Class<?> resourceClass, UriPathValue uriPath) {
        this.resourceClass = resourceClass;
        this.uriPath = uriPath;
        this.constructors = new ArrayList<AbstractResourceConstructor>();
        this.resourceMethods = new ArrayList<AbstractResourceMethod>();
        this.subResourceLocators = new ArrayList<AbstractSubResourceLocator>();
        this.subResourceMethods = new ArrayList<AbstractSubResourceMethod>();
    }

    public Class<?> getResourceClass() {
        return this.resourceClass;
    }

    public boolean isSubResource() {
        return this.uriPath == null;
    }

    public boolean isRootResource() {
        return this.uriPath != null;
    }

    @Override
    public UriPathValue getUriPath() {
        return this.uriPath;
    }

    public List<AbstractResourceMethod> getResourceMethods() {
        return this.resourceMethods;
    }

    public List<AbstractSubResourceMethod> getSubResourceMethods() {
        return this.subResourceMethods;
    }

    public List<AbstractSubResourceLocator> getSubResourceLocators() {
        return this.subResourceLocators;
    }

    public List<AbstractResourceConstructor> getConstructors() {
        return this.constructors;
    }

    @Override
    public void accept(AbstractModelVisitor visitor) {
        visitor.visitAbstractResource(this);
    }

    public String toString() {
        return "AbstractResource(" + (null == this.getUriPath() ? "" : "\"" + this.getUriPath().getValue() + "\", - ") + this.getResourceClass().getSimpleName() + ": " + this.getResourceMethods().size() + " res methods, " + this.getSubResourceMethods().size() + " subres methods, " + this.getSubResourceLocators().size() + " subres locators " + ")";
    }

    @Override
    public List<AbstractModelComponent> getComponents() {
        LinkedList<AbstractModelComponent> components = new LinkedList<AbstractModelComponent>();
        components.addAll(this.getConstructors());
        components.addAll(this.getResourceMethods());
        components.addAll(this.getSubResourceMethods());
        components.addAll(this.getSubResourceLocators());
        return components;
    }
}

