/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.api.client;

import com.sun.ws.rest.api.client.ClientHandler;
import com.sun.ws.rest.api.client.ClientRequest;
import com.sun.ws.rest.api.client.ClientResponse;
import com.sun.ws.rest.api.client.Filterable;
import com.sun.ws.rest.api.client.PartialRequestBuilder;
import com.sun.ws.rest.api.client.RequestBuilder;
import com.sun.ws.rest.api.client.UniformInterface;
import com.sun.ws.rest.api.client.UniformInterfaceException;
import com.sun.ws.rest.impl.client.ClientRequestImpl;
import java.net.URI;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WebResource
extends Filterable
implements RequestBuilder<Builder>,
UniformInterface {
    private final URI u;

    WebResource(ClientHandler c, URI u) {
        super(c);
        this.u = u;
    }

    public URI getURI() {
        return this.u;
    }

    public UriBuilder getBuilder() {
        return UriBuilder.fromUri((URI)this.u);
    }

    @Override
    public ClientResponse head() {
        return this.getHeadHandler().handle(new ClientRequestImpl(this.u, "HEAD"));
    }

    @Override
    public <T> T options(Class<T> c) {
        return this.handle(c, new ClientRequestImpl(this.u, "OPTIONS"));
    }

    @Override
    public <T> T get(Class<T> c) {
        return this.handle(c, new ClientRequestImpl(this.u, "GET"));
    }

    @Override
    public void put() {
        this.voidHandle(new ClientRequestImpl(this.u, "PUT", null));
    }

    @Override
    public void put(Object requestEntity) {
        this.voidHandle(new ClientRequestImpl(this.u, "PUT", requestEntity));
    }

    @Override
    public <T> T put(Class<T> c) {
        return this.handle(c, new ClientRequestImpl(this.u, "PUT"));
    }

    @Override
    public <T> T put(Class<T> c, Object requestEntity) {
        return this.handle(c, new ClientRequestImpl(this.u, "PUT", requestEntity));
    }

    @Override
    public void post() {
        this.voidHandle(new ClientRequestImpl(this.u, "POST"));
    }

    @Override
    public void post(Object requestEntity) {
        this.voidHandle(new ClientRequestImpl(this.u, "POST", requestEntity));
    }

    @Override
    public <T> T post(Class<T> c) {
        return this.handle(c, new ClientRequestImpl(this.u, "POST"));
    }

    @Override
    public <T> T post(Class<T> c, Object requestEntity) {
        return this.handle(c, new ClientRequestImpl(this.u, "POST", requestEntity));
    }

    @Override
    public void delete() {
        this.voidHandle(new ClientRequestImpl(this.u, "DELETE"));
    }

    @Override
    public void delete(Object requestEntity) {
        this.voidHandle(new ClientRequestImpl(this.u, "DELETE", requestEntity));
    }

    @Override
    public <T> T delete(Class<T> c) {
        return this.handle(c, new ClientRequestImpl(this.u, "DELETE"));
    }

    @Override
    public <T> T delete(Class<T> c, Object requestEntity) {
        return this.handle(c, new ClientRequestImpl(this.u, "DELETE", requestEntity));
    }

    @Override
    public void method(String method) {
        this.voidHandle(new ClientRequestImpl(this.u, method));
    }

    @Override
    public void method(String method, Object requestEntity) {
        this.voidHandle(new ClientRequestImpl(this.u, method, requestEntity));
    }

    @Override
    public <T> T method(String method, Class<T> c) {
        return this.handle(c, new ClientRequestImpl(this.u, method));
    }

    @Override
    public <T> T method(String method, Class<T> c, Object requestEntity) {
        return this.handle(c, new ClientRequestImpl(this.u, method, requestEntity));
    }

    @Override
    public Builder entity(Object entity) {
        return (Builder)new Builder(this.u).entity(entity);
    }

    @Override
    public Builder entity(Object entity, MediaType type) {
        return (Builder)new Builder(this.u).entity(entity, type);
    }

    @Override
    public Builder entity(Object entity, String type) {
        return (Builder)new Builder(this.u).entity(entity, type);
    }

    @Override
    public Builder type(MediaType type) {
        return (Builder)new Builder(this.u).type(type);
    }

    @Override
    public Builder type(String type) {
        return (Builder)new Builder(this.u).type(type);
    }

    @Override
    public Builder accept(MediaType ... types) {
        return (Builder)new Builder(this.u).accept(types);
    }

    @Override
    public Builder accept(String ... types) {
        return (Builder)new Builder(this.u).accept(types);
    }

    @Override
    public Builder header(String name, Object value) {
        return (Builder)new Builder(this.u).header(name, value);
    }

    public Builder path(String path) {
        return new Builder(UriBuilder.fromUri((URI)this.u).path(new String[]{path}).build());
    }

    public Builder uri(URI uri) {
        String query;
        UriBuilder b = UriBuilder.fromUri((URI)this.u).encode(false);
        String path = uri.getRawPath();
        if (path != null && path.length() > 0) {
            if (path.startsWith("/")) {
                b.replacePath(new String[]{path});
            } else {
                b.path(new String[]{path});
            }
        }
        if ((query = uri.getRawQuery()) != null && query.length() > 0) {
            b.replaceQueryParams(query);
        }
        return new Builder(b.build());
    }

    private <T> T handle(Class<T> c, ClientRequest ro) {
        ClientResponse r = this.getHeadHandler().handle(ro);
        if (c == ClientResponse.class) {
            return c.cast(r);
        }
        if (r.getStatus() < 300) {
            return r.getEntity(c);
        }
        throw new UniformInterfaceException(r);
    }

    private void voidHandle(ClientRequest ro) {
        ClientResponse r = this.getHeadHandler().handle(ro);
        if (r.getStatus() >= 300) {
            throw new UniformInterfaceException(r);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class Builder
    extends PartialRequestBuilder<Builder>
    implements UniformInterface {
        private final URI u;

        private Builder(URI u) {
            this.u = u;
        }

        private ClientRequest build(String method) {
            ClientRequestImpl ro = new ClientRequestImpl(this.u, method, this.entity, (MultivaluedMap<String, Object>)this.metadata);
            this.entity = null;
            this.metadata = null;
            return ro;
        }

        private ClientRequest build(String method, Object e) {
            ClientRequestImpl ro = new ClientRequestImpl(this.u, method, e, (MultivaluedMap<String, Object>)this.metadata);
            this.entity = null;
            this.metadata = null;
            return ro;
        }

        @Override
        public ClientResponse head() {
            return WebResource.this.getHeadHandler().handle(this.build("HEAD"));
        }

        @Override
        public <T> T options(Class<T> c) {
            return (T)WebResource.this.handle(c, this.build("OPTIONS"));
        }

        @Override
        public <T> T get(Class<T> c) {
            return (T)WebResource.this.handle(c, this.build("GET"));
        }

        @Override
        public void put() {
            WebResource.this.voidHandle(this.build("PUT"));
        }

        @Override
        public void put(Object requestEntity) {
            WebResource.this.voidHandle(this.build("PUT", requestEntity));
        }

        @Override
        public <T> T put(Class<T> c) {
            return (T)WebResource.this.handle(c, this.build("PUT"));
        }

        @Override
        public <T> T put(Class<T> c, Object requestEntity) {
            return (T)WebResource.this.handle(c, this.build("PUT", requestEntity));
        }

        @Override
        public void post() {
            WebResource.this.voidHandle(this.build("POST"));
        }

        @Override
        public void post(Object requestEntity) {
            WebResource.this.voidHandle(this.build("POST", requestEntity));
        }

        @Override
        public <T> T post(Class<T> c) {
            return (T)WebResource.this.handle(c, this.build("POST"));
        }

        @Override
        public <T> T post(Class<T> c, Object requestEntity) {
            return (T)WebResource.this.handle(c, this.build("POST", requestEntity));
        }

        @Override
        public void delete() {
            WebResource.this.voidHandle(this.build("DELETE"));
        }

        @Override
        public void delete(Object requestEntity) {
            WebResource.this.voidHandle(this.build("DELETE", requestEntity));
        }

        @Override
        public <T> T delete(Class<T> c) {
            return (T)WebResource.this.handle(c, this.build("DELETE"));
        }

        @Override
        public <T> T delete(Class<T> c, Object requestEntity) {
            return (T)WebResource.this.handle(c, this.build("DELETE", requestEntity));
        }

        @Override
        public void method(String method) {
            WebResource.this.voidHandle(this.build(method));
        }

        @Override
        public void method(String method, Object requestEntity) {
            WebResource.this.voidHandle(this.build(method, requestEntity));
        }

        @Override
        public <T> T method(String method, Class<T> c) {
            return (T)WebResource.this.handle(c, this.build(method));
        }

        @Override
        public <T> T method(String method, Class<T> c, Object requestEntity) {
            return (T)WebResource.this.handle(c, this.build(method, requestEntity));
        }
    }
}

