/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.validation.xpath;

import org.netbeans.modules.bpel.model.api.BooleanExpr;
import org.netbeans.modules.bpel.model.api.Branches;
import org.netbeans.modules.bpel.model.api.Condition;
import org.netbeans.modules.bpel.model.api.ContentElement;
import org.netbeans.modules.bpel.model.api.Copy;
import org.netbeans.modules.bpel.model.api.DeadlineExpression;
import org.netbeans.modules.bpel.model.api.DurationExpression;
import org.netbeans.modules.bpel.model.api.FinalCounterValue;
import org.netbeans.modules.bpel.model.api.For;
import org.netbeans.modules.bpel.model.api.From;
import org.netbeans.modules.bpel.model.api.PartReference;
import org.netbeans.modules.bpel.model.api.PartnerLink;
import org.netbeans.modules.bpel.model.api.Query;
import org.netbeans.modules.bpel.model.api.RepeatEvery;
import org.netbeans.modules.bpel.model.api.StartCounterValue;
import org.netbeans.modules.bpel.model.api.To;
import org.netbeans.modules.bpel.model.api.VariableDeclaration;
import org.netbeans.modules.bpel.model.api.VariableReference;
import org.netbeans.modules.bpel.model.api.references.BpelReference;
import org.netbeans.modules.bpel.model.api.references.SchemaReference;
import org.netbeans.modules.bpel.model.api.references.WSDLReference;
import org.netbeans.modules.bpel.model.api.support.PathValidationContext;
import org.netbeans.modules.bpel.model.api.support.Utils;
import org.netbeans.modules.bpel.model.api.support.ValidationVisitor;
import org.netbeans.modules.bpel.validation.core.BpelValidator;
import org.netbeans.modules.soa.ui.util.Duration;
import org.netbeans.modules.soa.ui.util.DurationUtil;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.validation.ValidationUtil;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Named;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.netbeans.modules.xml.xpath.ext.spi.validation.XPathValidationContext;

public final class Validator
extends BpelValidator
implements ValidationVisitor {
    public void visit(Copy copy) {
        Component component = this.getTypeOfElement(this.getType(copy.getFrom()));
        Component component2 = this.getTypeOfElement(this.getType(copy.getTo()));
        if (component == null || component2 == null) {
            return;
        }
        String string = ((Named)component).getName();
        String string2 = ((Named)component2).getName();
        if (string == null || string2 == null) {
            return;
        }
        if (string.equals(string2)) {
            return;
        }
        if (string.equals("anyType") || string2.equals("anyType")) {
            return;
        }
        if (ValidationUtil.getBasedSimpleType((Component)component) != ValidationUtil.getBasedSimpleType((Component)component2)) {
            this.addWarning("FIX_TYPE_IN_COPY", (Component)copy, this.getTypeName(component), this.getTypeName(component2));
        }
    }

    public void visit(To to) {
        this.checkPartnerLink(to);
        this.checkVariable(to);
    }

    private void checkPartnerLink(To to) {
        BpelReference bpelReference = to.getPartnerLink();
        if (bpelReference == null) {
            return;
        }
        PartnerLink partnerLink = (PartnerLink)bpelReference.get();
        if (partnerLink == null) {
            return;
        }
        WSDLReference wSDLReference = partnerLink.getPartnerRole();
        if (wSDLReference == null || wSDLReference.get() == null) {
            this.addError("FIX_To_PartnerLink", (Component)to);
        }
    }

    private void checkVariable(To to) {
        String string = to.getContent();
        if (string == null) {
            return;
        }
        if ((string = string.trim()).length() == 0) {
            return;
        }
        if (!string.startsWith("$")) {
            this.addError("FIX_To_Value", (Component)to, string);
        }
    }

    private Component getType(From from) {
        if (from == null) {
            return null;
        }
        Component component = this.getVariableType((VariableReference)from);
        if (component != null) {
            SchemaComponent schemaComponent = this.getPartType((PartReference)from);
            if (schemaComponent == null) {
                return component;
            }
            return schemaComponent;
        }
        return this.checkXPath((ContentElement)from);
    }

    private Component getType(To to) {
        if (to == null) {
            return null;
        }
        Component component = this.getVariableType((VariableReference)to);
        if (component != null) {
            SchemaComponent schemaComponent = this.getPartType((PartReference)to);
            if (schemaComponent == null) {
                return component;
            }
            return schemaComponent;
        }
        return this.checkXPath((ContentElement)to);
    }

    private Component getVariableType(VariableReference variableReference) {
        GlobalType globalType;
        SchemaReference schemaReference;
        SchemaReference schemaReference2;
        BpelReference bpelReference = variableReference.getVariable();
        if (bpelReference == null) {
            return null;
        }
        VariableDeclaration variableDeclaration = (VariableDeclaration)bpelReference.get();
        if (variableDeclaration == null) {
            return null;
        }
        WSDLReference wSDLReference = variableDeclaration.getMessageType();
        if (wSDLReference != null && (schemaReference2 = (Message)wSDLReference.get()) != null) {
            return schemaReference2;
        }
        schemaReference2 = variableDeclaration.getElement();
        if (schemaReference2 != null && (schemaReference = (GlobalElement)schemaReference2.get()) != null) {
            return schemaReference;
        }
        schemaReference = variableDeclaration.getType();
        if (schemaReference != null && (globalType = (GlobalType)schemaReference.get()) != null) {
            return globalType;
        }
        return null;
    }

    private SchemaComponent getPartType(PartReference partReference) {
        WSDLReference wSDLReference = partReference.getPart();
        if (wSDLReference == null) {
            return null;
        }
        return this.getPartType((Part)wSDLReference.get());
    }

    private SchemaComponent getPartType(Part part) {
        GlobalType globalType;
        NamedComponentReference namedComponentReference;
        if (part == null) {
            return null;
        }
        NamedComponentReference namedComponentReference2 = part.getElement();
        if (namedComponentReference2 != null && (namedComponentReference = (GlobalElement)namedComponentReference2.get()) != null) {
            return namedComponentReference;
        }
        namedComponentReference = part.getType();
        if (namedComponentReference != null && (globalType = (GlobalType)namedComponentReference.get()) != null) {
            return globalType;
        }
        return null;
    }

    public void visit(BooleanExpr booleanExpr) {
        this.checkXPath((ContentElement)booleanExpr);
    }

    public void visit(Branches branches) {
        this.checkXPath((ContentElement)branches);
    }

    public void visit(Condition condition) {
        this.checkXPath((ContentElement)condition);
    }

    public void visit(DeadlineExpression deadlineExpression) {
        this.checkXPath((ContentElement)deadlineExpression);
    }

    public void visit(FinalCounterValue finalCounterValue) {
        this.checkXPath((ContentElement)finalCounterValue);
    }

    public void visit(For for_) {
        this.checkXPath((ContentElement)for_);
        this.checkDuration((DurationExpression)for_);
    }

    public void visit(RepeatEvery repeatEvery) {
        this.checkXPath((ContentElement)repeatEvery);
        this.checkDuration((DurationExpression)repeatEvery);
        this.checkNegative(repeatEvery);
    }

    private void checkNegative(RepeatEvery repeatEvery) {
        String string = repeatEvery.getContent();
        if (string == null) {
            return;
        }
        if (!string.startsWith("'") || !string.endsWith("'")) {
            return;
        }
        try {
            Duration duration = DurationUtil.parseDuration((String)string, (boolean)true);
            if (duration.hasMinus() || this.isZero(duration)) {
                this.addError("FIX_Negative_RepeatEvery", (Component)repeatEvery);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private boolean isZero(Duration duration) {
        return duration.getYears() == 0 && duration.getMonths() == 0 && duration.getDays() == 0 && duration.getHours() == 0 && duration.getMinutes() == 0 && duration.getSeconds() == 0.0;
    }

    public void visit(Query query) {
        this.checkXPath((ContentElement)query);
    }

    public void visit(StartCounterValue startCounterValue) {
        this.checkXPath((ContentElement)startCounterValue);
    }

    private SchemaComponent checkXPath(ContentElement contentElement) {
        return Utils.checkXPathExpression((ContentElement)contentElement, (XPathValidationContext)new PathValidationContext((org.netbeans.modules.xml.xam.spi.Validator)this, (ValidationVisitor)this, contentElement));
    }

    private void checkDuration(DurationExpression durationExpression) {
        String string = durationExpression.getContent();
        try {
            DurationUtil.parseDuration((String)string, (boolean)true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.addError("FIX_Duration", (Component)durationExpression, illegalArgumentException.getMessage());
        }
    }

    private static void out() {
        System.out.println();
    }

    private void out(Object object) {
        System.out.println("*** " + object);
    }
}

