/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.validation.action;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import org.netbeans.modules.bpel.core.BPELDataEditorSupport;
import org.netbeans.modules.bpel.core.util.BPELValidationController;
import org.netbeans.modules.bpel.validation.core.QuickFix;
import org.netbeans.modules.bpel.validation.core.QuickFixable;
import org.netbeans.modules.bpel.validation.core.Util;
import org.netbeans.modules.soa.ui.util.UI;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.openide.nodes.Node;
import org.openide.text.DataEditorSupport;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class QuickFixAction
extends UI.IconAction {
    private BPELValidationController myValidationController;

    public QuickFixAction() {
        super(UI.i18n(QuickFixAction.class, (String)"CTL_Quick_Fix_Action"), UI.i18n(QuickFixAction.class, (String)"TLT_Quick_Fix_Action"), (Icon)UI.icon(Util.class, (String)"quickfix"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        InputOutput inputOutput = IOProvider.getDefault().getIO(UI.i18n(QuickFixAction.class, (String)"LBL_Quick_Fix_Window"), false);
        OutputWriter outputWriter = inputOutput.getOut();
        try {
            outputWriter.reset();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        inputOutput.select();
        outputWriter.println(UI.i18n(QuickFixAction.class, (String)"MSG_Quick_Fix_started"));
        this.doQuickFix(this.getQuickFixes(UI.getSelectedNode()), outputWriter);
        outputWriter.println();
        outputWriter.print(UI.i18n(QuickFixAction.class, (String)"MSG_Quick_Fix_finished"));
    }

    private void doQuickFix(List<QuickFix> list, OutputWriter outputWriter) {
        if (list.size() == 0) {
            outputWriter.println();
            outputWriter.println(UI.i18n(QuickFixAction.class, (String)"MSG_Nothing_to_do"));
            return;
        }
        for (QuickFix quickFix : list) {
            if (quickFix.canFix()) {
                quickFix.doFix();
            }
            outputWriter.println();
            outputWriter.println(UI.i18n(QuickFixAction.class, (String)"MSG_Quick_Fix", (String)quickFix.getDescription()));
        }
    }

    private List<QuickFix> getQuickFixes(Node node) {
        Object object;
        ArrayList<QuickFix> arrayList = new ArrayList<QuickFix>();
        if (node == null) {
            return arrayList;
        }
        if (this.myValidationController == null) {
            object = (BPELDataEditorSupport)node.getLookup().lookup(DataEditorSupport.class);
            this.myValidationController = object.getValidationController();
        }
        if (this.myValidationController == null) {
            return arrayList;
        }
        object = this.myValidationController.getValidationResult();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            QuickFix quickFix;
            Validator.ResultItem resultItem = (Validator.ResultItem)iterator.next();
            if (!(resultItem instanceof QuickFixable) || (quickFix = ((QuickFixable)resultItem).getQuickFix()) == null) continue;
            arrayList.add(quickFix);
        }
        return arrayList;
    }
}

