/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbjarproject.classpath;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.ejbjarproject.classpath.BootClassPathImplementation;
import org.netbeans.modules.j2ee.ejbjarproject.classpath.SourcePathImplementation;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.project.classpath.support.ProjectClassPathSupport;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;

public final class ClassPathProviderImpl
implements ClassPathProvider,
AntProjectListener {
    private final AntProjectHelper helper;
    private final File projectDirectory;
    private final PropertyEvaluator evaluator;
    private final SourceRoots sourceRoots;
    private final SourceRoots testSourceRoots;
    private final ClassPath[] cache = new ClassPath[9];
    private final Map<String, FileObject> dirCache = new HashMap<String, FileObject>();

    public ClassPathProviderImpl(AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator, SourceRoots sourceRoots, SourceRoots sourceRoots2) {
        this.helper = antProjectHelper;
        this.projectDirectory = FileUtil.toFile((FileObject)antProjectHelper.getProjectDirectory());
        assert (this.projectDirectory != null);
        this.evaluator = propertyEvaluator;
        this.sourceRoots = sourceRoots;
        this.testSourceRoots = sourceRoots2;
        this.helper.addAntProjectListener((AntProjectListener)this);
    }

    private FileObject getDir(final String string) {
        return (FileObject)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<FileObject>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public FileObject run() {
                ClassPathProviderImpl classPathProviderImpl = ClassPathProviderImpl.this;
                synchronized (classPathProviderImpl) {
                    String string2;
                    FileObject fileObject = (FileObject)ClassPathProviderImpl.this.dirCache.get(string);
                    if (!(fileObject != null && fileObject.isValid() || (string2 = ClassPathProviderImpl.this.helper.getStandardPropertyEvaluator().getProperty(string)) == null)) {
                        fileObject = ClassPathProviderImpl.this.helper.resolveFileObject(string2);
                        ClassPathProviderImpl.this.dirCache.put(string, fileObject);
                    }
                    return fileObject;
                }
            }
        });
    }

    private FileObject[] getPrimarySrcPath() {
        return this.sourceRoots.getRoots();
    }

    private FileObject[] getTestSrcDir() {
        return this.testSourceRoots.getRoots();
    }

    private FileObject getBuildClassesDir() {
        return this.getDir("build.classes.dir");
    }

    private FileObject getBuildJar() {
        return this.getDir("dist.jar");
    }

    private FileObject getBuildTestClassesDir() {
        return this.getDir("build.test.classes.dir");
    }

    private int getType(FileObject fileObject) {
        FileObject fileObject2;
        int n;
        FileObject[] fileObjectArray = this.getPrimarySrcPath();
        for (n = 0; n < fileObjectArray.length; ++n) {
            fileObject2 = fileObjectArray[n];
            if (!fileObject2.equals(fileObject) && !FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) continue;
            return 0;
        }
        fileObjectArray = this.getTestSrcDir();
        for (n = 0; n < fileObjectArray.length; ++n) {
            fileObject2 = fileObjectArray[n];
            if (!fileObject2.equals(fileObject) && !FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) continue;
            return 1;
        }
        FileObject fileObject3 = this.getBuildClassesDir();
        if (fileObject3 != null && (fileObject3.equals(fileObject) || FileUtil.isParentOf((FileObject)fileObject3, (FileObject)fileObject))) {
            return 2;
        }
        fileObject3 = this.getBuildJar();
        if (fileObject3 != null && fileObject3.equals(fileObject)) {
            return 4;
        }
        fileObject3 = this.getBuildTestClassesDir();
        if (fileObject3 != null && (fileObject3.equals(fileObject) || FileUtil.isParentOf((FileObject)fileObject3, (FileObject)fileObject))) {
            return 3;
        }
        return -1;
    }

    private ClassPath getCompileTimeClasspath(FileObject fileObject) {
        int n = this.getType(fileObject);
        return this.getCompileTimeClasspath(n);
    }

    private synchronized ClassPath getCompileTimeClasspath(int n) {
        if (n < 0 || n > 1) {
            return null;
        }
        ClassPath classPath = this.cache[2 + n];
        if (classPath == null) {
            classPath = n == 0 ? ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.evaluator, (String[])new String[]{"javac.classpath", "j2ee.platform.classpath"})) : ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.evaluator, (String[])new String[]{"javac.test.classpath", "j2ee.platform.classpath"}));
            this.cache[2 + n] = classPath;
        }
        return classPath;
    }

    private synchronized ClassPath getRunTimeClasspath(FileObject fileObject) {
        ClassPath classPath;
        int n = this.getType(fileObject);
        if (n < 0 || n > 4) {
            return null;
        }
        if (n > 1) {
            n -= 2;
        }
        if ((classPath = this.cache[4 + n]) == null) {
            if (n == 0) {
                classPath = ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.evaluator, (String[])new String[]{"debug.classpath"}));
            } else if (n == 1) {
                classPath = ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.evaluator, (String[])new String[]{"run.test.classpath"}));
            } else if (n == 2) {
                classPath = ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.evaluator, (String[])new String[]{"dist.jar"}));
            }
            this.cache[4 + n] = classPath;
        }
        return classPath;
    }

    private ClassPath getSourcepath(FileObject fileObject) {
        int n = this.getType(fileObject);
        return this.getSourcepath(n);
    }

    private synchronized ClassPath getSourcepath(int n) {
        if (n < 0 || n > 1) {
            return null;
        }
        ClassPath classPath = this.cache[n];
        if (classPath == null) {
            switch (n) {
                case 0: {
                    classPath = ClassPathFactory.createClassPath((ClassPathImplementation)new SourcePathImplementation(this.sourceRoots, this.helper));
                    break;
                }
                case 1: {
                    classPath = ClassPathFactory.createClassPath((ClassPathImplementation)new SourcePathImplementation(this.testSourceRoots, this.helper));
                }
            }
        }
        this.cache[n] = classPath;
        return classPath;
    }

    private synchronized ClassPath getBootClassPath() {
        ClassPath classPath = this.cache[7];
        if (classPath == null) {
            this.cache[7] = classPath = ClassPathFactory.createClassPath((ClassPathImplementation)new BootClassPathImplementation(this.evaluator));
        }
        return classPath;
    }

    public synchronized ClassPath getJ2eePlatformClassPath() {
        ClassPath classPath = this.cache[8];
        if (classPath == null) {
            this.cache[8] = classPath = ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.evaluator, (String[])new String[]{"j2ee.platform.classpath"}));
        }
        return classPath;
    }

    public ClassPath findClassPath(FileObject fileObject, String string) {
        if (string.equals("classpath/compile")) {
            return this.getCompileTimeClasspath(fileObject);
        }
        if (string.equals("classpath/execute")) {
            return this.getRunTimeClasspath(fileObject);
        }
        if (string.equals("classpath/source")) {
            return this.getSourcepath(fileObject);
        }
        if (string.equals("classpath/boot")) {
            return this.getBootClassPath();
        }
        return null;
    }

    public ClassPath[] getProjectClassPaths(String string) {
        if ("classpath/boot".equals(string)) {
            return new ClassPath[]{this.getBootClassPath()};
        }
        if ("classpath/compile".equals(string)) {
            ClassPath[] classPathArray = new ClassPath[]{this.getCompileTimeClasspath(0), this.getCompileTimeClasspath(1)};
            return classPathArray;
        }
        if ("classpath/source".equals(string)) {
            ClassPath[] classPathArray = new ClassPath[]{this.getSourcepath(0), this.getSourcepath(1)};
            return classPathArray;
        }
        assert (false);
        return null;
    }

    public ClassPath getProjectSourcesClassPath(String string) {
        if ("classpath/boot".equals(string)) {
            return this.getBootClassPath();
        }
        if ("classpath/compile".equals(string)) {
            return this.getCompileTimeClasspath(0);
        }
        if ("classpath/source".equals(string)) {
            return this.getSourcepath(0);
        }
        assert (false);
        return null;
    }

    public void configurationXmlChanged(AntProjectEvent antProjectEvent) {
        this.dirCache.clear();
    }

    public synchronized void propertiesChanged(AntProjectEvent antProjectEvent) {
        this.dirCache.clear();
    }

    public String getPropertyName(SourceGroup sourceGroup, String string) {
        int n;
        FileObject fileObject = sourceGroup.getRootFolder();
        FileObject[] fileObjectArray = this.getPrimarySrcPath();
        for (n = 0; n < fileObjectArray.length; ++n) {
            if (!fileObject.equals(fileObjectArray[n])) continue;
            if ("classpath/compile".equals(string)) {
                return "javac.classpath";
            }
            if ("classpath/execute".equals(string)) {
                return "debug.classpath";
            }
            return null;
        }
        fileObjectArray = this.getTestSrcDir();
        for (n = 0; n < fileObjectArray.length; ++n) {
            if (!fileObject.equals(fileObjectArray[n])) continue;
            if ("classpath/compile".equals(string)) {
                return "javac.test.classpath";
            }
            if ("classpath/execute".equals(string)) {
                return "run.test.classpath";
            }
            return null;
        }
        return null;
    }
}

