/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.propertyeditors.css;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.visualweb.propertyeditors.css.ColorSelectionField;
import org.netbeans.modules.visualweb.propertyeditors.css.FontFamilyEditorDialog;
import org.netbeans.modules.visualweb.propertyeditors.css.StyleBuilderDialog;
import org.netbeans.modules.visualweb.propertyeditors.css.StyleEditor;
import org.netbeans.modules.visualweb.propertyeditors.css.model.CssStyleData;
import org.netbeans.modules.visualweb.propertyeditors.css.model.FontModel;
import org.netbeans.modules.visualweb.propertyeditors.css.model.PropertyData;
import org.netbeans.modules.visualweb.propertyeditors.css.model.PropertyWithUnitData;
import org.netbeans.modules.visualweb.propertyeditors.css.model.TextDecorationData;
import org.netbeans.modules.visualweb.propertyeditors.css.model.Utils;
import org.openide.util.NbBundle;

public class FontStyleEditor
extends StyleEditor
implements PropertyChangeListener {
    CssStyleData cssStyleData = null;
    ColorSelectionField colorField = new ColorSelectionField();
    TextDecorationData textDecorationData = new TextDecorationData();
    FontModel fontModel = new FontModel();
    DefaultListModel fontFamilies = this.fontModel.getFontFamilySetList();
    private JLabel colorLabel;
    private JPanel colorSelectionPanel;
    private JLabel decorationLabel;
    private JPanel decorationPanel;
    private JLabel errorLabel;
    private JPanel errorPanel;
    private JTextField fontChosenField;
    private JList fontFaceList;
    private JScrollPane fontFaceScroll;
    private JButton fontFamilyButton;
    private JPanel fontFamilyPanel;
    private JLabel fontLabel;
    private JTextField fontSizeField;
    private JList fontSizeList;
    private JPanel fontSizePanel;
    private JScrollPane fontSizeScroll;
    private JComboBox fontSizeUnitCombo;
    private JComboBox fontStyleComboBox;
    private JComboBox fontVariantComboBox;
    private JComboBox fontWeightComboBox;
    private JPanel mainPanel;
    private JCheckBox noDecorationCheckbox;
    private JCheckBox overlineCheckbox;
    private JLabel sizeLabel;
    private JCheckBox strikethroughCheckbox;
    private JLabel styleLabel;
    private JPanel styleMainPanel;
    private JPanel stylePanel;
    private JCheckBox underlineCheckbox;
    private JLabel variantLabel;
    private JLabel weightLabel;

    public FontStyleEditor(CssStyleData cssStyleData) {
        this.cssStyleData = cssStyleData;
        this.setName("fontStyleEditor");
        this.setDisplayName(NbBundle.getMessage(StyleBuilderDialog.class, (String)"FONT_EDITOR_DISPNAME"));
        this.initComponents();
        this.colorSelectionPanel.add((Component)this.colorField, "Center");
        this.colorField.addCssPropertyChangeListener(this);
        this.initialize();
    }

    private void initialize() {
        String string;
        String string2;
        Object object;
        String string3;
        Object object2;
        Object object3;
        this.fontFamilies = this.fontModel.getFontFamilySetList();
        this.fontFaceList.setModel(this.fontFamilies);
        String string4 = this.cssStyleData.getProperty("font-family");
        if (string4 != null) {
            object3 = "";
            object2 = new StringTokenizer(string4.trim(), ",");
            while (((StringTokenizer)object2).hasMoreTokens()) {
                string3 = ((StringTokenizer)object2).nextToken();
                if (new StringTokenizer(string3.trim()).countTokens() == 1) {
                    string3 = string3.replaceAll("'", "");
                }
                object3 = (String)object3 + string3;
                if (!((StringTokenizer)object2).hasMoreTokens()) continue;
                object3 = (String)object3 + ",";
            }
            if (!this.fontFamilies.contains(object3)) {
                this.fontFamilies.add(1, object3);
            }
            this.fontFaceList.setSelectedIndex(this.fontFamilies.indexOf(object3));
        } else {
            this.fontFaceList.setSelectedIndex(0);
        }
        object3 = this.fontModel.getFontSizeList();
        this.fontSizeList.setModel(object3);
        object2 = this.fontModel.getFontSizeUnitList();
        this.fontSizeUnitCombo.setModel(object2);
        string3 = this.cssStyleData.getProperty("font-size");
        if (string3 != null) {
            if (((DefaultListModel)object3).contains(string3)) {
                this.fontSizeList.setSelectedIndex(((DefaultListModel)object3).indexOf(string3));
            } else {
                object = this.fontModel.getFontSize(string3);
                if (((FontModel.FontSize)object).getValue() != null) {
                    if (((DefaultListModel)object3).contains(((FontModel.FontSize)object).getValue())) {
                        this.fontSizeList.setSelectedIndex(((DefaultListModel)object3).indexOf(((FontModel.FontSize)object).getValue()));
                    } else {
                        this.fontSizeField.setText(((FontModel.FontSize)object).getValue());
                    }
                } else {
                    this.fontSizeList.setSelectedIndex(0);
                }
                if (((DefaultComboBoxModel)object2).getIndexOf(((FontModel.FontSize)object).getUnit()) != -1) {
                    this.fontSizeUnitCombo.setSelectedIndex(((DefaultComboBoxModel)object2).getIndexOf(((FontModel.FontSize)object).getUnit()));
                }
            }
        } else {
            this.fontSizeList.setSelectedIndex(0);
        }
        object = this.fontModel.getFontStyleList();
        this.fontStyleComboBox.setModel(object);
        String string5 = this.cssStyleData.getProperty("font-style");
        if (string5 != null) {
            if (((DefaultComboBoxModel)object).getIndexOf(string5) != -1) {
                this.fontStyleComboBox.setSelectedIndex(((DefaultComboBoxModel)object).getIndexOf(string5));
            }
        } else {
            this.fontStyleComboBox.setSelectedIndex(0);
        }
        DefaultComboBoxModel defaultComboBoxModel = this.fontModel.getFontWeightList();
        this.fontWeightComboBox.setModel(defaultComboBoxModel);
        String string6 = this.cssStyleData.getProperty("font-weight");
        if (string6 != null) {
            if (defaultComboBoxModel.getIndexOf(string6) != -1) {
                this.fontWeightComboBox.setSelectedIndex(defaultComboBoxModel.getIndexOf(string6));
            }
        } else {
            this.fontWeightComboBox.setSelectedIndex(0);
        }
        DefaultComboBoxModel defaultComboBoxModel2 = this.fontModel.getFontVariantList();
        this.fontVariantComboBox.setModel(defaultComboBoxModel2);
        String string7 = this.cssStyleData.getProperty("font-variant");
        if (string7 != null) {
            if (defaultComboBoxModel2.getIndexOf(string7) != -1) {
                this.fontVariantComboBox.setSelectedIndex(defaultComboBoxModel2.getIndexOf(string7));
            }
        } else {
            this.fontVariantComboBox.setSelectedIndex(0);
        }
        if ((string2 = this.cssStyleData.getProperty("text-decoration")) != null) {
            this.textDecorationData.setDecoration(string2);
            this.underlineCheckbox.setSelected(this.textDecorationData.underlineEnabled());
            this.overlineCheckbox.setSelected(this.textDecorationData.overlineEnabled());
            this.strikethroughCheckbox.setSelected(this.textDecorationData.lineThroughEnabled());
        }
        if ((string = this.cssStyleData.getProperty("color")) != null) {
            this.colorField.setColorString(string);
        }
        FontMetrics fontMetrics = this.fontSizeField.getFontMetrics(this.fontSizeField.getFont());
        int n = fontMetrics.stringWidth((String)((DefaultListModel)object3).get(0)) + 10;
        int n2 = fontMetrics.getHeight() + 10 > 25 ? fontMetrics.getHeight() + 10 : 25;
        this.fontSizeField.setPreferredSize(new Dimension(n, n2));
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setFontColor();
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.fontFamilyPanel = new JPanel();
        this.fontLabel = new JLabel();
        this.fontFaceScroll = new JScrollPane();
        this.fontFaceList = new JList();
        this.fontChosenField = new JTextField();
        this.fontFamilyButton = new JButton();
        this.fontSizePanel = new JPanel();
        this.sizeLabel = new JLabel();
        this.fontSizeField = new JTextField();
        this.fontSizeUnitCombo = new JComboBox();
        this.fontSizeScroll = new JScrollPane();
        this.fontSizeList = new JList();
        this.styleMainPanel = new JPanel();
        this.stylePanel = new JPanel();
        this.styleLabel = new JLabel();
        this.fontStyleComboBox = new JComboBox();
        this.weightLabel = new JLabel();
        this.fontWeightComboBox = new JComboBox();
        this.variantLabel = new JLabel();
        this.fontVariantComboBox = new JComboBox();
        this.colorLabel = new JLabel();
        this.colorSelectionPanel = new JPanel();
        this.decorationPanel = new JPanel();
        this.decorationLabel = new JLabel();
        this.underlineCheckbox = new JCheckBox();
        this.strikethroughCheckbox = new JCheckBox();
        this.overlineCheckbox = new JCheckBox();
        this.noDecorationCheckbox = new JCheckBox();
        this.errorPanel = new JPanel();
        this.errorLabel = new JLabel();
        this.setLayout(new BorderLayout());
        this.mainPanel.setLayout(new BorderLayout());
        this.fontFamilyPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.fontFamilyPanel.setLayout(new GridBagLayout());
        this.fontLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/visualweb/propertyeditors/css/Bundle").getString("FONT_FAMILY_MNEMONIC").charAt(0));
        this.fontLabel.setLabelFor(this.fontChosenField);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/visualweb/propertyeditors/css/Bundle");
        this.fontLabel.setText(resourceBundle.getString("Font_Family"));
        this.fontLabel.setMinimumSize(new Dimension(200, 15));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.fontFamilyPanel.add((Component)this.fontLabel, gridBagConstraints);
        this.fontFaceList.setSelectionMode(0);
        this.fontFaceList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                FontStyleEditor.this.fontFaceListValueChanged(listSelectionEvent);
            }
        });
        this.fontFaceScroll.setViewportView(this.fontFaceList);
        this.fontFaceList.getAccessibleContext().setAccessibleName(resourceBundle.getString("FontFamilyList"));
        this.fontFaceList.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("FontFamilyListAccessibleDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.fontFamilyPanel.add((Component)this.fontFaceScroll, gridBagConstraints);
        this.fontChosenField.setEditable(false);
        this.fontChosenField.setMargin(new Insets(1, 2, 2, 4));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.fontFamilyPanel.add((Component)this.fontChosenField, gridBagConstraints);
        this.fontChosenField.getAccessibleContext().setAccessibleName(resourceBundle.getString("chosenFontsAccessibleName"));
        this.fontChosenField.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ChosenFontAccessibleDescription"));
        this.fontFamilyButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/visualweb/propertyeditors/css/Bundle").getString("EDIT_FONT_FAMILY_MNEMONIC").charAt(0));
        this.fontFamilyButton.setText(resourceBundle.getString("EDIT"));
        this.fontFamilyButton.setMargin(new Insets(4, 4, 4, 4));
        this.fontFamilyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FontStyleEditor.this.fontFamilyButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.fontFamilyPanel.add((Component)this.fontFamilyButton, gridBagConstraints);
        this.fontFamilyButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("EditChosenFontsAccessibleDescription"));
        this.mainPanel.add((Component)this.fontFamilyPanel, "Center");
        this.fontSizePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.fontSizePanel.setLayout(new GridBagLayout());
        this.sizeLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/visualweb/propertyeditors/css/Bundle").getString("FONT_SIZE_MNEMONIC").charAt(0));
        this.sizeLabel.setLabelFor(this.fontSizeField);
        this.sizeLabel.setText(resourceBundle.getString("FONT_SIZE"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.fontSizePanel.add((Component)this.sizeLabel, gridBagConstraints);
        this.fontSizeField.setHorizontalAlignment(2);
        this.fontSizeField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FontStyleEditor.this.fontSizeFieldActionPerformed(actionEvent);
            }
        });
        this.fontSizeField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                FontStyleEditor.this.fontSizeFieldFocusLost(focusEvent);
            }
        });
        this.fontSizeField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                FontStyleEditor.this.fontSizeFieldKeyTyped(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.fontSizePanel.add((Component)this.fontSizeField, gridBagConstraints);
        this.fontSizeField.getAccessibleContext().setAccessibleName(resourceBundle.getString("ChosenFontSizeAccessibleName"));
        this.fontSizeField.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ChosenFontSizeAccessibleDescription"));
        this.fontSizeUnitCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                FontStyleEditor.this.fontSizeUnitComboItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.fontSizePanel.add((Component)this.fontSizeUnitCombo, gridBagConstraints);
        this.fontSizeUnitCombo.getAccessibleContext().setAccessibleName(resourceBundle.getString("FontSizeUnitListAccessibleName"));
        this.fontSizeUnitCombo.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("FontSizeUnitListAccessibleDescription"));
        this.fontSizeList.setSelectionMode(0);
        this.fontSizeList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                FontStyleEditor.this.fontSizeListValueChanged(listSelectionEvent);
            }
        });
        this.fontSizeScroll.setViewportView(this.fontSizeList);
        this.fontSizeList.getAccessibleContext().setAccessibleName(resourceBundle.getString("FontSizeListAccessibleName"));
        this.fontSizeList.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("FontSizeListAccessibleDesription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        this.fontSizePanel.add((Component)this.fontSizeScroll, gridBagConstraints);
        this.mainPanel.add((Component)this.fontSizePanel, "East");
        this.styleMainPanel.setLayout(new BorderLayout(20, 0));
        this.stylePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.stylePanel.setLayout(new GridBagLayout());
        this.styleLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/visualweb/propertyeditors/css/Bundle").getString("FONT_STYLE_MNEMONIC").charAt(0));
        this.styleLabel.setLabelFor(this.fontStyleComboBox);
        this.styleLabel.setText(resourceBundle.getString("FONT_STYLE"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.stylePanel.add((Component)this.styleLabel, gridBagConstraints);
        this.fontStyleComboBox.setMinimumSize(new Dimension(150, 20));
        this.fontStyleComboBox.setPreferredSize(new Dimension(150, 20));
        this.fontStyleComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                FontStyleEditor.this.fontStyleComboBoxItemStateChanged(itemEvent);
            }
        });
        this.fontStyleComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FontStyleEditor.this.fontStyleComboBoxActionPerformed(actionEvent);
            }
        });
        this.fontStyleComboBox.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                FontStyleEditor.this.fontStyleComboBoxFocusLost(focusEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.stylePanel.add((Component)this.fontStyleComboBox, gridBagConstraints);
        this.fontStyleComboBox.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("FontStyleSelectionAccessibleDescription"));
        this.weightLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/visualweb/propertyeditors/css/Bundle").getString("FONT_WEIGHT_MNEMONIC").charAt(0));
        this.weightLabel.setLabelFor(this.fontWeightComboBox);
        this.weightLabel.setText(resourceBundle.getString("FONT_WEIGHT"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.stylePanel.add((Component)this.weightLabel, gridBagConstraints);
        this.fontWeightComboBox.setMinimumSize(new Dimension(150, 20));
        this.fontWeightComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FontStyleEditor.this.fontWeightComboBoxActionPerformed(actionEvent);
            }
        });
        this.fontWeightComboBox.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                FontStyleEditor.this.fontWeightComboBoxFocusLost(focusEvent);
            }
        });
        this.fontWeightComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                FontStyleEditor.this.fontWeightComboBoxItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.stylePanel.add((Component)this.fontWeightComboBox, gridBagConstraints);
        this.fontWeightComboBox.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("FontWeightSelectionAccessibleDescription"));
        this.variantLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/visualweb/propertyeditors/css/Bundle").getString("FONT_VARIANT_MNEMONIC").charAt(0));
        this.variantLabel.setLabelFor(this.fontVariantComboBox);
        this.variantLabel.setText(resourceBundle.getString("FONT_VARIANT"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.stylePanel.add((Component)this.variantLabel, gridBagConstraints);
        this.variantLabel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("FontVariantSelectionAccessibleDescription"));
        this.fontVariantComboBox.setMinimumSize(new Dimension(150, 20));
        this.fontVariantComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                FontStyleEditor.this.fontVariantComboBoxItemStateChanged(itemEvent);
            }
        });
        this.fontVariantComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FontStyleEditor.this.fontVariantComboBoxActionPerformed(actionEvent);
            }
        });
        this.fontVariantComboBox.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                FontStyleEditor.this.fontVariantComboBoxFocusGained(focusEvent);
            }

            public void focusLost(FocusEvent focusEvent) {
                FontStyleEditor.this.fontVariantComboBoxFocusLost(focusEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.stylePanel.add((Component)this.fontVariantComboBox, gridBagConstraints);
        this.fontVariantComboBox.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("FontVariantSelectionAccessibleDescription"));
        this.colorLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/visualweb/propertyeditors/css/Bundle").getString("FONT_COLOR_MNEMONICS").charAt(0));
        this.colorLabel.setLabelFor(this.colorSelectionPanel);
        this.colorLabel.setText(resourceBundle.getString("FONT_COLOR"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.stylePanel.add((Component)this.colorLabel, gridBagConstraints);
        this.colorSelectionPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.stylePanel.add((Component)this.colorSelectionPanel, gridBagConstraints);
        this.styleMainPanel.add((Component)this.stylePanel, "West");
        this.decorationPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.decorationPanel.setLayout(new GridBagLayout());
        this.decorationLabel.setText(resourceBundle.getString("FONT_DECORATION"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.decorationPanel.add((Component)this.decorationLabel, gridBagConstraints);
        this.underlineCheckbox.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/visualweb/propertyeditors/css/Bundle").getString("FONT_DECORATION_UNDERLINE_MNEMONIC").charAt(0));
        this.underlineCheckbox.setText(resourceBundle.getString("FONT_UNDERLINE"));
        this.underlineCheckbox.setMargin(new Insets(0, 2, 0, 2));
        this.underlineCheckbox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                FontStyleEditor.this.underlineCheckboxItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.decorationPanel.add((Component)this.underlineCheckbox, gridBagConstraints);
        this.underlineCheckbox.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("FontUnderlineAccessibleDescription"));
        this.strikethroughCheckbox.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/visualweb/propertyeditors/css/Bundle").getString("FONT_DECORATION_STRIKETHROUGH_MNEMONIC").charAt(0));
        this.strikethroughCheckbox.setText(resourceBundle.getString("FONT_STRIKETHROUGH"));
        this.strikethroughCheckbox.setMargin(new Insets(0, 2, 0, 2));
        this.strikethroughCheckbox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                FontStyleEditor.this.strikethroughCheckboxItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.decorationPanel.add((Component)this.strikethroughCheckbox, gridBagConstraints);
        this.strikethroughCheckbox.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("FontStrikeThroughAccessibleDescription"));
        this.overlineCheckbox.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/visualweb/propertyeditors/css/Bundle").getString("FONT_DECORATION_OVERLINE_MNEMONIC").charAt(0));
        this.overlineCheckbox.setText(resourceBundle.getString("FONT_OVERLINE"));
        this.overlineCheckbox.setMargin(new Insets(0, 2, 0, 2));
        this.overlineCheckbox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                FontStyleEditor.this.overlineCheckboxItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.decorationPanel.add((Component)this.overlineCheckbox, gridBagConstraints);
        this.overlineCheckbox.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("FontOverlineAccessibleDescription"));
        this.noDecorationCheckbox.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/visualweb/propertyeditors/css/Bundle").getString("FONT_DECORATION_NONE_MNEMONIC").charAt(0));
        this.noDecorationCheckbox.setText(resourceBundle.getString("NO_DECORATION"));
        this.noDecorationCheckbox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                FontStyleEditor.this.noDecorationCheckboxItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.decorationPanel.add((Component)this.noDecorationCheckbox, gridBagConstraints);
        this.noDecorationCheckbox.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("FontNoDecorationAccessibleDescription"));
        this.styleMainPanel.add((Component)this.decorationPanel, "Center");
        this.mainPanel.add((Component)this.styleMainPanel, "South");
        this.add((Component)this.mainPanel, "North");
        this.errorPanel.setBorder(BorderFactory.createEmptyBorder(1, 10, 1, 1));
        this.errorPanel.setLayout(new BorderLayout());
        this.errorLabel.setForeground(new Color(0, 0, 153));
        this.errorLabel.setMinimumSize(new Dimension(200, 20));
        this.errorLabel.setPreferredSize(new Dimension(200, 20));
        this.errorPanel.add((Component)this.errorLabel, "Center");
        this.add((Component)this.errorPanel, "Center");
    }

    private void noDecorationCheckboxItemStateChanged(ItemEvent itemEvent) {
        this.textDecorationData.enableNoDecoration(itemEvent.getStateChange() == 1);
        if (itemEvent.getStateChange() == 1) {
            this.strikethroughCheckbox.setSelected(false);
            this.overlineCheckbox.setSelected(false);
            this.underlineCheckbox.setSelected(false);
            this.strikethroughCheckbox.setEnabled(false);
            this.overlineCheckbox.setEnabled(false);
            this.underlineCheckbox.setEnabled(false);
        } else {
            this.strikethroughCheckbox.setEnabled(true);
            this.overlineCheckbox.setEnabled(true);
            this.underlineCheckbox.setEnabled(true);
        }
        this.setTextDecoration();
    }

    private void fontVariantComboBoxFocusGained(FocusEvent focusEvent) {
        this.errorLabel.setText(CssStyleData.PREVIEW_NOT_SUPPORTED);
    }

    private void strikethroughCheckboxItemStateChanged(ItemEvent itemEvent) {
        this.textDecorationData.enableLineThrough(itemEvent.getStateChange() == 1);
        this.setTextDecoration();
    }

    private void overlineCheckboxItemStateChanged(ItemEvent itemEvent) {
        this.textDecorationData.enableOverline(itemEvent.getStateChange() == 1);
        this.setTextDecoration();
    }

    private void underlineCheckboxItemStateChanged(ItemEvent itemEvent) {
        this.textDecorationData.enableUnderline(itemEvent.getStateChange() == 1);
        this.setTextDecoration();
    }

    private void fontVariantComboBoxItemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() != 2) {
            this.setFontVariant();
        }
    }

    private void fontVariantComboBoxFocusLost(FocusEvent focusEvent) {
        this.errorLabel.setText("");
        this.setFontVariant();
    }

    private void fontVariantComboBoxActionPerformed(ActionEvent actionEvent) {
        this.setFontVariant();
    }

    private void fontWeightComboBoxItemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() != 2) {
            this.setFontWeight();
        }
    }

    private void fontWeightComboBoxActionPerformed(ActionEvent actionEvent) {
        this.setFontWeight();
    }

    private void fontWeightComboBoxFocusLost(FocusEvent focusEvent) {
        this.setFontWeight();
    }

    private void fontStyleComboBoxActionPerformed(ActionEvent actionEvent) {
        this.setFontStyle();
    }

    private void fontStyleComboBoxFocusLost(FocusEvent focusEvent) {
        this.setFontStyle();
    }

    private void fontStyleComboBoxItemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() != 2) {
            this.setFontStyle();
        }
    }

    private void fontSizeUnitComboItemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() != 2) {
            this.setFontSize();
        }
    }

    private void fontSizeFieldActionPerformed(ActionEvent actionEvent) {
        this.setFontSize();
    }

    private void fontSizeFieldFocusLost(FocusEvent focusEvent) {
        this.setFontSize();
    }

    private void fontSizeFieldKeyTyped(KeyEvent keyEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FontStyleEditor.this.enableFontSizeUnitCombo(Utils.isInteger(FontStyleEditor.this.fontSizeField.getText()));
            }
        });
    }

    private void fontSizeListValueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        String string = (String)this.fontSizeList.getSelectedValue();
        this.fontSizeField.setText(string);
        this.enableFontSizeUnitCombo(Utils.isInteger(string));
        this.setFontSize();
    }

    private void enableFontSizeUnitCombo(final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FontStyleEditor.this.fontSizeUnitCombo.setEnabled(bl);
            }
        });
    }

    private void fontFaceListValueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        this.fontChosenField.setText(this.fontFaceList.getSelectedValue().toString());
        this.setFontFamily();
    }

    private void fontFamilyButtonActionPerformed(ActionEvent actionEvent) {
        FontFamilyEditorDialog fontFamilyEditorDialog = new FontFamilyEditorDialog(this.fontFamilies, this.fontFaceList.getSelectedIndex());
        fontFamilyEditorDialog.showDialog();
        this.fontFaceList.setSelectedIndex(fontFamilyEditorDialog.getSelectedIndex());
        this.fontChosenField.setText(this.fontFaceList.getSelectedValue().toString());
        this.setFontFamily();
    }

    private void setFontFamily() {
        PropertyData propertyData = new PropertyData();
        propertyData.setValue(this.fontChosenField.getText());
        this.cssStyleData.modifyProperty("font-family", propertyData.toString());
    }

    private void setFontSize() {
        PropertyWithUnitData propertyWithUnitData = new PropertyWithUnitData();
        propertyWithUnitData.setUnit(this.fontSizeUnitCombo.getSelectedItem().toString());
        propertyWithUnitData.setValue(this.fontSizeField.getText());
        this.cssStyleData.modifyProperty("font-size", propertyWithUnitData.toString());
    }

    private void setFontStyle() {
        PropertyData propertyData = new PropertyData();
        propertyData.setValue(this.fontStyleComboBox.getSelectedItem().toString());
        this.cssStyleData.modifyProperty("font-style", propertyData.toString());
    }

    private void setFontWeight() {
        PropertyData propertyData = new PropertyData();
        propertyData.setValue(this.fontWeightComboBox.getSelectedItem().toString());
        this.cssStyleData.modifyProperty("font-weight", propertyData.toString());
    }

    private void setFontVariant() {
        PropertyData propertyData = new PropertyData();
        propertyData.setValue(this.fontVariantComboBox.getSelectedItem().toString());
        this.cssStyleData.modifyProperty("font-variant", propertyData.toString());
    }

    private void setFontColor() {
        PropertyData propertyData = new PropertyData();
        propertyData.setValue(this.colorField.getColorString());
        this.cssStyleData.modifyProperty("color", propertyData.toString());
    }

    private void setTextDecoration() {
        this.cssStyleData.modifyProperty("text-decoration", this.textDecorationData.toString());
    }
}

