/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.propertyeditors;

import java.awt.Component;
import javax.faces.component.UIComponent;
import org.netbeans.modules.visualweb.propertyeditors.PropertyEditorBase;
import org.netbeans.modules.visualweb.propertyeditors.UrlFileFilter;
import org.netbeans.modules.visualweb.propertyeditors.UrlPropertyPanel;

public class UrlPropertyEditor
extends PropertyEditorBase
implements com.sun.rave.propertyeditors.UrlPropertyEditor {
    public boolean isEditableAsText() {
        return true;
    }

    protected String getPropertyHelpId() {
        return "projrave_ui_elements_propeditors_url_prop_ed";
    }

    public String getAsText() {
        Object object = super.getValue();
        if (object == null || object.equals(this.unsetValue)) {
            return "";
        }
        return UrlPropertyEditor.decodeUrl((String)object);
    }

    public void setAsText(String string) throws IllegalArgumentException {
        if (string == null) {
            super.setValue(null);
        } else if (string.trim().length() == 0) {
            super.setValue(this.unsetValue);
        } else {
            super.setValue(UrlPropertyEditor.encodeUrl(string.trim()));
        }
    }

    public Component getCustomEditor() {
        return new UrlPropertyPanel(this);
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public boolean isTargetComponent(UIComponent uIComponent) {
        return false;
    }

    public String getTargetComponentName(UIComponent uIComponent) {
        return uIComponent.getId();
    }

    public UrlFileFilter getFileFilter() {
        return null;
    }

    public static String encodeUrl(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        int n = string.lastIndexOf(35);
        if (n >= 0 && (n == string.length() - 1 || string.charAt(n + 1) != '{' || string.lastIndexOf(125) <= n)) {
            string2 = string.substring(n + 1);
            string = string.substring(0, n);
        }
        char[] cArray = string.toCharArray();
        block13: for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] <= ' ') {
                stringBuffer.append('%');
                stringBuffer.append(Integer.toHexString(cArray[i]));
                continue;
            }
            switch (cArray[i]) {
                case '\t': {
                    stringBuffer.append("%09");
                    continue block13;
                }
                case ' ': {
                    stringBuffer.append("%20");
                    continue block13;
                }
                case '#': {
                    if (i < cArray.length - 1 && cArray[i + 1] == '{') {
                        int n2;
                        for (n2 = i + 2; n2 < cArray.length && cArray[n2] != '}'; ++n2) {
                        }
                        if (n2 < cArray.length && cArray[n2] == '}') {
                            stringBuffer.append(cArray, i, n2 - i + 1);
                            i = n2;
                            continue block13;
                        }
                        stringBuffer.append("%23");
                        continue block13;
                    }
                    stringBuffer.append("%23");
                    continue block13;
                }
                case '%': {
                    stringBuffer.append("%25");
                    continue block13;
                }
                case '<': {
                    stringBuffer.append("%3C");
                    continue block13;
                }
                case '>': {
                    stringBuffer.append("%3E");
                    continue block13;
                }
                case '[': {
                    stringBuffer.append("%5B");
                    continue block13;
                }
                case ']': {
                    stringBuffer.append("%5D");
                    continue block13;
                }
                case '{': {
                    stringBuffer.append("%7B");
                    continue block13;
                }
                case '}': {
                    stringBuffer.append("%7D");
                    continue block13;
                }
                case '~': {
                    stringBuffer.append("%7E");
                    continue block13;
                }
                default: {
                    stringBuffer.append(cArray[i]);
                }
            }
        }
        if (string2 != null) {
            stringBuffer.append('#');
            stringBuffer.append(string2);
        }
        if (stringBuffer.length() == string.length()) {
            return string;
        }
        return stringBuffer.toString();
    }

    public static String decodeUrl(String string) {
        if (string == null || string.indexOf(37) == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '%' && i + 2 < cArray.length) {
                stringBuffer.append((char)Integer.parseInt(String.copyValueOf(cArray, i + 1, 2), 16));
                i += 2;
                continue;
            }
            stringBuffer.append(cArray[i]);
        }
        return stringBuffer.toString();
    }
}

