/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsfcl.std.property;

import com.sun.jsfcl.std.property.AbstractPropertyJPanel;
import com.sun.jsfcl.std.property.BundleHolder;
import com.sun.jsfcl.std.property.ChooseOneReferenceDataPropertyEditor;
import com.sun.jsfcl.std.property.NewReferenceDataItemDialog;
import com.sun.jsfcl.std.property.ReferenceDataTwoColumnListCellRenderer;
import com.sun.jsfcl.std.reference.CompositeReferenceData;
import com.sun.jsfcl.std.reference.ReferenceDataItem;
import com.sun.rave.designtime.DesignProperty;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;
import org.openide.explorer.propertysheet.PropertyEnv;

public class ChooseOneReferenceDataPanel
extends AbstractPropertyJPanel {
    protected static final String ADD_ACTION = "add";
    protected static final String REMOVE_ACTION = "remove";
    protected static final String CLEAR_FILTER_ACTION = "clearFilter";
    protected static final int MIN_ITEMS_FOR_FILTER = 15;
    protected JButton addJButton;
    protected JList choicesJList;
    protected DefaultListModel choicesJListModel;
    protected JScrollPane choicesJListScrollPane;
    protected JButton clearFilterButton;
    protected Pattern filterPattern;
    protected JTextField filterTextControl;
    protected JButton removeJButton;
    protected ReferenceDataItem selectedChoice;
    private PanelSubmissionListener panelSubmissionListener;

    public ChooseOneReferenceDataPanel(ChooseOneReferenceDataPropertyEditor chooseOneReferenceDataPropertyEditor, DesignProperty designProperty) {
        super(chooseOneReferenceDataPropertyEditor, designProperty);
        PropertyEnv propertyEnv = chooseOneReferenceDataPropertyEditor.getEnv();
        if (propertyEnv != null) {
            propertyEnv.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
            this.panelSubmissionListener = new PanelSubmissionListener(chooseOneReferenceDataPropertyEditor);
            propertyEnv.addVetoableChangeListener((VetoableChangeListener)this.panelSubmissionListener);
            this.propertyEditor = chooseOneReferenceDataPropertyEditor;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (ADD_ACTION.equals(actionEvent.getActionCommand())) {
            this.handleAddAction(actionEvent);
            return;
        }
        if (REMOVE_ACTION.equals(actionEvent.getActionCommand())) {
            this.handleRemoveAction(actionEvent);
            return;
        }
        if (CLEAR_FILTER_ACTION.equals(actionEvent.getActionCommand())) {
            this.handleClearFilterAction(actionEvent);
            return;
        }
    }

    protected List getChoices() {
        return this.getChooseFromReferenceDataPropertyEditor().getItems();
    }

    protected ChooseOneReferenceDataPropertyEditor getChooseFromReferenceDataPropertyEditor() {
        return (ChooseOneReferenceDataPropertyEditor)this.getPropertyEditor();
    }

    protected CompositeReferenceData getCompositeReferenceData() {
        return this.getChooseFromReferenceDataPropertyEditor().getCompositeReferenceData();
    }

    protected int getListSelectionStyle() {
        return 0;
    }

    public Object getPropertyValue() {
        if (this.selectedChoice == null) {
            return null;
        }
        return this.selectedChoice.getValue();
    }

    protected ReferenceDataItem getSelectedChoice() {
        return this.selectedChoice;
    }

    protected String getTopLabel() {
        return this.getCompositeReferenceData().getChooseOneTitle();
    }

    protected int getValueLabelGridWidth() {
        return 2;
    }

    protected void grabCurrentValueFromPropertyEditor() {
        this.selectedChoice = this.getChooseFromReferenceDataPropertyEditor().getValueReferenceDataItem();
    }

    protected void handleAddAction(ActionEvent actionEvent) {
        ReferenceDataItem referenceDataItem = new NewReferenceDataItemDialog(this.getCompositeReferenceData()).showDialog(this);
        if (referenceDataItem == null) {
            return;
        }
        this.populateChoicesJListModel();
        this.choicesJList.setSelectedValue(referenceDataItem, true);
    }

    protected void handleChoicesJListSelectionChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        this.selectedChoice = this.choicesJList.getSelectedIndices().length == 0 ? null : (ReferenceDataItem)this.choicesJList.getSelectedValue();
        this.updateButtonsState();
    }

    public void handleClearFilterAction(ActionEvent actionEvent) {
        this.filterTextControl.setText("");
    }

    public void handleFilterChanged() {
        String string = this.filterTextControl.getText().trim();
        this.clearFilterButton.setEnabled(string.length() > 0);
        if (string.length() == 0) {
            this.filterPattern = null;
        } else {
            try {
                this.filterPattern = Pattern.compile(".*" + string + ".*", 66);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                this.filterPattern = null;
            }
        }
        this.populateChoicesJListModel();
    }

    protected void handleRemoveAction(ActionEvent actionEvent) {
        int n = this.choicesJList.getMinSelectionIndex();
        this.getCompositeReferenceData().remove(this.getSelectedChoice());
        this.populateChoicesJListModel();
        if (this.choicesJListModel.size() > 0) {
            if (n >= this.choicesJListModel.size()) {
                n = this.choicesJListModel.size() - 1;
            }
            this.choicesJList.setSelectedIndex(n);
            this.choicesJList.ensureIndexIsVisible(n);
        }
    }

    protected boolean includeInChoicesJList(ReferenceDataItem referenceDataItem) {
        return this.filterPattern == null || referenceDataItem.matchesPattern(this.filterPattern);
    }

    protected void initializeComponents() {
        JPanel jPanel;
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        jLabel.setText(this.getTopLabel());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = this.getValueLabelGridWidth();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)jLabel, gridBagConstraints);
        if (this.getChoices().size() > 15) {
            jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 2));
            jLabel = new JLabel();
            jLabel.setText(BundleHolder.bundle.getMessage("Filter"));
            jPanel.add(jLabel);
            jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
            this.filterTextControl = new JTextField();
            this.filterTextControl.setColumns(10);
            this.filterTextControl.getDocument().addDocumentListener(this);
            jPanel.add(this.filterTextControl);
            jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
            this.clearFilterButton = new JButton(BundleHolder.bundle.getMessage("CLEAR_BUTTON_TXT"));
            this.clearFilterButton.setEnabled(false);
            this.clearFilterButton.setActionCommand(CLEAR_FILTER_ACTION);
            this.clearFilterButton.addActionListener(this);
            jPanel.add(this.clearFilterButton);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.insets = new Insets(10, 10, 0, 10);
            this.add((Component)jPanel, gridBagConstraints);
        }
        this.choicesJListModel = new DefaultListModel();
        this.choicesJList = new JList(this.choicesJListModel);
        this.choicesJList.setSelectionMode(this.getListSelectionStyle());
        this.choicesJList.setLayoutOrientation(0);
        this.choicesJList.setVisibleRowCount(-1);
        this.choicesJList.addListSelectionListener(this);
        this.choicesJList.setCellRenderer(new ReferenceDataTwoColumnListCellRenderer());
        this.populateChoicesJListModel();
        this.updateChoicesJListSelection();
        this.choicesJListScrollPane = new JScrollPane(this.choicesJList);
        this.choicesJListScrollPane.setPreferredSize(new Dimension(200, 200));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)this.choicesJListScrollPane, gridBagConstraints);
        if (this.getCompositeReferenceData().canAddRemoveItems()) {
            jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            this.addJButton = new JButton(BundleHolder.bundle.getMessage("New"));
            this.addJButton.setActionCommand(ADD_ACTION);
            this.addJButton.addActionListener(this);
            jPanel.add(this.addJButton);
            jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
            this.removeJButton = new JButton(BundleHolder.bundle.getMessage(REMOVE_ACTION));
            this.removeJButton.setActionCommand(REMOVE_ACTION);
            this.removeJButton.addActionListener(this);
            jPanel.add(this.removeJButton);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.anchor = 23;
            gridBagConstraints.insets = new Insets(5, 10, 0, 0);
            this.add((Component)jPanel, gridBagConstraints);
        }
    }

    public void documentEvent(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this.filterTextControl.getDocument()) {
            this.handleFilterChanged();
        }
    }

    public void doLayout() {
        super.doLayout();
        this.choicesJList.ensureIndexIsVisible(this.choicesJList.getSelectedIndex());
        this.updateButtonsState();
    }

    protected void populateChoicesJListModel() {
        this.choicesJListModel.clear();
        ReferenceDataTwoColumnListCellRenderer referenceDataTwoColumnListCellRenderer = (ReferenceDataTwoColumnListCellRenderer)this.choicesJList.getCellRenderer();
        referenceDataTwoColumnListCellRenderer.resetLeftColumnWidth();
        for (ReferenceDataItem referenceDataItem : this.getChoices()) {
            if (!this.includeInChoicesJList(referenceDataItem)) continue;
            this.choicesJListModel.addElement(referenceDataItem);
            referenceDataTwoColumnListCellRenderer.getListCellRendererComponent(this.choicesJList, referenceDataItem, -1, false, false);
            referenceDataTwoColumnListCellRenderer.adjustLeftColumnWidthIfNecessary();
        }
    }

    protected void updateButtonsState() {
        if (this.removeJButton != null) {
            ReferenceDataItem referenceDataItem = this.getSelectedChoice();
            this.removeJButton.setEnabled(referenceDataItem != null && referenceDataItem.isRemovable());
        }
    }

    protected void updateChoicesJListSelection() {
        this.choicesJList.setSelectedValue(this.getSelectedChoice(), true);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        super.valueChanged(listSelectionEvent);
        if (listSelectionEvent.getSource() == this.choicesJList) {
            this.handleChoicesJListSelectionChanged(listSelectionEvent);
        }
    }

    protected void finalize() throws Throwable {
        if (this.panelSubmissionListener != null) {
            ((ChooseOneReferenceDataPropertyEditor)this.propertyEditor).getEnv().removeVetoableChangeListener((VetoableChangeListener)this.panelSubmissionListener);
        }
        super.finalize();
    }

    class PanelSubmissionListener
    implements VetoableChangeListener {
        ChooseOneReferenceDataPropertyEditor propertyEditor;

        PanelSubmissionListener(ChooseOneReferenceDataPropertyEditor chooseOneReferenceDataPropertyEditor) {
            this.propertyEditor = chooseOneReferenceDataPropertyEditor;
        }

        public final void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            if ("state".equals(propertyChangeEvent.getPropertyName())) {
                this.propertyEditor.setValue(ChooseOneReferenceDataPanel.this.getPropertyValue());
                this.propertyEditor.getEnv().setState(PropertyEnv.STATE_VALID);
            }
        }
    }
}

