/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsfcl.std.property;

import com.sun.jsfcl.std.property.BundleHolder;
import com.sun.jsfcl.std.property.ChooseManyReferenceDataPropertyEditor;
import com.sun.jsfcl.std.property.ChooseOneReferenceDataPanel;
import com.sun.jsfcl.std.property.ReferenceDataTwoColumnListCellRenderer;
import com.sun.jsfcl.std.reference.ReferenceDataItem;
import com.sun.rave.designtime.DesignProperty;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;

public class ChooseManyReferenceDataPanel
extends ChooseOneReferenceDataPanel {
    protected static final String DESELECT_ACTION = "deselect";
    protected static final String DESELECT_ALL_ACTION = "deselect-all";
    protected static final String DOWN_ACTION = "down";
    protected static final String SELECT_ACTION = "select";
    protected static final String UP_ACTION = "up";
    protected JButton downJButton;
    protected JButton deselectJButton;
    protected JButton deselectAllJButton;
    protected JButton selectJButton;
    protected JList selectedJList;
    protected DefaultListModel selectedJListModel;
    protected JButton upJButton;

    public ChooseManyReferenceDataPanel(ChooseManyReferenceDataPropertyEditor chooseManyReferenceDataPropertyEditor, DesignProperty designProperty) {
        super(chooseManyReferenceDataPropertyEditor, designProperty);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (DESELECT_ACTION.equals(actionEvent.getActionCommand())) {
            this.handleDeselectAction(actionEvent);
            return;
        }
        if (DESELECT_ALL_ACTION.equals(actionEvent.getActionCommand())) {
            this.handleDeselectAllAction(actionEvent);
            return;
        }
        if (SELECT_ACTION.equals(actionEvent.getActionCommand())) {
            this.handleSelectAction(actionEvent);
            return;
        }
        if (DOWN_ACTION.equals(actionEvent.getActionCommand())) {
            this.handleDownAction(actionEvent);
            return;
        }
        if (UP_ACTION.equals(actionEvent.getActionCommand())) {
            this.handleUpAction(actionEvent);
            return;
        }
    }

    protected void adjustLeftColumnWidthIfNecessary(ReferenceDataItem referenceDataItem) {
        ReferenceDataTwoColumnListCellRenderer referenceDataTwoColumnListCellRenderer = (ReferenceDataTwoColumnListCellRenderer)this.selectedJList.getCellRenderer();
        referenceDataTwoColumnListCellRenderer.getListCellRendererComponent(this.choicesJList, referenceDataItem, -1, false, false);
        referenceDataTwoColumnListCellRenderer.adjustLeftColumnWidthIfNecessary();
    }

    protected ChooseManyReferenceDataPropertyEditor getChooseManyReferenceDataPropertyEditor() {
        return (ChooseManyReferenceDataPropertyEditor)this.getPropertyEditor();
    }

    protected int getListSelectionStyle() {
        return 2;
    }

    public Object getPropertyValue() {
        Object[] objectArray = this.getSelectedItems();
        if (objectArray == null || objectArray.length == 0) {
            return null;
        }
        String string = this.getChooseManyReferenceDataPropertyEditor().getStringForManyItems(objectArray);
        return string;
    }

    protected ReferenceDataItem[] getSelectedItems() {
        ReferenceDataItem[] referenceDataItemArray = new ReferenceDataItem[this.selectedJListModel.size()];
        for (int i = 0; i < referenceDataItemArray.length; ++i) {
            referenceDataItemArray[i] = (ReferenceDataItem)this.selectedJListModel.get(i);
        }
        return referenceDataItemArray;
    }

    protected Map getSelectedItemsMap() {
        IdentityHashMap<ReferenceDataItem, Object> identityHashMap = new IdentityHashMap<ReferenceDataItem, Object>();
        ReferenceDataItem[] referenceDataItemArray = this.getSelectedItems();
        Object object = new Object();
        for (int i = 0; i < referenceDataItemArray.length; ++i) {
            ReferenceDataItem referenceDataItem = referenceDataItemArray[i];
            identityHashMap.put(referenceDataItem, object);
        }
        return identityHashMap;
    }

    protected String getTopLabel() {
        return this.getCompositeReferenceData().getChooseManyTitle();
    }

    protected int getValueLabelGridWidth() {
        return 6;
    }

    protected void grabCurrentValueFromPropertyEditor() {
    }

    protected void handleDeselectAction(ActionEvent actionEvent) {
        Object[] objectArray = this.selectedJList.getSelectedValues();
        for (int i = 0; i < objectArray.length; ++i) {
            this.selectedJListModel.removeElement(objectArray[i]);
        }
        this.updateButtonsState();
    }

    protected void handleDeselectAllAction(ActionEvent actionEvent) {
        this.selectedJListModel.clear();
        this.updateButtonsState();
    }

    protected void handleDownAction(ActionEvent actionEvent) {
        int[] nArray = this.selectedJList.getSelectedIndices();
        int n = this.selectedJListModel.size() - 1;
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            if (n2 >= n) continue;
            Object e = this.selectedJListModel.elementAt(n2 + 1);
            this.selectedJListModel.set(n2 + 1, this.selectedJListModel.elementAt(n2));
            this.selectedJListModel.set(n2, e);
            int n3 = i;
            nArray[n3] = nArray[n3] + 1;
        }
        this.selectedJList.setSelectedIndices(nArray);
    }

    protected void handleSelectAction(ActionEvent actionEvent) {
        Object[] objectArray = this.choicesJList.getSelectedValues();
        int[] nArray = new int[objectArray.length];
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            ReferenceDataItem referenceDataItem = (ReferenceDataItem)objectArray[i];
            if (!this.getChooseManyReferenceDataPropertyEditor().getAllowDuplicates() && this.getSelectedItemsMap().containsKey(referenceDataItem)) continue;
            nArray[n] = this.selectedJListModel.size();
            ++n;
            this.selectedJListModel.addElement(referenceDataItem);
            this.adjustLeftColumnWidthIfNecessary(referenceDataItem);
        }
        if (n != objectArray.length) {
            int[] nArray2 = nArray;
            nArray = new int[n];
            System.arraycopy(nArray2, 0, nArray, 0, n);
        }
        this.updateButtonsState();
        this.selectedJList.setSelectedIndices(nArray);
        if (nArray.length > 0) {
            this.selectedJList.ensureIndexIsVisible(nArray[0]);
        }
    }

    protected void handleSelectedJListSelectionChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        if (this.selectedJList != null) {
            this.updateButtonsState();
        }
    }

    protected void handleUpAction(ActionEvent actionEvent) {
        int n;
        int[] nArray = this.selectedJList.getSelectedIndices();
        int n2 = 0;
        while (n2 < nArray.length && (n = nArray[n2]) > 0) {
            Object e = this.selectedJListModel.elementAt(n - 1);
            this.selectedJListModel.set(n - 1, this.selectedJListModel.elementAt(n));
            this.selectedJListModel.set(n, e);
            int n3 = n2++;
            nArray[n3] = nArray[n3] - 1;
        }
        this.selectedJList.setSelectedIndices(nArray);
    }

    protected boolean includeInChoicesJList(ReferenceDataItem referenceDataItem) {
        if (super.includeInChoicesJList(referenceDataItem)) {
            return referenceDataItem.getName().length() > 0;
        }
        return false;
    }

    protected void initializeComponents() {
        super.initializeComponents();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.selectJButton = new JButton(">");
        this.selectJButton.setActionCommand(SELECT_ACTION);
        this.selectJButton.addActionListener(this);
        this.selectJButton.setEnabled(false);
        jPanel.add((Component)this.selectJButton, null);
        jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        this.deselectJButton = new JButton("<");
        this.deselectJButton.setActionCommand(DESELECT_ACTION);
        this.deselectJButton.addActionListener(this);
        this.deselectJButton.setEnabled(false);
        jPanel.add((Component)this.deselectJButton, null);
        jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        this.deselectAllJButton = new JButton("<<");
        this.deselectAllJButton.setActionCommand(DESELECT_ALL_ACTION);
        this.deselectAllJButton.addActionListener(this);
        jPanel.add((Component)this.deselectAllJButton, null);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)jPanel, gridBagConstraints);
        JLabel jLabel = new JLabel();
        jLabel.setText(BundleHolder.bundle.getMessage("Available"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)jLabel, gridBagConstraints);
        jLabel = new JLabel();
        jLabel.setText(BundleHolder.bundle.getMessage("sel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)jLabel, gridBagConstraints);
        Component component = this.initializeSelectedListComponent();
        JScrollPane jScrollPane = new JScrollPane(component);
        jScrollPane.setPreferredSize(new Dimension(200, 200));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)jScrollPane, gridBagConstraints);
        if (this.getCompositeReferenceData().canOrderItems()) {
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 1));
            this.upJButton = new JButton(BundleHolder.bundle.getMessage(UP_ACTION));
            this.upJButton.setActionCommand(UP_ACTION);
            this.upJButton.addActionListener(this);
            this.upJButton.setEnabled(false);
            jPanel2.add(this.upJButton);
            jPanel2.add(Box.createRigidArea(new Dimension(0, 5)));
            this.downJButton = new JButton(BundleHolder.bundle.getMessage(DOWN_ACTION));
            this.downJButton.setActionCommand(DOWN_ACTION);
            this.downJButton.setEnabled(false);
            this.downJButton.addActionListener(this);
            jPanel2.add(this.downJButton);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 5;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 19;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 10, 0, 10);
            this.add((Component)jPanel2, gridBagConstraints);
        }
    }

    protected Component initializeSelectedListComponent() {
        this.selectedJListModel = new DefaultListModel();
        this.selectedJList = new JList(this.selectedJListModel);
        this.selectedJList.setSelectionMode(this.getListSelectionStyle());
        this.selectedJList.setLayoutOrientation(0);
        this.selectedJList.setVisibleRowCount(-1);
        this.selectedJList.setCellRenderer(new ReferenceDataTwoColumnListCellRenderer());
        this.populateSelectedJListModel();
        this.selectedJList.addListSelectionListener(this);
        return this.selectedJList;
    }

    protected void populateSelectedJListModel() {
        this.selectedJListModel.clear();
        ReferenceDataTwoColumnListCellRenderer referenceDataTwoColumnListCellRenderer = (ReferenceDataTwoColumnListCellRenderer)this.selectedJList.getCellRenderer();
        referenceDataTwoColumnListCellRenderer.resetLeftColumnWidth();
        ReferenceDataItem[] referenceDataItemArray = this.getChooseManyReferenceDataPropertyEditor().getValueReferenceDataItems();
        if (referenceDataItemArray != null) {
            for (int i = 0; i < referenceDataItemArray.length; ++i) {
                ReferenceDataItem referenceDataItem = referenceDataItemArray[i];
                this.selectedJListModel.addElement(referenceDataItem);
                referenceDataTwoColumnListCellRenderer.getListCellRendererComponent(this.choicesJList, referenceDataItem, -1, false, false);
                referenceDataTwoColumnListCellRenderer.adjustLeftColumnWidthIfNecessary();
            }
        }
    }

    protected void updateButtonsState() {
        super.updateButtonsState();
        boolean bl = this.choicesJList.getSelectedIndices().length > 0;
        this.selectJButton.setEnabled(bl);
        if (this.selectedJList != null) {
            bl = this.selectedJList.getSelectedIndices().length > 0;
            this.deselectJButton.setEnabled(bl);
            this.deselectAllJButton.setEnabled(this.selectedJListModel.size() > 0);
            if (this.getCompositeReferenceData().canOrderItems()) {
                this.upJButton.setEnabled(this.selectedJList.getMinSelectionIndex() > 0);
                this.downJButton.setEnabled(this.selectedJList.getMaxSelectionIndex() >= 0 && this.selectedJList.getMaxSelectionIndex() < this.selectedJListModel.size() - 1);
            }
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        super.valueChanged(listSelectionEvent);
        if (listSelectionEvent.getSource() == this.selectedJList) {
            this.handleSelectedJListSelectionChanged(listSelectionEvent);
        }
    }
}

