/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.libraries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.spi.java.queries.JavadocForBinaryQueryImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.ChangeSupport;
import org.openide.util.WeakListeners;

public class JavadocForBinaryQueryLibraryImpl
implements JavadocForBinaryQueryImplementation {
    private static int MAX_DEPTH = 3;
    private final Map<URL, URL> normalizedURLCache = new HashMap<URL, URL>();

    public JavadocForBinaryQuery.Result findJavadoc(URL uRL) {
        boolean bl = JavadocForBinaryQueryLibraryImpl.isNormalizedURL(uRL);
        for (LibraryManager libraryManager : LibraryManager.getOpenManagers()) {
            for (Library library : libraryManager.getLibraries()) {
                if (!library.getType().equals("j2se")) continue;
                for (URL uRL2 : library.getContent("classpath")) {
                    URL uRL3 = bl ? this.getNormalizedURL(uRL2) : uRL2;
                    if (!uRL.equals(uRL3)) continue;
                    class R
                    implements JavadocForBinaryQuery.Result,
                    PropertyChangeListener {
                        private Library lib;
                        private final ChangeSupport cs = new ChangeSupport((Object)this);
                        private URL[] cachedRoots;

                        public R(Library library) {
                            this.lib = library;
                            this.lib.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.lib));
                        }

                        public synchronized URL[] getRoots() {
                            if (this.cachedRoots == null) {
                                ArrayList<URL> arrayList = new ArrayList<URL>();
                                for (URL uRL : this.lib.getContent("javadoc")) {
                                    arrayList.add(JavadocForBinaryQueryLibraryImpl.getIndexFolder(uRL));
                                }
                                this.cachedRoots = arrayList.toArray(new URL[arrayList.size()]);
                            }
                            return this.cachedRoots;
                        }

                        public synchronized void addChangeListener(ChangeListener changeListener) {
                            assert (changeListener != null) : "Listener can not be null";
                            this.cs.addChangeListener(changeListener);
                        }

                        public synchronized void removeChangeListener(ChangeListener changeListener) {
                            assert (changeListener != null) : "Listener can not be null";
                            this.cs.removeChangeListener(changeListener);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                            if ("content".equals(propertyChangeEvent.getPropertyName())) {
                                R r = this;
                                synchronized (r) {
                                    this.cachedRoots = null;
                                }
                                this.cs.fireChange();
                            }
                        }
                    }
                    return new R(library);
                }
            }
        }
        return null;
    }

    private URL getNormalizedURL(URL uRL) {
        FileObject fileObject;
        if (JavadocForBinaryQueryLibraryImpl.isNormalizedURL(uRL)) {
            return uRL;
        }
        URL uRL2 = this.normalizedURLCache.get(uRL);
        if (uRL2 == null && (fileObject = URLMapper.findFileObject((URL)uRL)) != null) {
            try {
                uRL2 = fileObject.getURL();
                this.normalizedURLCache.put(uRL, uRL2);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                ErrorManager.getDefault().notify((Throwable)fileStateInvalidException);
            }
        }
        return uRL2;
    }

    private static boolean isNormalizedURL(URL uRL) {
        if ("jar".equals(uRL.getProtocol())) {
            uRL = FileUtil.getArchiveFile((URL)uRL);
        }
        return "file".equals(uRL.getProtocol());
    }

    static boolean isValidLibraryJavadocRoot(URL uRL) {
        assert (uRL != null && uRL.toExternalForm().endsWith("/"));
        FileObject fileObject = URLMapper.findFileObject((URL)uRL);
        if (fileObject == null) {
            return false;
        }
        return JavadocForBinaryQueryLibraryImpl.findIndexFolder(fileObject, 1) != null;
    }

    private static URL getIndexFolder(URL uRL) {
        if (uRL == null) {
            return null;
        }
        FileObject fileObject = URLMapper.findFileObject((URL)uRL);
        if (fileObject == null) {
            return uRL;
        }
        FileObject fileObject2 = JavadocForBinaryQueryLibraryImpl.findIndexFolder(fileObject, 1);
        try {
            return fileObject2 == null ? uRL : fileObject2.getURL();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            ErrorManager.getDefault().notify((Throwable)fileStateInvalidException);
            return uRL;
        }
    }

    private static FileObject findIndexFolder(FileObject fileObject, int n) {
        if (n > MAX_DEPTH) {
            return null;
        }
        if (fileObject.getFileObject("index-files", null) != null || fileObject.getFileObject("index-all.html", null) != null) {
            return fileObject;
        }
        for (FileObject fileObject2 : fileObject.getChildren()) {
            FileObject fileObject3;
            if (!fileObject2.isFolder() || (fileObject3 = JavadocForBinaryQueryLibraryImpl.findIndexFolder(fileObject2, n + 1)) == null) continue;
            return fileObject3;
        }
        return null;
    }
}

