/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.projectint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.netbeans.modules.tasklist.projectint.EmptyIterator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FileObjectIterator
implements Iterator<FileObject> {
    private Collection<FileObject> roots;
    private Collection<FileObject> editedFiles;
    private Iterator<FileObject> rootsIterator;
    private Iterator<FileObject> editedFilesIterator;
    private Enumeration<? extends FileObject> rootChildrenEnum;

    public FileObjectIterator(Collection<FileObject> collection, Collection<FileObject> collection2) {
        this.roots = collection;
        this.editedFiles = collection2;
    }

    @Override
    public boolean hasNext() {
        if (null == this.rootsIterator) {
            this.checkEditedFiles();
            this.rootsIterator = this.roots.iterator();
            return this.rootsIterator.hasNext();
        }
        return null != this.rootChildrenEnum && this.rootChildrenEnum.hasMoreElements() || this.rootsIterator.hasNext() || this.editedFilesIterator.hasNext();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public FileObject next() {
        if (this.editedFilesIterator.hasNext()) {
            return this.editedFilesIterator.next();
        }
        FileObject fileObject = null;
        if (null != this.rootChildrenEnum) {
            if (this.rootChildrenEnum.hasMoreElements()) return this.rootChildrenEnum.nextElement();
        }
        if (!this.rootsIterator.hasNext()) throw new NoSuchElementException();
        fileObject = this.rootsIterator.next();
        this.rootChildrenEnum = fileObject.getChildren(true);
        return fileObject;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void checkEditedFiles() {
        if (null != this.editedFiles) {
            ArrayList<FileObject> arrayList = new ArrayList<FileObject>(this.editedFiles.size());
            for (FileObject fileObject : this.editedFiles) {
                if (!this.isUnderRoots(fileObject)) continue;
                arrayList.add(fileObject);
            }
            this.editedFiles = null;
            this.editedFilesIterator = arrayList.iterator();
        } else {
            this.editedFilesIterator = new EmptyIterator();
        }
    }

    private boolean isUnderRoots(FileObject fileObject) {
        for (FileObject fileObject2 : this.roots) {
            if (!FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) continue;
            return true;
        }
        return false;
    }
}

