/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mapper.common.palette;

import java.awt.Image;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.Action;
import org.netbeans.modules.soa.mapper.common.palette.PaletteCategoryNode;
import org.netbeans.modules.soa.mapper.common.palette.PaletteManager;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.FileSystemAction;
import org.openide.actions.MoveDownAction;
import org.openide.actions.MoveUpAction;
import org.openide.actions.NewAction;
import org.openide.actions.ReorderAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;

public class PaletteNode
extends DataFolder.FolderNode {
    private static String iconURL = "com/stc/collabeditor/common/palette/resources/palette.gif";
    private static String icon32URL = "com/stc/collabeditor/common/palette/resources/palette32.gif";
    private static final Node.PropertySet[] NO_PROPERTIES = new Node.PropertySet[0];
    private static SystemAction[] staticActions;
    private DataFolder paletteFolder;

    public PaletteNode(String string) {
        this(PaletteNode.getThisPaletteFolder(string));
        this.initizalShortDesc();
    }

    PaletteNode(DataFolder dataFolder) {
        DataFolder dataFolder2 = dataFolder;
        dataFolder2.getClass();
        super(dataFolder2, (Children)new PaletteNodeChildren(dataFolder));
        this.paletteFolder = null;
        this.paletteFolder = dataFolder;
        this.setDisplayName(PaletteManager.getBundle().getString("CTL_Component_palette"));
        this.initizalShortDesc();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("gui.options.component-palette");
    }

    public Node[] getCategoryNodes() {
        DataObject[] dataObjectArray = this.paletteFolder.getChildren();
        ArrayList<PaletteCategoryNode> arrayList = new ArrayList<PaletteCategoryNode>();
        for (int i = 0; i < dataObjectArray.length; ++i) {
            DataFolder dataFolder = (DataFolder)dataObjectArray[i].getCookie(DataFolder.class);
            if (dataFolder == null) continue;
            PaletteCategoryNode paletteCategoryNode = new PaletteCategoryNode(dataFolder);
            arrayList.add(paletteCategoryNode);
        }
        return (Node[])arrayList.toArray(new PaletteCategoryNode[arrayList.size()]);
    }

    DataFolder getPaletteFolder() {
        return this.paletteFolder;
    }

    private void initizalShortDesc() {
        String string = (String)this.getNodeAttribute("Tooltip");
        if (string != null) {
            this.setShortDescription(string);
        } else {
            this.setShortDescription("");
        }
    }

    static DataFolder getThisPaletteFolder(String string) {
        try {
            FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource(string);
            if (fileObject == null) {
                fileObject = Repository.getDefault().getDefaultFileSystem().getRoot().createFolder(string);
            }
            return DataFolder.findFolder((FileObject)fileObject);
        }
        catch (IOException iOException) {
            throw new InternalError("Folder not found and cannot be created: " + string);
        }
    }

    public Node.Cookie getCookie(Class clazz) {
        DataFolder dataFolder;
        if (Index.class.isAssignableFrom(clazz) && (dataFolder = (DataFolder)super.getCookie(DataFolder.class)) != null) {
            return new PaletteIndex(dataFolder, (Node)this, (PaletteNodeChildren)this.getChildren());
        }
        return super.getCookie(clazz);
    }

    public Image getIcon(int n) {
        if (n == 1 || n == 3) {
            return Utilities.loadImage((String)iconURL);
        }
        return Utilities.loadImage((String)icon32URL);
    }

    public Image getOpenedIcon(int n) {
        return this.getIcon(n);
    }

    public NewType[] getNewTypes() {
        return new NewType[]{new NewCategory()};
    }

    public Action[] getActions(boolean bl) {
        if (staticActions == null) {
            staticActions = new SystemAction[]{SystemAction.get(FileSystemAction.class), null, SystemAction.get(MoveUpAction.class), SystemAction.get(MoveDownAction.class), SystemAction.get(ReorderAction.class), null, SystemAction.get(NewAction.class)};
        }
        return staticActions;
    }

    public Node.PropertySet[] getPropertySets() {
        return NO_PROPERTIES;
    }

    public Object getNodeAttribute(String string) {
        return this.paletteFolder.getPrimaryFile().getAttribute(string);
    }

    void createNewCategory() throws IOException {
        ResourceBundle resourceBundle = PaletteManager.getBundle();
        NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(resourceBundle.getString("CTL_NewCategoryName"), resourceBundle.getString("CTL_NewCategoryTitle"));
        inputLine.setInputText(resourceBundle.getString("CTL_NewCategoryValue"));
        while (DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine) == NotifyDescriptor.OK_OPTION) {
            String string = inputLine.getInputText();
            if (!PaletteCategoryNode.checkCategoryName(string, null)) continue;
            String string2 = PaletteCategoryNode.convertToFolderName(string, null);
            FileObject fileObject = this.getPaletteFolder().getPrimaryFile().createFolder(string2);
            if (string2.equals(string)) break;
            fileObject.setAttribute("categoryName", (Object)string);
            break;
        }
    }

    private final class NewCategory
    extends NewType {
        private NewCategory() {
        }

        public String getName() {
            return PaletteManager.getBundle().getString("CTL_NewCategory");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(NewCategory.class);
        }

        public void create() throws IOException {
            PaletteNode.this.createNewCategory();
        }
    }

    private static final class PaletteIndex
    extends DataFolder.Index {
        private PaletteNodeChildren children;

        PaletteIndex(DataFolder dataFolder, Node node, PaletteNodeChildren paletteNodeChildren) {
            super(dataFolder, node);
            this.children = paletteNodeChildren;
        }

        public int getNodesCount() {
            return this.children.getNodesCount();
        }

        public Node[] getNodes() {
            return this.children.getNodes();
        }
    }

    private static final class PaletteNodeChildren
    extends FilterNode.Children {
        public PaletteNodeChildren(DataFolder dataFolder) {
            super(dataFolder.getNodeDelegate());
        }

        protected Node copyNode(Node node) {
            DataFolder dataFolder = (DataFolder)node.getCookie(DataFolder.class);
            if (dataFolder != null) {
                return new PaletteCategoryNode(dataFolder);
            }
            return node.cloneNode();
        }
    }
}

