/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mapper.basicmapper.canvas.jgo;

import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoLink;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoPort;
import com.nwoods.jgo.JGoSelection;
import com.nwoods.jgo.JGoView;
import java.awt.Color;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SwingUtilities;
import org.netbeans.modules.soa.mapper.basicmapper.canvas.jgo.BasicCanvasPort;
import org.netbeans.modules.soa.mapper.basicmapper.canvas.jgo.NetworkHighlightTraverser;
import org.netbeans.modules.soa.mapper.basicmapper.canvas.jgo.util.DrawPort;
import org.netbeans.modules.soa.mapper.common.IMapperLink;
import org.netbeans.modules.soa.mapper.common.IMapperNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.canvas.gtk.ICanvasMapperLink;
import org.netbeans.modules.soa.mapper.common.basicmapper.canvas.gtk.ICanvasView;
import org.netbeans.modules.soa.mapper.common.basicmapper.tree.IMapperTreeNode;
import org.netbeans.modules.soa.mapper.common.gtk.ICanvasLinkLabel;
import org.netbeans.modules.soa.mapper.common.gtk.ICanvasNode;

public abstract class AbstractCanvasLink
extends JGoLink
implements ICanvasMapperLink {
    private ICanvasView mCanvas;
    private IMapperLink mMapperLink;
    private static final int MID_SEGEMTNT_IDENT = 5;
    private int mMidPoint = 0;
    private static final int OVERLAP_OFFSET_PIXELS = 2;
    private static final int INDENT_TO_LEFT = -1;
    private static final int INDENT_TO_RIGHT = 1;
    protected JGoPort endPort;
    protected JGoPort startPort;
    private JGoPen pen;
    private JGoBrush brush;
    private boolean mIsSelected;
    int mPosition = 0;
    int mCollectionSize = 0;

    public AbstractCanvasLink(IMapperLink iMapperLink) {
        this.mMapperLink = iMapperLink;
        this.setRelinkable(false);
        this.setOrthogonal(true);
        this.setJumpsOver(true);
        this.pen = this.getPen();
        this.brush = this.getBrush();
    }

    protected AbstractCanvasLink(JGoPort jGoPort, JGoPort jGoPort2) {
        super(jGoPort, jGoPort2);
        this.setJumpsOver(true);
    }

    public ICanvasNode getDestinationNode() {
        if (this.mMapperLink.getEndNode() instanceof ICanvasNode) {
            return (ICanvasNode)((Object)this.mMapperLink.getEndNode());
        }
        return null;
    }

    public ICanvasLinkLabel getLabel() {
        return null;
    }

    public ICanvasView getMapperCanvas() {
        return this.mCanvas;
    }

    public IMapperLink getMapperLink() {
        return this.mMapperLink;
    }

    public ICanvasNode getSourceNode() {
        if (this.mMapperLink.getStartNode() instanceof ICanvasNode) {
            return (ICanvasNode)((Object)this.mMapperLink.getStartNode());
        }
        return null;
    }

    public void setLabel(ICanvasLinkLabel iCanvasLinkLabel) {
    }

    public void setLabelVisible(boolean bl) {
    }

    public void setMapperCanvas(ICanvasView iCanvasView) {
        this.mCanvas = iCanvasView;
        this.pen = JGoPen.makeStockPen((Color)DEFAULT_LINK_COLOR);
        this.brush = JGoBrush.makeStockBrush((Color)DEFAULT_LINK_COLOR);
        this.setPen(this.pen);
        this.setBrush(this.brush);
    }

    public void updateLabelText(String string) {
    }

    public void setDataObject(Object object) {
    }

    public Object getDataObject() {
        return null;
    }

    public boolean isDisplaying(Rectangle rectangle) {
        return true;
    }

    public void setPosition(int n, int n2) {
        this.mPosition = n;
        this.mCollectionSize = n2;
    }

    protected int getMidOrthoPosition(int n, int n2, boolean bl) {
        int n3;
        int n4 = super.getMidOrthoPosition(n, n2, bl);
        if (this.mPosition > 0 && (n3 = n + this.mPosition * 6) < n4) {
            n4 = n3;
        }
        return n4;
    }

    protected void gainedSelection(JGoSelection jGoSelection) {
        this.mIsSelected = true;
        super.gainedSelection(jGoSelection);
        this.startHighlighting();
        if (this.getMapperCanvas().isPathHighlightingEnabled()) {
            new NetworkHighlightTraverser(true).visit(this);
        }
    }

    protected void lostSelection(JGoSelection jGoSelection) {
        this.mIsSelected = false;
        super.lostSelection(jGoSelection);
        this.stopHighlighting();
        if (this.getMapperCanvas().isPathHighlightingEnabled()) {
            new NetworkHighlightTraverser(false).visit(this);
        }
    }

    public void startHighlighting() {
        this.setPen(JGoPen.make((int)65535, (int)(this.mIsSelected ? 2 : 1), (Color)DEFAULT_LINK_SELECTED_COLOR));
        this.setBrush(JGoBrush.makeStockBrush((Color)DEFAULT_LINK_SELECTED_COLOR));
        this.highlightSingleLink(this.mMapperLink, this.getMapperCanvas());
    }

    public void stopHighlighting() {
        if (!this.mIsSelected) {
            this.setPen(this.pen);
            this.setBrush(this.brush);
            this.unHighlightSingleLink(this.mMapperLink, this.getMapperCanvas());
        }
    }

    public JGoPort getStartPort() {
        return this.startPort;
    }

    public JGoPort getEndPort() {
        return this.endPort;
    }

    public static void initializeArrowHeads(JGoLink jGoLink) {
        jGoLink.setArrowLength(7.5);
        jGoLink.setArrowShaftLength(6.5);
        jGoLink.setArrowWidth(4.0);
    }

    private void highlightSingleLink(IMapperLink iMapperLink, ICanvasView iCanvasView) {
        IMapperNode iMapperNode;
        IMapperNode iMapperNode2 = iMapperLink.getStartNode();
        if (iMapperNode2 instanceof IMapperTreeNode) {
            iMapperNode = (IMapperTreeNode)iMapperNode2;
            iMapperNode.setHighlightLink(true);
            iMapperNode.setSelectedLink(this.mIsSelected);
            iCanvasView.getParentView().getViewManager().getSourceView().getTree().scrollPathToVisible(iMapperNode.getPath());
            iCanvasView.getParentView().getViewManager().getSourceView().getTree().repaint();
        }
        if ((iMapperNode = iMapperLink.getEndNode()) instanceof IMapperTreeNode) {
            IMapperTreeNode iMapperTreeNode = (IMapperTreeNode)iMapperNode;
            iMapperTreeNode.setHighlightLink(true);
            iMapperTreeNode.setSelectedLink(this.mIsSelected);
            iCanvasView.getParentView().getViewManager().getDestView().getTree().scrollPathToVisible(iMapperTreeNode.getPath());
            iCanvasView.getParentView().getViewManager().getDestView().getTree().repaint();
        }
        AbstractCanvasLink.setPortActivated(this.startPort, true);
        AbstractCanvasLink.setPortActivated(this.endPort, true);
    }

    private void unHighlightSingleLink(IMapperLink iMapperLink, ICanvasView iCanvasView) {
        IMapperNode iMapperNode;
        IMapperNode iMapperNode2 = iMapperLink.getStartNode();
        if (iMapperNode2 instanceof IMapperTreeNode) {
            iMapperNode = (IMapperTreeNode)iMapperNode2;
            iMapperNode.setHighlightLink(false);
            iMapperNode.setSelectedLink(false);
            iCanvasView.getParentView().getViewManager().getSourceView().getTree().repaint();
        }
        if ((iMapperNode = iMapperLink.getEndNode()) instanceof IMapperTreeNode) {
            IMapperTreeNode iMapperTreeNode = (IMapperTreeNode)iMapperNode;
            iMapperTreeNode.setHighlightLink(false);
            iMapperTreeNode.setSelectedLink(false);
            iCanvasView.getParentView().getViewManager().getDestView().getTree().repaint();
        }
        AbstractCanvasLink.setPortActivated(this.startPort, false);
        AbstractCanvasLink.setPortActivated(this.endPort, false);
    }

    private static void setPortActivated(JGoPort jGoPort, boolean bl) {
        DrawPort drawPort;
        if (jGoPort instanceof BasicCanvasPort && (drawPort = ((BasicCanvasPort)jGoPort).getDrawPort()) != null) {
            drawPort.setIsActivated(bl);
        }
    }

    protected class NodeYChangeListener
    implements PropertyChangeListener {
        protected static final int Y_AXIS_DIFF = 1;
        private JGoPort mPort;
        private JGoView mView;

        public NodeYChangeListener(JGoView jGoView, JGoPort jGoPort) {
            this.mPort = jGoPort;
            this.mView = jGoView;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("MNode.Y")) {
                final int n = ((IMapperNode)propertyChangeEvent.getSource()).getY() + 1 + this.mView.getViewPosition().y;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        NodeYChangeListener.this.mPort.setTop(n);
                    }
                });
            }
        }
    }
}

