/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mapper.basicmapper;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.netbeans.modules.soa.mapper.basicmapper.util.MapperUtilities;
import org.netbeans.modules.soa.mapper.common.IMapperGroupNode;
import org.netbeans.modules.soa.mapper.common.IMapperLink;
import org.netbeans.modules.soa.mapper.common.IMapperNode;

public class MapperNode
implements IMapperNode,
Cloneable {
    private IMapperGroupNode mGroupNode;
    private List mLinks;
    private Object mNodeObject;
    private List mPropertyListeners;
    private int mX;
    private int mY;
    private List mNextNodes;
    private List mPreviousNodes;

    public MapperNode() {
        this(0, 0);
    }

    public MapperNode(int n, int n2) {
        this.mX = n;
        this.mY = n2;
        this.mPropertyListeners = new Vector();
        this.mNextNodes = new Vector();
        this.mPreviousNodes = new Vector();
        this.mLinks = new Vector();
    }

    public IMapperGroupNode getGroupNode() {
        return this.mGroupNode;
    }

    public int getLinkCount() {
        return this.mLinks.size();
    }

    public List getLinks() {
        return new ArrayList(this.mLinks);
    }

    public Object getNodeObject() {
        return this.mNodeObject;
    }

    public int getX() {
        return this.mX;
    }

    public int getY() {
        return this.mY;
    }

    public void setGroupNode(IMapperGroupNode iMapperGroupNode) {
        this.mGroupNode = iMapperGroupNode;
    }

    public void setNodeObject(Object object) {
        this.mNodeObject = object;
    }

    public void setX(int n) {
        if (this.mX == n) {
            return;
        }
        int n2 = this.mX;
        this.mX = n;
        this.firePropertyChange("MNode.X", new Integer(n), new Integer(n2));
    }

    public void setY(int n) {
        if (this.mY == n) {
            return;
        }
        int n2 = this.mY;
        this.mY = n;
        this.firePropertyChange("MNode.Y", new Integer(this.mY), new Integer(n2));
    }

    public void addLink(IMapperLink iMapperLink) {
        if (!this.mLinks.contains(iMapperLink)) {
            this.mLinks.add(iMapperLink);
            if (iMapperLink.getStartNode() == this) {
                this.mNextNodes.add(iMapperLink.getEndNode());
            } else {
                this.mPreviousNodes.add(iMapperLink.getStartNode());
            }
            this.firePropertyChange("MNode.AddLink", iMapperLink, null);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.mPropertyListeners.add(propertyChangeListener);
    }

    public boolean containsLink(IMapperLink iMapperLink) {
        return this.mLinks.contains(iMapperLink);
    }

    public void removeLink(IMapperLink iMapperLink) {
        if (this.mLinks.contains(iMapperLink)) {
            this.mLinks.remove(iMapperLink);
            if (iMapperLink.getStartNode() == this) {
                this.mNextNodes.remove(iMapperLink.getEndNode());
            } else {
                this.mPreviousNodes.remove(iMapperLink.getStartNode());
            }
            this.firePropertyChange("MNode.RemoveLink", null, iMapperLink);
        }
    }

    public List getNextNodes() {
        return new ArrayList(this.mNextNodes);
    }

    public List getPreviousNodes() {
        return new ArrayList(this.mPreviousNodes);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.mPropertyListeners.remove(propertyChangeListener);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this.mPropertyListeners.size() > 0) {
            MapperUtilities.firePropertyChanged(this.mPropertyListeners.toArray(new PropertyChangeListener[this.mPropertyListeners.size()]), this, string, object, object2);
        }
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public String getParamString() {
        return super.toString() + " [X=" + this.mX + ", Y=" + this.mY + ", links=" + this.mLinks + ", nodeObj=" + this.mNodeObject + ", groupNode=" + this.mGroupNode + "]";
    }

    public Object clone() {
        MapperNode mapperNode = null;
        try {
            mapperNode = (MapperNode)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            mapperNode = new MapperNode();
        }
        mapperNode.mX = this.mX;
        mapperNode.mY = this.mY;
        mapperNode.mNodeObject = null;
        mapperNode.mGroupNode = null;
        mapperNode.mLinks = new Vector();
        mapperNode.mPropertyListeners = new Vector();
        return mapperNode;
    }
}

