/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.ruby;

import java.awt.Color;
import java.io.CharConversionException;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.StyleConstants;
import org.jruby.ast.AliasNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.IScopingNode;
import org.jruby.ast.Node;
import org.jruby.ast.types.INameNode;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.gsf.api.Index;
import org.netbeans.modules.gsfpath.api.classpath.ClassPath;
import org.netbeans.modules.gsfpath.api.classpath.GlobalPathRegistry;
import org.netbeans.modules.gsfpath.spi.classpath.support.ClassPathSupport;
import org.netbeans.modules.refactoring.ruby.RubyElementCtx;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyIndex;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.elements.IndexedMethod;
import org.netbeans.modules.ruby.lexer.RubyTokenId;
import org.netbeans.napi.gsfret.source.ClasspathInfo;
import org.netbeans.napi.gsfret.source.CompilationInfo;
import org.netbeans.napi.gsfret.source.Source;
import org.netbeans.napi.gsfret.source.SourceUtils;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.xml.XMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetoucheUtils {
    public static Source createSource(ClasspathInfo classpathInfo, FileObject fileObject) {
        if (RubyUtils.isRubyOrRhtmlFile((FileObject)fileObject)) {
            return Source.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[]{fileObject});
        }
        return null;
    }

    public static Source getSource(FileObject fileObject) {
        Source source = Source.forFileObject((FileObject)fileObject);
        return source;
    }

    public static Source getSource(Document document) {
        Source source = Source.forDocument((Document)document);
        return source;
    }

    public static BaseDocument getDocument(CompilationInfo compilationInfo, FileObject fileObject) {
        try {
            DataObject dataObject;
            EditorCookie editorCookie;
            BaseDocument baseDocument = null;
            if (compilationInfo != null) {
                baseDocument = (BaseDocument)compilationInfo.getDocument();
            }
            if (baseDocument == null && (editorCookie = (EditorCookie)(dataObject = DataObject.find((FileObject)fileObject)).getCookie(EditorCookie.class)) != null) {
                baseDocument = (BaseDocument)editorCookie.openDocument();
            }
            return baseDocument;
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return null;
        }
    }

    public static String[] getNodeNames(Node node) {
        Colon2Node colon2Node;
        String string = null;
        String string2 = null;
        if (node instanceof Colon2Node) {
            colon2Node = (Colon2Node)node;
            string2 = colon2Node.getName();
            string = AstUtilities.getFqn((Colon2Node)colon2Node);
        } else if (node instanceof AliasNode) {
            string = ((AliasNode)node).getNewName();
        }
        if (string == null && node instanceof INameNode) {
            string = ((INameNode)node).getName();
        }
        if (string == null && node instanceof IScopingNode) {
            if (((IScopingNode)node).getCPath() instanceof Colon2Node) {
                colon2Node = (Colon2Node)((IScopingNode)node).getCPath();
                string2 = colon2Node.getName();
                string = AstUtilities.getFqn((Colon2Node)colon2Node);
            } else {
                string = AstUtilities.getClassOrModuleName((IScopingNode)((IScopingNode)node));
            }
        }
        if (string2 == null) {
            string2 = string;
        }
        return new String[]{string, string2};
    }

    public static CloneableEditorSupport findCloneableEditorSupport(CompilationInfo compilationInfo) {
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)compilationInfo.getFileObject());
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
        }
        return RetoucheUtils.findCloneableEditorSupport(dataObject);
    }

    public static CloneableEditorSupport findCloneableEditorSupport(DataObject dataObject) {
        Node.Cookie cookie = dataObject.getCookie(OpenCookie.class);
        if (cookie instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)cookie;
        }
        cookie = dataObject.getCookie(EditorCookie.class);
        if (cookie instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)cookie;
        }
        return null;
    }

    public static String htmlize(String string) {
        try {
            return XMLUtil.toElementContent((String)string);
        }
        catch (CharConversionException charConversionException) {
            Exceptions.printStackTrace((Throwable)charConversionException);
            return string;
        }
    }

    public static IndexedMethod getOverridingMethod(RubyElementCtx rubyElementCtx, CompilationInfo compilationInfo) {
        RubyIndex rubyIndex = RubyIndex.get((Index)compilationInfo.getIndex("text/x-ruby"));
        String string = AstUtilities.getFqnName((AstPath)rubyElementCtx.getPath());
        return rubyIndex.getOverridingMethod(string, rubyElementCtx.getName());
    }

    public static String getHtml(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        TokenHierarchy tokenHierarchy = TokenHierarchy.create((CharSequence)string, (Language)RubyTokenId.language());
        Lookup lookup = MimeLookup.getLookup((MimePath)MimePath.get((String)"text/x-ruby"));
        FontColorSettings fontColorSettings = (FontColorSettings)lookup.lookup(FontColorSettings.class);
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        while (tokenSequence.moveNext()) {
            Token token = tokenSequence.token();
            String string2 = token.id().name();
            AttributeSet attributeSet = fontColorSettings.getTokenFontColors(string2);
            if (attributeSet == null) {
                string2 = token.id().primaryCategory();
                if (string2 == null) {
                    string2 = "whitespace";
                }
                attributeSet = fontColorSettings.getTokenFontColors(string2);
            }
            String string3 = RetoucheUtils.htmlize(((Object)token.text()).toString());
            stringBuffer.append(RetoucheUtils.color(string3, attributeSet));
        }
        return stringBuffer.toString();
    }

    private static String color(String string, AttributeSet attributeSet) {
        if (attributeSet == null) {
            return string;
        }
        if (string.trim().length() == 0) {
            return Utilities.replaceString((String)Utilities.replaceString((String)string, (String)" ", (String)"&nbsp;"), (String)"\n", (String)"<br>");
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        if (StyleConstants.isBold(attributeSet)) {
            stringBuffer.insert(0, "<b>");
            stringBuffer.append("</b>");
        }
        if (StyleConstants.isItalic(attributeSet)) {
            stringBuffer.insert(0, "<i>");
            stringBuffer.append("</i>");
        }
        if (StyleConstants.isStrikeThrough(attributeSet)) {
            stringBuffer.insert(0, "<s>");
            stringBuffer.append("</s>");
        }
        stringBuffer.insert(0, "<font color=" + RetoucheUtils.getHTMLColor(StyleConstants.getForeground(attributeSet)) + ">");
        stringBuffer.append("</font>");
        return stringBuffer.toString();
    }

    private static String getHTMLColor(Color color) {
        String string = "0" + Integer.toHexString(color.getRed());
        string = string.substring(string.length() - 2);
        String string2 = "0" + Integer.toHexString(color.getGreen());
        string2 = string2.substring(string2.length() - 2);
        String string3 = "0" + Integer.toHexString(color.getBlue());
        string3 = string3.substring(string3.length() - 2);
        String string4 = "#" + string + string2 + string3;
        return string4;
    }

    public static boolean isElementInOpenProject(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < projectArray.length; ++i) {
            if (project != projectArray[i]) continue;
            return true;
        }
        return false;
    }

    public static boolean isFileInOpenProject(FileObject fileObject) {
        assert (fileObject != null);
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < projectArray.length; ++i) {
            if (project != projectArray[i]) continue;
            return true;
        }
        return false;
    }

    public static boolean isOnSourceClasspath(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return false;
        }
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < projectArray.length; ++i) {
            if (project != projectArray[i]) continue;
            SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("ruby");
            for (int j = 0; j < sourceGroupArray.length; ++j) {
                if (fileObject == sourceGroupArray[j].getRootFolder()) {
                    return true;
                }
                if (!FileUtil.isParentOf((FileObject)sourceGroupArray[j].getRootFolder(), (FileObject)fileObject)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean isClasspathRoot(FileObject fileObject) {
        FileObject fileObject2;
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
        if (classPath != null && (fileObject2 = classPath.findOwnerRoot(fileObject)) != null) {
            return fileObject.equals(fileObject2);
        }
        return false;
    }

    public static boolean isRefactorable(FileObject fileObject) {
        return RubyUtils.isRubyOrRhtmlFile((FileObject)fileObject) && RetoucheUtils.isFileInOpenProject(fileObject) && RetoucheUtils.isOnSourceClasspath(fileObject);
    }

    public static String getPackageName(FileObject fileObject) {
        assert (fileObject.isFolder()) : "argument must be folder";
        return ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source").getResourceName(fileObject, '.', false);
    }

    public static String getPackageName(URL uRL) {
        File file = null;
        try {
            file = FileUtil.normalizeFile((File)new File(uRL.toURI()));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Cannot create package name for url " + uRL);
        }
        String string = "";
        do {
            FileObject fileObject;
            if ((fileObject = FileUtil.toFileObject((File)file)) != null) {
                if ("".equals(string)) {
                    return RetoucheUtils.getPackageName(fileObject);
                }
                String string2 = RetoucheUtils.getPackageName(fileObject);
                return string2 + ("".equals(string2) ? "" : ".") + string;
            }
            if (!"".equals(string)) {
                string = "." + string;
            }
            string = URLDecoder.decode(file.getPath().substring(file.getPath().lastIndexOf(File.separatorChar) + 1)) + string;
        } while ((file = file.getParentFile()) != null);
        throw new IllegalArgumentException("Cannot create package name for url " + uRL);
    }

    public static FileObject getOrCreateFolder(URL uRL) throws IOException {
        try {
            FileObject fileObject = URLMapper.findFileObject((URL)uRL);
            if (fileObject != null) {
                return fileObject;
            }
            File file = new File(uRL.toURI());
            fileObject = FileUtil.createFolder((File)file);
            return fileObject;
        }
        catch (URISyntaxException uRISyntaxException) {
            throw (IOException)new IOException().initCause(uRISyntaxException);
        }
    }

    public static FileObject getClassPathRoot(URL uRL) throws IOException {
        FileObject fileObject = URLMapper.findFileObject((URL)uRL);
        File file = FileUtil.normalizeFile((File)new File(uRL.getPath()));
        while (fileObject == null) {
            fileObject = FileUtil.toFileObject((File)file);
            file = file.getParentFile();
        }
        return ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source").findOwnerRoot(fileObject);
    }

    public static ElementKind getElementKind(RubyElementCtx rubyElementCtx) {
        return rubyElementCtx.getKind();
    }

    public static ClasspathInfo getClasspathInfoFor(FileObject ... classPath) {
        Project project;
        FileObject fileObject2;
        assert (((FileObject[])classPath).length > 0);
        HashSet<URL> hashSet = new HashSet<URL>();
        for (FileObject fileObject2 : classPath) {
            project = null;
            if (fileObject2 != null) {
                project = FileOwnerQuery.getOwner((FileObject)fileObject2);
            }
            if (project != null) {
                URL uRL = URLMapper.findURL((FileObject)ClassPath.getClassPath((FileObject)fileObject2, (String)"classpath/source").findOwnerRoot(fileObject2), (int)0);
                hashSet.addAll(SourceUtils.getDependentRoots((URL)uRL));
                for (SourceGroup sourceGroup : ProjectUtils.getSources((Project)project).getSourceGroups("ruby")) {
                    hashSet.add(URLMapper.findURL((FileObject)sourceGroup.getRootFolder(), (int)0));
                }
                continue;
            }
            for (SourceGroup[] sourceGroupArray : GlobalPathRegistry.getDefault().getPaths("classpath/source")) {
                for (FileObject fileObject3 : sourceGroupArray.getRoots()) {
                    hashSet.add(URLMapper.findURL((FileObject)fileObject3, (int)0));
                }
            }
        }
        ClassPath classPath2 = ClassPathSupport.createClassPath((URL[])hashSet.toArray(new URL[hashSet.size()]));
        ClassPath classPath3 = ClassPathSupport.createClassPath((FileObject[])new FileObject[0]);
        ClassPath classPath4 = classPath[0] != null ? ClassPath.getClassPath((FileObject)classPath[0], (String)"classpath/boot") : classPath3;
        fileObject2 = classPath[0] != null ? ClassPath.getClassPath((FileObject)classPath[0], (String)"classpath/compile") : classPath3;
        project = ClasspathInfo.create((ClassPath)classPath4, (ClassPath)fileObject2, (ClassPath)classPath2);
        return project;
    }

    public static ClasspathInfo getClasspathInfoFor(RubyElementCtx rubyElementCtx) {
        return RetoucheUtils.getClasspathInfoFor(rubyElementCtx.getFileObject());
    }

    public static List<FileObject> getRubyFilesInProject(FileObject fileObject) {
        ClasspathInfo classpathInfo = RetoucheUtils.getClasspathInfoFor(fileObject);
        ClassPath classPath = classpathInfo.getClassPath(ClasspathInfo.PathKind.SOURCE);
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>(100);
        for (ClassPath.Entry entry : classPath.entries()) {
            FileObject fileObject2 = entry.getRoot();
            String string = fileObject2.getName();
            if (string.equals("vendor") || string.equals("script")) continue;
            RetoucheUtils.addRubyFiles(arrayList, fileObject2);
        }
        return arrayList;
    }

    private static void addRubyFiles(List<FileObject> list, FileObject fileObject) {
        if (fileObject.isFolder()) {
            for (FileObject fileObject2 : fileObject.getChildren()) {
                RetoucheUtils.addRubyFiles(list, fileObject2);
            }
        } else if (RubyUtils.isRubyOrRhtmlFile((FileObject)fileObject)) {
            list.add(fileObject);
        }
    }
}

