/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.reflection.wrapper;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.property.PropertyTokenizer;
import org.apache.ibatis.reflection.wrapper.BaseWrapper;

public class MapWrapper
extends BaseWrapper {
    private Map map;
    private Object[] keyArray;

    public MapWrapper(MetaObject metaObject, Map map) {
        super(metaObject);
        this.map = map;
        this.updateKeyArray();
    }

    public Object get(PropertyTokenizer prop) {
        if (prop.getIndex() != null) {
            Object collection = this.resolveCollection(prop, this.map);
            return this.getCollectionValue(prop, collection);
        }
        return this.map.get(prop.getName());
    }

    public void set(PropertyTokenizer prop, Object value) {
        if (prop.getIndex() != null) {
            Object collection = this.resolveCollection(prop, this.map);
            this.setCollectionValue(prop, collection, value);
        } else {
            this.map.put(prop.getName(), value);
        }
        this.updateKeyArray();
    }

    public String findProperty(String name) {
        this.updateKeyArray();
        if (name != null) {
            Arrays.binarySearch(this.keyArray, name, new Comparator(){

                public int compare(Object o1, Object o2) {
                    if (o1 == o2) {
                        return 0;
                    }
                    if (o1 == null && o2 == null) {
                        return 0;
                    }
                    if (o1 == null) {
                        return -1;
                    }
                    if (o2 == null) {
                        return 1;
                    }
                    return ((String)o1).toLowerCase().compareTo(((String)o2).toLowerCase());
                }
            });
        }
        return name;
    }

    public String[] getGetterNames() {
        return this.map.keySet().toArray(new String[this.map.keySet().size()]);
    }

    public String[] getSetterNames() {
        return this.map.keySet().toArray(new String[this.map.keySet().size()]);
    }

    public Class getSetterType(String name) {
        PropertyTokenizer prop = new PropertyTokenizer(name);
        if (prop.hasNext()) {
            MetaObject metaValue = this.metaObject.metaObjectForProperty(prop.getIndexedName());
            if (metaValue == MetaObject.NULL_META_OBJECT) {
                return Object.class;
            }
            return metaValue.getSetterType(prop.getChildren());
        }
        if (this.map.get(name) != null) {
            return this.map.get(name).getClass();
        }
        return Object.class;
    }

    public Class getGetterType(String name) {
        PropertyTokenizer prop = new PropertyTokenizer(name);
        if (prop.hasNext()) {
            MetaObject metaValue = this.metaObject.metaObjectForProperty(prop.getIndexedName());
            if (metaValue == MetaObject.NULL_META_OBJECT) {
                return Object.class;
            }
            return metaValue.getGetterType(prop.getChildren());
        }
        if (this.map.get(name) != null) {
            return this.map.get(name).getClass();
        }
        return Object.class;
    }

    public boolean hasSetter(String name) {
        return true;
    }

    public boolean hasGetter(String name) {
        PropertyTokenizer prop = new PropertyTokenizer(name);
        if (prop.hasNext()) {
            if (this.map.containsKey(prop.getIndexedName())) {
                MetaObject metaValue = this.metaObject.metaObjectForProperty(prop.getIndexedName());
                if (metaValue == MetaObject.NULL_META_OBJECT) {
                    return this.map.containsKey(name);
                }
                return metaValue.hasGetter(prop.getChildren());
            }
            return false;
        }
        return this.map.containsKey(name);
    }

    public MetaObject instantiatePropertyValue(String name, PropertyTokenizer prop, ObjectFactory objectFactory) {
        HashMap map = new HashMap();
        this.set(prop, map);
        return MetaObject.forObject(map, this.metaObject.getObjectFactory(), this.metaObject.getObjectWrapperFactory());
    }

    private void updateKeyArray() {
        this.keyArray = this.map.keySet().toArray();
        Arrays.sort(this.keyArray);
    }
}

