/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.logging;

import java.lang.reflect.Constructor;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogFactory {
    private static Constructor<? extends Log> logConstructor;

    public static Log getLog(Class<?> aClass) {
        try {
            return logConstructor.newInstance(aClass);
        }
        catch (Throwable t) {
            throw new LogException("Error creating logger for class " + aClass + ".  Cause: " + t, t);
        }
    }

    public static synchronized void useSlf4jLogging() {
        LogFactory.setImplementation("org.slf4j.LoggerFactory", "org.apache.ibatis.logging.slf4j.Slf4jImpl");
    }

    public static synchronized void useCommonsLogging() {
        LogFactory.setImplementation("org.apache.commons.logging.LogFactory", "org.apache.ibatis.logging.commons.JakartaCommonsLoggingImpl");
    }

    public static synchronized void useLog4JLogging() {
        LogFactory.setImplementation("org.apache.log4j.Logger", "org.apache.ibatis.logging.log4j.Log4jImpl");
    }

    public static synchronized void useJdkLogging() {
        LogFactory.setImplementation("java.util.logging.Logger", "org.apache.ibatis.logging.jdk14.Jdk14LoggingImpl");
    }

    public static synchronized void useStdOutLogging() {
        LogFactory.setImplementation("org.apache.ibatis.logging.stdout.StdOutImpl");
    }

    public static synchronized void useNoLogging() {
        LogFactory.setImplementation("org.apache.ibatis.logging.nologging.NoLoggingImpl");
    }

    private static void tryImplementation(Runnable runnable) {
        if (logConstructor == null) {
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void setImplementation(String implClassName) {
        LogFactory.setImplementation(implClassName, implClassName);
    }

    private static void setImplementation(String testClassName, String implClassName) {
        try {
            Resources.classForName(testClassName);
            Class<?> implClass = Resources.classForName(implClassName);
            logConstructor = implClass.getConstructor(Class.class);
        }
        catch (Throwable t) {
            throw new LogException("Error setting Log implementation.  Cause: " + t, t);
        }
    }

    static {
        LogFactory.tryImplementation(new Runnable(){

            public void run() {
                LogFactory.useSlf4jLogging();
            }
        });
        LogFactory.tryImplementation(new Runnable(){

            public void run() {
                LogFactory.useCommonsLogging();
            }
        });
        LogFactory.tryImplementation(new Runnable(){

            public void run() {
                LogFactory.useLog4JLogging();
            }
        });
        LogFactory.tryImplementation(new Runnable(){

            public void run() {
                LogFactory.useJdkLogging();
            }
        });
        LogFactory.tryImplementation(new Runnable(){

            public void run() {
                LogFactory.useNoLogging();
            }
        });
    }
}

