//---------------------------------------------------------------------------
// Copyright (C) 1999 Dallas Semiconductor Corporation, All Rights Reserved.
// 
// Permission is hereby granted, free of charge, to any person obtaining a 
// copy of this software and associated documentation files (the "Software"), 
// to deal in the Software without restriction, including without limitation 
// the rights to use, copy, modify, merge, publish, distribute, sublicense, 
// and/or sell copies of the Software, and to permit persons to whom the 
// Software is furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included 
// in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS 
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
// MERCHANTABILITY,  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. 
// IN NO EVENT SHALL DALLAS SEMICONDUCTOR BE LIABLE FOR ANY CLAIM, DAMAGES 
// OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, 
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
// OTHER DEALINGS IN THE SOFTWARE.
// 
// Except as contained in this notice, the name of Dallas Semiconductor 
// shall not be used except as stated in the Dallas Semiconductor 
// Branding Policy. 
//---------------------------------------------------------------------------
//
//  TODO.C - Link Layer functions required by MLANTRAN, MLANNET.C and 
//           MLANFILE.C.  Fill in the platform specific code.
//
//  Version: 1.03
//
//  History: 1.00 -> 1.01  Added function msDelay.
//           1.02 -> 1.03  Added function msGettick.
//
 
#include "MLan.h"

// exportable link-level functions
int MLanTouchReset(void);
int MLanTouchBit(int);
int MLanTouchByte(int);
int MLanWriteByte(int sendbyte);
int MLanReadByte(void);
int MLanSpeed(int);
int MLanLevel(int);
int MLanProgramPulse(void);
void msDelay(int);
long msGettick(void);

//--------------------------------------------------------------------------
// Reset all of the devices on the MicroLAN and return the result.
//
// Returns: TRUE(1):  presense pulse(s) detected, device(s) reset
//          FALSE(0): no presense pulses detected
//
int MLanTouchReset(void)
{
   // add platform specific code here
   return 0;
}


//--------------------------------------------------------------------------
// Send 1 bit of communication to the MicroLAN and return the
// result 1 bit read from the MicroLAN.  The parameter 'sendbit'
// least significant bit is used and the least significant bit
// of the result is the return bit.
//
// 'sendbit' - the least significant bit is the bit to send
//
// Returns: 0:   0 bit read from sendbit
//          1:   1 bit read from sendbit
//
int MLanTouchBit(int sendbit)
{
   // add platform specific code here
   return 0;
}


//--------------------------------------------------------------------------
// Send 8 bits of communication to the MicroLAN and return the
// result 8 bits read from the MicroLAN.  The parameter 'sendbyte'
// least significant 8 bits are used and the least significant 8 bits
// of the result is the return byte.
//
// 'sendbyte' - 8 bits to send (least significant byte)
//
// Returns:  8 bytes read from sendbyte
//
int MLanTouchByte(int sendbyte)
{
   // add platform specific code here
   return 0;
}


//--------------------------------------------------------------------------
// Send 8 bits of communication to the MicroLAN and verify that the
// 8 bits read from the MicroLAN is the same (write operation).  
// The parameter 'sendbyte' least significant 8 bits are used.
//
// 'sendbyte' - 8 bits to send (least significant byte)
//
// Returns:  TRUE: bytes written and echo was the same
//           FALSE: echo was not the same 
//
int MLanWriteByte(int sendbyte)
{
   return (MLanTouchByte(sendbyte) == sendbyte) ? TRUE : FALSE;
}


//--------------------------------------------------------------------------
// Send 8 bits of read communication to the MicroLAN and and return the
// result 8 bits read from the MicroLAN.   
//
// Returns:  8 bytes read from MicroLAN
//
int MLanReadByte(void)
{
   return MLanTouchByte(0xFF);
}


//--------------------------------------------------------------------------
// Set the MicroLAN communucation speed.  
//
// 'NewSpeed' - new speed defined as
//                MODE_NORMAL     0x00
//                MODE_OVERDRIVE  0x01
//
// Returns:  current MicroLAN speed 
//
int MLanSpeed(int NewSpeed)
{
   // add platform specific code here
   return 0;
}


//--------------------------------------------------------------------------
// Set the MicroLAN line level.  The values for NewLevel are
// as follows:
//
// 'NewLevel' - new level defined as
//                MODE_NORMAL     0x00
//                MODE_STRONG5    0x02
//                MODE_PROGRAM    0x04
//                MODE_BREAK      0x08 
//
// Returns:  current MicroLAN level  
//
int MLanLevel(int NewLevel)
{
   // add platform specific code here
   return 0;
}


//--------------------------------------------------------------------------
// This procedure creates a fixed 480 microseconds 12 volt pulse 
// on the MicroLAN for programming EPROM iButtons.
//
// Returns:  TRUE  successful
//           FALSE program voltage not available  
//
int MLanProgramPulse(void)
{
   // add platform specific code here
   return 0;
}


//--------------------------------------------------------------------------
//  Description:
//     Delay for at least 'len' ms
// 
void msDelay(int len)
{
   // add platform specific code here
}


//--------------------------------------------------------------------------
// Get the current millisecond tick count.  Does not have to represent
// an actual time, it just needs to be an incrementing timer.
//
long msGettick(void)
{
   // add platform specific code here
   return 0;
}

