//---------------------------------------------------------------------------
// Copyright (C) 1999 Dallas Semiconductor Corporation, All Rights Reserved.
// 
// Permission is hereby granted, free of charge, to any person obtaining a 
// copy of this software and associated documentation files (the "Software"), 
// to deal in the Software without restriction, including without limitation 
// the rights to use, copy, modify, merge, publish, distribute, sublicense, 
// and/or sell copies of the Software, and to permit persons to whom the 
// Software is furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included 
// in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS 
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
// MERCHANTABILITY,  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. 
// IN NO EVENT SHALL DALLAS SEMICONDUCTOR BE LIABLE FOR ANY CLAIM, DAMAGES 
// OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, 
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
// OTHER DEALINGS IN THE SOFTWARE.
// 
// Except as contained in this notice, the name of Dallas Semiconductor 
// shall not be used except as stated in the Dallas Semiconductor 
// Branding Policy. 
//---------------------------------------------------------------------------
//
//  tstfind.C - Test application to search for all 1-Wire devices on 1-Wire 
//              Net.
//
//  Version: 1.03
//
//           1.02 -> 1.03  Removed caps in #includes for Linux capatibility
//                         Removed "ds2480.h", <windows.h> and <conio.h> 
//                           includes because not needed
//                         Added "mlan.h" include to define TRUE/FALSE
//                         Prompt to search again 
//                         Changed to use Aquire/Release 1-Wire Net functions
 
#include <stdio.h>
#include <stdlib.h>
#include "mlan.h"

// external MLan functions to test
extern int  MLanFirst(int,int);
extern int  MLanNext(int,int);
extern void MLanSerialNum(uchar *, int);
extern int  Aquire1WireNet(char *, char *);
extern void Release1WireNet(char *);

// local funcitons
void PrintSerialNum(void);

//----------------------------------------------------------------------
//  Main Test
//
void main(short argc, char **argv)
{
   int rslt,cnt;
   char line_zstr[128];
   char return_msg[128];
  
   // check for required port name
   if (argc != 2)
   {
      printf("1-Wire Net name required on command line!\n"
             " (example: \"COM1\" (Win32 DS2480),\"/dev/cua0\" "
             "(Linux DS2480),\"1\" (Win32 TMEX)\n");
      exit(1);
   }

   // attempt to aquire the 1-Wire Net
   if (!Aquire1WireNet(argv[1], return_msg))
   {  
      printf("%s",return_msg);
      exit(1);
   }

   // success
   printf("%s",return_msg);

   //----------------------------------------
   // Introduction
   printf("\n/---------------------------------------------\n");
   printf("  Loop to find all iButton on MicroLAN.\n"
          "  Press any key to stop.\n\n");

   do
   {
      printf("-------------------- Start of search\n");
      cnt = 0;
      // find the first device (all devices not just alarming)
      rslt = MLanFirst(TRUE, FALSE);
      while (rslt)
      {
         // print the device number
         cnt++;
         printf("(%d) ",cnt);

         // print the Serial Number of the device just found
         PrintSerialNum();

         // find the next device
         rslt = MLanNext(TRUE, FALSE);
      }
      printf("-------------------- End of search\n");

      printf("\n(ENTER to search again, Q or q to Quit) ");
      gets(line_zstr);
      printf("\n");  
   }
   while ((line_zstr[0] != 'q') && (line_zstr[0] != 'Q'));   

   // release the 1-Wire Net
   Release1WireNet(return_msg);
   printf("%s",return_msg);
   exit(0);
}


//----------------------------------------------------------------------
//  Read and print the Serial Number.
//
void PrintSerialNum(void)
{
   uchar TempSerialNumber[8];
   int i;

   MLanSerialNum(TempSerialNumber,TRUE);
   for (i = 7; i >= 0; i--)
      printf("%02X",TempSerialNumber[i]);
   printf("\n");
}
