/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    private static File workDir = null;

    public static OS getPlatform() {
        String string = System.getProperty("os.name").toLowerCase();
        if (string.contains("win")) {
            return OS.WINDOWS;
        }
        if (string.contains("mac")) {
            return OS.MACOS;
        }
        if (string.contains("solaris")) {
            return OS.SOLARIS;
        }
        if (string.contains("sunos")) {
            return OS.SOLARIS;
        }
        if (string.contains("linux")) {
            return OS.LINUX;
        }
        if (string.contains("unix")) {
            return OS.LINUX;
        }
        return OS.UNKNOWN;
    }

    public static File getWorkingDirectory() {
        if (workDir == null) {
            workDir = Util.getWorkingDirectory("minecraft");
        }
        return workDir;
    }

    public static File getWorkingDirectory(String string) {
        File file;
        String string2 = System.getProperty("user.home", ".");
        switch (Util.getPlatform()) {
            case LINUX: 
            case SOLARIS: {
                file = new File(string2, '.' + string + '/');
                break;
            }
            case WINDOWS: {
                String string3 = System.getenv("APPDATA");
                String string4 = string3 != null ? string3 : string2;
                file = new File(string4, '.' + string + '/');
                break;
            }
            case MACOS: {
                file = new File(string2, "Library/Application Support/" + string);
                break;
            }
            default: {
                file = new File(string2, string + '/');
            }
        }
        if (!file.exists() && !file.mkdirs()) {
            throw new RuntimeException("The working directory could not be created: " + file);
        }
        return file;
    }

    public static String buildQuery(Map<String, Object> map) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('&');
            }
            try {
                stringBuilder.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
            if (entry.getValue() == null) continue;
            stringBuilder.append('=');
            try {
                stringBuilder.append(URLEncoder.encode(entry.getValue().toString(), "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        }
        return stringBuilder.toString();
    }

    public static String executePost(String string, Map<String, Object> map) {
        return Util.executePost(string, Util.buildQuery(map));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String executePost(String string, String string2) {
        HttpURLConnection httpURLConnection = null;
        try {
            String string3;
            URL uRL = new URL(string);
            httpURLConnection = (HttpsURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            httpURLConnection.setRequestProperty("Content-Length", "" + Integer.toString(string2.getBytes().length));
            httpURLConnection.setRequestProperty("Content-Language", "en-US");
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.connect();
            Certificate[] certificateArray = ((HttpsURLConnection)httpURLConnection).getServerCertificates();
            byte[] byArray = new byte[294];
            DataInputStream dataInputStream = new DataInputStream(Util.class.getResourceAsStream("minecraft.key"));
            dataInputStream.readFully(byArray);
            dataInputStream.close();
            Certificate certificate = certificateArray[0];
            PublicKey publicKey = certificate.getPublicKey();
            byte[] byArray2 = publicKey.getEncoded();
            for (int i = 0; i < byArray2.length; ++i) {
                if (byArray2[i] == byArray[i]) continue;
                throw new RuntimeException("Public key mismatch");
            }
            DataOutputStream dataOutputStream = new DataOutputStream(httpURLConnection.getOutputStream());
            dataOutputStream.writeBytes(string2);
            dataOutputStream.flush();
            dataOutputStream.close();
            InputStream inputStream = httpURLConnection.getInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuffer stringBuffer = new StringBuffer();
            while ((string3 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string3);
                stringBuffer.append('\r');
            }
            bufferedReader.close();
            String string4 = stringBuffer.toString();
            return string4;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string5 = null;
            return string5;
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static void openLink(URI uRI) {
        try {
            Object object = Class.forName("java.awt.Desktop").getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            object.getClass().getMethod("browse", URI.class).invoke(object, uRI);
        }
        catch (Throwable throwable) {
            System.out.println("Failed to open link " + uRI.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OS {
        LINUX,
        SOLARIS,
        WINDOWS,
        MACOS,
        UNKNOWN;

    }
}

