/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import java.applet.Applet;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.MessageDigest;
import java.security.PermissionCollection;
import java.security.PrivilegedExceptionAction;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.zip.ZipEntry;
import net.minecraft.Launcher;
import net.minecraft.Util;

public class GameUpdater
implements Runnable {
    public static final int STATE_INIT = 1;
    public static final int STATE_DETERMINING_PACKAGES = 2;
    public static final int STATE_CHECKING_CACHE = 3;
    public static final int STATE_DOWNLOADING = 4;
    public static final int STATE_EXTRACTING_PACKAGES = 5;
    public static final int STATE_UPDATING_CLASSPATH = 6;
    public static final int STATE_SWITCHING_APPLET = 7;
    public static final int STATE_INITIALIZE_REAL_APPLET = 8;
    public static final int STATE_START_REAL_APPLET = 9;
    public static final int STATE_DONE = 10;
    public int percentage;
    public int currentSizeDownload;
    public int totalSizeDownload;
    public int currentSizeExtract;
    public int totalSizeExtract;
    protected URL[] urlList;
    private static ClassLoader classLoader;
    protected Thread loaderThread;
    public boolean fatalError;
    public String fatalErrorDescription;
    protected String subtaskMessage = "";
    protected int state = 1;
    protected boolean lzmaSupported = false;
    protected boolean pack200Supported = false;
    protected boolean certificateRefused;
    protected static boolean natives_loaded;
    public static boolean forceUpdate;
    private String latestVersion;
    private String mainGameUrl;
    public boolean pauseAskUpdate;
    public boolean shouldUpdate;
    public boolean skipUpdate;

    public GameUpdater(String string, String string2, boolean bl) {
        this.latestVersion = string;
        this.mainGameUrl = string2;
        this.skipUpdate = bl;
    }

    public void init() {
        this.state = 1;
        try {
            Class.forName("LZMA.LzmaInputStream");
            this.lzmaSupported = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            Pack200.class.getSimpleName();
            this.pack200Supported = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private String generateStacktrace(Exception exception) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        exception.printStackTrace(printWriter);
        return ((Object)stringWriter).toString();
    }

    protected String getDescriptionForState() {
        switch (this.state) {
            case 1: {
                return "Initializing loader";
            }
            case 2: {
                return "Determining packages to load";
            }
            case 3: {
                return "Checking cache for existing files";
            }
            case 4: {
                return "Downloading packages";
            }
            case 5: {
                return "Extracting downloaded packages";
            }
            case 6: {
                return "Updating classpath";
            }
            case 7: {
                return "Switching applet";
            }
            case 8: {
                return "Initializing real applet";
            }
            case 9: {
                return "Starting real applet";
            }
            case 10: {
                return "Done loading";
            }
        }
        return "unknown state";
    }

    protected String trimExtensionByCapabilities(String string) {
        if (!this.pack200Supported) {
            string = string.replaceAll(".pack", "");
        }
        if (!this.lzmaSupported) {
            string = string.replaceAll(".lzma", "");
        }
        return string;
    }

    protected void loadJarURLs() throws Exception {
        this.state = 2;
        String string = "lwjgl.jar, jinput.jar, lwjgl_util.jar, " + this.mainGameUrl;
        string = this.trimExtensionByCapabilities(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        int n = stringTokenizer.countTokens() + 1;
        this.urlList = new URL[n];
        URL uRL = new URL("http://s3.amazonaws.com/MinecraftDownload/");
        for (int i = 0; i < n - 1; ++i) {
            this.urlList[i] = new URL(uRL, stringTokenizer.nextToken());
        }
        String string2 = System.getProperty("os.name");
        String string3 = null;
        if (string2.startsWith("Win")) {
            string3 = "windows_natives.jar.lzma";
        } else if (string2.startsWith("Linux")) {
            string3 = "linux_natives.jar.lzma";
        } else if (string2.startsWith("Mac")) {
            string3 = "macosx_natives.jar.lzma";
        } else if (string2.startsWith("Solaris") || string2.startsWith("SunOS")) {
            string3 = "solaris_natives.jar.lzma";
        } else {
            this.fatalErrorOccured("OS (" + string2 + ") not supported", null);
        }
        if (string3 == null) {
            this.fatalErrorOccured("no lwjgl natives files found", null);
        } else {
            string3 = this.trimExtensionByCapabilities(string3);
            this.urlList[n - 1] = new URL(uRL, string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.init();
        this.state = 3;
        this.percentage = 5;
        try {
            this.loadJarURLs();
            String string = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return Util.getWorkingDirectory() + File.separator + "bin" + File.separator;
                }
            });
            File file = new File(string);
            if (!file.exists()) {
                file.mkdirs();
            }
            if (this.latestVersion != null) {
                File file2 = new File(file, "version");
                boolean bl = false;
                if (!this.skipUpdate && !forceUpdate && file2.exists() && (this.latestVersion.equals("-1") || this.latestVersion.equals(this.readVersionFile(file2)))) {
                    bl = true;
                    this.percentage = 90;
                }
                if (!(this.skipUpdate || !forceUpdate && bl)) {
                    this.shouldUpdate = true;
                    if (!forceUpdate && file2.exists()) {
                        this.checkShouldUpdate();
                    }
                    if (this.shouldUpdate) {
                        this.writeVersionFile(file2, "");
                        this.downloadJars(string);
                        this.extractJars(string);
                        this.extractNatives(string);
                        if (this.latestVersion != null) {
                            this.percentage = 90;
                            this.writeVersionFile(file2, this.latestVersion);
                        }
                    } else {
                        bl = true;
                        this.percentage = 90;
                    }
                }
            }
            this.updateClassPath(file);
            this.state = 10;
        }
        catch (AccessControlException accessControlException) {
            this.fatalErrorOccured(accessControlException.getMessage(), accessControlException);
            this.certificateRefused = true;
        }
        catch (Exception exception) {
            this.fatalErrorOccured(exception.getMessage(), exception);
        }
        finally {
            this.loaderThread = null;
        }
    }

    private void checkShouldUpdate() {
        this.pauseAskUpdate = true;
        while (this.pauseAskUpdate) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    protected String readVersionFile(File file) throws Exception {
        DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
        String string = dataInputStream.readUTF();
        dataInputStream.close();
        return string;
    }

    protected void writeVersionFile(File file, String string) throws Exception {
        DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(file));
        dataOutputStream.writeUTF(string);
        dataOutputStream.close();
    }

    protected void updateClassPath(File file) throws Exception {
        String string;
        this.state = 6;
        this.percentage = 95;
        URL[] uRLArray = new URL[this.urlList.length];
        for (int i = 0; i < this.urlList.length; ++i) {
            uRLArray[i] = new File(file, this.getJarName(this.urlList[i])).toURI().toURL();
        }
        if (classLoader == null) {
            classLoader = new URLClassLoader(uRLArray){

                protected PermissionCollection getPermissions(CodeSource codeSource) {
                    PermissionCollection permissionCollection = null;
                    try {
                        Method method = SecureClassLoader.class.getDeclaredMethod("getPermissions", CodeSource.class);
                        method.setAccessible(true);
                        permissionCollection = (PermissionCollection)method.invoke((Object)this.getClass().getClassLoader(), codeSource);
                        permissionCollection.add(new SocketPermission("www.minecraft.net", "connect,accept"));
                        permissionCollection.add(new FilePermission("<<ALL FILES>>", "read"));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    return permissionCollection;
                }
            };
        }
        if (!(string = file.getAbsolutePath()).endsWith(File.separator)) {
            string = string + File.separator;
        }
        this.unloadNatives(string);
        System.setProperty("org.lwjgl.librarypath", string + "natives");
        System.setProperty("net.java.games.input.librarypath", string + "natives");
        natives_loaded = true;
    }

    private void unloadNatives(String string) {
        if (!natives_loaded) {
            return;
        }
        try {
            Field field = ClassLoader.class.getDeclaredField("loadedLibraryNames");
            field.setAccessible(true);
            Vector vector = (Vector)field.get(this.getClass().getClassLoader());
            String string2 = new File(string).getCanonicalPath();
            for (int i = 0; i < vector.size(); ++i) {
                String string3 = (String)vector.get(i);
                if (!string3.startsWith(string2)) continue;
                vector.remove(i);
                --i;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Applet createApplet() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> clazz = classLoader.loadClass("net.minecraft.client.MinecraftApplet");
        return (Applet)clazz.newInstance();
    }

    protected void downloadJars(String string) throws Exception {
        int n;
        Object object;
        int n2;
        Object object2;
        File file = new File(string, "md5s");
        Properties properties = new Properties();
        if (file.exists()) {
            try {
                object2 = new FileInputStream(file);
                properties.load((InputStream)object2);
                ((FileInputStream)object2).close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.state = 4;
        int[] nArray = new int[this.urlList.length];
        boolean[] blArray = new boolean[this.urlList.length];
        for (n2 = 0; n2 < this.urlList.length; ++n2) {
            object2 = this.urlList[n2].openConnection();
            ((URLConnection)object2).setDefaultUseCaches(false);
            blArray[n2] = false;
            if (object2 instanceof HttpURLConnection) {
                ((HttpURLConnection)object2).setRequestMethod("HEAD");
                object = "\"" + properties.getProperty(this.getFileName(this.urlList[n2])) + "\"";
                if (!forceUpdate && object != null) {
                    ((URLConnection)object2).setRequestProperty("If-None-Match", (String)object);
                }
                if ((n = ((HttpURLConnection)object2).getResponseCode()) / 100 == 3) {
                    blArray[n2] = true;
                }
            }
            nArray[n2] = ((URLConnection)object2).getContentLength();
            this.totalSizeDownload += nArray[n2];
        }
        this.percentage = 10;
        n2 = 10;
        object = new byte[65536];
        for (n = 0; n < this.urlList.length; ++n) {
            if (blArray[n]) {
                this.percentage = n2 + nArray[n] * 45 / this.totalSizeDownload;
                continue;
            }
            try {
                properties.remove(this.getFileName(this.urlList[n]));
                properties.store(new FileOutputStream(file), "md5 hashes for downloaded files");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            int n3 = 0;
            int n4 = 3;
            boolean bl = true;
            while (bl) {
                int n5;
                bl = false;
                object2 = this.urlList[n].openConnection();
                String string2 = "";
                if (object2 instanceof HttpURLConnection) {
                    ((URLConnection)object2).setRequestProperty("Cache-Control", "no-cache");
                    ((URLConnection)object2).connect();
                    string2 = ((URLConnection)object2).getHeaderField("ETag");
                    string2 = string2.substring(1, string2.length() - 1);
                }
                String string3 = this.getFileName(this.urlList[n]);
                InputStream inputStream = this.getJarInputStream(string3, (URLConnection)object2);
                FileOutputStream fileOutputStream = new FileOutputStream(string + string3);
                long l = System.currentTimeMillis();
                int n6 = 0;
                int n7 = 0;
                String string4 = "";
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                while ((n5 = inputStream.read((byte[])object, 0, ((byte[])object).length)) != -1) {
                    fileOutputStream.write((byte[])object, 0, n5);
                    messageDigest.update((byte[])object, 0, n5);
                    this.currentSizeDownload += n5;
                    n7 += n5;
                    this.percentage = n2 + this.currentSizeDownload * 45 / this.totalSizeDownload;
                    this.subtaskMessage = "Retrieving: " + string3 + " " + this.currentSizeDownload * 100 / this.totalSizeDownload + "%";
                    n6 += n5;
                    long l2 = System.currentTimeMillis() - l;
                    if (l2 >= 1000L) {
                        float f = (float)n6 / (float)l2;
                        f = (float)((int)(f * 100.0f)) / 100.0f;
                        string4 = " @ " + f + " KB/sec";
                        n6 = 0;
                        l += 1000L;
                    }
                    this.subtaskMessage = this.subtaskMessage + string4;
                }
                inputStream.close();
                fileOutputStream.close();
                String string5 = new BigInteger(1, messageDigest.digest()).toString(16);
                while (string5.length() < 32) {
                    string5 = "0" + string5;
                }
                boolean bl2 = true;
                if (string2 != null) {
                    bl2 = string5.equals(string2);
                }
                if (!(object2 instanceof HttpURLConnection)) continue;
                if (bl2 && (n7 == nArray[n] || nArray[n] <= 0)) {
                    try {
                        properties.setProperty(this.getFileName(this.urlList[n]), string2);
                        properties.store(new FileOutputStream(file), "md5 hashes for downloaded files");
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    continue;
                }
                if (++n3 < n4) {
                    bl = true;
                    this.currentSizeDownload -= n7;
                    continue;
                }
                throw new Exception("failed to download " + string3);
            }
        }
        this.subtaskMessage = "";
    }

    protected InputStream getJarInputStream(String string, final URLConnection uRLConnection) throws Exception {
        final InputStream[] inputStreamArray = new InputStream[1];
        for (int i = 0; i < 3 && inputStreamArray[0] == null; ++i) {
            Thread thread = new Thread(){

                public void run() {
                    try {
                        inputStreamArray[0] = uRLConnection.getInputStream();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            };
            thread.setName("JarInputStreamThread");
            thread.start();
            int n = 0;
            while (inputStreamArray[0] == null && n++ < 5) {
                try {
                    thread.join(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (inputStreamArray[0] != null) continue;
            try {
                thread.interrupt();
                thread.join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (inputStreamArray[0] == null) {
            throw new Exception("Unable to download " + string);
        }
        return inputStreamArray[0];
    }

    protected void extractLZMA(String string, String string2) throws Exception {
        File file = new File(string);
        if (!file.exists()) {
            return;
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        Class<?> clazz = Class.forName("LZMA.LzmaInputStream");
        Constructor<?> constructor = clazz.getDeclaredConstructor(InputStream.class);
        InputStream inputStream = (InputStream)constructor.newInstance(fileInputStream);
        FileOutputStream fileOutputStream = new FileOutputStream(string2);
        byte[] byArray = new byte[16384];
        int n = inputStream.read(byArray);
        while (n >= 1) {
            ((OutputStream)fileOutputStream).write(byArray, 0, n);
            n = inputStream.read(byArray);
        }
        inputStream.close();
        ((OutputStream)fileOutputStream).close();
        fileOutputStream = null;
        inputStream = null;
        file.delete();
    }

    protected void extractPack(String string, String string2) throws Exception {
        File file = new File(string);
        if (!file.exists()) {
            return;
        }
        FileOutputStream fileOutputStream = new FileOutputStream(string2);
        JarOutputStream jarOutputStream = new JarOutputStream(fileOutputStream);
        Pack200.Unpacker unpacker = Pack200.newUnpacker();
        unpacker.unpack(file, jarOutputStream);
        jarOutputStream.close();
        file.delete();
    }

    protected void extractJars(String string) throws Exception {
        this.state = 5;
        float f = 10.0f / (float)this.urlList.length;
        for (int i = 0; i < this.urlList.length; ++i) {
            this.percentage = 55 + (int)(f * (float)(i + 1));
            String string2 = this.getFileName(this.urlList[i]);
            if (string2.endsWith(".pack.lzma")) {
                this.subtaskMessage = "Extracting: " + string2 + " to " + string2.replaceAll(".lzma", "");
                this.extractLZMA(string + string2, string + string2.replaceAll(".lzma", ""));
                this.subtaskMessage = "Extracting: " + string2.replaceAll(".lzma", "") + " to " + string2.replaceAll(".pack.lzma", "");
                this.extractPack(string + string2.replaceAll(".lzma", ""), string + string2.replaceAll(".pack.lzma", ""));
                continue;
            }
            if (string2.endsWith(".pack")) {
                this.subtaskMessage = "Extracting: " + string2 + " to " + string2.replace(".pack", "");
                this.extractPack(string + string2, string + string2.replace(".pack", ""));
                continue;
            }
            if (!string2.endsWith(".lzma")) continue;
            this.subtaskMessage = "Extracting: " + string2 + " to " + string2.replace(".lzma", "");
            this.extractLZMA(string + string2, string + string2.replace(".lzma", ""));
        }
    }

    protected void extractNatives(String string) throws Exception {
        Object object;
        Object object2;
        Serializable serializable;
        this.state = 5;
        int n = this.percentage;
        String string2 = this.getJarName(this.urlList[this.urlList.length - 1]);
        Certificate[] certificateArray = Launcher.class.getProtectionDomain().getCodeSource().getCertificates();
        if (certificateArray == null) {
            serializable = Launcher.class.getProtectionDomain().getCodeSource().getLocation();
            object2 = (JarURLConnection)new URL("jar:" + ((URL)serializable).toString() + "!/net/minecraft/Launcher.class").openConnection();
            ((URLConnection)object2).setDefaultUseCaches(true);
            try {
                certificateArray = ((JarURLConnection)object2).getCertificates();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!((File)(serializable = new File(string + "natives"))).exists()) {
            ((File)serializable).mkdir();
        }
        if (!((File)(object2 = new File(string + string2))).exists()) {
            return;
        }
        JarFile jarFile = new JarFile((File)object2, true);
        Enumeration<JarEntry> enumeration = jarFile.entries();
        this.totalSizeExtract = 0;
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (((ZipEntry)object).isDirectory() || ((ZipEntry)object).getName().indexOf(47) != -1) continue;
            this.totalSizeExtract = (int)((long)this.totalSizeExtract + ((ZipEntry)object).getSize());
        }
        this.currentSizeExtract = 0;
        enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            int n2;
            File file;
            object = enumeration.nextElement();
            if (((ZipEntry)object).isDirectory() || ((ZipEntry)object).getName().indexOf(47) != -1 || (file = new File(string + "natives" + File.separator + ((ZipEntry)object).getName())).exists() && !file.delete()) continue;
            InputStream inputStream = jarFile.getInputStream(jarFile.getEntry(((ZipEntry)object).getName()));
            FileOutputStream fileOutputStream = new FileOutputStream(string + "natives" + File.separator + ((ZipEntry)object).getName());
            byte[] byArray = new byte[65536];
            while ((n2 = inputStream.read(byArray, 0, byArray.length)) != -1) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n2);
                this.currentSizeExtract += n2;
                this.percentage = n + this.currentSizeExtract * 20 / this.totalSizeExtract;
                this.subtaskMessage = "Extracting: " + ((ZipEntry)object).getName() + " " + this.currentSizeExtract * 100 / this.totalSizeExtract + "%";
            }
            GameUpdater.validateCertificateChain(certificateArray, ((JarEntry)object).getCertificates());
            inputStream.close();
            ((OutputStream)fileOutputStream).close();
        }
        this.subtaskMessage = "";
        jarFile.close();
        object = new File(string + string2);
        ((File)object).delete();
    }

    protected static void validateCertificateChain(Certificate[] certificateArray, Certificate[] certificateArray2) throws Exception {
        if (certificateArray == null) {
            return;
        }
        if (certificateArray2 == null) {
            throw new Exception("Unable to validate certificate chain. Native entry did not have a certificate chain at all");
        }
        if (certificateArray.length != certificateArray2.length) {
            throw new Exception("Unable to validate certificate chain. Chain differs in length [" + certificateArray.length + " vs " + certificateArray2.length + "]");
        }
        for (int i = 0; i < certificateArray.length; ++i) {
            if (certificateArray[i].equals(certificateArray2[i])) continue;
            throw new Exception("Certificate mismatch: " + certificateArray[i] + " != " + certificateArray2[i]);
        }
    }

    protected String getJarName(URL uRL) {
        String string = uRL.getFile();
        if (string.contains("?")) {
            string = string.substring(0, string.indexOf("?"));
        }
        if (string.endsWith(".pack.lzma")) {
            string = string.replaceAll(".pack.lzma", "");
        } else if (string.endsWith(".pack")) {
            string = string.replaceAll(".pack", "");
        } else if (string.endsWith(".lzma")) {
            string = string.replaceAll(".lzma", "");
        }
        return string.substring(string.lastIndexOf(47) + 1);
    }

    protected String getFileName(URL uRL) {
        String string = uRL.getFile();
        if (string.contains("?")) {
            string = string.substring(0, string.indexOf("?"));
        }
        return string.substring(string.lastIndexOf(47) + 1);
    }

    protected void fatalErrorOccured(String string, Exception exception) {
        exception.printStackTrace();
        this.fatalError = true;
        this.fatalErrorDescription = "Fatal error occured (" + this.state + "): " + string;
        System.out.println(this.fatalErrorDescription);
        System.out.println(this.generateStacktrace(exception));
    }

    public boolean canPlayOffline() {
        try {
            String string;
            String string2 = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return Util.getWorkingDirectory() + File.separator + "bin" + File.separator;
                }
            });
            File file = new File(string2);
            if (!file.exists()) {
                return false;
            }
            if (!(file = new File(file, "version")).exists()) {
                return false;
            }
            if (file.exists() && (string = this.readVersionFile(file)) != null && string.length() > 0) {
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return false;
    }

    static {
        natives_loaded = false;
        forceUpdate = false;
    }
}

