%define _prefix	/usr
%define __libtoolize    /bin/true

Name:			MediaInfo_GUI
Version:		0.7.44
Release:		%mkrel 1
Summary:		Supplies technical and tag information about a video or audio file
Summary(de):		zeigt technische und zusätzliche Tag-Informationen über Video- und Audiodateien
Group:			Video
License:		GPL
URL:			http://mediainfo.sourceforge.net/
Source0:		%{name}_%{version}_GNU_FromSource.tar.bz2
Source1:		mediainfo-16.png
Source2:		mediainfo-32.png
Source3:		mediainfo-48.png
BuildRoot:		%{_tmppath}/%{name}-%{version}-%{release}-root
BuildRequires: 		gcc-c++
BuildRequires: 		zlib-devel
BuildRequires:		libzen-devel  >= 0.4.19
BuildRequires:		libmediainfo-devel >= 0.7.44
BuildRequires:		wxGTK2.8-devel
Obsoletes:		MediaInfo
Requires:  		glibc >= 2.10.1
Requires:   		libstdc++6 >= 4.4.1
Requires:		libzen0 >= 0.4.9
Requires:		libmediainfo0 >= 0.7.44
Obsoletes:		%name < %version

%description
MediaInfo supplies technical and tag information about a video or
audio file.
What information can I get from MediaInfo?
* General: title, author, director, album, track number, date, duration...
* Video: codec, aspect, fps, bitrate...
* Audio: codec, sample rate, channels, language, bitrate...
* Text: language of subtitle
* Chapters: number of chapters, list of chapters

What format (container) does MediaInfo support?
* Video: MKV, OGM, AVI, DivX, WMV, QuickTime, Real, MPEG-1,
  MPEG-2, MPEG-4, DVD (VOB) (Codecs: DivX, XviD, MSMPEG4, ASP,
  H.264, AVC...)
* Audio: OGG, MP3, WAV, RA, AC3, DTS, AAC, M4A, AU, AIFF
* Subtitles: SRT, SSA, ASS, SAMI


%description -l de
MediaInfo liefert technische und zusätzliche Tag-Informationen über Video- und Audiodateien.
Es ist freie Software (kostenlos und freier Zugriff auf den Quellcode unter GPL- oder LGPL-Lizenz)
Welche Informationen liefert MediaInfo?

    * Grundsätzliches: Titel, Autor, Regisseur, Album, Titelnummer, Datum, Spieldauer...
    * Video: Codec, Bildseitenverhältnis, Bildfrequenz, Bitrate...
    * Audio: Codec, Samplingrate, Kanäle, Sprache, Bitrate...
    * Text: Sprache der Untertitel
    * Kapitel: Anzahl der Kapitel, Kapitelübersicht

Welche Formate (Container) unterstützt MediaInfo?

    * Video: MKV, OGM, AVI, DivX, WMV, QuickTime, Real, MPEG-1, MPEG-2, MPEG-4, DVD (VOB)...
      (Codecs: DivX, XviD, MSMPEG4, ASP, H.264, AVC...)
    * Audio: OGG, MP3, WAV, RA, AC3, DTS, AAC, M4A, AU, AIFF...
    * Untertitel: SRT, SSA, ASS, SAMI...

%description -l be
MediaInfo дазваляе атрымліваць тэхнічныя дадзеныя і тэгі з відэа- або аўдыё- файлаў.
Гэта - бясплатнае праграмнае забеспячэнне (без усякай аплаты і з вольным доступам да зыходнага кода, ліцэнзіі GPL або LGPL)
Якую інфармацыю я магу атрымаць ад MediaInfo?

    * Асноўная : назва, аўтар, рэжысёр, альбом, нумар гукавой дарожкі, дата, працягласць...
    * Відэа : кодэк, суадносіны бакоў, частата кадраў, бітрэйт...
    * Аўдыё : кодэк, каналы, мова, бітрэйт...
    * Тэкст : мова субтытраў
    * Часткі : колькасць частак, спіс частак

Якія фарматы (кантэйнеры) падтрымлівае MediaInfo?

    * Відэа : MKV, OGM, AVI, DivX, WMV, QuickTime, Real, MPEG-1, MPEG-2, MPEG-4, DVD (VOB)...
      (Кодэкі: DivX, XviD, MSMPEG4, ASP, H.264, AVC...)
    * Аўдыё : OGG, MP3, WAV, RA, AC3, DTS, AAC, M4A, AU, AIFF...
    * Субтытры: SRT, SSA, ASS, SAMI...


%description -l bg
MediaInfo предоставя подробна техническа информация и инфромазия за таговете на даден видео или аудио файл.
Програмата е с безплатен лиценз (без такси и със свободен достъп до сорс кода: GPL или LGPL лиценз)
Каква информация можете да получите чрез MediaInfo?

    * Обща: заглавие, автор, продуцент, албум, номер на песента, дата, продължителност...
    * Видео: кодек, мащаб, кадри в секунда, bitrate...
    * Аудио: кодек, честота, канали, език, bitrate...
    * Текст: език на субтитрите
    * Глави: брой глави в DVD филм, списък на главите

Какви формати поддържа MediaInfo?

    * Видео: MKV, OGM, AVI, DivX, WMV, QuickTime, Real, MPEG-1, MPEG-2, MPEG-4, DVD (VOB)...
      (Кодеци: DivX, XviD, MSMPEG4, ASP, H.264, AVC...)
    * Аудио: OGG, MP3, WAV, RA, AC3, DTS, AAC, M4A, AU, AIFF...
    * Субтитри: SRT, SSA, ASS, SAMI...


%description -l ca
MediaInfo us proporciona informació tècnica quant als vostres arxius de vídeo i àudio.
És una aplicació de codi lliure (gratuïta i accessible al codi font).
Quina informació es pot obtenir mitjançant MediaInfo?

    * General: títol, autor, director, àlbum, nombre de pista, data, duració...
    * Vídeo: còdec, aspecte, imatges per segon, ràtio...
    * Àudio: còdec, freqüència de mostratge, canals, idioma, ràtio...
    * Informació estesa: idioma dels subtítols
    * Capítols: nombre i llistat de capítols

Quins formats (contenidor) suporta MediaInfo?

    * Vídeo: MKV, OGM, AVI, DivX, WMV, QuickTime, Real, MPEG-1, MPEG-2, MPEG-4, DVD (VOB)...
      (Codecs: DivX, XviD, MSMPEG4, ASP, H.264, AVC...)
    * Àudio: OGG, MP3, WAV, RA, AC3, DTS, AAC, M4A, AU, AIFF...
    * Subtítols: SRT, SSA, ASS, SAMI...


%description -l es
MediaInfo provee información técnica y de la etiqueta sobre un archivo video o audio.
Éste es un software libre (gratuito y de libre acceso al código fuente: GPL o licencia LGPL)
¿Qué información puedo obtener con MediaInfo?

    * General: título, autor, director, álbum, número de pista, fecha, duración...
    * Video: códec, aspecto, fps, bitrate...
    * Audio: códec, frecuencia de muestreo, canales, lenguaje, bitrate...
    * Texto: idioma de subtítulo
    * Capítulos: número de capítulos, lista de capítulos

¿Qué formatos soporta MediaInfo?

    * Video: MKV, OGM, AVI, DivX, WMV, QuickTime, Real, MPEG-1, MPEG-2, MPEG-4, DVD (VOB)...
      (Códecs: DivX, XviD, MSMPEG4, ASP, H.264, AVC...)
    * Audio: OGG, MP3, WAV, RA, AC3, DTS, AAC, M4A, AU, AIFF...
    * Subtítulos: SRT, SSA, ASS, SAMI...


%description -l fa
مديا اينفو تمام مشخصات فایلهای ویدیویی و صوتی را نمایش می دهد.
این نرم افزار رایگان است (GPL یا LGPL لیسانس)
چه اطلاعاتی مدیا اینفو به من می دهد?

    * در اصل: عنوان, نویسنده یا خواننده, هدایتگر, آلبوم, شماره آهنگ, تاربخ, مدت فایل و غیره
    * ویدیو: کدک, نمود, اف پی اس, بیت ریت و غیره
    * صوت: کدک, میزان نمونه, کانال, زبان, بیت ریت و غیره
    * متن: زبان و زیرنویس
    * کپچرز: تعداد کپچرز, لیست کپچرز

مدیا اینفو چه فرمت هایی را پشتیبانی می کند?

    * ویدیو: MKV, OGM, AVI, DivX, WMV, QuickTime, Real, MPEG-1, MPEG-2, MPEG-4, DVD (VOB)...
      (کدکها: DivX, XviD, MSMPEG4, ASP, H.264, AVC...)
    * صوت: OGG, MP3, WAV, RA, AC3, DTS, AAC, M4A, AU, AIFF...
    * زیرنویس: SRT, SSA, ASS, SAMI...


%description -l fr
MediaInfo fournit des informations techniques et les tags à propos de vos fichiers video et audio.
C'est un logiciel "libre" (libre de ne rien payer, et libre accès au code source, licence GPL ou LGPL)
Quelles informations puis-je avoir avec MediaInfo?

    * General : titre, auteur, réalisateur, album, numéro de piste, date, durée...
    * Video : codec, forme, images/s, débit...
    * Audio : codec, Fréquence, nombre de cannaux, langue, débit...
    * Texte : codec, langue des sous-titres
    * Chapitres : nombre de chapitres, liste des chapitres

Quels formats (conteneur) MediaInfo sait-il lire?

    * Video : MKV, OGM, AVI, DivX, WMV, QuickTime, Real, MPEG-1, MPEG-2, MPEG-4, DVD (VOB)...
      (Codecs : DivX, XviD, MSMPEG4, ASP, H.264, AVC...)
    * Audio : OGG, MP3, WAV, RA, AC3, DTS, AAC, M4A, AU, AIFF...
    * Sous-titres : SRT, SSA, ASS, SAMI...


%description -l hr
Što je to MediaInfo?
MediaInfo je program koji korisnika opskrbljuje tehničkim i tagovnim informacijama o nekoj video- ili audio-datoteci.
Radi se o slobodnom softveru (slobodan plaćanja i slobodan u pristupu izvorskom kôdu sukladno GPL ili LGPL dopuštenjima)
Koje informacije mogu dobiti pomoću MediaInfo?

    * Općenito: naslov, autor, redatelj, album, redni broj snimka, nadnevak, trajanje...
    * Video: kôdek, razmjere, fps, tempo protoka...
    * Audio: kôdek, učestalost uzorkovanja, kanali, jezik, tempo protoka...
    * Tekst: jezik prijevoda podnaslova
    * Poglavlja: broj poglavlja, spisak poglavlja

Koje oblike datoteka (spremnika) podržava MediaInfo?

    * Video: MKV, OGM, AVI, DivX, WMV, QuickTime, Real, MPEG-1, MPEG-2, MPEG-4, DVD (VOB)...
      (Kôdeki: DivX, XviD, MSMPEG4, ASP, H.264, AVC...)
    * Audio: OGG, MP3, WAV, RA, AC3, DTS, AAC, M4A, AU, AIFF...
    * Podnaslovi: SRT, SSA, ASS, SAMI...


%description -l hu
A MediaInfo műszaki és jelölési (tag) adatokat szolgáltat mozgókép- és hangfájlokról.
A program szabad szoftver (ingyenes, forráskódja szabadon elérhető GPL vagy LGPL engedéllyel).
Milyen adatokat szolgáltat a MediaInfo?

    * Általános: cím, szerző, rendező, album, sáv szám, dátum, hossz...
    * Mozgókép: kódek, képarány, képsebesség, adatsebesség...
    * Hang: kódek, mintavételezési gyakoriság, csatornák, nyelv, adatsebesség...
    * Szöveg: a feliratozás nyelve
    * Fejezet: fejezetek száma, fejezetek listája

Milyen formátumokat (gyűjtőket) ismer a MediaInfo?

    * Mozgókép: MKV, OGM, AVI, DivX, WMV, QuickTime, Real, MPEG-1, MPEG-2, MPEG-4, DVD (VOB)...
      (Kódekek: DivX, XviD, MSMPEG4, ASP, H.264, AVC...)
    * Hang: OGG, MP3, WAV, RA, AC3, DTS, AAC, M4A, AU, AIFF...
    * Felirat: SRT, SSA, ASS, SAMI...


%description -l id
MediaInfo memberikan informasi teknikal dan data mengenai berkas video dan audio.
MediaInfo adalah software yang gratis dan bebas untuk dimodifikasi (Anda bisa mengakses kode sumber berlisensi GPL maupun LGPL)
Indormasi apa saja yang bisa saya dapat dari MediaInfo?

    * Umum : Judul, pembuat, direktor, album, nomor trek, tanggal, durasi...
    * Video: codec, aspect, fps, bitrate...
    * Audio: codec, sample rate, channels, language, bitrate...
    * Subtitel: Bahasa dari subtitel
    * Bab (chapter): Nama chapter, nomor chapter

Format apa saja yang didukung MediaInfo

    * Video: MKV, OGM, AVI, DivX, WMV, QuickTime, Real, MPEG-1, MPEG-2, MPEG-4, DVD (VOB)...
      (Codecs: DivX, XviD, MSMPEG4, ASP, H.264, AVC...)
    * Audio: OGG, MP3, WAV, RA, AC3, DTS, AAC, M4A, AU, AIFF...
    * Subtitel:: SRT, SSA, ASS, SAMI...


%description -l it
MediaInfo da informazioni tecniche su file video o audio.
E' un programma gratuito (non necessita pagamento ed è possibile accedere al codice sorgente gratuitamente, licenza GPL o LGPL)
Quali informazioni posso ottenere con MediaInfo?

    * Generali : titolo, autore, regista, album, numero della traccia, data, durata...
    * Video : codec, aspect ratio, fps, bitrate...
    * Audio : codec, sample rate, canali, lingua, bitrate...
    * Sottotitoli : lingua del sottotitolo
    * Capitoli : numero dei capitoli, lista dei capitoli

Che tipo di formato (contenitore) è supportato da MediaInfo?

    * Video : MKV, OGM, AVI, DivX, WMV, QuickTime, Real, MPEG-1, MPEG-2, MPEG-4, DVD (VOB)...
      (Codec: DivX, XviD, MSMPEG4, ASP, H.264, AVC...)
    * Audio: OGG, MP3, WAV, RA, AC3, DTS, AAC, M4A, AU, AIFF...
    * Sottotitoli: SRT, SSA, ASS, SAMI...


%description -l ja
MediaInfo はビデオ、オーディオ ファイルが使用するコーデックについてのタグ及び技術的な詳細情報を調査し見易くフレンドリーな形式でイクスポートできるツールです
MediaInfo はフリーです ( 無料で使用できて 自由にソースコードへアクセスできることを意味します: 適用ライセンスは GPL 及び LGPL です )
MediaInfo で調査できる情報は？

    * 全般情報: タイトル, 製作者, ディレクター, アルバム, トラック番号, 日付, プレイ時間...
    * ビデオ: コーデック, 解像度, fps, ビットレート...
    * オーディオ: コーデック, サンプル レート, チャンネル, 言語, ビット レート...
    * テキスト: 字幕の言語
    * チャプター: チャプター番号、チャプターリスト

MediaInfo がサポートするフォーマット（コンテナ）は？

    * ビデオ: MKV, OGM, AVI, DivX, WMV, QuickTime, Real, MPEG-1, MPEG-2, MPEG-4, DVD (VOB)...
      (Codecs: DivX, XviD, MSMPEG4, ASP, H.264, AVC...)
    * オーディオ: OGG, MP3, WAV, RA, AC3, DTS, AAC, M4A, AU, AIFF...
    * 字幕: SRT, SSA, ASS, SAMI...


%description -l ko
MediaInfo는 비디오나 오디오 파일에 대한 태그 정보와 기술 정보를 제공해주는 무료 소프트웨어입니다.
(공개 소프트웨어: GPL 또는 LGPL 라이센스)

MediaInfo에서 어떤 정보를 얻을 수 있나요?

    * 일반: 제목, 작가, 디렉터, 앨범, 트랙 개수, 날짜, 재생 시간...
    * 비디오: 코덱, 종횡비, fps, 비트레이트...
    * 오디오: 코덱, 샘플레이트, 채널, 언어, 비트레이트...
    * 텍스트: 자막의 언어
    * 챕터: 챕터 개수, 챕터 리스트

MediaInfo는 어떤 포맷(컨테이너)을 지원하나요?

    * 비디오: MKV, OGM, AVI, DivX, WMV, 퀵타임, 리얼, MPEG-1, MPEG-2, MPEG-4, DVD (VOB)...
      (코덱: DivX, XviD, MSMPEG4, ASP, H.264, AVC...)
    * 오디오: OGG, MP3, WAV, RA, AC3, DTS, AAC, M4A, AU, AIFF...
    * 자막: SRT, SSA, ASS, SAMI...


%description -l lt
MediaInfo teikia techninę ir papildomą informaciją apie video arba audio failus.
Tai yra laisva programinė įranga (nemokama ir su leidimu prieiti prie programos pirminio teksto: GPL arba LGPL licencija)
Kokią informaciją aš gausiu iš MediaInfo?

    * Bendra: antraštė, autorius, direktorius, albumas, takelio numeris, data, trukmė....
    * Video: kodekas, aspektas, kps, bitreitas...
    * Audio: kodekas, atrankos tempą, kanalai, kalba, bitreitas...
    * Tekstas: subtitrų kalba
    * Skyrius: skyrių skaičius, skyrių sąrašas

Kokį formatą (talpyklą) palaiko MediaInfo?

    * Video: MKV, OGM, AVI, DivX, WMV, QuickTime, Real, MPEG-1, MPEG-2, MPEG-4, DVD (VOB)...
      (Kodekai: DivX, XviD, MSMPEG4, ASP, H.264, AVC...)
    * Audio: OGG, MP3, WAV, RA, AC3, DTS, AAC, M4A, AU, AIFF...
    * Subtitrai: SRT, SSA, ASS, SAMI...


%description -l nl
MediaInfo levert technische en tag-informatie over een video- of audiobestand.
Dit is gratis software (gratis gebruik en gratis toegang tot broncode, GPL of LGPL licentie)
Wat voor informatie kan ik van MediaInfo krijgen?

    * Algemeen: titel, auteur, regisseur, album, tracknummer, datum, tijdsduur...
    * Video: codec, aspect, fps, bitrate...
    * Audio: codec, samplerate, kanalen, taal, bitrate...
    * Tekst: taal van ondertiteling
    * Hoofdstukken: telling van hoofdstukken, lijst van hoofstukken

Welk formaat (container) wordt door MediaInfo ondersteund?

    * Video: MKV, OGM, AVI, DivX, WMV, QuickTime, Real, MPEG-1, MPEG-2, MPEG-4, DVD (VOB)...
      (Codecs: DivX, XviD, MSMPEG4, ASP, H.264, AVC...)
    * Audio: OGG, MP3, WAV, RA, AC3, DTS, AAC, M4A, AU, AIFF...
    * Ondertiteling: SRT, SSA, ASS, SAMI...


%description -l pl
MediaInfo dostarcza informacji technicznych i pochodzących ze znaczników o plikach audio i wideo.
Jest programem darmowym (bezpłatnym i z otwartym kodem źródłowym na licencji GPL lub LGPL)
Czego można się dowiedzieć z pomocą MediaInfo?

    * Ogólne: tytuł, autor, reżyser, album, numer nagrania, data, czas trwania...
    * Wideo: kodek, proporcje obrazu, ilość klatek na sekundę, przypływność bitów...
    * Audio: kodek, częstotliwość próbkowania, liczba kanałów, język, przypływność bitów...
    * Tekst: język napisów
    * Rozdziały: liczba rozdziałów, lista rozdziałów

Jakie formaty (zawartość) obsługuje MediaInfo?

    * Wideo: MKV, OGM, AVI, DivX, WMV, QuickTime, Real, MPEG-1, MPEG-2, MPEG-4, DVD (VOB)...
      (kodeki: DivX, XviD, MSMPEG4, ASP, H.264, AVC...)
    * Audio: OGG, MP3, WAV, RA, AC3, DTS, AAC, M4A, AU, AIFF...
    * Napisy: SRT, SSA, ASS, SAMI...


%description -l pt
O MediaInfo fornece informação técnica e de etiqueta sobre um arquivo de vídeo ou áudio.
Este programa é gratuito (livre de custo e de acesso ao código fonte: licença GPL ou LGPL)
Que tipo de informação eu consigo com o MediaInfo?

    * Geral: título, autor, diretor, álbum, número da faixa, data, duração...
    * Vídeo: codec, resolução, fps, taxa de bits...
    * Áudio: codec, taxa de amostragem, canais, idioma, taxa de bits...
    * Texto: idioma da legenda
    * Capítulos: número de capítulos, lista de capítulos

Quais formatos (container) o MediaInfo suporta?

    * Vídeo: MKV, OGM, AVI, DivX, WMV, QuickTime, Real, MPEG-1, MPEG-2, MPEG-4, DVD (VOB)...
      (Codecs: DivX, XviD, MSMPEG4, ASP, H.264, AVC...)
    * Áudio: OGG, MP3, WAV, RA, AC3, DTS, AAC, M4A, AU, AIFF...
    * Legendas: SRT, SSA, ASS, SAMI...


%description -l pt-BR
O MediaInfo proporciona informações técnicas e informações sobre tags de seus arquivos de áudio ou vídeo..
Esse programa grátis (livre de cobrança e de código fonte livre: licença GPL ou LGPL)
Quais informações eu consigo usando o MediaInfo?

    * Geral: título, autor, diretor, álbum, número da faixa, data, duração...
    * Vídeo: codec, aspécto, fps (quadros por segundo), taxa de bits...
    * Áudio: codec, taxa de amostragem, canais, idioma, taxa de bits...
    * Texto: idioma da legenda
    * Chapters: number of chapters, list of chapters

Quais formatos (containers) o MediaInfo suporta?

    * Vídeo: MKV, OGM, AVI, DivX, WMV, QuickTime, Real, MPEG-1, MPEG-2, MPEG-4, DVD (VOB)...
      (Codecs: DivX, XviD, MSMPEG4, ASP, H.264, AVC...)
    * Áudio: OGG, MP3, WAV, RA, AC3, DTS, AAC, M4A, AU, AIFF...
    * Legendas: SRT, SSA, ASS, SAMI...



%description -l ru
MediaInfo позволяет получать техническую информацию из видео- или аудио- файлов.
Это - свободное программное обеспечение (распространяется бесплатно и с исходным кодом, доступным по лицензии GPL или LGPL)
Какую информацию я могу получить с помощью MediaInfo?

    * Основная: название, автор, режиссер, альбом, номер звуковой дорожки, дата, продолжительность...
    * Видео: кодек, отношение сторон, частота кадров, скорость потока...
    * Аудио: кодек, каналы, язык, скорость потока...
    * Текст: язык субтитров
    * Части: количество частей, список частей

Какие форматы (контейнеры) поддерживает MediaInfo?

    * Видео: MKV, OGM, AVI, DivX, WMV, QuickTime, Real, MPEG-1, MPEG-2, MPEG-4, DVD (VOB)...
      (Кодеки: DivX, XviD, MSMPEG4, ASP, H.264, AVC...)
    * Аудио: OGG, MP3, WAV, RA, AC3, DTS, AAC, M4A, AU, AIFF...
    * Субтитры: SRT, SSA, ASS, SAMI...


%description -l sq
MediaInfo paraqet informacione teknike dhe etiketuese për skedat filmike e zanore.
Ky softuer jepet falas (pa pagesë dhe me akses të lirë në kodin burimor: licenca GPL ose LGPL)
Ç'informacione mund të marr nga MediaInfo?

    * Kryesore: titulli, autori, regjisori, albumi, numri i kolonës, data, kohëzgjatja...
    * Video: kodeku, aspekti, fps, raporti i bitit...
    * Audio: kodeku, raporti i shëmbëllimit, kanale, gjuha, raporti i bitit...
    * Tekst: gjuha e titrave
    * Kapituj: numri i kapitujve, lista e kapitujve

Ç'formate (mbajtës) përkrah MediaInfo?

    * Video: MKV, OGM, AVI, DivX, WMV, QuickTime, Real, MPEG-1, MPEG-2, MPEG-4, DVD (VOB)...
      (Kodekë: DivX, XviD, MSMPEG4, ASP, H.264, AVC...)
    * Audio: OGG, MP3, WAV, RA, AC3, DTS, AAC, M4A, AU, AIFF...
    * Titra: SRT, SSA, ASS, SAMI...


%description -l sv
MediaInfo tillhandahåller teknisk information om video och ljudfiler.
Detta är ett gratis program (gratis att användas och gratis att använda källkoden, GPL eller LGPL licens)
Vilken information kan jag få från MediaInfo?

    * Allmäna: titel, författare, regissör, album, spår-nummer, datum, längd...
    * Video: codec, aspect, fps, bitrate...
    * Ljud: codec, samplingshastighet, kanaler, språk, bitrate...
    * Text: språk på undertexten
    * Kapitel: antal kapitel, kapitellista

Vilka format stödjer MediaInfo?

    * Video: MKV, OGM, AVI, DivX, WMV, QuickTime, Real, MPEG-1, MPEG-2, MPEG-4, DVD (VOB)...
      (Codecs: DivX, XviD, MSMPEG4, ASP, H.264, AVC...)
    * Ljud: OGG, MP3, WAV, RA, AC3, DTS, AAC, M4A, AU, AIFF...
    * Undertexter: SRT, SSA, ASS, SAMI...



%description -l th
MediaInfo เป็นโปรแกรมที่ใช้แสดงข้อมูลด้านเทคนิคและข้อมูล tag ของไฟล์วีดีโอและไฟล์เสียง
นี่เป็นโปรแกรมฟรี ฟรีทั้งราคาและฟรีสำหรับการเข้าถึงซอร์สโค้ด: GPL หรือ LGPL licence)
ข้อมูลอะไรที่ฉันจะได้จาก MediaInfo?

    * ทั่วไป: ชื่อเพลงหรือชื่อเรื่อง, ผู้เขียน, director, อัลบัม, เลขที่แทร็ค, วันที่, ระยะเวลา...
    * วีดีโอ: codec, aspect, fps, บิตเรต...
    * เสียง: codec, แซมเปิลเรต, ช่องสัญญาณ, ภาษา, บิตเรต...
    * ข้อความ: ภาษาของคำบรรยาย
    * เชปเตอร์: เลขที่เชปเตอร์, รายการของเชปเตอร์

รูปแบบ (container) อะไรบ้างที่ MediaInfo สนับสนุน?

    * วีดีโอ: MKV, OGM, AVI, DivX, WMV, QuickTime, Real, MPEG-1, MPEG-2, MPEG-4, DVD (VOB)...
      (Codecs: DivX, XviD, MSMPEG4, ASP, H.264, AVC...)
    * เสียง: OGG, MP3, WAV, RA, AC3, DTS, AAC, M4A, AU, AIFF...
    * คำบรรยาย: SRT, SSA, ASS, SAMI...


%description -l uk
MediaInfo дозволяє отримувати технічну та тегову інформацію з ваших відео і аудіо файлів.
Це є вільне програмне забезпечення (безкоштовний та вільний доступ до вихідного коду: GPL або LGPL ліцензії)
Яку інформацію я можу отримати за допомогою MediaInfo?

    * Основна: назва, автор, режисер, альбом, номер звукової дорожки, дата, тривалість...
    * Відео: кодек, співвідношення сторін, частота кадрів, швидкість потоку...
    * Аудіо: кодек, частота дискретизації, канали, мову, швидкість потоку...
    * Текст: мова субтитрів
    * Частини: намерація частин, список частин

Які формати (контейнери) підтримує MediaInfo?

    * Відео: MKV, OGM, AVI, DivX, WMV, QuickTime, Real, MPEG-1, MPEG-2, MPEG-4, DVD (VOB)...
      (Кодеки: DivX, XviD, MSMPEG4, ASP, H.264, AVC...)
    * Аудіо: OGG, MP3, WAV, RA, AC3, DTS, AAC, M4A, AU, AIFF...
    * Субтитри: SRT, SSA, ASS, SAMI...


%description -l zh-CN
MediaInfo 用来分析视频和音频文件的编码和内容信息。
MediaInfo 是自由软件 (免费使用、免费获得源代码，许可协议：GNU GPL/LGPL)
使用MediaInfo可以获得多媒体文件的哪些信息?

    * 内容信息：标题，作者，专辑名，音轨号，日期，总时间……
    * 视频：编码器，长宽比，帧频率，比特率……
    * 音频：编码器，采样率，声道数，语言，比特率……
    * 文本：语言和字幕
    * 段落：段落数，列表

MediaInfo支持哪些文件格式?

    * 视频：MKV, OGM, AVI, DivX, WMV, QuickTime, Real, MPEG-1, MPEG-2, MPEG-4, DVD (VOB)...
      (编码器：DivX, XviD, MSMPEG4, ASP, H.264, AVC...)
    * 音频：OGG, MP3, WAV, RA, AC3, DTS, AAC, M4A, AU, AIFF...
    * 字幕：SRT, SSA, ASS, SAMI...


%description -l zh-TW
MediaInfo 提供影音檔案有關技術上與標籤的資訊.
這是自由軟體 (無須花費, 且也可以自由存取原始碼, 為 GPL 或 LGPL 授權)
我能從 MediaInfo 獲得哪些資訊?

    * 一般: 標題, 作者, 導演, 專輯, 曲目, 日期, 播放長度...
    * 視訊: 編解碼器 (CODECs), 畫面比例, 每秒影格數, 流量...
    * 音訊: 編解碼器, 取樣率, 聲道數, 語言, 流量...
    * 文字: 字幕語言
    * 章節: 章節總數, 章節列表

MediaInfo 支援哪些 (容器) 格式?

    * 視訊: MKV, OGM, AVI, DivX, WMV, QuickTime, Real, MPEG-1, MPEG-2, MPEG-4, DVD (VOB)...
      (編碼內容: DivX, XviD, MSMPEG4, ASP, H.264, AVC...)
    * 音訊: OGG, MP3, WAV, RA, AC3, DTS, AAC, M4A, AU, AIFF...
    * 字幕: SRT, SSA, ASS, SAMI...


%prep
%setup -q -n %{name}_GNU_FromSource

%__sed -i 's/\r//g' MediaInfoLib/License.html MediaInfoLib/*.txt
%__sed -i 's/\r//g' MediaInfoLib/*.txt

%__sed -i -e 's|/usr/lib/libz.a|%{_libdir}/libz.a|g' \
	MediaInfoLib/Project/GNU/Library/configure

%build
export CFLAGS="$RPM_OPT_FLAGS"
export CXXFLAGS="$RPM_OPT_FLAGS"

./GUI_Compile.sh \
	--program-prefix=%{?_program_prefix} \
	--prefix=%{_prefix} \
	--exec-prefix=%{_exec_prefix} \
	--bindir=%{_bindir} \
	--sbindir=%{_sbindir} \
	--sysconfdir=%{_sysconfdir} \
	--datadir=%{_datadir} \
	--includedir=%{_includedir} \
	--libdir=%{_libdir} \
	--libexecdir=%{_libexecdir} \
	--localstatedir=%{_localstatedir} \
	--sharedstatedir=%{_sharedstatedir} \
	--mandir=%{_mandir} \
	--infodir=%{_infodir} \
	--disable-maintainer

%install
pushd MediaInfo/Project/GNU/GUI
	%makeinstall
popd

#Desktop entry
mkdir -p %{buildroot}%{_datadir}/applications
%__cat > %{buildroot}%{_datadir}/applications/%{name}.desktop << EOF
[Desktop Entry]
Encoding=UTF-8
Name=MediaInfo
Comment=Media Analyzer
Exec=mediainfo-gui
Icon=mediainfo.png
Terminal=false 
Type=Application
StartupNotify=true
Categories=AudioVideo;X-MandrivaLinux-Multimedia-Video;X-MandrivaLinux-Multimedia-Sound
ServiceTypes=audio/*,video/*,image/*,application/x-flash-video
EOF

# install and resize icons
mkdir -p %buildroot{%_iconsdir,%_liconsdir,%_miconsdir}
install -m 0644 %{SOURCE1} %{buildroot}%_miconsdir/mediainfo.png
install -m 0644 %{SOURCE2} %{buildroot}%_iconsdir/mediainfo.png
install -m 0644 %{SOURCE3} %{buildroot}%_iconsdir/mediainfo.png


%clean
[ -d "%{buildroot}" -a "%{buildroot}" != "" ] && %__rm -rf "%{buildroot}"

%files
%defattr(-,root,root,-)
%doc MediaInfo/Release/ReadMe_GUI_Linux.txt
%doc MediaInfoLib/License.html MediaInfoLib/*.txt
%{_bindir}/mediainfo-gui
%{_datadir}/applications/%{name}.desktop
%_miconsdir/mediainfo.png
%_iconsdir/mediainfo.png
%_iconsdir/mediainfo.png

%changelog
* Wed Jan 06 2010 leiche <MeissSW01 at aol.com> 0.7.44-1pclos2010
- 0.7.44

* Wed Dec 23 2009 Leiche <MeissSW01 at aol.com> 0.7.26-1pclos2010
- 0.7.26

* Fri Nov 13 2009 Leiche <MeissSW01 at aol.com> 0.7.25-1pclos2010
- 0.7.25
- change menu entries (tex)

* Mon Oct 26 2009 Leiche <MeissSW01 at aol.com> 0.7.23-1pclos2010
- 0.7.23
- add additional synaptic decription translations 

* Mon Sep 28 2009 Leiche <MeissSW01 at aol.com> 0.7.22-1pclos2009
- 0.7.22
- add german synaptic decription translation

* Fri Sep 11 2009 slick50 <lxgator@gmail.com> 0.7.21-1pclos2009
- 0.7.21

* Sun Jun 01 2009 Texstar <texstar@gmail.com> 0.7.12-1pclos2009
- create package


