/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.ant;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ant.AbstractArtifactWithRepositoryTask;
import org.apache.maven.artifact.ant.AntResolutionListener;
import org.apache.maven.artifact.ant.Pom;
import org.apache.maven.artifact.ant.SpecificScopesArtifactFilter;
import org.apache.maven.artifact.ant.TypesArtifactFilter;
import org.apache.maven.artifact.ant.shaded.FileUtils;
import org.apache.maven.artifact.ant.shaded.StringUtils;
import org.apache.maven.artifact.ant.util.AntBuildWriter;
import org.apache.maven.artifact.ant.util.AntTaskModified;
import org.apache.maven.artifact.ant.util.AntUtil;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.project.artifact.MavenMetadataSource;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependenciesTask
extends AbstractArtifactWithRepositoryTask {
    private static final String[] SCOPES = new String[]{"compile", "provided", "runtime", "test", "system"};
    private static final Set<String> SCOPES_SET = new HashSet<String>(Arrays.asList(SCOPES));
    public static final String DEFAULT_ANT_BUILD_FILE = "target/build-dependencies.xml";
    private List<Dependency> dependencies = new ArrayList<Dependency>();
    private String pathId;
    private String filesetId;
    private String sourcesFilesetId;
    private String javadocFilesetId;
    private String versionsId;
    private String useScope;
    private String scopes;
    private String type;
    private String pathType;
    private String dependencyRefsBuildFile;
    private boolean cacheDependencyRefs;

    @Override
    protected void doExecute() {
        if (this.useScope != null && this.scopes != null) {
            throw new BuildException("You cannot specify both useScope and scopes in the dependencies task.");
        }
        if (this.getPom() != null && !this.dependencies.isEmpty()) {
            throw new BuildException("You cannot specify both dependencies and a pom in the dependencies task");
        }
        if (this.isCacheDependencyRefs()) {
            if (this.getDependencyRefsBuildFile() == null) {
                this.setDependencyRefsBuildFile(DEFAULT_ANT_BUILD_FILE);
            }
            if (this.checkCachedDependencies()) {
                this.log("Dependency refs loaded from file: " + this.getDependencyRefsBuildFile(), 3);
                return;
            }
        }
        this.doExecuteResolution();
    }

    protected ArtifactResolutionResult doExecuteResolution() {
        ArtifactResolutionResult result;
        ArtifactRepository localRepo = this.createLocalArtifactRepository();
        this.log("Using local repository: " + localRepo.getBasedir(), 3);
        ArtifactResolver resolver = (ArtifactResolver)this.lookup(ArtifactResolver.ROLE);
        ArtifactFactory artifactFactory = (ArtifactFactory)this.lookup(ArtifactFactory.ROLE);
        MavenMetadataSource metadataSource = (MavenMetadataSource)this.lookup(ArtifactMetadataSource.ROLE);
        Pom pom = this.initializePom(localRepo);
        if (pom != null) {
            this.dependencies = pom.getDependencies();
        } else {
            pom = this.createDummyPom(localRepo);
        }
        if (this.dependencies.isEmpty()) {
            this.log("There were no dependencies specified", 1);
        } else {
            for (Dependency dependency : this.dependencies) {
                String scope = dependency.getScope();
                if ("system".equals(scope)) {
                    if (!StringUtils.isBlank(dependency.getSystemPath())) continue;
                    throw new BuildException(dependency.toString() + " is defined with scope='system': systemPath attribute is required.");
                }
                if (scope == null || SCOPES_SET.contains(scope)) continue;
                this.log("Unknown scope='" + scope + "' for " + dependency + ", supported scopes are: " + SCOPES_SET, 1);
            }
        }
        this.log("Resolving dependencies...", 3);
        List<ArtifactRepository> remoteArtifactRepositories = this.createRemoteArtifactRepositories(pom.getRepositories());
        try {
            Set artifacts = MavenMetadataSource.createArtifacts(artifactFactory, this.dependencies, null, null, null);
            Artifact pomArtifact = artifactFactory.createBuildArtifact(pom.getGroupId(), pom.getArtifactId(), pom.getVersion(), pom.getPackaging());
            List<AntResolutionListener> listeners = Collections.singletonList(new AntResolutionListener(this.getProject()));
            Map managedDependencies = pom.getMavenProject().getManagedVersionMap();
            ArtifactFilter filter = null;
            if (this.useScope != null) {
                filter = new ScopeArtifactFilter(this.useScope);
            }
            if (this.scopes != null) {
                filter = new SpecificScopesArtifactFilter(this.scopes);
            }
            if (this.type != null) {
                TypesArtifactFilter typeArtifactFilter = new TypesArtifactFilter(this.type);
                if (filter != null) {
                    AndArtifactFilter andFilter = new AndArtifactFilter();
                    andFilter.add(filter);
                    andFilter.add(typeArtifactFilter);
                    filter = andFilter;
                } else {
                    filter = typeArtifactFilter;
                }
            }
            result = resolver.resolveTransitively(artifacts, pomArtifact, managedDependencies, localRepo, remoteArtifactRepositories, metadataSource, filter, listeners);
        }
        catch (ArtifactResolutionException e) {
            throw new BuildException("Unable to resolve artifact: " + e.getMessage(), (Throwable)e);
        }
        catch (ArtifactNotFoundException e) {
            throw new BuildException("Dependency not found: " + e.getMessage(), (Throwable)e);
        }
        catch (InvalidDependencyVersionException e) {
            throw new BuildException("Invalid dependency version: " + e.getMessage(), (Throwable)e);
        }
        FileSet dependencyFileSet = this.createFileSet();
        FileSet sourcesFileSet = this.createFileSet();
        FileSet javadocsFileSet = this.createFileSet();
        Path dependencyPath = new Path(this.getProject());
        HashSet<String> versions = new HashSet<String>();
        TypesArtifactFilter pathFilter = this.pathType != null ? new TypesArtifactFilter(this.pathType) : null;
        for (Artifact artifact : result.getArtifacts()) {
            this.addArtifactToResult(localRepo, artifact, dependencyFileSet, dependencyPath, pathFilter);
            versions.add(artifact.getVersion());
            if (this.sourcesFilesetId != null) {
                this.resolveSource(artifactFactory, resolver, remoteArtifactRepositories, localRepo, artifact, "sources", sourcesFileSet);
            }
            if (this.javadocFilesetId == null) continue;
            this.resolveSource(artifactFactory, resolver, remoteArtifactRepositories, localRepo, artifact, "javadoc", javadocsFileSet);
        }
        this.defineFilesetReference(this.filesetId, dependencyFileSet);
        this.defineFilesetReference(this.sourcesFilesetId, sourcesFileSet);
        this.defineFilesetReference(this.javadocFilesetId, javadocsFileSet);
        if (this.pathId != null) {
            this.getProject().addReference(this.pathId, (Object)dependencyPath);
        }
        if (this.versionsId != null) {
            String versionsValue = StringUtils.join(versions.iterator(), File.pathSeparator);
            this.getProject().setNewProperty(this.versionsId, versionsValue);
        }
        if (this.getDependencyRefsBuildFile() != null || this.isCacheDependencyRefs()) {
            if (this.getDependencyRefsBuildFile() == null || this.getDependencyRefsBuildFile().equals("default")) {
                this.setDependencyRefsBuildFile(DEFAULT_ANT_BUILD_FILE);
            }
            this.log("Building ant file: " + this.getDependencyRefsBuildFile());
            AntBuildWriter antBuildWriter = new AntBuildWriter();
            File antBuildFile = FileUtils.resolveFile(this.getProject().getBaseDir(), this.getDependencyRefsBuildFile());
            try {
                String versionsList;
                antBuildWriter.openAntBuild(antBuildFile, "maven-dependencies", "init-dependencies");
                antBuildWriter.openTarget("init-dependencies");
                antBuildWriter.writeEcho("Loading dependency paths from file: " + antBuildFile.getAbsolutePath());
                for (Artifact artifact : result.getArtifacts()) {
                    String conflictId = artifact.getDependencyConflictId();
                    antBuildWriter.writeProperty(conflictId, artifact.getFile().getAbsolutePath());
                    FileSet singleArtifactFileSet = (FileSet)this.getProject().getReference(conflictId);
                    antBuildWriter.writeFileSet(singleArtifactFileSet, conflictId);
                }
                if (this.pathId != null) {
                    Path thePath = (Path)this.getProject().getReference(this.pathId);
                    antBuildWriter.writePath(thePath, this.pathId);
                }
                if (this.filesetId != null) {
                    antBuildWriter.writeFileSet(dependencyFileSet, this.filesetId);
                }
                if (this.sourcesFilesetId != null) {
                    antBuildWriter.writeFileSet(sourcesFileSet, this.sourcesFilesetId);
                }
                if (this.javadocFilesetId != null) {
                    antBuildWriter.writeFileSet(sourcesFileSet, this.javadocFilesetId);
                }
                if ((versionsList = this.getProject().getProperty(this.versionsId)) != null) {
                    antBuildWriter.writeProperty(this.versionsId, versionsList);
                }
                antBuildWriter.closeTarget();
                antBuildWriter.closeAntBuild();
            }
            catch (IOException e) {
                throw new BuildException("Unable to write ant build: " + e);
            }
        }
        return result;
    }

    private boolean checkCachedDependencies() {
        File pomFile;
        File cacheBuildFile = FileUtils.resolveFile(this.getProject().getBaseDir(), this.getDependencyRefsBuildFile());
        if (!cacheBuildFile.exists()) {
            return false;
        }
        File antBuildFile = new File(this.getProject().getProperty("ant.file"));
        if (antBuildFile.lastModified() > cacheBuildFile.lastModified()) {
            return false;
        }
        Pom pom = this.getPom();
        if (pom != null && ((pomFile = pom.getFile()) == null || pomFile.lastModified() > cacheBuildFile.lastModified())) {
            return false;
        }
        return this.loadDependenciesFromAntBuildFile();
    }

    private boolean loadDependenciesFromAntBuildFile() {
        Project currentAntProject = this.getProject();
        AntTaskModified dependenciesAntBuild = new AntTaskModified();
        dependenciesAntBuild.setAntfile(this.getDependencyRefsBuildFile());
        dependenciesAntBuild.setProject(currentAntProject);
        dependenciesAntBuild.execute();
        Project cachedDepsProject = dependenciesAntBuild.getSavedNewProject();
        AntUtil.copyProperties(cachedDepsProject, currentAntProject);
        AntUtil.copyReferences(cachedDepsProject, currentAntProject);
        return true;
    }

    private FileSet createFileSet() {
        FileSet fileSet = new FileSet();
        fileSet.setProject(this.getProject());
        fileSet.setDir(this.getLocalRepository().getPath());
        return fileSet;
    }

    private void defineFilesetReference(String id, FileSet fileSet) {
        if (id != null) {
            if (!fileSet.hasPatterns()) {
                fileSet.createExclude().setName("**/**");
            }
            this.getProject().addReference(id, (Object)fileSet);
        }
    }

    private void addArtifactToResult(ArtifactRepository localRepo, Artifact artifact, FileSet toFileSet) {
        this.addArtifactToResult(localRepo, artifact, toFileSet, null, null);
    }

    private void addArtifactToResult(ArtifactRepository localRepo, Artifact artifact, FileSet toFileSet, Path path, ArtifactFilter filter) {
        String filename = localRepo.pathOf(artifact);
        toFileSet.createInclude().setName(filename);
        this.getProject().setProperty(artifact.getDependencyConflictId(), artifact.getFile().getAbsolutePath());
        FileSet artifactFileSet = new FileSet();
        artifactFileSet.setProject(this.getProject());
        artifactFileSet.setFile(artifact.getFile());
        this.getProject().addReference(artifact.getDependencyConflictId(), (Object)artifactFileSet);
        if (path != null && (filter == null || filter.include(artifact))) {
            path.addFileset(artifactFileSet);
        }
    }

    private void resolveSource(ArtifactFactory artifactFactory, ArtifactResolver resolver, List<ArtifactRepository> remoteArtifactRepositories, ArtifactRepository localRepo, Artifact artifact, String classifier, FileSet sourcesFileSet) {
        Artifact sourceArtifact = artifactFactory.createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), "java-source", classifier);
        try {
            resolver.resolve(sourceArtifact, remoteArtifactRepositories, localRepo);
            this.addArtifactToResult(localRepo, sourceArtifact, sourcesFileSet);
        }
        catch (ArtifactResolutionException e) {
            throw new BuildException("Unable to resolve artifact: " + e.getMessage(), (Throwable)e);
        }
        catch (ArtifactNotFoundException e) {
            // empty catch block
        }
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public void addDependency(Dependency dependency) {
        this.dependencies.add(dependency);
    }

    public String getPathId() {
        return this.pathId;
    }

    public void setPathId(String pathId) {
        this.pathId = pathId;
    }

    public String getFilesetId() {
        return this.filesetId;
    }

    public void setSourcesFilesetId(String filesetId) {
        this.sourcesFilesetId = filesetId;
    }

    public String getSourcesFilesetId() {
        return this.sourcesFilesetId;
    }

    public void setJavadocFilesetId(String filesetId) {
        this.javadocFilesetId = filesetId;
    }

    public String getJavadocFilesetId() {
        return this.javadocFilesetId;
    }

    public void setFilesetId(String filesetId) {
        this.filesetId = filesetId;
    }

    public String getVersionsId() {
        return this.versionsId;
    }

    public void setVersionsId(String versionsId) {
        this.versionsId = versionsId;
    }

    public void setVerbose(boolean verbose) {
        this.getProject().log("Option \"verbose\" is deprecated.  Please use the standard Ant -v option.", 1);
    }

    public void setUseScope(String useScope) {
        this.useScope = useScope;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setPathType(String pathType) {
        this.pathType = pathType;
    }

    public String getScopes() {
        return this.scopes;
    }

    public void setScopes(String scopes) {
        this.scopes = scopes;
    }

    public void setAddArtifactFileSetRefs(boolean addArtifactFileSetRefs) {
        this.log("Parameter addArtifactFileSetRefs is deprecated. A fileset ref is always created for each dependency.", 1);
    }

    public String getDependencyRefsBuildFile() {
        return this.dependencyRefsBuildFile;
    }

    public void setDependencyRefsBuildFile(String dependencyRefsBuildFile) {
        this.dependencyRefsBuildFile = dependencyRefsBuildFile;
    }

    public boolean isCacheDependencyRefs() {
        return this.cacheDependencyRefs;
    }

    public void setCacheDependencyRefs(boolean cacheDependencyRefs) {
        this.cacheDependencyRefs = cacheDependencyRefs;
    }
}

