/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.ant.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.maven.artifact.ant.shaded.IOUtil;
import org.apache.maven.artifact.ant.shaded.StringUtils;
import org.apache.maven.artifact.ant.shaded.xml.PrettyPrintXMLWriter;
import org.apache.maven.artifact.ant.shaded.xml.XMLWriter;
import org.apache.maven.artifact.ant.shaded.xml.XmlWriterUtil;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;

public class AntBuildWriter {
    public static final String DEFAULT_FILE_ENCODING = "UTF-8";
    protected static final int DEFAULT_INDENTATION_SIZE = 2;
    private XMLWriter writer;
    private OutputStreamWriter outputStreamWriter;

    public void openAntBuild(File dependenciesBuildFile, String name, String defaultTarget) throws IOException {
        String encoding = DEFAULT_FILE_ENCODING;
        if (!dependenciesBuildFile.getParentFile().exists()) {
            dependenciesBuildFile.getParentFile().mkdirs();
        }
        this.outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(dependenciesBuildFile), encoding);
        this.writer = new PrettyPrintXMLWriter(this.outputStreamWriter, StringUtils.repeat(" ", 2), encoding, null);
        this.writer.startElement("project");
        this.writer.addAttribute("name", name);
        this.writer.addAttribute("default", defaultTarget);
        XmlWriterUtil.writeLineBreak(this.writer);
    }

    public void closeAntBuild() throws IOException {
        this.writer.endElement();
        XmlWriterUtil.writeLineBreak(this.writer);
        IOUtil.close(this.outputStreamWriter);
    }

    public void openTarget(String targetName) throws IOException {
        this.writer.startElement("target");
        this.writer.addAttribute("name", targetName);
    }

    public void closeTarget() throws IOException {
        this.writer.endElement();
    }

    public void writeFileSet(FileSet fileSet, String id) {
        this.writer.startElement("fileset");
        if (id != null) {
            this.writer.addAttribute("id", id);
        }
        File dir = fileSet.getDir(fileSet.getProject());
        this.writer.addAttribute("dir", dir.getAbsolutePath());
        DirectoryScanner scanner = fileSet.getDirectoryScanner(fileSet.getProject());
        scanner.scan();
        String[] files = scanner.getIncludedFiles();
        for (int i = 0; i < files.length; ++i) {
            this.writer.startElement("include");
            this.writer.addAttribute("name", files[i]);
            this.writer.endElement();
        }
        this.writer.endElement();
    }

    public void writeProperty(String name, String value) {
        this.writer.startElement("property");
        this.writer.addAttribute("name", name);
        this.writer.addAttribute("value", value);
        this.writer.endElement();
    }

    public void writeEcho(String message) {
        this.writer.startElement("echo");
        this.writer.addAttribute("message", message);
        this.writer.endElement();
    }

    public void writeFileList(FileList fileList, String id) {
        this.writer.startElement("filelist");
        this.writer.addAttribute("id", id);
        File dir = fileList.getDir(fileList.getProject());
        this.writer.addAttribute("dir", dir.getAbsolutePath());
        String[] files = fileList.getFiles(fileList.getProject());
        for (int i = 0; i < files.length; ++i) {
            this.writer.startElement("file");
            this.writer.addAttribute("name", files[i]);
            this.writer.endElement();
        }
        this.writer.endElement();
    }

    public void writePath(Path path, String pathId) {
        this.writer.startElement("path");
        this.writer.addAttribute("id", pathId);
        String[] paths = path.list();
        for (int i = 0; i < paths.length; ++i) {
            this.writer.startElement("pathelement");
            this.writer.addAttribute("path", paths[i]);
            this.writer.endElement();
        }
        this.writer.endElement();
    }
}

