/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.image;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.imageio.ImageIO;
import org.mapyrus.Constants;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;
import org.mapyrus.image.ColorIcon;
import org.mapyrus.image.PATImage;
import org.mapyrus.image.PNMImage;
import org.mapyrus.image.XBMImage;

public class ImageIOWrapper {
    private static boolean isSingleColorImage(BufferedImage bufferedImage) {
        Color color = Color.BLACK;
        boolean bl = false;
        boolean bl2 = false;
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        for (int i = 0; i < n2 && !bl; ++i) {
            for (int j = 0; j < n && !bl; ++j) {
                int n3 = bufferedImage.getRGB(j, i);
                if ((n3 & 0xFF000000) == 0) continue;
                if (!bl2) {
                    bl2 = true;
                    color = new Color(n3 & 0xFFFFFF);
                    continue;
                }
                bl = n3 != color.getRGB();
            }
        }
        return !bl;
    }

    public static ColorIcon read(File file, Color color) throws IOException, MapyrusException {
        ColorIcon colorIcon = null;
        BufferedImage bufferedImage = null;
        try {
            String string = file.getName().toLowerCase();
            bufferedImage = string.endsWith(".ppm") || string.endsWith(".pgm") || string.endsWith(".pbm") ? new PNMImage(file.toString()).getBufferedImage() : (string.endsWith(".pat") ? new PATImage(file.toString()).getBufferedImage() : (string.endsWith(".xbm") ? new XBMImage(file.toString(), color.getRGB()).getBufferedImage() : ImageIO.read(file)));
            if (bufferedImage != null) {
                if (!ImageIOWrapper.isSingleColorImage(bufferedImage)) {
                    color = null;
                }
                colorIcon = new ColorIcon(bufferedImage, color);
            } else {
                colorIcon = null;
            }
        }
        catch (SecurityException securityException) {
            throw new IOException(securityException.getClass().getName() + ": " + securityException.getMessage() + ": " + file.getPath());
        }
        return colorIcon;
    }

    public static ColorIcon read(URL uRL, Color color) throws IOException, MapyrusException {
        ColorIcon colorIcon;
        InputStream inputStream = null;
        BufferedImage bufferedImage = null;
        try {
            String string = uRL.getPath().toLowerCase();
            URLConnection uRLConnection = uRL.openConnection();
            String string2 = uRLConnection.getContentType();
            inputStream = uRLConnection.getInputStream();
            if (string2.startsWith("text/") || string2.startsWith("application/vnd.ogc.")) {
                int n;
                StringBuffer stringBuffer = new StringBuffer();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                while ((n = bufferedReader.read()) != -1) {
                    stringBuffer.append((char)n);
                    if (stringBuffer.length() < 1360) continue;
                    stringBuffer.append("...");
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("urlreturned") + ": " + string2 + Constants.LINE_SEPARATOR + uRL.toString() + Constants.LINE_SEPARATOR + stringBuffer);
            }
            bufferedImage = string2.equals("image/x-portable-pixmap") || string2.equals("image/x-portable-bitmap") || string2.equals("image/x-portable-graymap") ? new PNMImage(inputStream, string).getBufferedImage() : (string2.equals("image/x-xbm") ? new XBMImage(inputStream, string, color.getRGB()).getBufferedImage() : ImageIO.read(inputStream));
            if (bufferedImage != null) {
                if (!ImageIOWrapper.isSingleColorImage(bufferedImage)) {
                    color = null;
                }
                colorIcon = new ColorIcon(bufferedImage, color);
            } else {
                colorIcon = null;
            }
        }
        catch (SecurityException securityException) {
            throw new IOException(securityException.getClass().getName() + ": " + securityException.getMessage() + ": " + uRL.toString());
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return colorIcon;
    }

    public static void write(BufferedImage bufferedImage, String string, File file) throws IOException {
        FilterOutputStream filterOutputStream = null;
        try {
            filterOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            ImageIOWrapper.write(bufferedImage, string, filterOutputStream);
        }
        catch (SecurityException securityException) {
            throw new IOException(securityException.getClass().getName() + ": " + securityException.getMessage() + ": " + file.getPath());
        }
        finally {
            if (filterOutputStream != null) {
                filterOutputStream.close();
            }
        }
    }

    public static void write(BufferedImage bufferedImage, String string, OutputStream outputStream) throws IOException {
        if (string.equalsIgnoreCase("ppm")) {
            PNMImage.write(bufferedImage, outputStream);
        } else {
            ImageIO.write((RenderedImage)bufferedImage, string, outputStream);
        }
    }

    public static String[] getWriterFormatNames() {
        String[] stringArray = ImageIO.getWriterFormatNames();
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[stringArray.length] = "ppm";
        return stringArray2;
    }
}

