/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.ScrollPane;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.util.concurrent.LinkedBlockingQueue;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import org.mapyrus.Constants;
import org.mapyrus.ContextStack;
import org.mapyrus.FileOrURL;
import org.mapyrus.ImageSelection;
import org.mapyrus.Interpreter;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;
import org.mapyrus.Mutex;
import org.mapyrus.gui.CrosshairMouseListener;
import org.mapyrus.gui.MapyrusEditorPanel;
import org.mapyrus.gui.MapyrusEventListener;
import org.mapyrus.gui.MapyrusMenuBar;
import org.mapyrus.gui.MapyrusToolBar;

public class MapyrusFrame
implements MapyrusEventListener {
    private static Font m_fixedFont = new Font("Monospaced", 0, 12);
    private Mutex m_mutex;
    private JFrame m_frame;
    private MapyrusEditorPanel m_editorPanel;
    private JTextArea m_outputTextArea;
    private Thread m_outputThread;
    private JPanel m_displayPanel;
    private LinkedBlockingQueue<MapyrusEventListener.Action> m_actionQueue = null;
    private Thread m_actionThread;
    private BufferedImage m_displayImage;
    private CrosshairMouseListener m_displayPanelListener;
    private File m_lastOpenedDirectory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapyrusFrame(String[] stringArray) {
        this.setLookAndFeel();
        this.createActionQueue();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        dimension = new Dimension((int)dimension.getWidth(), (int)dimension.getHeight() - 48);
        this.m_frame = new JFrame("Mapyrus " + Constants.getVersion());
        this.m_frame.setPreferredSize(dimension);
        this.m_mutex = new Mutex();
        this.m_mutex.lock();
        this.m_frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (MapyrusFrame.this.saveAndExit()) {
                    MapyrusFrame.this.m_mutex.unlock();
                }
            }
        });
        Container container = this.m_frame.getContentPane();
        container.setLayout(new BorderLayout());
        MapyrusMenuBar mapyrusMenuBar = new MapyrusMenuBar();
        mapyrusMenuBar.addListener(this);
        container.add((Component)mapyrusMenuBar, "North");
        JSplitPane jSplitPane = new JSplitPane(0);
        JSplitPane jSplitPane2 = new JSplitPane(0);
        this.m_displayPanel = new JPanel(){
            static final long serialVersionUID = 13058L;

            @Override
            public void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                if (MapyrusFrame.this.m_displayPanel != null && MapyrusFrame.this.m_displayImage != null) {
                    graphics.drawImage(MapyrusFrame.this.m_displayImage, 0, 0, null);
                }
            }
        };
        this.m_displayPanelListener = new CrosshairMouseListener();
        this.m_displayPanel.addMouseMotionListener(this.m_displayPanelListener);
        this.m_displayPanel.addMouseListener(this.m_displayPanelListener);
        this.m_displayPanel.setPreferredSize(dimension);
        jSplitPane.add(this.m_displayPanel);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        MapyrusToolBar mapyrusToolBar = new MapyrusToolBar();
        mapyrusToolBar.addListener(this);
        jPanel.add((Component)mapyrusToolBar, "North");
        this.m_editorPanel = new MapyrusEditorPanel();
        this.m_editorPanel.setFont(m_fixedFont);
        jPanel.add((Component)this.m_editorPanel, "Center");
        jSplitPane2.add(jPanel);
        this.m_outputTextArea = new JTextArea(2, 80);
        this.m_outputTextArea.setBackground(Color.WHITE);
        this.m_outputTextArea.setFont(m_fixedFont);
        this.m_outputTextArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.m_outputTextArea);
        jSplitPane2.add(jScrollPane);
        jSplitPane.add(jSplitPane2);
        container.add((Component)jSplitPane, "Center");
        this.m_frame.pack();
        jSplitPane.setDividerLocation(0.6);
        this.m_frame.setVisible(true);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.m_editorPanel.createTab(stringArray[i], null, null);
            }
        } else {
            String[] stringArray2 = new String[]{"Mapyrus Logo", "USA", "Eurozone"};
            String[] stringArray3 = new String[]{"commands1.txt", "commands2.txt", "commands3.txt"};
            for (int i = 0; i < stringArray2.length; ++i) {
                this.m_editorPanel.createTab(null, stringArray2[i], null);
                InputStreamReader inputStreamReader = null;
                try {
                    int n;
                    URL uRL = this.getClass().getResource(stringArray3[i]);
                    inputStreamReader = new InputStreamReader(uRL.openConnection().getInputStream());
                    StringBuffer stringBuffer = new StringBuffer();
                    while ((n = inputStreamReader.read()) != -1) {
                        stringBuffer.append((char)n);
                    }
                    this.m_editorPanel.appendToSelectedTextArea(stringBuffer.toString());
                    if (i != stringArray2.length - 1) continue;
                    this.actionPerformed(MapyrusEventListener.Action.RUN);
                    continue;
                }
                catch (IOException iOException) {
                    continue;
                }
                finally {
                    try {
                        if (inputStreamReader != null) {
                            inputStreamReader.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        this.m_editorPanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
            }
        });
        this.waitForClose();
    }

    public MapyrusFrame(String string, BufferedImage bufferedImage) {
        this.setLookAndFeel();
        this.createActionQueue();
        this.m_displayImage = bufferedImage;
        this.m_frame = new JFrame(string);
        Container container = this.m_frame.getContentPane();
        container.setLayout(new BorderLayout());
        MapyrusMenuBar mapyrusMenuBar = new MapyrusMenuBar();
        mapyrusMenuBar.addListener(this);
        container.add((Component)mapyrusMenuBar, "North");
        ImageIcon imageIcon = new ImageIcon(bufferedImage);
        JLabel jLabel = new JLabel(imageIcon);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if ((double)bufferedImage.getWidth() > dimension.getWidth() || (double)bufferedImage.getHeight() > dimension.getHeight() - 50.0) {
            ScrollPane scrollPane = new ScrollPane();
            scrollPane.add(jLabel);
            container.add((Component)scrollPane, "Center");
        } else {
            container.add((Component)jLabel, "Center");
        }
        this.m_mutex = new Mutex();
        this.m_mutex.lock();
        this.m_frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (MapyrusFrame.this.saveAndExit()) {
                    MapyrusFrame.this.m_mutex.unlock();
                }
            }
        });
        this.m_frame.pack();
        this.m_frame.setVisible(true);
        this.waitForClose();
    }

    private void setLookAndFeel() {
        try {
            String string = UIManager.getSystemLookAndFeelClassName();
            UIManager.setLookAndFeel(string);
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
    }

    private void createActionQueue() {
        if (this.m_actionQueue != null) {
            this.m_actionQueue.clear();
        } else {
            this.m_actionQueue = new LinkedBlockingQueue();
        }
        this.m_actionThread = new Thread(){

            @Override
            public void run() {
                try {
                    MapyrusFrame.this.processActions();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        this.m_actionThread.start();
    }

    @Override
    public void actionPerformed(MapyrusEventListener.Action action) {
        if (action == MapyrusEventListener.Action.STOP || action == MapyrusEventListener.Action.EXIT) {
            this.m_actionThread.interrupt();
            if (this.m_outputThread != null) {
                this.m_outputThread.interrupt();
                this.m_outputThread = null;
            }
            this.createActionQueue();
        }
        try {
            this.m_actionQueue.put(action);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void processActions() throws InterruptedException {
        while (true) {
            String[] stringArray;
            MapyrusEventListener.Action action;
            if ((action = this.m_actionQueue.take()) == MapyrusEventListener.Action.NEW_TAB_ACTION) {
                if (this.m_editorPanel == null) continue;
                this.m_editorPanel.createTab(null, null, null);
                continue;
            }
            if (action == MapyrusEventListener.Action.OPEN_FILE) {
                this.openFile();
                continue;
            }
            if (action == MapyrusEventListener.Action.COPY) {
                ImageSelection imageSelection = new ImageSelection(this.m_displayImage);
                stringArray = Toolkit.getDefaultToolkit().getSystemClipboard();
                stringArray.setContents(imageSelection, null);
                continue;
            }
            if (action == MapyrusEventListener.Action.EXPORT_PNG) {
                try {
                    this.exportToPNG();
                }
                catch (SecurityException securityException) {
                    JOptionPane.showMessageDialog(this.m_frame, securityException.getClass().getName() + ": " + securityException.getMessage(), "Mapyrus", 0);
                }
                continue;
            }
            if (action == MapyrusEventListener.Action.EXPORT_PDF) {
                try {
                    this.exportToPDF();
                }
                catch (SecurityException securityException) {
                    JOptionPane.showMessageDialog(this.m_frame, securityException.getClass().getName() + ": " + securityException.getMessage(), "Mapyrus", 0);
                }
                continue;
            }
            if (action == MapyrusEventListener.Action.RUN) {
                this.runCommands();
                continue;
            }
            if (action == MapyrusEventListener.Action.CLOSE_TAB) {
                if (this.m_editorPanel == null || this.m_editorPanel.getTabCount() <= 0) continue;
                boolean bl = true;
                if (this.m_editorPanel.isSelectedTabEdited()) {
                    bl = this.saveTab(true);
                }
                if (!bl) continue;
                this.m_editorPanel.closeSelectedTab();
                continue;
            }
            if (action == MapyrusEventListener.Action.SAVE_TAB) {
                if (this.m_editorPanel == null || this.m_editorPanel.getTabCount() <= 0) continue;
                this.saveTab(false);
                continue;
            }
            if (action == MapyrusEventListener.Action.EXIT) {
                if (!this.saveAndExit()) continue;
                this.m_mutex.unlock();
                continue;
            }
            if (action == MapyrusEventListener.Action.ONLINE_HELP) {
                final JFrame jFrame = new JFrame(MapyrusMessages.get("onlinehelp"));
                try {
                    stringArray = new JEditorPane();
                    stringArray.setEditable(false);
                    URL uRL = this.getClass().getResource("onlinehelp.html");
                    stringArray.setPage(uRL);
                    JButton jButton = new JButton(MapyrusMessages.get("close"));
                    jButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            jFrame.setVisible(false);
                            jFrame.dispose();
                        }
                    });
                    JPanel jPanel = new JPanel();
                    jPanel.setLayout(new BorderLayout());
                    jPanel.add((Component)stringArray, "Center");
                    JPanel jPanel2 = new JPanel();
                    jPanel2.setLayout(new FlowLayout(2));
                    jPanel2.add(jButton);
                    jPanel.add((Component)jPanel2, "South");
                    jFrame.getContentPane().add(jPanel);
                    jFrame.setPreferredSize(new Dimension(600, 600));
                    jFrame.pack();
                    jFrame.setVisible(true);
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(this.m_frame, iOException.getMessage(), "Mapyrus", 0);
                    jFrame.dispose();
                }
                continue;
            }
            if (action != MapyrusEventListener.Action.ABOUT) continue;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Mapyrus").append(" ").append(Constants.getVersion());
            stringBuffer.append(", ").append(Constants.getReleaseDate());
            stringBuffer.append(" ").append("http://mapyrus.sourceforge.net");
            stringBuffer.append(Constants.LINE_SEPARATOR);
            stringBuffer.append(Constants.LINE_SEPARATOR);
            stringArray = Constants.getLicense();
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(stringArray[i]).append(Constants.LINE_SEPARATOR);
            }
            JOptionPane.showMessageDialog(this.m_frame, stringBuffer.toString(), "Mapyrus", 1);
        }
    }

    private void openFile() {
        if (this.m_editorPanel != null) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogType(0);
            jFileChooser.setCurrentDirectory(this.m_lastOpenedDirectory);
            int n = jFileChooser.showOpenDialog(this.m_frame);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                this.m_lastOpenedDirectory = file.getParentFile();
                String string = file.getPath();
                this.m_editorPanel.createTab(string, null, null);
            }
        }
    }

    private void exportToPNG() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setFileFilter(new PNGImageFilter());
        jFileChooser.setSelectedFile(this.m_lastOpenedDirectory);
        int n = jFileChooser.showSaveDialog(this.m_frame);
        if (n == 0) {
            File file;
            this.m_lastOpenedDirectory = file = jFileChooser.getSelectedFile();
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                ImageIO.write((RenderedImage)this.m_displayImage, "png", fileOutputStream);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this.m_frame, iOException.getMessage(), "Mapyrus", 0);
                file.delete();
            }
        }
    }

    private void exportToPDF() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setFileFilter(new PDFImageFilter());
        jFileChooser.setSelectedFile(this.m_lastOpenedDirectory);
        int n = jFileChooser.showSaveDialog(this.m_frame);
        if (n == 0) {
            File file;
            this.m_lastOpenedDirectory = file = jFileChooser.getSelectedFile();
            try {
                this.createPDF(file);
            }
            catch (InterruptedException interruptedException) {
                JOptionPane.showMessageDialog(this.m_frame, interruptedException.getMessage(), "Mapyrus", 0);
                file.delete();
            }
        }
    }

    private void runCommands() throws InterruptedException {
        String string = this.m_editorPanel.getSelectedTabContents();
        if (string.length() > 0) {
            try {
                String string2 = this.m_editorPanel.getSelectedTabTitle();
                FileOrURL fileOrURL = new FileOrURL(new StringReader(string), string2);
                Dimension dimension = this.m_displayPanel.getSize();
                this.m_displayPanel.getGraphics().clearRect(0, 0, dimension.width, dimension.height);
                this.m_displayImage = new BufferedImage(dimension.width, dimension.height, 6);
                this.m_displayImage.getGraphics().setColor(Color.WHITE);
                this.m_displayImage.getGraphics().fillRect(0, 0, dimension.width, dimension.height);
                Interpreter interpreter = new Interpreter();
                ContextStack contextStack = new ContextStack();
                contextStack.setOutputFormat(this.m_displayImage, "lineantialiasing=true");
                this.m_displayPanelListener.setImage(this.m_displayImage);
                this.m_displayPanelListener.setWorlds(contextStack.getWorlds());
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(new byte[0]);
                PipedOutputStream pipedOutputStream = new PipedOutputStream();
                final PipedInputStream pipedInputStream = new PipedInputStream(pipedOutputStream);
                this.m_outputTextArea.setText("");
                this.m_outputThread = new Thread(){

                    @Override
                    public void run() {
                        try {
                            int n;
                            byte[] byArray = new byte[256];
                            while ((n = pipedInputStream.read(byArray)) > 0) {
                                String string = new String(byArray, 0, n);
                                int n2 = MapyrusFrame.this.m_outputTextArea.getCaretPosition();
                                MapyrusFrame.this.m_outputTextArea.append(string);
                                MapyrusFrame.this.m_outputTextArea.setCaretPosition(n2 + string.length());
                                MapyrusFrame.this.m_outputTextArea.repaint();
                            }
                        }
                        catch (IOException iOException) {
                            MapyrusFrame.this.m_outputTextArea.append(iOException.getMessage());
                        }
                    }
                };
                this.m_outputThread.start();
                PrintStream printStream = new PrintStream(pipedOutputStream);
                interpreter.interpret(contextStack, fileOrURL, byteArrayInputStream, printStream);
                this.m_displayPanelListener.setWorlds(contextStack.getWorlds());
                printStream.close();
                if (this.m_outputThread != null) {
                    this.m_outputThread.join();
                    this.m_outputThread = null;
                }
                this.m_outputTextArea.repaint();
                this.m_displayPanel.repaint();
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this.m_frame, iOException.getMessage(), "Mapyrus", 0);
            }
            catch (MapyrusException mapyrusException) {
                JOptionPane.showMessageDialog(this.m_frame, mapyrusException.getMessage(), "Mapyrus", 0);
            }
        }
    }

    private void createPDF(File file) throws InterruptedException {
        String string = this.m_editorPanel.getSelectedTabContents();
        if (string.length() > 0) {
            try {
                String string2 = file.getPath();
                string2 = string2.replace("\\", "\\\\");
                string2 = string2.replace("'", "\\'");
                string = "newpage 'pdf', '" + string2 + "', 'A4'\n" + string + "\n" + "endpage";
                String string3 = this.m_editorPanel.getSelectedTabTitle();
                FileOrURL fileOrURL = new FileOrURL(new StringReader(string), string3);
                Interpreter interpreter = new Interpreter();
                ContextStack contextStack = new ContextStack();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(new byte[0]);
                PipedOutputStream pipedOutputStream = new PipedOutputStream();
                final PipedInputStream pipedInputStream = new PipedInputStream(pipedOutputStream);
                this.m_outputTextArea.setText("");
                this.m_outputThread = new Thread(){

                    @Override
                    public void run() {
                        try {
                            int n;
                            byte[] byArray = new byte[256];
                            while ((n = pipedInputStream.read(byArray)) > 0) {
                                String string = new String(byArray, 0, n);
                                int n2 = MapyrusFrame.this.m_outputTextArea.getCaretPosition();
                                MapyrusFrame.this.m_outputTextArea.append(string);
                                MapyrusFrame.this.m_outputTextArea.setCaretPosition(n2 + string.length());
                                MapyrusFrame.this.m_outputTextArea.repaint();
                            }
                        }
                        catch (IOException iOException) {
                            MapyrusFrame.this.m_outputTextArea.append(iOException.getMessage());
                        }
                    }
                };
                this.m_outputThread.start();
                PrintStream printStream = new PrintStream(pipedOutputStream);
                interpreter.interpret(contextStack, fileOrURL, byteArrayInputStream, printStream);
                printStream.close();
                if (this.m_outputThread != null) {
                    this.m_outputThread.join();
                    this.m_outputThread = null;
                }
                this.m_outputTextArea.repaint();
                String string4 = MapyrusMessages.get("exportedto") + ": " + file.getPath();
                JOptionPane.showMessageDialog(this.m_frame, string4, "Mapyrus", 1);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this.m_frame, iOException.getMessage(), "Mapyrus", 0);
            }
            catch (MapyrusException mapyrusException) {
                JOptionPane.showMessageDialog(this.m_frame, mapyrusException.getMessage(), "Mapyrus", 0);
            }
        }
    }

    private void waitForClose() {
        this.m_mutex.lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveTab(boolean bl) {
        Object object;
        int n = 0;
        String string = this.m_editorPanel.getSelectedTabFilename();
        if (bl) {
            object = MapyrusMessages.get("savechangesintab") + " " + this.m_editorPanel.getSelectedTabTitle();
            if (!string.startsWith(MapyrusMessages.get("untitled"))) {
                object = (String)object + "\n" + MapyrusMessages.get("tofile") + " " + string;
            }
            n = JOptionPane.showConfirmDialog(this.m_frame, (String)object + "?", "Mapyrus", 1);
        }
        if (n == 2) {
            return false;
        }
        if (n == 0) {
            Object object2;
            if (string.startsWith(MapyrusMessages.get("untitled"))) {
                do {
                    try {
                        object = new JFileChooser();
                        ((JFileChooser)object).setDialogType(1);
                        ((JFileChooser)object).setSelectedFile(new File(this.m_lastOpenedDirectory, string));
                        n = ((JFileChooser)object).showSaveDialog(this.m_frame);
                        if (n != 0) {
                            return false;
                        }
                        object2 = ((JFileChooser)object).getSelectedFile();
                        n = 0;
                        this.m_lastOpenedDirectory = ((File)object2).getParentFile();
                        string = ((File)object2).getPath();
                        if (!((File)object2).exists()) continue;
                        n = JOptionPane.showConfirmDialog(this.m_frame, MapyrusMessages.get("overwrite") + " " + string + "?", "Mapyrus", 0);
                    }
                    catch (SecurityException securityException) {
                        JOptionPane.showMessageDialog(this.m_frame, securityException.getMessage(), "Mapyrus", 0);
                        return false;
                    }
                } while (n != 0);
            }
            object = null;
            try {
                object = new FileWriter(string);
                object2 = this.m_editorPanel.getSelectedTabContents();
                ((Writer)object).write((String)object2);
                ((OutputStreamWriter)object).flush();
                this.m_editorPanel.setSelectedTabEdited(false);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this.m_frame, iOException.getMessage(), "Mapyrus", 0);
                boolean bl2 = false;
                return bl2;
            }
            catch (SecurityException securityException) {
                JOptionPane.showMessageDialog(this.m_frame, securityException.getMessage(), "Mapyrus", 0);
                boolean bl3 = false;
                return bl3;
            }
            finally {
                try {
                    if (object != null) {
                        ((OutputStreamWriter)object).close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    private boolean saveAndExit() {
        boolean bl = true;
        while (bl && this.m_editorPanel != null && this.m_editorPanel.getTabCount() > 0) {
            if (this.m_editorPanel.isSelectedTabEdited()) {
                bl = this.saveTab(true);
            }
            if (!bl) continue;
            this.m_editorPanel.closeSelectedTab();
        }
        return bl;
    }

    private class PDFImageFilter
    extends FileFilter {
        private PDFImageFilter() {
        }

        @Override
        public boolean accept(File file) {
            boolean bl = file.isDirectory();
            if (!bl) {
                String string = file.getName();
                bl = string.endsWith(".pdf") || string.endsWith(".PDF");
            }
            return bl;
        }

        @Override
        public String getDescription() {
            return MapyrusMessages.get("pdffiles");
        }
    }

    private class PNGImageFilter
    extends FileFilter {
        private PNGImageFilter() {
        }

        @Override
        public boolean accept(File file) {
            boolean bl = file.isDirectory();
            if (!bl) {
                String string = file.getName();
                bl = string.endsWith(".png") || string.endsWith(".PNG");
            }
            return bl;
        }

        @Override
        public String getDescription() {
            return MapyrusMessages.get("pngimagefiles");
        }
    }
}

