/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.font;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.mapyrus.MapyrusException;
import org.mapyrus.font.AdobeFontMetrics;
import org.mapyrus.font.StringDimension;

public class AdobeFontMetricsManager {
    private static String[] m_stdFontMetricResources = new String[]{"agd.afm", "agdo.afm", "agw.afm", "agwo.afm", "bkd.afm", "bkdi.afm", "bkl.afm", "bkli.afm", "cob.afm", "cobo.afm", "com.afm", "coo.afm", "hv.afm", "hvb.afm", "hvbo.afm", "hvn.afm", "hvnb.afm", "hvnbo.afm", "hvno.afm", "hvo.afm", "ncb.afm", "ncbi.afm", "nci.afm", "ncr.afm", "pob.afm", "pobi.afm", "poi.afm", "por.afm", "sy.afm", "tib.afm", "tibi.afm", "tii.afm", "tir.afm", "zcmi.afm", "zd.afm"};
    private HashMap<String, AdobeFontMetrics> m_fontMetrics = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AdobeFontMetricsManager(List<String> list, HashSet<String> hashSet) throws IOException, MapyrusException {
        Object object;
        Closeable closeable;
        for (int i = 0; i < m_stdFontMetricResources.length; ++i) {
            String string = "org/mapyrus/font/" + m_stdFontMetricResources[i];
            closeable = this.getClass().getClassLoader().getResourceAsStream(string);
            object = null;
            try {
                object = new BufferedReader(new InputStreamReader((InputStream)closeable));
                AdobeFontMetrics adobeFontMetrics = new AdobeFontMetrics((BufferedReader)object, string, hashSet);
                this.m_fontMetrics.put(adobeFontMetrics.getFontName(), adobeFontMetrics);
                continue;
            }
            finally {
                if (object != null) {
                    ((BufferedReader)object).close();
                }
            }
        }
        for (String string : list) {
            closeable = null;
            try {
                closeable = new BufferedReader(new FileReader(string));
                object = new AdobeFontMetrics((BufferedReader)closeable, string, hashSet);
                this.m_fontMetrics.put(((AdobeFontMetrics)object).getFontName(), (AdobeFontMetrics)object);
            }
            finally {
                if (closeable == null) continue;
                ((BufferedReader)closeable).close();
            }
        }
    }

    public StringDimension getStringDimension(String string, double d, String string2) {
        StringDimension stringDimension = new StringDimension();
        AdobeFontMetrics adobeFontMetrics = this.m_fontMetrics.get(string);
        if (adobeFontMetrics != null) {
            stringDimension = adobeFontMetrics.getStringDimension(string2, d);
        } else {
            double d2 = (double)string2.length() * d;
            stringDimension.setSize(d2, d, d, 0.0);
        }
        return stringDimension;
    }

    public char getEncodedChar(String string, char c) {
        AdobeFontMetrics adobeFontMetrics = this.m_fontMetrics.get(string);
        char c2 = adobeFontMetrics != null ? adobeFontMetrics.getEncodedChar(c) : c;
        return c2;
    }

    public static String getISOLatin2Encoding() {
        return "32 /nbspace\n130 /quotesinglbase\n132 /quotedblbase\n133 /ellipsis\n134 /dagger\n135 /daggerdbl\n137 /perthousand\n138 /Scaron\n139 /guilsinglleft\n140 /Sacute\n141 /Tcaron\n142 /Zcaron\n143 /Zacute\n145 /quotesinglleft\n146 /quotesinglright\n147 /quotedblleft\n148 /quotedblright\n149 /bullet\n150 /endash\n151 /emdash\n153 /trademark\n154 /scaron\n155 /guilsinglright\n156 /sacute\n157 /tcaron\n158 /zcaron\n159 /zacute\n160 /nbspace\n161 /caron\n162 /breve\n163 /Lslash\n164 /currency\n165 /Aogonek\n166 /brokenbar\n167 /section\n168 /dieresis\n169 /copyright\n170 /Scedilla\n171 /guillemotleft\n172 /notsign\n173 /hyphen\n174 /registered\n175 /Zdotaccent\n176 /degree\n177 /plusminus\n178 /ogonek\n179 /lslash\n180 /acute\n181 /mu\n182 /paragraph\n183 /periodcentered\n184 /cedilla\n185 /aogonek\n186 /scedilla\n187 /guillemotright\n188 /Lcaron\n189 /hungarumlaut\n190 /lcaron\n191 /zdotaccent\n192 /Racute\n193 /Aacute\n194 /Acircumflex\n195 /Abreve\n196 /Adieresis\n197 /Lacute\n198 /Cacute\n199 /Ccedilla\n200 /Ccaron\n201 /Eacute\n202 /Eogonek\n203 /Edieresis\n204 /Ecaron\n205 /Iacute\n206 /Icircumflex\n207 /Dcaron\n208 /Eth\n209 /Nacute\n210 /Ncaron\n211 /Oacute\n212 /Ocircumflex\n213 /Ohungarumlaut\n214 /Odieresis\n215 /multiply\n216 /Rcaron\n217 /Uring\n218 /Uacute\n219 /Uhungarumlaut\n220 /Udieresis\n221 /Yacute\n222 /Tcedilla\n223 /germandbls\n224 /racute\n225 /aacute\n226 /acircumflex\n227 /abreve\n228 /adieresis\n229 /lacute\n230 /cacute\n231 /ccedilla\n232 /ccaron\n233 /eacute\n234 /eogonek\n235 /edieresis\n236 /ecaron\n237 /iacute\n238 /icircumflex\n239 /dcaron\n240 /eth\n241 /nacute\n242 /ncaron\n243 /oacute\n244 /ocircumflex\n245 /ohungarumlaut\n246 /odieresis\n247 /divide\n248 /rcaron\n249 /uring\n250 /uacute\n251 /uhungarumlaut\n252 /udieresis\n253 /yacute\n254 /tcedilla\n255 /dotaccent\n";
    }

    public static String getISOLatin9Encoding() {
        return "161 /exclamdown\n162 /cent\n163 /sterling\n164 /Euro\n165 /yen\n166 /Scaron\n167 /section\n168 /scaron\n169 /copyright\n170 /ordfeminine\n171 /guillemotleft\n172 /logicalnot\n173 /hyphen\n174 /registered\n175 /macron\n176 /degree\n177 /plusminus\n178 /twosuperior\n179 /threesuperior\n180 /Zcaron\n181 /mu\n182 /paragraph\n183 /periodcentered\n184 /zcaron\n185 /onesuperior\n186 /ordmasculine\n187 /guillemotright\n188 /OE\n189 /oe\n190 /Ydieresis\n191 /questiondown\n192 /Agrave\n193 /Aacute\n194 /Acircumflex\n195 /Atilde\n196 /Adieresis\n197 /Aring\n198 /AE\n199 /Ccedilla\n200 /Egrave\n201 /Eacute\n202 /Ecircumflex\n203 /Edieresis\n204 /Igrave\n205 /Iacute\n206 /Icircumflex\n207 /Idieresis\n208 /Eth\n209 /Ntilde\n210 /Ograve\n211 /Oacute\n212 /Ocircumflex\n213 /Otilde\n214 /Odieresis\n215 /multiply\n216 /Oslash\n217 /Ugrave\n218 /Uacute\n219 /Ucircumflex\n220 /Udieresis\n221 /Yacute\n222 /Thorn\n223 /germandbls\n224 /agrave\n225 /aacute\n226 /acircumflex\n227 /atilde\n228 /adieresis\n229 /aring\n230 /ae\n231 /ccedilla\n232 /egrave\n233 /eacute\n234 /ecircumflex\n235 /edieresis\n236 /igrave\n237 /iacute\n238 /icircumflex\n239 /idieresis\n240 /eth\n241 /ntilde\n242 /ograve\n243 /oacute\n244 /ocircumflex\n245 /otilde\n246 /odieresis\n247 /divide\n248 /oslash\n249 /ugrave\n250 /uacute\n251 /ucircumflex\n252 /udieresis\n253 /yacute\n254 /thorn\n255 /ydieresis\n";
    }

    public static String getISOLatin10Encoding() {
        return "161 /Aogonek\n162 /aogonek\n163 /Lslash\n164 /Euro\n165 /quotedblbase\n166 /Scaron\n167 /section\n168 /scaron\n169 /copyright\n170 /Scommaaccent\n171 /guillemotleft\n172 /Zacute\n173 /hyphen\n174 /zacute\n175 /Zdotaccent\n176 /degree\n177 /plusminus\n178 /Ccaron\n179 /lslash\n180 /Zcaron\n181 /quotedblright\n182 /paragraph\n183 /periodcentered\n184 /zcaron\n185 /ccaron\n186 /scommaaccent\n187 /guillemotright\n188 /OE\n189 /oe\n190 /Ydieresis\n191 /zdotaccent\n192 /Agrave\n193 /Aacute\n194 /Acircumflex\n195 /Abreve\n196 /Adieresis\n197 /Cacute\n198 /AE\n199 /Ccedilla\n200 /Egrave\n201 /Eacute\n202 /Ecircumflex\n203 /Edieresis\n204 /Igrave\n205 /Iacute\n206 /Icircumflex\n207 /Idieresis\n208 /Dcroat\n209 /Nacute\n210 /Ograve\n211 /Oacute\n212 /Ocircumflex\n213 /Ohungarumlaut\n214 /Odieresis\n215 /Sacute\n216 /Uhungarumlaut\n217 /Ugrave\n218 /Uacute\n219 /Ucircumflex\n220 /Udieresis\n221 /Eogonek\n222 /Tcommaaccent\n223 /germandbls\n224 /agrave\n225 /aacute\n226 /acircumflex\n227 /abreve\n228 /adieresis\n229 /cacute\n230 /ae\n231 /ccedilla\n232 /egrave\n233 /eacute\n234 /ecircumflex\n235 /edieresis\n236 /igrave\n237 /iacute\n238 /icircumflex\n239 /idieresis\n240 /dcroat\n241 /nacute\n242 /ograve\n243 /oacute\n244 /ocircumflex\n245 /ohungarumlaut\n246 /odieresis\n247 /sacute\n248 /uhungarumlaut\n249 /ugrave\n250 /uacute\n251 /ucircumflex\n252 /udieresis\n253 /eogonek\n254 /tcommaaccent\n255 /ydieresis\n";
    }

    public static String getWindows1250Encoding() {
        return "128 /Euro\n130 /quotesinglbase\n132 /quotedblbase\n133 /ellipsis\n134 /dagger\n135 /daggerdbl\n137 /perthousand\n138 /Scaron\n139 /guilsinglleft\n140 /Sacute\n141 /Tcaron\n142 /Zcaron\n143 /Zacute\n145 /quoteleft\n146 /quoteright\n147 /quotedblleft\n148 /quotedblright\n149 /bullet\n150 /endash\n151 /emdash\n153 /trademark\n154 /scaron\n155 /guilsinglright\n156 /sacute\n157 /tcaron\n158 /zcaron\n159 /zacute\n160 /space\n161 /caron\n162 /breve\n163 /Lslash\n164 /currency\n165 /Aogonek\n166 /brokenbar\n167 /section\n168 /dieresis\n169 /copyright\n170 /Scedilla\n171 /guillemotleft\n172 /logicalnot\n173 /hyphen\n174 /registered\n175 /Zdotaccent\n176 /degree\n177 /plusminus\n178 /ogonek\n179 /lslash\n180 /acute\n181 /mu\n182 /paragraph\n183 /periodcentered\n184 /cedilla\n185 /aogonek\n186 /scedilla\n187 /guillemotright\n188 /Lcaron\n189 /hungarumlaut\n190 /lcaron\n191 /zdotaccent\n192 /Racute\n193 /Aacute\n194 /Acircumflex\n195 /Abreve\n196 /Adieresis\n197 /Lacute\n198 /Cacute\n199 /Ccedilla\n200 /Ccaron\n201 /Eacute\n202 /Eogonek\n203 /Edieresis\n204 /Ecaron\n205 /Iacute\n206 /Icircumflex\n207 /Dcaron\n208 /Dcroat\n209 /Nacute\n210 /Ncaron\n211 /Oacute\n212 /Ocircumflex\n213 /Ohungarumlaut\n214 /Odieresis\n215 /multiply\n216 /Rcaron\n217 /Uring\n218 /Uacute\n219 /Uhungarumlaut\n220 /Udieresis\n221 /Yacute\n222 /Tcommaaccent\n223 /germandbls\n224 /racute\n225 /aacute\n226 /acircumflex\n227 /abreve\n228 /adieresis\n229 /lacute\n230 /cacute\n231 /ccedilla\n232 /ccaron\n233 /eacute\n234 /eogonek\n235 /edieresis\n236 /ecaron\n237 /iacute\n238 /icircumflex\n239 /dcaron\n240 /dcroat\n241 /nacute\n242 /ncaron\n243 /oacute\n244 /ocircumflex\n245 /ohungarumlaut\n246 /odieresis\n247 /divide\n248 /rcaron\n249 /uring\n250 /uacute\n251 /uhungarumlaut\n252 /udieresis\n253 /yacute\n254 /tcommaaccent\n255 /dotaccent\n";
    }

    public static String getWindows1251Encoding() {
        return "128 /afii10051\n129 /afii10052\n130 /quotesinglbase\n131 /afii10100\n132 /quotedblbase\n133 /ellipsis\n134 /dagger\n135 /daggerdbl\n136 /Euro\n137 /perthousand\n138 /afii10058\n139 /guilsinglleft\n140 /afii10059\n141 /afii10061\n142 /afii10060\n143 /afii10145\n144 /afii10099\n145 /quoteleft\n146 /quoteright\n147 /quotedblleft\n148 /quotedblright\n149 /bullet\n150 /endash\n151 /emdash\n153 /trademark\n154 /afii10106\n155 /guilsinglright\n156 /afii10107\n157 /afii10109\n158 /afii10108\n159 /afii10193\n160 /space\n161 /afii10062\n162 /afii10110\n163 /afii10057\n164 /currency\n165 /afii10050\n166 /brokenbar\n167 /section\n168 /afii10023\n169 /copyright\n170 /afii10053\n171 /guillemotleft\n172 /logicalnot\n173 /hyphen\n174 /registered\n175 /afii10056\n176 /degree\n177 /plusminus\n178 /afii10055\n179 /afii10103\n180 /afii10098\n181 /mu\n182 /paragraph\n183 /periodcentered\n184 /afii10071\n185 /afii61352\n186 /afii10101\n187 /guillemotright\n188 /afii10105\n189 /afii10054\n190 /afii10102\n191 /afii10104\n192 /afii10017\n193 /afii10018\n194 /afii10019\n195 /afii10020\n196 /afii10021\n197 /afii10022\n198 /afii10024\n199 /afii10025\n200 /afii10026\n201 /afii10027\n202 /afii10028\n203 /afii10029\n204 /afii10030\n205 /afii10031\n206 /afii10032\n207 /afii10033\n208 /afii10034\n209 /afii10035\n210 /afii10036\n211 /afii10037\n212 /afii10038\n213 /afii10039\n214 /afii10040\n215 /afii10041\n216 /afii10042\n217 /afii10043\n218 /afii10044\n219 /afii10045\n220 /afii10046\n221 /afii10047\n222 /afii10048\n223 /afii10049\n224 /afii10065\n225 /afii10066\n226 /afii10067\n227 /afii10068\n228 /afii10069\n229 /afii10070\n230 /afii10072\n231 /afii10073\n232 /afii10074\n233 /afii10075\n234 /afii10076\n235 /afii10077\n236 /afii10078\n237 /afii10079\n238 /afii10080\n239 /afii10081\n240 /afii10082\n241 /afii10083\n242 /afii10084\n243 /afii10085\n244 /afii10086\n245 /afii10087\n246 /afii10088\n247 /afii10089\n248 /afii10090\n249 /afii10091\n250 /afii10092\n251 /afii10093\n252 /afii10094\n253 /afii10095\n254 /afii10096\n255 /afii10097\n";
    }

    public static String getWindows1252Encoding() {
        return "128 /Euro\n130 /quotesinglbase\n131 /florin\n132 /quotedblbase\n133 /ellipsis\n134 /dagger\n135 /daggerdbl\n136 /circumflex\n137 /perthousand\n138 /Scaron\n139 /guilsinglleft\n140 /OE\n142 /Zcaron\n145 /quoteleft\n146 /quoteright\n147 /quotedblleft\n148 /quotedblright\n149 /bullet\n150 /endash\n151 /emdash\n152 /tilde\n153 /trademark\n154 /scaron\n155 /guilsinglright\n156 /oe\n158 /zcaron\n159 /Ydieresis\n160 /space\n161 /exclamdown\n162 /cent\n163 /sterling\n164 /currency\n165 /yen\n166 /brokenbar\n167 /section\n168 /dieresis\n169 /copyright\n170 /ordfeminine\n171 /guillemotleft\n172 /logicalnot\n173 /hyphen\n174 /registered\n175 /macron\n176 /degree\n177 /plusminus\n178 /twosuperior\n179 /threesuperior\n180 /acute\n181 /mu\n182 /paragraph\n183 /periodcentered\n184 /cedilla\n185 /onesuperior\n186 /ordmasculine\n187 /guillemotright\n188 /onequarter\n189 /onehalf\n190 /threequarters\n191 /questiondown\n192 /Agrave\n193 /Aacute\n194 /Acircumflex\n195 /Atilde\n196 /Adieresis\n197 /Aring\n198 /AE\n199 /Ccedilla\n200 /Egrave\n201 /Eacute\n202 /Ecircumflex\n203 /Edieresis\n204 /Igrave\n205 /Iacute\n206 /Icircumflex\n207 /Idieresis\n208 /Eth\n209 /Ntilde\n210 /Ograve\n211 /Oacute\n212 /Ocircumflex\n213 /Otilde\n214 /Odieresis\n215 /multiply\n216 /Oslash\n217 /Ugrave\n218 /Uacute\n219 /Ucircumflex\n220 /Udieresis\n221 /Yacute\n222 /Thorn\n223 /germandbls\n224 /agrave\n225 /aacute\n226 /acircumflex\n227 /atilde\n228 /adieresis\n229 /aring\n230 /ae\n231 /ccedilla\n232 /egrave\n233 /eacute\n234 /ecircumflex\n235 /edieresis\n236 /igrave\n237 /iacute\n238 /icircumflex\n239 /idieresis\n240 /eth\n241 /ntilde\n242 /ograve\n243 /oacute\n244 /ocircumflex\n245 /otilde\n246 /odieresis\n247 /divide\n248 /oslash\n249 /ugrave\n250 /uacute\n251 /ucircumflex\n252 /udieresis\n253 /yacute\n254 /thorn\n255 /ydieresis\n";
    }

    public static String getWindows1253Encoding() {
        return "128 /Euro\n130 /quotesinglbase\n131 /florin\n132 /quotedblbase\n133 /ellipsis\n134 /dagger\n135 /daggerdbl\n137 /perthousand\n139 /guilsinglleft\n145 /quoteleft\n146 /quoteright\n147 /quotedblleft\n148 /quotedblright\n149 /bullet\n150 /endash\n151 /emdash\n153 /trademark\n155 /guilsinglright\n160 /space\n161 /dieresistonos\n162 /Alphatonos\n163 /sterling\n164 /currency\n165 /yen\n166 /brokenbar\n167 /section\n168 /dieresis\n169 /copyright\n171 /guillemotleft\n172 /logicalnot\n173 /hyphen\n174 /registered\n175 /afii00208\n176 /degree\n177 /plusminus\n178 /twosuperior\n179 /threesuperior\n180 /tonos\n181 /mu\n182 /paragraph\n183 /periodcentered\n184 /Epsilontonos\n185 /Etatonos\n186 /Iotatonos\n187 /guillemotright\n188 /Omicrontonos\n189 /onehalf\n190 /Upsilontonos\n191 /Omegatonos\n192 /iotadieresistonos\n193 /Alpha\n194 /Beta\n195 /Gamma\n196 /Delta\n197 /Epsilon\n198 /Zeta\n199 /Eta\n200 /Theta\n201 /Iota\n202 /Kappa\n203 /Lambda\n204 /Mu\n205 /Nu\n206 /Xi\n207 /Omicron\n208 /Pi\n209 /Rho\n211 /Sigma\n212 /Tau\n213 /Upsilon\n214 /Phi\n215 /Chi\n216 /Psi\n217 /Omega\n218 /Iotadieresis\n219 /Upsilondieresis\n220 /alphatonos\n221 /epsilontonos\n222 /etatonos\n223 /iotatonos\n224 /upsilondieresistonos\n225 /alpha\n226 /beta\n227 /gamma\n228 /delta\n229 /epsilon\n230 /zeta\n231 /eta\n232 /theta\n233 /iota\n234 /kappa\n235 /lambda\n236 /mu\n237 /nu\n238 /xi\n239 /omicron\n240 /pi\n241 /rho\n242 /sigma1\n243 /sigma\n244 /tau\n245 /upsilon\n246 /phi\n247 /chi\n248 /psi\n249 /omega\n250 /iotadieresis\n251 /upsilondieresis\n252 /omicrontonos\n253 /upsilontonos\n254 /omegatonos\n";
    }

    public static String getWindows1254Encoding() {
        return "128 /Euro\n130 /quotesinglbase\n131 /florin\n132 /quotedblbase\n133 /ellipsis\n134 /dagger\n135 /daggerdbl\n136 /circumflex\n137 /perthousand\n138 /Scaron\n139 /guilsinglleft\n140 /OE\n145 /quoteleft\n146 /quoteright\n147 /quotedblleft\n148 /quotedblright\n149 /bullet\n150 /endash\n151 /emdash\n152 /tilde\n153 /trademark\n154 /scaron\n155 /guilsinglright\n156 /oe\n159 /Ydieresis\n160 /space\n161 /exclamdown\n162 /cent\n163 /sterling\n164 /currency\n165 /yen\n166 /brokenbar\n167 /section\n168 /dieresis\n169 /copyright\n170 /ordfeminine\n171 /guillemotleft\n172 /logicalnot\n173 /hyphen\n174 /registered\n175 /macron\n176 /degree\n177 /plusminus\n178 /twosuperior\n179 /threesuperior\n180 /acute\n181 /mu\n182 /paragraph\n183 /periodcentered\n184 /cedilla\n185 /onesuperior\n186 /ordmasculine\n187 /guillemotright\n188 /onequarter\n189 /onehalf\n190 /threequarters\n191 /questiondown\n192 /Agrave\n193 /Aacute\n194 /Acircumflex\n195 /Atilde\n196 /Adieresis\n197 /Aring\n198 /AE\n199 /Ccedilla\n200 /Egrave\n201 /Eacute\n202 /Ecircumflex\n203 /Edieresis\n204 /Igrave\n205 /Iacute\n206 /Icircumflex\n207 /Idieresis\n208 /Gbreve\n209 /Ntilde\n210 /Ograve\n211 /Oacute\n212 /Ocircumflex\n213 /Otilde\n214 /Odieresis\n215 /multiply\n216 /Oslash\n217 /Ugrave\n218 /Uacute\n219 /Ucircumflex\n220 /Udieresis\n221 /Idotaccent\n222 /Scedilla\n223 /germandbls\n224 /agrave\n225 /aacute\n226 /acircumflex\n227 /atilde\n228 /adieresis\n229 /aring\n230 /ae\n231 /ccedilla\n232 /egrave\n233 /eacute\n234 /ecircumflex\n235 /edieresis\n236 /igrave\n237 /iacute\n238 /icircumflex\n239 /idieresis\n240 /gbreve\n241 /ntilde\n242 /ograve\n243 /oacute\n244 /ocircumflex\n245 /otilde\n246 /odieresis\n247 /divide\n248 /oslash\n249 /ugrave\n250 /uacute\n251 /ucircumflex\n252 /udieresis\n253 /dotlessi\n254 /scedilla\n255 /ydieresis\n";
    }
}

