/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.mapyrus.Expression;
import org.mapyrus.StatementType;

public class Statement {
    private StatementType m_type;
    private ArrayList<Statement> m_thenStatements;
    private ArrayList<Statement> m_elseStatements;
    private ArrayList<Statement> m_loopStatements;
    private String m_blockName;
    private ArrayList<Statement> m_statementBlock;
    private ArrayList<String> m_parameters;
    private Expression[] m_expressions;
    private Expression m_forHashMapExpression;
    private String m_filename;
    private int m_lineNumber;
    private static HashMap<String, StatementType> m_statementTypeLookup = new HashMap(100);

    private StatementType getStatementType(String string) {
        StatementType statementType = m_statementTypeLookup.get(string.toLowerCase());
        if (statementType == null) {
            statementType = StatementType.CALL;
        }
        return statementType;
    }

    public Statement(String string, Expression[] expressionArray) {
        this.m_type = this.getStatementType(string);
        if (this.m_type == StatementType.CALL) {
            this.m_blockName = string;
        }
        this.m_expressions = expressionArray;
    }

    public Statement(String string, ArrayList<String> arrayList, ArrayList<Statement> arrayList2) {
        this.m_blockName = string;
        this.m_parameters = arrayList;
        this.m_statementBlock = arrayList2;
        this.m_type = StatementType.BLOCK;
    }

    public Statement(Expression expression, ArrayList<Statement> arrayList, ArrayList<Statement> arrayList2) {
        this.m_type = StatementType.CONDITIONAL;
        this.m_expressions = new Expression[1];
        this.m_expressions[0] = expression;
        this.m_thenStatements = arrayList;
        this.m_elseStatements = arrayList2;
    }

    public Statement(Expression expression, ArrayList<Statement> arrayList, boolean bl) {
        this.m_type = bl ? StatementType.WHILE_LOOP : StatementType.REPEAT_LOOP;
        this.m_expressions = new Expression[1];
        this.m_expressions[0] = expression;
        this.m_loopStatements = arrayList;
    }

    public Statement(Expression expression, Expression expression2, ArrayList<Statement> arrayList) {
        this.m_type = StatementType.FOR_LOOP;
        this.m_expressions = new Expression[1];
        this.m_expressions[0] = expression;
        this.m_forHashMapExpression = expression2;
        this.m_loopStatements = arrayList;
    }

    public void setFilenameAndLineNumber(String string, int n) {
        this.m_filename = string;
        this.m_lineNumber = n;
    }

    public String getFilenameAndLineNumber() {
        return this.m_filename + ":" + this.m_lineNumber;
    }

    public String getFilename() {
        return this.m_filename;
    }

    public StatementType getType() {
        return this.m_type;
    }

    public Expression[] getExpressions() {
        return this.m_expressions;
    }

    public ArrayList<Statement> getThenStatements() {
        return this.m_thenStatements;
    }

    public ArrayList<Statement> getElseStatements() {
        return this.m_elseStatements;
    }

    public ArrayList<Statement> getLoopStatements() {
        return this.m_loopStatements;
    }

    public Expression getForHashMap() {
        return this.m_forHashMapExpression;
    }

    public String getBlockName() {
        return this.m_blockName;
    }

    public ArrayList<String> getBlockParameters() {
        return this.m_parameters;
    }

    public ArrayList<Statement> getStatementBlock() {
        return this.m_statementBlock;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_type == StatementType.CALL) {
            stringBuffer.append("CALL ").append(this.m_blockName);
        } else if (this.m_type == StatementType.CONDITIONAL) {
            stringBuffer.append("CONDITIONAL");
        } else if (this.m_type == StatementType.REPEAT_LOOP) {
            stringBuffer.append("REPEAT_LOOP");
        } else if (this.m_type == StatementType.WHILE_LOOP) {
            stringBuffer.append("WHILE_LOOP");
        } else if (this.m_type == StatementType.FOR_LOOP) {
            stringBuffer.append("FOR_LOOP");
        } else if (this.m_type == StatementType.BLOCK) {
            stringBuffer.append("BLOCK ").append(this.m_blockName);
        } else {
            for (Map.Entry<String, StatementType> entry : m_statementTypeLookup.entrySet()) {
                if (entry.getValue() != this.m_type) continue;
                stringBuffer.append(entry.getKey());
            }
        }
        if (this.m_expressions != null) {
            for (int i = 0; i < this.m_expressions.length; ++i) {
                stringBuffer.append(" ").append(this.m_expressions[i]);
            }
        }
        return stringBuffer.toString();
    }

    static {
        EnumSet<StatementType> enumSet = EnumSet.allOf(StatementType.class);
        for (StatementType statementType : enumSet) {
            if (statementType.isControl()) continue;
            m_statementTypeLookup.put(statementType.getName(), statementType);
        }
    }
}

