/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus;

import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Stack;
import org.mapyrus.Argument;
import org.mapyrus.Constants;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;
import org.mapyrus.NumericalAnalysis;
import org.mapyrus.geom.LineEquation;

public class GeometricPath {
    static final int CALCULATE_LENGTHS = 1;
    static final int CALCULATE_AREAS = 2;
    static final int CALCULATE_CENTROID = 3;
    static final int CALCULATE_PIP = 4;
    static final int CALCULATE_START_ANGLE = 5;
    static final int CALCULATE_END_ANGLE = 6;
    private static final double ONE_OVER_SQRT_TWO = 0.707106781186547;
    private static AffineTransform m_identityMatrix = new AffineTransform();
    private GeneralPath m_path;
    private ArrayList<Double> m_rotations;
    private ArrayList<Point2D> m_moveTos;
    private int m_nLineTos;

    public GeometricPath() {
        this.m_path = new GeneralPath();
        this.m_rotations = new ArrayList();
        this.m_moveTos = new ArrayList();
        this.m_nLineTos = 0;
    }

    public GeometricPath(GeometricPath geometricPath) {
        this.m_path = (GeneralPath)geometricPath.m_path.clone();
        this.m_nLineTos = geometricPath.m_nLineTos;
        this.m_moveTos = new ArrayList(geometricPath.m_moveTos.size());
        for (Point2D object : geometricPath.m_moveTos) {
            this.m_moveTos.add(object);
        }
        this.m_rotations = new ArrayList(geometricPath.m_rotations.size());
        for (Double d : geometricPath.m_rotations) {
            this.m_rotations.add(d);
        }
    }

    public void moveTo(float f, float f2, double d) {
        this.m_path.moveTo(f, f2);
        this.m_moveTos.add(new Point2D.Float(f, f2));
        this.m_rotations.add(new Double(d));
    }

    public void lineTo(float f, float f2) {
        this.m_path.lineTo(f, f2);
        ++this.m_nLineTos;
    }

    public void arcTo(int n, float f, float f2, float f3, float f4) throws MapyrusException {
        Point2D point2D = this.m_path.getCurrentPoint();
        if (point2D == null) {
            throw new MapyrusException(MapyrusMessages.get("noarcstart"));
        }
        float f5 = (float)point2D.getX();
        float f6 = (float)point2D.getY();
        if (NumericalAnalysis.equals(f5, f3) && NumericalAnalysis.equals(f6, f4)) {
            f3 = f5;
            f4 = f6;
        }
        double d = Point2D.distance(f, f2, f3, f4);
        Arc2D.Float float_ = new Arc2D.Float();
        float_.setArcByCenter(f, f2, d, 0.0, 1.0, 0);
        float_.setAngles(f5, f6, f3, f4);
        if ((double)n < 0.0) {
            float_.setAngleExtent(float_.getAngleExtent() - 360.0);
        }
        this.m_path.append(float_, true);
        ++this.m_nLineTos;
    }

    public void curveTo(float f, float f2, float f3, float f4, float f5, float f6) throws MapyrusException {
        Point2D point2D = this.m_path.getCurrentPoint();
        if (point2D == null) {
            throw new MapyrusException(MapyrusMessages.get("nobezierstart"));
        }
        this.m_path.curveTo(f, f2, f3, f4, f5, f6);
        ++this.m_nLineTos;
    }

    public void ellipseTo(double d, double d2, double d3, double d4, double d5) {
        Point2D point2D;
        Ellipse2D.Double double_ = new Ellipse2D.Double(d - d3 / 2.0, d2 - d4 / 2.0, d3, d4);
        if (d5 != 0.0) {
            GeneralPath generalPath = new GeneralPath(double_);
            AffineTransform affineTransform = AffineTransform.getRotateInstance(d5, d, d2);
            generalPath.transform(affineTransform);
            this.m_path.append(generalPath, false);
            point2D = generalPath.getCurrentPoint();
        } else {
            this.m_path.append(double_, false);
            point2D = new Point2D.Float((float)(d + d3), (float)d2);
        }
        this.m_moveTos.add(point2D);
        ++this.m_nLineTos;
    }

    public void closePath() {
        this.m_path.closePath();
        ++this.m_nLineTos;
    }

    public void append(GeometricPath geometricPath, boolean bl) {
        this.m_path.append(geometricPath.getShape(), bl);
        ArrayList<Point2D> arrayList = geometricPath.getMoveTos();
        ArrayList<Double> arrayList2 = geometricPath.getMoveToRotations();
        for (int i = 0; i < arrayList.size(); ++i) {
            this.m_moveTos.add(arrayList.get(i));
            this.m_rotations.add(arrayList2.get(i));
        }
    }

    public int getMoveToCount() {
        return this.m_moveTos.size();
    }

    public int getLineToCount() {
        return this.m_nLineTos;
    }

    public ArrayList<Point2D> getMoveTos() {
        return this.m_moveTos;
    }

    public ArrayList<Double> getMoveToRotations() {
        return this.m_rotations;
    }

    public Rectangle2D getBounds2D() {
        Rectangle2D rectangle2D;
        if (this.m_moveTos.size() > 0 && this.m_nLineTos == 0) {
            double d;
            double d2;
            Point2D point2D = this.m_moveTos.get(0);
            double d3 = d2 = point2D.getX();
            double d4 = d = point2D.getY();
            for (int i = 1; i < this.m_moveTos.size(); ++i) {
                point2D = this.m_moveTos.get(i);
                if (point2D.getX() < d3) {
                    d3 = point2D.getX();
                }
                if (point2D.getY() < d4) {
                    d4 = point2D.getY();
                }
                if (point2D.getX() > d2) {
                    d2 = point2D.getX();
                }
                if (!(point2D.getY() > d)) continue;
                d = point2D.getY();
            }
            rectangle2D = new Rectangle2D.Double(d3, d4, d2 - d3, d - d4);
        } else {
            rectangle2D = this.m_path.getBounds2D();
        }
        return rectangle2D;
    }

    public GeneralPath getShape() {
        return this.m_path;
    }

    public ArrayList<Point2D> getSubPathPoints(double d, double d2) {
        double d3;
        float[] fArray = new float[6];
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        boolean bl = false;
        ArrayList<Point2D> arrayList = new ArrayList<Point2D>();
        double d11 = 0.0;
        PathIterator pathIterator = this.m_path.getPathIterator(Constants.IDENTITY_MATRIX, 25.4 / (double)Constants.getScreenResolution());
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(fArray);
            if (n == 0) {
                d5 = d9 = (double)fArray[0];
                d6 = d10 = (double)fArray[1];
            } else {
                if (n == 4) {
                    d7 = d9;
                    d8 = d10;
                } else {
                    d7 = fArray[0];
                    d8 = fArray[1];
                }
                d3 = Math.sqrt((d7 - d5) * (d7 - d5) + (d8 - d6) * (d8 - d6));
                if (d4 + d3 >= d) {
                    double d12;
                    int n2 = arrayList.size();
                    if (n2 == 0) {
                        if (d3 > 0.0) {
                            d12 = (d - d4) / d3;
                            if (d12 < 0.0) {
                                d3 += -d12 * d3;
                            }
                        } else {
                            d12 = 0.0;
                        }
                        d5 += d12 * (d7 - d5);
                        d6 += d12 * (d8 - d6);
                        arrayList.add(new Point2D.Double(d5, d6));
                        bl = true;
                    }
                    if (bl) {
                        if (d4 + d3 > d + d2) {
                            d12 = d3 > 0.0 ? (d + d2 - d4) / d3 : 0.0;
                            d5 += d12 * (d7 - d5);
                            d6 += d12 * (d8 - d6);
                            arrayList.add(new Point2D.Double(d5, d6));
                            bl = false;
                        } else {
                            arrayList.add(new Point2D.Double(d7, d8));
                            d11 = Math.atan2(d8 - d6, d7 - d5);
                        }
                    }
                }
                d4 += d3;
                d5 = d7;
                d6 = d8;
            }
            pathIterator.next();
        }
        if (bl) {
            d3 = d + d2 - d4;
            arrayList.add(new Point2D.Double(d7 += Math.cos(d11) * d3, d8 += Math.sin(d11) * d3));
        }
        return arrayList;
    }

    public void reset() {
        this.m_path.reset();
        this.m_rotations.clear();
        this.m_moveTos.clear();
        this.m_nLineTos = 0;
    }

    public double getArea(double d) {
        double d2 = 0.0;
        double[] dArray = this.walkPath(2, d);
        for (int i = 0; i < dArray.length; ++i) {
            d2 += dArray[i];
        }
        return Math.abs(d2);
    }

    public double getLength(double d) {
        double d2 = 0.0;
        double[] dArray = this.walkPath(1, d);
        for (int i = 0; i < dArray.length; ++i) {
            d2 += dArray[i];
        }
        return d2;
    }

    public Point2D.Double getCentroid(double d) {
        double[] dArray = this.walkPath(3, d);
        return new Point2D.Double(dArray[0], dArray[1]);
    }

    public boolean isClockwise(double d) {
        double[] dArray = this.walkPath(2, d);
        return dArray[0] < 0.0;
    }

    public double getStartAngle(double d) {
        double[] dArray = this.walkPath(5, d);
        return dArray[0];
    }

    public double getEndAngle(double d) {
        double[] dArray = this.walkPath(6, d);
        return dArray[0];
    }

    public Point2D getStartPoint() {
        if (this.m_moveTos.size() > 0 && this.m_nLineTos == 0) {
            return this.m_moveTos.get(0);
        }
        PathIterator pathIterator = this.m_path.getPathIterator(m_identityMatrix);
        float[] fArray = new float[6];
        Point2D.Float float_ = null;
        if (!pathIterator.isDone()) {
            pathIterator.currentSegment(fArray);
            float_ = new Point2D.Float(fArray[0], fArray[1]);
        }
        return float_;
    }

    public Point2D getEndPoint() {
        if (this.m_moveTos.size() > 0 && this.m_nLineTos == 0) {
            return this.m_moveTos.get(this.m_moveTos.size() - 1);
        }
        Point2D.Double double_ = null;
        PathIterator pathIterator = this.m_path.getPathIterator(m_identityMatrix);
        float[] fArray = new float[6];
        float f = 0.0f;
        float f2 = 0.0f;
        boolean bl = true;
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(fArray);
            if (n == 0) {
                f = fArray[0];
                f2 = fArray[1];
            } else if (n == 4) {
                fArray[0] = f;
                fArray[1] = f2;
            } else if (n == 2) {
                fArray[1] = fArray[3];
                fArray[0] = fArray[2];
            } else if (n == 3) {
                fArray[1] = fArray[5];
                fArray[0] = fArray[4];
            }
            bl = false;
            pathIterator.next();
        }
        if (!bl) {
            double_ = new Point2D.Double(fArray[0], fArray[1]);
        }
        return double_;
    }

    private double[] walkPath(int n, double d) {
        double[] dArray;
        PathIterator pathIterator = this.m_path.getPathIterator(m_identityMatrix, d);
        float[] fArray = new float[6];
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        int n2 = 0;
        int n3 = 0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n4 = n == 5 || n == 6 ? 1 : (n == 3 ? 2 : this.getMoveToCount());
        double[] dArray2 = dArray = new double[n4];
        double[] dArray3 = dArray;
        double[] dArray4 = dArray;
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = 0.0;
        }
        while (!pathIterator.isDone()) {
            int n5 = pathIterator.currentSegment(fArray);
            if (n5 == 0) {
                f = f7 = fArray[0];
                f2 = f8 = fArray[1];
                ++n2;
            } else {
                ++n3;
                if (n == 5) break;
                if (n5 == 4) {
                    f3 = f7;
                    f4 = f8;
                } else {
                    f3 = fArray[0];
                    f4 = fArray[1];
                }
                if (n == 1) {
                    int n6 = n2 - 1;
                    dArray[n6] = dArray[n6] + Math.sqrt((f3 - f) * (f3 - f) + (f4 - f2) * (f4 - f2));
                } else if (n == 2) {
                    int n7 = n2 - 1;
                    dArray2[n7] = dArray2[n7] + (double)(f * f4 - f3 * f2) / 2.0;
                } else if (n == 3) {
                    double d5 = f * f4 - f3 * f2;
                    d4 += d5;
                    d3 += (double)(f3 + f) * d5;
                    d2 += (double)(f4 + f2) * d5;
                }
                f5 = f;
                f6 = f2;
                f = f3;
                f2 = f4;
            }
            pathIterator.next();
        }
        if (n == 5) {
            if (n3 > 0) {
                dArray4[0] = Math.atan2(fArray[1] - f2, fArray[0] - f);
            }
        } else if (n == 6) {
            if (n3 > 0) {
                dArray4[0] = Math.atan2(f4 - f6, f3 - f5);
            }
        } else if (n == 3) {
            dArray3[0] = d3 / (3.0 * d4);
            dArray3[1] = d2 / (3.0 * d4);
        }
        return dArray;
    }

    public Argument toArgument(double d) {
        Argument argument;
        int n = this.m_moveTos.size();
        if (n == 0) {
            argument = Argument.emptyGeometry;
        } else if (this.m_nLineTos == 0) {
            double[] dArray;
            if (n == 1) {
                Point2D.Float float_ = (Point2D.Float)this.m_moveTos.get(0);
                dArray = new double[]{100.0, 1.0, 0.0, float_.x, float_.y};
            } else {
                dArray = new double[2 + n * 5];
                dArray[0] = 103.0;
                dArray[1] = n;
                int n2 = 2;
                for (int i = 0; i < n; ++i) {
                    Point2D.Float float_ = (Point2D.Float)this.m_moveTos.get(i);
                    dArray[n2++] = 100.0;
                    dArray[n2++] = 1.0;
                    dArray[n2++] = 0.0;
                    dArray[n2++] = float_.x;
                    dArray[n2++] = float_.y;
                }
            }
            argument = new Argument((int)dArray[0], dArray);
        } else {
            int n3;
            float[] fArray = new float[6];
            PathIterator pathIterator = this.m_path.getPathIterator(m_identityMatrix, d);
            int n4 = 2;
            while (!pathIterator.isDone()) {
                n3 = pathIterator.currentSegment(fArray);
                n4 = n3 == 0 ? (n4 += 5) : (n4 += 3);
                pathIterator.next();
            }
            double[] dArray = new double[n4];
            boolean bl = false;
            double d2 = Double.MAX_VALUE;
            double d3 = Double.MAX_VALUE;
            double d4 = d2;
            double d5 = d3;
            int n5 = 0;
            int n6 = 0;
            n4 = 0;
            int n7 = 0;
            int n8 = 0;
            pathIterator = this.m_path.getPathIterator(m_identityMatrix, d);
            while (!pathIterator.isDone()) {
                n3 = pathIterator.currentSegment(fArray);
                if (n3 == 0) {
                    if (n4 > 0) {
                        if (d4 == d2 && d5 == d3) {
                            bl = true;
                        }
                        if (bl) {
                            dArray[n8] = 102.0;
                            ++n5;
                        } else {
                            dArray[n8] = 101.0;
                            ++n6;
                        }
                        dArray[n8 + 1] = n4;
                        n8 = n7;
                    }
                    n4 = 1;
                    bl = false;
                    dArray[n7 += 2] = 0.0;
                    dArray[n7 + 1] = d2 = (double)fArray[0];
                    dArray[n7 + 2] = d3 = (double)fArray[1];
                    n7 += 3;
                } else if (n3 == 4) {
                    bl = true;
                    dArray[n7] = 1.0;
                    dArray[n7 + 1] = d2;
                    dArray[n7 + 2] = d3;
                    n7 += 3;
                    ++n4;
                } else {
                    dArray[n7] = 1.0;
                    dArray[n7 + 1] = fArray[0];
                    dArray[n7 + 2] = fArray[1];
                    n7 += 3;
                    ++n4;
                }
                d4 = fArray[0];
                d5 = fArray[1];
                pathIterator.next();
            }
            if (n4 > 1) {
                if (d4 == d2 && d5 == d3) {
                    bl = true;
                }
                if (bl) {
                    dArray[n8] = 102.0;
                    ++n5;
                } else {
                    dArray[n8] = 101.0;
                    ++n6;
                }
                dArray[n8 + 1] = n4;
            }
            if (n5 + n6 > 1) {
                System.arraycopy(dArray, 0, dArray, 2, dArray.length - 2);
                dArray[0] = n6 == 0 ? 105.0 : (n5 == 0 ? 104.0 : 106.0);
                dArray[1] = n5 + n6;
            }
            argument = new Argument((int)dArray[0], dArray);
        }
        return argument;
    }

    public GeometricPath translatePath(double d, double d2) {
        GeometricPath geometricPath = new GeometricPath();
        geometricPath.m_path = (GeneralPath)this.m_path.clone();
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(d, d2);
        geometricPath.m_path.transform(affineTransform);
        for (int i = 0; i < this.m_moveTos.size(); ++i) {
            Point2D.Float serializable = (Point2D.Float)this.m_moveTos.get(i);
            serializable = new Point2D.Float((float)((double)serializable.x + d), (float)((double)serializable.y + d2));
            geometricPath.m_moveTos.add(serializable);
        }
        geometricPath.m_nLineTos = this.m_nLineTos;
        geometricPath.m_rotations = new ArrayList(this.m_rotations.size());
        for (Double d3 : this.m_rotations) {
            geometricPath.m_rotations.add(d3);
        }
        return geometricPath;
    }

    private ArrayList<LineEquation> eliminateParallelLoops(ArrayList<LineEquation> arrayList, double d, boolean bl) {
        ArrayList<LineEquation> arrayList2;
        LineEquation lineEquation = null;
        LineEquation lineEquation2 = null;
        LineEquation lineEquation3 = null;
        LineEquation lineEquation4 = null;
        Point2D.Double double_ = null;
        Point2D.Double double_2 = null;
        Point2D.Double double_3 = null;
        int n = arrayList.size();
        if (n < 3) {
            arrayList2 = arrayList;
        } else {
            arrayList2 = new ArrayList(n);
            ArrayList<LineEquation> arrayList3 = new ArrayList<LineEquation>(n);
            for (int i = 0; i <= n; ++i) {
                if (i < n) {
                    lineEquation = arrayList.get(i);
                    lineEquation4 = lineEquation.createParallel(d);
                }
                if (i == 0) {
                    if (bl) {
                        LineEquation lineEquation5 = arrayList.get(n - 1);
                        double_3 = lineEquation4.intersect(lineEquation5.createParallel(d), false);
                        if (double_3 == null) {
                            double_3 = lineEquation4.getStartPoint();
                        }
                        double_ = double_3;
                    } else {
                        double_ = lineEquation4.getStartPoint();
                    }
                } else {
                    double_ = i == n ? (bl ? double_3 : lineEquation4.getEndPoint()) : lineEquation4.intersect(lineEquation3, false);
                    if (double_ == null) {
                        arrayList2.add(lineEquation2);
                        arrayList3.add(lineEquation3);
                        double_ = double_2;
                    } else {
                        double d2;
                        double d3 = double_.y - double_2.y;
                        double d4 = double_.x - double_2.x;
                        double d5 = Math.atan2(d3, d4);
                        double d6 = Math.abs(d5 - (d2 = lineEquation3.getAngle()));
                        if (d6 < 0.1 || d6 > 6.183185307179587) {
                            arrayList2.add(lineEquation2);
                            arrayList3.add(lineEquation3);
                        } else {
                            LineEquation lineEquation6;
                            int n2 = arrayList3.size();
                            if (n2 > 0 && (double_ = (lineEquation6 = (LineEquation)arrayList3.get(n2 - 1)).intersect(lineEquation4, false)) == null) {
                                double_ = lineEquation6.getStartPoint();
                            }
                        }
                    }
                }
                lineEquation2 = lineEquation;
                lineEquation3 = lineEquation4;
                double_2 = double_;
            }
        }
        return arrayList2;
    }

    private GeometricPath createParallelPath(double[] dArray, ArrayList<LineEquation> arrayList, GeometricPath geometricPath, boolean bl) {
        for (int i = 0; i < dArray.length; ++i) {
            LineEquation lineEquation;
            boolean bl2 = false;
            LineEquation lineEquation2 = null;
            ArrayList<LineEquation> arrayList2 = this.eliminateParallelLoops(arrayList, dArray[i], bl);
            int n = arrayList2.size();
            if (bl && n > 0) {
                lineEquation = arrayList2.get(n - 1);
                lineEquation = lineEquation.createParallel(dArray[i]);
            } else {
                lineEquation = null;
            }
            for (int j = 0; j < n; ++j) {
                LineEquation lineEquation3 = arrayList2.get(j);
                lineEquation2 = lineEquation3.createParallel(dArray[i]);
                Point2D.Double double_ = lineEquation == null ? lineEquation2.getStartPoint() : lineEquation2.intersect(lineEquation, false);
                if (double_ != null) {
                    if (bl2) {
                        geometricPath.lineTo((float)double_.x, (float)double_.y);
                    } else {
                        geometricPath.moveTo((float)double_.x, (float)double_.y, 0.0);
                        bl2 = true;
                    }
                }
                lineEquation = lineEquation2;
            }
            if (bl) {
                if (!bl2) continue;
                geometricPath.closePath();
                continue;
            }
            if (lineEquation2 == null) continue;
            Point2D.Double double_ = lineEquation2.getEndPoint();
            geometricPath.lineTo((float)double_.x, (float)double_.y);
        }
        return geometricPath;
    }

    public GeometricPath parallelPath(double[] dArray, double d) {
        GeometricPath geometricPath = new GeometricPath();
        float[] fArray = new float[6];
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        boolean bl = false;
        ArrayList<LineEquation> arrayList = new ArrayList<LineEquation>();
        PathIterator pathIterator = this.m_path.getPathIterator(m_identityMatrix, d);
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(fArray);
            if (n == 0) {
                if (!arrayList.isEmpty()) {
                    if (f5 == f && f6 == f2) {
                        bl = true;
                    }
                    this.createParallelPath(dArray, arrayList, geometricPath, bl);
                    arrayList.clear();
                    bl = false;
                }
                f3 = f = fArray[0];
                f4 = f2 = fArray[1];
            } else {
                if (n == 4) {
                    f5 = f;
                    f6 = f2;
                    bl = true;
                } else {
                    f5 = fArray[0];
                    f6 = fArray[1];
                }
                if (f3 != f5 || f4 != f6) {
                    LineEquation lineEquation = new LineEquation(f3, f4, f5, f6);
                    arrayList.add(lineEquation);
                }
                f3 = f5;
                f4 = f6;
            }
            pathIterator.next();
        }
        if (!arrayList.isEmpty()) {
            if (f5 == f && f6 == f2) {
                bl = true;
            }
            this.createParallelPath(dArray, arrayList, geometricPath, bl);
        }
        return geometricPath;
    }

    public GeometricPath samplePath(double d, double d2, double d3) {
        int n;
        float[] fArray = new float[6];
        double d4 = 0.0;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        GeometricPath geometricPath = new GeometricPath();
        double[] dArray = null;
        int n2 = 0;
        if (d < 0.0) {
            n = -1;
            d = -d;
            dArray = this.walkPath(1, d3);
        } else {
            n = 1;
        }
        PathIterator pathIterator = this.m_path.getPathIterator(m_identityMatrix, d3);
        while (!pathIterator.isDone()) {
            int n3 = pathIterator.currentSegment(fArray);
            if (n3 == 0) {
                if (n > 0) {
                    d4 = d2;
                } else {
                    double d5 = dArray[n2] - d2;
                    d4 = NumericalAnalysis.fmod(d5, d);
                }
                f = f3 = fArray[0];
                f2 = f4 = fArray[1];
            } else {
                float f7;
                float f8;
                if (n3 == 4) {
                    f8 = f3;
                    f7 = f4;
                } else {
                    f8 = fArray[0];
                    f7 = fArray[1];
                }
                double d6 = Math.sqrt((f8 - f) * (f8 - f) + (f7 - f2) * (f7 - f2));
                double d7 = Math.atan2(f7 - f2, f8 - f);
                double d8 = Math.cos(d7);
                double d9 = Math.sin(d7);
                int n4 = 0;
                while (d4 + (double)n4 * d < d6 || NumericalAnalysis.equals(d4 + (double)n4 * d, d6)) {
                    f5 = (float)((double)f + (d4 + (double)n4 * d) * d8);
                    f6 = (float)((double)f2 + (d4 + (double)n4 * d) * d9);
                    geometricPath.moveTo(f5, f6, d7);
                    ++n4;
                }
                d4 += d * (double)n4;
                d4 -= d6;
                f = f8;
                f2 = f7;
            }
            pathIterator.next();
        }
        return geometricPath;
    }

    public GeometricPath stripePath(double d, double d2) {
        long l;
        double d3;
        double d4;
        double d5;
        double d6;
        GeometricPath geometricPath = new GeometricPath();
        Rectangle2D rectangle2D = this.getBounds2D();
        int n = 4;
        double[] dArray = new double[n * 2];
        AffineTransform affineTransform = new AffineTransform();
        AffineTransform affineTransform2 = new AffineTransform();
        dArray[0] = 0.0;
        dArray[1] = 0.0;
        dArray[2] = 0.0;
        dArray[3] = rectangle2D.getHeight();
        dArray[4] = rectangle2D.getWidth();
        dArray[5] = dArray[3];
        dArray[6] = dArray[4];
        dArray[7] = 0.0;
        affineTransform2.rotate(-d2);
        affineTransform2.transform(dArray, 0, dArray, 0, n);
        double d7 = d6 = dArray[0];
        double d8 = d5 = dArray[1];
        for (int i = 1; i < n; ++i) {
            d7 = Math.min(d7, dArray[i * 2]);
            d8 = Math.min(d8, dArray[i * 2 + 1]);
            d6 = Math.max(d6, dArray[i * 2]);
            d5 = Math.max(d5, dArray[i * 2 + 1]);
        }
        double d9 = Math.cos(d2);
        double d10 = rectangle2D.getMinX();
        double d11 = rectangle2D.getMinY();
        if (Math.abs(d9) > 0.707106781186547) {
            d4 = d / d9;
            d3 = Math.tan(d2) * rectangle2D.getMinX();
            l = Math.round((d11 - d3) / d4);
            d11 = d3 + (double)l * d4;
        } else {
            d4 = d / Math.sin(d2);
            double d12 = rectangle2D.getMinY() / Math.tan(d2);
            l = Math.round((d10 - d12) / d4);
            d10 = d12 + (double)l * d4;
        }
        affineTransform.translate(d10, d11);
        affineTransform.rotate(d2);
        d4 = d / 2.0;
        for (d3 = Math.floor((d8 - d) / d) * d; d3 <= d5 + d; d3 += d) {
            dArray[0] = d7 - d4;
            dArray[1] = dArray[3] = d3;
            dArray[2] = d6 + d4;
            affineTransform.transform(dArray, 0, dArray, 0, 2);
            geometricPath.moveTo((float)dArray[0], (float)dArray[1], 0.0);
            geometricPath.lineTo((float)dArray[2], (float)dArray[3]);
        }
        return geometricPath;
    }

    private void sortParts(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        for (int i = 1; i < n; ++i) {
            for (int j = i; j < n; ++j) {
                if (!(dArray[j] < dArray[j - 1])) continue;
                double d = dArray[j];
                dArray[j] = dArray[j - 1];
                dArray[j - 1] = d;
                d = dArray2[j];
                dArray2[j] = dArray2[j - 1];
                dArray2[j - 1] = d;
            }
        }
    }

    private int mergeSelectedParts(double[] dArray, double[] dArray2) {
        int n;
        double[] dArray3 = new double[dArray.length];
        double[] dArray4 = new double[dArray2.length];
        int n2 = 1;
        for (n = 0; n < dArray.length; ++n) {
            if (dArray[n] < 0.0) {
                int n3 = n;
                dArray2[n3] = dArray2[n3] + dArray[n];
                dArray[n] = 0.0;
            }
            if (!(dArray2[n] < 0.0)) continue;
            dArray2[n] = 0.0;
        }
        this.sortParts(dArray, dArray2);
        dArray3[0] = dArray[0];
        dArray4[0] = dArray2[0];
        for (n = 1; n < dArray.length; ++n) {
            double d = dArray[n];
            double d2 = dArray[n] + dArray2[n];
            double d3 = dArray3[n2 - 1] + dArray4[n2 - 1];
            if (d < d3) {
                if (!(d2 > d3)) continue;
                dArray4[n2 - 1] = d2 - dArray3[n2 - 1];
                continue;
            }
            dArray3[n2] = dArray[n];
            dArray4[n2] = dArray2[n];
            ++n2;
        }
        System.arraycopy(dArray3, 0, dArray, 0, n2);
        System.arraycopy(dArray4, 0, dArray2, 0, n2);
        return n2;
    }

    public GeometricPath selectPath(double[] dArray, double[] dArray2, double d) {
        double d2;
        double d3;
        double d4;
        double d5;
        GeometricPath geometricPath = new GeometricPath();
        float[] fArray = new float[6];
        double d6 = 0.0;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        double d7 = 0.0;
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        int n3 = this.mergeSelectedParts(dArray, dArray2);
        PathIterator pathIterator = this.m_path.getPathIterator(m_identityMatrix, d);
        while (!pathIterator.isDone() && n < n3) {
            int n4 = pathIterator.currentSegment(fArray);
            if (n4 == 0) {
                f = f5 = fArray[0];
                f2 = f6 = fArray[1];
                if (bl) {
                    geometricPath.moveTo(f, f2, 0.0);
                }
            } else {
                if (n2 > 0) {
                    f = f3;
                    f2 = f4;
                }
                if (n4 == 4) {
                    f3 = f5;
                    f4 = f6;
                } else {
                    f3 = fArray[0];
                    f4 = fArray[1];
                }
                d6 = Math.sqrt((f3 - f) * (f3 - f) + (f4 - f2) * (f4 - f2));
                while (n < n3 && d7 + d6 > dArray[n]) {
                    if (bl) {
                        if (d7 + d6 <= dArray[n] + dArray2[n]) {
                            geometricPath.lineTo(f3, f4);
                            break;
                        }
                        d5 = Math.atan2(f4 - f2, f3 - f);
                        d4 = Math.cos(d5);
                        d3 = Math.sin(d5);
                        d2 = dArray[n] + dArray2[n] - d7;
                        f7 = (float)((double)f + d4 * d2);
                        f8 = (float)((double)f2 + d3 * d2);
                        geometricPath.lineTo(f7, f8);
                        bl = false;
                        ++n;
                        continue;
                    }
                    d5 = Math.atan2(f4 - f2, f3 - f);
                    d4 = Math.cos(d5);
                    d3 = Math.sin(d5);
                    f7 = (float)((double)f + d4 * (dArray[n] - d7));
                    f8 = (float)((double)f2 + d3 * (dArray[n] - d7));
                    geometricPath.moveTo(f7, f8, 0.0);
                    bl = true;
                }
                d7 += d6;
                ++n2;
            }
            pathIterator.next();
        }
        if (bl) {
            if (dArray[n] + dArray2[n] >= d7) {
                geometricPath.lineTo(f3, f4);
            } else {
                d5 = Math.atan2(f4 - f2, f3 - f);
                d4 = Math.cos(d5);
                d3 = Math.sin(d5);
                d2 = dArray[n] + dArray2[n] - (d7 - d6);
                f7 = (float)((double)f + d4 * d2);
                f8 = (float)((double)f2 + d3 * d2);
                geometricPath.lineTo(f7, f8);
            }
        }
        return geometricPath;
    }

    public GeometricPath reversePath(double d) {
        float[] fArray = new float[6];
        float f = 0.0f;
        float f2 = 0.0f;
        GeometricPath geometricPath = new GeometricPath();
        Stack<PathElement> stack = new Stack<PathElement>();
        if (this.getMoveToCount() > 0 && this.getLineToCount() == 0) {
            for (int i = this.m_moveTos.size() - 1; i >= 0; --i) {
                Point2D point2D = this.m_moveTos.get(i);
                Double d2 = this.m_rotations.get(i);
                geometricPath.moveTo((float)point2D.getX(), (float)point2D.getY(), d2);
            }
            return geometricPath;
        }
        PathIterator pathIterator = this.m_path.getPathIterator(m_identityMatrix, d);
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(fArray);
            if (n == 0) {
                f = fArray[0];
                f2 = fArray[1];
                stack.push(new PathElement(n, f, f2));
            } else if (n == 4) {
                stack.push(new PathElement(n, f, f2));
            } else {
                stack.push(new PathElement(n, fArray[0], fArray[1]));
            }
            pathIterator.next();
        }
        boolean bl = false;
        boolean bl2 = true;
        while (!stack.isEmpty()) {
            PathElement pathElement = (PathElement)stack.pop();
            if (bl2 || pathElement.mSegmentType == 4) {
                f = pathElement.mX;
                f2 = pathElement.mY;
                bl = pathElement.mSegmentType == 4;
                geometricPath.moveTo(f, f2, 0.0);
                bl2 = false;
                continue;
            }
            if (pathElement.mSegmentType == 1) {
                geometricPath.lineTo(pathElement.mX, pathElement.mY);
                continue;
            }
            if (bl) {
                geometricPath.closePath();
            } else {
                geometricPath.lineTo(pathElement.mX, pathElement.mY);
            }
            bl = false;
            bl2 = true;
        }
        return geometricPath;
    }

    private class PathElement {
        public int mSegmentType;
        public float mX;
        public float mY;

        public PathElement(int n, float f, float f2) {
            this.mSegmentType = n;
            this.mX = f;
            this.mY = f2;
        }
    }
}

