/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus;

import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.mapyrus.util.Version;

public class Constants {
    public static final String PROGRAM_NAME = "Mapyrus";
    public static final String WEB_SITE = "http://mapyrus.sourceforge.net";
    private static String m_version = null;
    private static String m_releaseDate = null;
    public static final DecimalFormatSymbols US_DECIMAL_FORMAT_SYMBOLS = new DecimalFormatSymbols(Locale.US);
    public static final AffineTransform IDENTITY_MATRIX = new AffineTransform();
    public static final int MAX_HTTP_THREADS = 8;
    public static final int HTTP_TIMEOUT = 30000;
    public static final int HTTP_TEMPFILE_LIFESPAN = 300000;
    public static final int HTTP_SOCKET_TIMEOUT = 30000;
    public static final int MAX_HTTP_REQUEST_TIME = 30000;
    public static final int DB_CONNECTION_TIMEOUT = 30;
    public static final int DB_IDLE_TIMEOUT = 600;
    public static final int ICON_CACHE_SIZE = 64;
    public static final int POINTS_PER_INCH = 72;
    public static final double MM_PER_INCH = 25.4;
    private static int mScreenResolution;
    public static final String LINE_SEPARATOR;

    public static String getVersion() {
        if (m_version == null) {
            m_version = new Version().getVersion();
        }
        return m_version;
    }

    public static String getReleaseDate() {
        if (m_releaseDate == null) {
            m_releaseDate = new Version().getReleaseDate();
        }
        return m_releaseDate;
    }

    public static String[] getLicense() {
        String[] stringArray = new String[]{"Mapyrus comes with ABSOLUTELY NO WARRANTY, not even for MERCHANTABILITY or", "FITNESS FOR A PARTICULAR PURPOSE.  You may redistribute copies of Mapyrus", "under the terms of the GNU Lesser General Public License.  For more", "information about these matters, see the file named COPYING.", "", "Report bugs to <simoc@users.sourceforge.net>."};
        return stringArray;
    }

    public static final int getScreenResolution() {
        if (mScreenResolution == 0) {
            try {
                mScreenResolution = Toolkit.getDefaultToolkit().getScreenResolution();
            }
            catch (InternalError internalError) {
                mScreenResolution = 96;
            }
            catch (HeadlessException headlessException) {
                mScreenResolution = 96;
            }
        }
        return mScreenResolution;
    }

    public static final double getScreenWidth() {
        int n = Constants.getScreenResolution();
        double d = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        return d / (double)n * 25.4;
    }

    public static final double getScreenHeight() {
        int n = Constants.getScreenResolution();
        double d = Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        return d / (double)n * 25.4;
    }

    public static String getOSName() {
        String string = System.getProperty("os.name");
        string = string == null ? "" : string.toUpperCase();
        return string;
    }

    static {
        LINE_SEPARATOR = System.getProperty("line.separator");
    }
}

