/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.dataset;

import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.mapyrus.Argument;
import org.mapyrus.FileOrURL;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;
import org.mapyrus.Row;
import org.mapyrus.dataset.GeographicDataset;
import org.mapyrus.geom.Geometry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShapefileDataset
implements GeographicDataset {
    private static final int MAGIC_NUMBER = 9994;
    private static final byte DBF_HEADER_SENTINEL = 13;
    private static final byte DBF_DELETED_RECORD = 42;
    private static final int NULL_SHAPE = 0;
    private static final int POINT = 1;
    private static final int POLYLINE = 3;
    private static final int POLYGON = 5;
    private static final int MULTIPOINT = 8;
    private static final int POINT_Z = 11;
    private static final int POLYLINE_Z = 13;
    private static final int POLYGON_Z = 15;
    private static final int MULTIPOINT_Z = 18;
    private static final int POINT_M = 21;
    private static final int POLYLINE_M = 23;
    private static final int POLYGON_M = 25;
    private static final int MULTIPOINT_M = 28;
    private static final int MULTIPATCH = 31;
    private static final byte DBF_CHARACTER = 67;
    private static final byte DBF_DATE = 68;
    private static final byte DBF_NUMBER = 78;
    private static final byte DBF_FLOATING = 70;
    private static final byte DBF_LOGICAL = 76;
    private DataInputStream m_shapeStream;
    private DataInputStream m_DBFStream;
    private String m_filename;
    private int m_shapeFileLength;
    private int m_shapeFileType;
    private int m_geometryType;
    private int m_DBFRecordLength;
    private String m_projection;
    private ArrayList<Boolean> m_DBFFieldsToFetch;
    private int m_nDBFFieldsToFetch;
    private String[] m_fieldNames;
    private int[] m_fieldTypes;
    private int[] m_DBFFieldTypes;
    private int[] m_DBFFieldLengths;
    private Rectangle2D.Double m_extents;
    private Rectangle2D.Double m_queryExtents;
    private int m_BytesRead;
    private byte[] m_DBFRecord;
    private String m_encoding;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShapefileDataset(String string, String string2) throws FileNotFoundException, IOException, MapyrusException {
        FileOrURL fileOrURL;
        Object object;
        String string3;
        String string4;
        String string5;
        HashSet<String> hashSet = null;
        double d = -3.4028234663852886E38;
        double d2 = -3.4028234663852886E38;
        double d3 = 3.4028234663852886E38;
        double d4 = 3.4028234663852886E38;
        this.m_encoding = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        while (stringTokenizer.hasMoreTokens()) {
            String string6 = stringTokenizer.nextToken();
            if (string6.startsWith("dbffields=")) {
                hashSet = new HashSet<String>();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string6.substring(10), ",");
                while (stringTokenizer2.hasMoreTokens()) {
                    string6 = stringTokenizer2.nextToken();
                    hashSet.add(string6);
                }
                continue;
            }
            if (string6.startsWith("xmin=") || string6.startsWith("ymin=") || string6.startsWith("xmax=") || string6.startsWith("ymax=")) {
                double d5;
                String string7 = string6.substring(5);
                try {
                    d5 = Double.parseDouble(string7);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MapyrusException(MapyrusMessages.get("invalidnumber") + ": " + string7);
                }
                if (string6.startsWith("xmin=")) {
                    d2 = d5;
                    continue;
                }
                if (string6.startsWith("ymin=")) {
                    d = d5;
                    continue;
                }
                if (string6.startsWith("xmax=")) {
                    d4 = d5;
                    continue;
                }
                d3 = d5;
                continue;
            }
            if (!string6.startsWith("encoding=")) continue;
            this.m_encoding = string6.substring(9);
        }
        if (d2 > d4) {
            throw new MapyrusException(MapyrusMessages.get("invalidrange") + ": " + d2 + " - " + d4);
        }
        if (d > d3) {
            throw new MapyrusException(MapyrusMessages.get("invalidrange") + ": " + d + " - " + d3);
        }
        this.m_queryExtents = new Rectangle2D.Double(d2, d, d4 - d2, d3 - d);
        if (string.endsWith(".shp") || string.endsWith(".dbf") || string.endsWith(".shx")) {
            this.m_filename = string.substring(0, string.length() - 4);
            string5 = this.m_filename + ".shp";
            string4 = this.m_filename + ".dbf";
            string3 = this.m_filename + ".prj";
        } else if (string.endsWith(".SHP") || string.endsWith(".DBF") || string.endsWith(".SHX")) {
            this.m_filename = string.substring(0, string.length() - 4);
            string5 = this.m_filename + ".SHP";
            string4 = this.m_filename + ".DBF";
            string3 = this.m_filename + ".PRJ";
        } else {
            this.m_filename = string;
            string5 = string + ".shp";
            string4 = string + ".dbf";
            string3 = string + ".prj";
        }
        try {
            object = new FileOrURL(string5);
            this.m_shapeStream = new DataInputStream(((FileOrURL)object).getInputStream());
            try {
                fileOrURL = new FileOrURL(string4);
                this.m_DBFStream = new DataInputStream(fileOrURL.getInputStream());
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.m_DBFStream = null;
            }
            catch (MapyrusException mapyrusException) {
                this.m_DBFStream = null;
            }
        }
        catch (SecurityException securityException) {
            throw new IOException(securityException.getClass().getName() + ": " + securityException.getMessage());
        }
        object = null;
        try {
            fileOrURL = new FileOrURL(string3);
            object = fileOrURL.getReader();
            this.m_projection = ((BufferedReader)object).readLine();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.m_projection = "";
        }
        catch (MapyrusException mapyrusException) {
            this.m_projection = "";
        }
        finally {
            if (object != null) {
                ((BufferedReader)object).close();
            }
        }
        try {
            this.readShapeHeader();
            this.readDBFHeader(hashSet);
            if (Geometry.overlaps(this.m_queryExtents, this.m_extents.getMinX(), this.m_extents.getMinY(), this.m_extents.getMaxX(), this.m_extents.getMaxY())) {
                this.m_BytesRead = 0;
                this.m_DBFRecord = new byte[this.m_DBFRecordLength];
            } else {
                this.m_BytesRead = this.m_shapeFileLength;
            }
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
        catch (MapyrusException mapyrusException) {
            this.close();
            throw mapyrusException;
        }
    }

    private long readLittleEndianLong(DataInputStream dataInputStream) throws IOException {
        long l = dataInputStream.read();
        long l2 = dataInputStream.read();
        long l3 = dataInputStream.read();
        long l4 = dataInputStream.read();
        long l5 = dataInputStream.read();
        long l6 = dataInputStream.read();
        long l7 = dataInputStream.read();
        long l8 = dataInputStream.read();
        long l9 = (l8 << 56) + (l7 << 48) + (l6 << 40) + (l5 << 32) + (l4 << 24) + (l3 << 16) + (l2 << 8) + l;
        return l9;
    }

    private int readLittleEndianInt(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.read();
        int n2 = dataInputStream.read();
        int n3 = dataInputStream.read();
        int n4 = dataInputStream.read();
        int n5 = (n4 << 24) + (n3 << 16) + (n2 << 8) + n;
        return n5;
    }

    private short readLittleEndianShort(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.read();
        int n2 = dataInputStream.read();
        return (short)((n2 << 8) + n);
    }

    private double readLittleEndianDouble(DataInputStream dataInputStream) throws IOException {
        long l = this.readLittleEndianLong(dataInputStream);
        double d = Double.longBitsToDouble(l);
        return d;
    }

    private void readShapeHeader() throws IOException, MapyrusException {
        int n = this.m_shapeStream.readInt();
        if (n != 9994) {
            throw new MapyrusException(this.m_filename + ": " + MapyrusMessages.get("notshapefile"));
        }
        this.m_shapeStream.readInt();
        this.m_shapeStream.readInt();
        this.m_shapeStream.readInt();
        this.m_shapeStream.readInt();
        this.m_shapeStream.readInt();
        this.m_shapeFileLength = this.m_shapeStream.readInt() * 2 - 100;
        this.readLittleEndianInt(this.m_shapeStream);
        this.m_shapeFileType = this.readLittleEndianInt(this.m_shapeStream);
        double d = this.readLittleEndianDouble(this.m_shapeStream);
        double d2 = this.readLittleEndianDouble(this.m_shapeStream);
        double d3 = this.readLittleEndianDouble(this.m_shapeStream);
        double d4 = this.readLittleEndianDouble(this.m_shapeStream);
        this.readLittleEndianDouble(this.m_shapeStream);
        this.readLittleEndianDouble(this.m_shapeStream);
        this.readLittleEndianDouble(this.m_shapeStream);
        this.readLittleEndianDouble(this.m_shapeStream);
        this.m_extents = new Rectangle2D.Double(d, d2, d3 - d, d4 - d2);
        switch (this.m_shapeFileType) {
            case 0: {
                this.m_geometryType = 0;
                break;
            }
            case 1: 
            case 11: 
            case 21: {
                this.m_geometryType = 100;
                break;
            }
            case 3: 
            case 13: 
            case 23: {
                this.m_geometryType = 104;
                break;
            }
            case 5: 
            case 15: 
            case 25: 
            case 31: {
                this.m_geometryType = 105;
                break;
            }
            case 8: 
            case 18: 
            case 28: {
                this.m_geometryType = 103;
            }
        }
    }

    private String unpackString(byte[] byArray, int n, int n2) throws MapyrusException {
        String string;
        int n3;
        for (n3 = n + n2 - 1; n3 >= n && (byArray[n3] == 0 || Character.isWhitespace((char)byArray[n3])); --n3) {
        }
        if (n3 < n) {
            string = "";
        } else if (this.m_encoding != null) {
            try {
                string = new String(byArray, n, n3 - n + 1, this.m_encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new MapyrusException(MapyrusMessages.get("invalidcharset") + ": " + this.m_encoding + ": " + unsupportedEncodingException.getMessage());
            }
        } else {
            string = new String(byArray, n, n3 - n + 1);
        }
        return string;
    }

    private void readDBFHeader(HashSet<String> hashSet) throws IOException, MapyrusException {
        byte[] byArray;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        int n = 0;
        int n2 = 0;
        this.m_nDBFFieldsToFetch = 0;
        int n3 = 0;
        this.m_DBFFieldsToFetch = new ArrayList();
        if (this.m_DBFStream != null) {
            this.m_DBFStream.skipBytes(4);
            this.readLittleEndianInt(this.m_DBFStream);
            n2 = this.readLittleEndianShort(this.m_DBFStream);
            this.m_DBFRecordLength = this.readLittleEndianShort(this.m_DBFStream);
            this.m_DBFStream.skipBytes(20);
            n = 32;
            do {
                byArray = new byte[32];
                byArray[0] = (byte)this.m_DBFStream.read();
                ++n;
                if (byArray[0] == 13) continue;
                this.m_DBFStream.read(byArray, 1, byArray.length - 1);
                String string = this.unpackString(byArray, 0, 11);
                boolean bl = hashSet == null || hashSet.contains(string);
                this.m_DBFFieldsToFetch.add(bl);
                if (bl) {
                    ++this.m_nDBFFieldsToFetch;
                }
                n += byArray.length - 1;
                arrayList.add(byArray);
                ++n3;
            } while (byArray[0] != 13);
        }
        this.m_fieldNames = new String[this.m_nDBFFieldsToFetch + 1];
        this.m_fieldTypes = new int[this.m_nDBFFieldsToFetch + 1];
        this.m_DBFFieldTypes = new int[n3];
        this.m_DBFFieldLengths = new int[n3];
        this.m_fieldNames[this.m_nDBFFieldsToFetch] = "GEOMETRY";
        this.m_fieldTypes[this.m_nDBFFieldsToFetch] = 4;
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            byArray = (byte[])arrayList.get(i);
            this.m_DBFFieldTypes[i] = byArray[11];
            this.m_DBFFieldLengths[i] = byArray[16] >= 0 ? byArray[16] : 256 + byArray[16];
            if (!this.m_DBFFieldsToFetch.get(i).booleanValue()) continue;
            this.m_fieldNames[n4] = this.unpackString(byArray, 0, 11);
            switch (this.m_DBFFieldTypes[i]) {
                case 67: 
                case 68: {
                    this.m_fieldTypes[n4] = 1;
                    break;
                }
                case 70: 
                case 76: 
                case 78: {
                    this.m_fieldTypes[n4] = 0;
                }
            }
            ++n4;
        }
        int n5 = n2 - n;
        if (n5 > 0) {
            this.m_DBFStream.skipBytes(n5);
        }
    }

    @Override
    public String getProjection() {
        return this.m_projection;
    }

    @Override
    public Hashtable<String, String> getMetadata() {
        return null;
    }

    @Override
    public String[] getFieldNames() {
        return this.m_fieldNames;
    }

    @Override
    public Rectangle2D.Double getWorlds() {
        return this.m_extents;
    }

    @Override
    public Row fetch() throws MapyrusException {
        Row row;
        boolean bl = false;
        double[] dArray = null;
        try {
            row = new Row();
            while (!bl && this.m_BytesRead < this.m_shapeFileLength) {
                int n;
                int n2;
                int n3;
                double d;
                double d2;
                double d3;
                double d4;
                this.m_shapeStream.readInt();
                int n4 = this.m_shapeStream.readInt() * 2;
                int n5 = this.readLittleEndianInt(this.m_shapeStream);
                int n6 = 4;
                if (n5 == 0) {
                    dArray = Argument.emptyGeometry.getGeometryValue();
                    bl = true;
                } else if (this.m_shapeFileType == 1 || this.m_shapeFileType == 11 || this.m_shapeFileType == 21) {
                    dArray = new double[]{100.0, 1.0, 0.0, this.readLittleEndianDouble(this.m_shapeStream), this.readLittleEndianDouble(this.m_shapeStream)};
                    n6 += 16;
                    bl = this.m_queryExtents.outcode(dArray[3], dArray[4]) == 0;
                } else if (this.m_shapeFileType == 3 || this.m_shapeFileType == 5 || this.m_shapeFileType == 13 || this.m_shapeFileType == 15 || this.m_shapeFileType == 23 || this.m_shapeFileType == 25 || this.m_shapeFileType == 31) {
                    d4 = this.readLittleEndianDouble(this.m_shapeStream);
                    d3 = this.readLittleEndianDouble(this.m_shapeStream);
                    d2 = this.readLittleEndianDouble(this.m_shapeStream);
                    d = this.readLittleEndianDouble(this.m_shapeStream);
                    n6 += 32;
                    bl = Geometry.overlaps(this.m_queryExtents, d4, d3, d2, d);
                    if (bl) {
                        boolean bl2;
                        int n7 = this.readLittleEndianInt(this.m_shapeStream);
                        n3 = this.readLittleEndianInt(this.m_shapeStream);
                        n6 += 8;
                        int[] nArray = new int[n7];
                        for (n2 = 0; n2 < n7; ++n2) {
                            nArray[n2] = this.readLittleEndianInt(this.m_shapeStream);
                        }
                        n6 += n7 * 4;
                        if (this.m_shapeFileType == 31) {
                            this.m_shapeStream.skipBytes(n7 * 4);
                            n6 += n7 * 4;
                        }
                        dArray = new double[2 + n7 * 2 + n3 * 3];
                        int n8 = 0;
                        int n9 = 0;
                        boolean bl3 = bl2 = this.m_shapeFileType == 3 || this.m_shapeFileType == 23 || this.m_shapeFileType == 13;
                        if (bl2) {
                            dArray[0] = 104.0;
                            dArray[1] = n7;
                        } else {
                            dArray[0] = 102.0;
                        }
                        int n10 = 0;
                        n = 2;
                        double d5 = Double.MAX_VALUE;
                        double d6 = Double.MAX_VALUE;
                        for (n2 = 0; n2 < n3; ++n2) {
                            double d7 = this.readLittleEndianDouble(this.m_shapeStream);
                            double d8 = this.readLittleEndianDouble(this.m_shapeStream);
                            n6 += 16;
                            if (n10 < n7 && nArray[n10] == n2) {
                                if (bl2) {
                                    if (n10 > 0) {
                                        dArray[n9] = n8;
                                    }
                                    n8 = 0;
                                    dArray[n] = 101.0;
                                    n9 = n + 1;
                                    n += 2;
                                }
                                dArray[n] = 0.0;
                                ++n;
                                ++n10;
                            } else {
                                if (d7 == d6 && d8 == d5) continue;
                                dArray[n] = 1.0;
                                ++n;
                            }
                            dArray[n] = d6 = d7;
                            dArray[n + 1] = d5 = d8;
                            n += 2;
                            ++n8;
                        }
                        if (bl2) {
                            dArray[n9] = n8;
                        } else {
                            dArray[1] = n8;
                        }
                    }
                } else if (this.m_shapeFileType == 8 || this.m_shapeFileType == 18 || this.m_shapeFileType == 28) {
                    d4 = this.readLittleEndianDouble(this.m_shapeStream);
                    d3 = this.readLittleEndianDouble(this.m_shapeStream);
                    d2 = this.readLittleEndianDouble(this.m_shapeStream);
                    d = this.readLittleEndianDouble(this.m_shapeStream);
                    n6 += 32;
                    bl = Geometry.overlaps(this.m_queryExtents, d4, d3, d2, d);
                    if (bl) {
                        n3 = this.readLittleEndianInt(this.m_shapeStream);
                        n6 += 4;
                        dArray = new double[n3 * 5 + 2];
                        dArray[0] = 103.0;
                        dArray[1] = n3;
                        n = 2;
                        for (n2 = 0; n2 < n3; ++n2) {
                            dArray[n] = 100.0;
                            dArray[n + 1] = 1.0;
                            dArray[n + 2] = 0.0;
                            dArray[n + 3] = this.readLittleEndianDouble(this.m_shapeStream);
                            dArray[n + 4] = this.readLittleEndianDouble(this.m_shapeStream);
                            n += 5;
                            n6 += 16;
                        }
                    }
                }
                if (n6 < n4) {
                    this.m_shapeStream.skipBytes(n4 - n6);
                }
                this.m_BytesRead += n4 + 8;
                if (this.m_nDBFFieldsToFetch > 0) {
                    this.m_DBFStream.read(this.m_DBFRecord);
                    while (this.m_DBFRecord[0] == 42) {
                        this.m_DBFStream.read(this.m_DBFRecord);
                    }
                }
                if (!bl) continue;
                if (this.m_nDBFFieldsToFetch > 0) {
                    int n11 = 1;
                    for (n2 = 0; n2 < this.m_DBFFieldTypes.length; ++n2) {
                        Argument argument = null;
                        if (this.m_DBFFieldsToFetch.get(n2).booleanValue()) {
                            if (this.m_DBFFieldTypes[n2] == 67 || this.m_DBFFieldTypes[n2] == 68) {
                                argument = new Argument(1, this.unpackString(this.m_DBFRecord, n11, this.m_DBFFieldLengths[n2]));
                            } else if (this.m_DBFFieldTypes[n2] == 78 || this.m_DBFFieldTypes[n2] == 70) {
                                double d9;
                                String string = this.unpackString(this.m_DBFRecord, n11, this.m_DBFFieldLengths[n2]);
                                try {
                                    d9 = Double.parseDouble(string);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    d9 = 0.0;
                                }
                                argument = new Argument(d9);
                            } else if (this.m_DBFFieldTypes[n2] == 76) {
                                switch ((char)this.m_DBFRecord[n11]) {
                                    case 'T': 
                                    case 'Y': 
                                    case 't': 
                                    case 'y': {
                                        argument = Argument.numericOne;
                                        break;
                                    }
                                    default: {
                                        argument = Argument.numericZero;
                                    }
                                }
                            }
                            row.add(argument);
                        }
                        n11 += this.m_DBFFieldLengths[n2];
                    }
                }
                row.add(new Argument(this.m_geometryType, dArray));
            }
        }
        catch (IOException iOException) {
            throw new MapyrusException(iOException.getMessage());
        }
        if (bl) {
            return row;
        }
        return null;
    }

    @Override
    public void close() throws MapyrusException {
        try {
            this.m_shapeStream.close();
        }
        catch (IOException iOException) {
            throw new MapyrusException(iOException.getMessage());
        }
        finally {
            try {
                if (this.m_DBFStream != null) {
                    this.m_DBFStream.close();
                }
            }
            catch (IOException iOException) {
                throw new MapyrusException(iOException.getMessage());
            }
        }
    }
}

