/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.font;

import java.awt.Font;
import java.awt.FontFormatException;
import java.io.FileInputStream;
import java.io.IOException;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;

public class TrueTypeFont {
    private String m_fontName;
    private String m_filename;

    public TrueTypeFont(String string) throws IOException, MapyrusException {
        if (!string.toLowerCase().endsWith(".ttf")) {
            throw new MapyrusException(MapyrusMessages.get("notattffile") + ": " + string);
        }
        this.m_filename = string;
        Font font = this.getFont();
        this.m_fontName = font.getPSName();
    }

    public String getName() {
        return this.m_fontName;
    }

    public String toString() {
        return "TrueType Font " + this.m_fontName;
    }

    public Font getFont() throws IOException, MapyrusException {
        Font font = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.m_filename);
            font = Font.createFont(0, fileInputStream);
        }
        catch (FontFormatException fontFormatException) {
            throw new MapyrusException(MapyrusMessages.get("notattffile") + ": " + this.m_filename);
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        return font;
    }
}

