/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.dataset;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;

public class WKBGeometryParser {
    private static byte BIG_ENDIAN = 0;
    private static byte LITTLE_ENDIAN = 1;
    private static int WKB_POINT = 1;
    private static int WKB_LINESTRING = 2;
    private static int WKB_POLYGON = 3;
    private static int WKB_MULTIPOINT = 4;
    private static int WKB_MULTILINESTRING = 5;
    private static int WKB_MULTIPOLYGON = 6;
    private static int WKB_GEOMETRY_COLLECTION = 7;

    private static String convertToHexDigits(int n, ByteBuffer byteBuffer) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("0x");
        String string = Integer.toHexString(n &= 0xFF);
        if (string.length() == 1) {
            stringBuffer.append("0");
        }
        stringBuffer.append(string);
        for (int i = 0; i < 6; ++i) {
            if (!byteBuffer.hasRemaining()) continue;
            n = byteBuffer.get();
            string = Integer.toHexString(n &= 0xFF);
            if (string.length() == 1) {
                stringBuffer.append("0");
            }
            stringBuffer.append(string);
        }
        if (byteBuffer.hasRemaining()) {
            stringBuffer.append("...");
        }
        return stringBuffer.toString();
    }

    private static int parseGeometry(ByteBuffer byteBuffer, double[] dArray, int n) throws MapyrusException {
        int n2 = n;
        if (byteBuffer.remaining() < 21) {
            String string = "";
            if (byteBuffer.hasRemaining()) {
                string = WKBGeometryParser.convertToHexDigits(byteBuffer.get(), byteBuffer);
            }
            throw new MapyrusException(MapyrusMessages.get("invalidogcwkb") + ": " + string);
        }
        byte by = byteBuffer.get();
        if (by == BIG_ENDIAN) {
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
        } else if (by == LITTLE_ENDIAN) {
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            throw new MapyrusException(MapyrusMessages.get("invalidogcwkb") + ": " + WKBGeometryParser.convertToHexDigits(by, byteBuffer));
        }
        int n3 = byteBuffer.getInt();
        if (n3 == WKB_POINT) {
            dArray[n2++] = 100.0;
            dArray[n2++] = 1.0;
            dArray[n2++] = 0.0;
            dArray[n2++] = byteBuffer.getDouble();
            dArray[n2++] = byteBuffer.getDouble();
        } else if (n3 == WKB_LINESTRING) {
            dArray[n2++] = 101.0;
            int n4 = n2++;
            int n5 = byteBuffer.getInt();
            dArray[n4] = n5;
            boolean bl = false;
            for (int i = 0; i < n5; ++i) {
                dArray[n2++] = (double)bl;
                dArray[n2++] = byteBuffer.getDouble();
                dArray[n2++] = byteBuffer.getDouble();
                bl = true;
            }
        } else if (n3 == WKB_POLYGON) {
            dArray[n2++] = 102.0;
            int n6 = n2++;
            int n7 = 0;
            int n8 = byteBuffer.getInt();
            for (int i = 0; i < n8; ++i) {
                int n9 = byteBuffer.getInt();
                n7 += n9;
                boolean bl = false;
                for (int j = 0; j < n9; ++j) {
                    dArray[n2++] = (double)bl;
                    dArray[n2++] = byteBuffer.getDouble();
                    dArray[n2++] = byteBuffer.getDouble();
                    bl = true;
                }
            }
            dArray[n6] = n7;
        } else if (n3 == WKB_MULTIPOINT) {
            dArray[n2++] = 103.0;
            int n10 = n2++;
            int n11 = byteBuffer.getInt();
            dArray[n10] = n11;
            for (int i = 0; i < n11; ++i) {
                int n12 = WKBGeometryParser.parseGeometry(byteBuffer, dArray, n2);
                n2 += n12;
            }
        } else if (n3 == WKB_MULTILINESTRING) {
            dArray[n2++] = 104.0;
            int n13 = n2++;
            int n14 = byteBuffer.getInt();
            dArray[n13] = n14;
            for (int i = 0; i < n14; ++i) {
                int n15 = WKBGeometryParser.parseGeometry(byteBuffer, dArray, n2);
                n2 += n15;
            }
        } else if (n3 == WKB_MULTIPOLYGON) {
            dArray[n2++] = 105.0;
            int n16 = n2++;
            int n17 = byteBuffer.getInt();
            dArray[n16] = n17;
            for (int i = 0; i < n17; ++i) {
                int n18 = WKBGeometryParser.parseGeometry(byteBuffer, dArray, n2);
                n2 += n18;
            }
        } else if (n3 == WKB_GEOMETRY_COLLECTION) {
            dArray[n2++] = 106.0;
            int n19 = n2++;
            int n20 = byteBuffer.getInt();
            dArray[n19] = n20;
            for (int i = 0; i < n20; ++i) {
                int n21 = WKBGeometryParser.parseGeometry(byteBuffer, dArray, n2);
                n2 += n21;
            }
        } else {
            throw new MapyrusException(MapyrusMessages.get("invalidogcwkb") + ": " + WKBGeometryParser.convertToHexDigits(n3, byteBuffer));
        }
        return n2 - n;
    }

    public static double[] parse(byte[] byArray) throws MapyrusException {
        double[] dArray = new double[(byArray.length + 7) / 8 * 2];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        WKBGeometryParser.parseGeometry(byteBuffer, dArray, 0);
        return dArray;
    }
}

