/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.dataset;

import java.awt.geom.Point2D;
import java.sql.SQLException;
import java.util.ArrayList;
import oracle.spatial.geometry.JGeometry;
import oracle.sql.STRUCT;
import org.mapyrus.Argument;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;

public class OracleGeometry {
    private static final int INTERPRETATION_LINES = 1;
    private static final int INTERPRETATION_ARCS = 2;
    private static final int INTERPRETATION_RECTANGLE = 3;
    private static final int INTERPRETATION_CIRCLE = 4;

    public static Argument parseGeometry(Object object) throws SQLException, MapyrusException {
        STRUCT sTRUCT = (STRUCT)object;
        JGeometry jGeometry = JGeometry.load((STRUCT)sTRUCT);
        Argument argument = Argument.emptyGeometry;
        if (jGeometry.isPoint()) {
            double[] dArray = jGeometry.getPoint();
            if (dArray != null) {
                double[] dArray2 = new double[]{100.0, 1.0, 0.0, dArray[0], dArray[1]};
                argument = new Argument(100, dArray2);
            }
        } else if (jGeometry.isMultiPoint()) {
            Point2D[] point2DArray = jGeometry.getJavaPoints();
            if (point2DArray != null) {
                double[] dArray = new double[point2DArray.length * 5 + 2];
                dArray[0] = 103.0;
                dArray[1] = point2DArray.length;
                int n = 2;
                for (int i = 0; i < point2DArray.length; ++i) {
                    dArray[n++] = 100.0;
                    dArray[n++] = 1.0;
                    dArray[n++] = 0.0;
                    dArray[n++] = point2DArray[i].getX();
                    dArray[n++] = point2DArray[i].getY();
                }
                argument = new Argument(103, dArray);
            }
        } else {
            int[] nArray = jGeometry.getElemInfo();
            double[] dArray = jGeometry.getOrdinatesArray();
            argument = OracleGeometry.createGeometryArgument(nArray, dArray);
        }
        return argument;
    }

    private static Argument createGeometryArgument(int[] nArray, double[] dArray) throws MapyrusException {
        int n;
        int n2;
        Argument argument = Argument.emptyGeometry;
        ArrayList<double[]> arrayList = new ArrayList<double[]>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList<Argument> arrayList3 = new ArrayList<Argument>();
        for (int i = 0; i < nArray.length; i += 3) {
            double d;
            double d2;
            double d3;
            n2 = nArray[i] - 1;
            int n3 = i + 3 < nArray.length ? nArray[i + 3] - 1 : dArray.length;
            int n4 = nArray[i + 1];
            arrayList2.add(n4);
            n = nArray[i + 2];
            double[] dArray2 = null;
            if ((n4 %= 1000) == 3 && n == 3) {
                double d4 = dArray[n2];
                d3 = dArray[n2 + 1];
                d2 = dArray[n2 + 2];
                d = dArray[n2 + 3];
                dArray2 = new double[]{d4, d3, d2, d3, d2, d, d4, d, d4, d3};
            } else if (n4 == 3 && n == 4) {
                double d5 = dArray[n2];
                d3 = dArray[n2 + 1];
                d2 = dArray[n2 + 2];
                d = dArray[n2 + 3];
                double d6 = dArray[n2 + 4];
                double d7 = dArray[n2 + 5];
                double[] dArray3 = JGeometry.computeArc((double)d5, (double)d3, (double)d2, (double)d, (double)d6, (double)d7);
                dArray2 = new double[722];
                for (int j = 0; j <= 360; ++j) {
                    double d8 = Math.toRadians(j);
                    dArray2[j * 2] = dArray3[0] + Math.cos(d8) * dArray3[2];
                    dArray2[j * 2 + 1] = dArray3[1] + Math.sin(d8) * dArray3[2];
                }
            } else if ((n4 == 2 || n4 == 3) && n == 1) {
                dArray2 = new double[n3 - n2];
                for (int j = 0; j < dArray2.length; ++j) {
                    dArray2[j] = dArray[n2 + j];
                }
            } else {
                throw new MapyrusException(MapyrusMessages.get("unsupportedoracle") + ": " + nArray[i] + " " + nArray[i + 1] + " " + nArray[i + 2]);
            }
            arrayList.add(dArray2);
        }
        n2 = 0;
        while (n2 < arrayList.size()) {
            int n5;
            Integer n6 = (Integer)arrayList2.get(n2);
            double[] dArray4 = (double[])arrayList.get(n2);
            n = dArray4.length / 2;
            if (n6 == 2) {
                double[] dArray5 = new double[2 + n * 3];
                dArray5[0] = 101.0;
                dArray5[1] = n;
                int n7 = 2;
                for (n5 = 0; n5 < n; ++n5) {
                    dArray5[n7] = n5 == 0 ? 0.0 : 1.0;
                    dArray5[n7 + 1] = dArray4[n5 * 2];
                    dArray5[n7 + 2] = dArray4[n5 * 2 + 1];
                    n7 += 3;
                }
                arrayList3.add(new Argument(101, dArray5));
                ++n2;
                continue;
            }
            if (n6 != 1003) continue;
            for (int i = n2 + 1; i < arrayList.size() && (Integer)arrayList2.get(i) == 2003; ++i) {
                double[] dArray6 = (double[])arrayList.get(i);
                n += dArray6.length / 2;
            }
            double[] dArray7 = new double[2 + n * 3];
            dArray7[0] = 102.0;
            dArray7[1] = n;
            n5 = OracleGeometry.addPolygonCoords(dArray7, 2, dArray4);
            ++n2;
            while (n2 < arrayList.size() && (Integer)arrayList2.get(n2) == 2003) {
                double[] dArray8 = (double[])arrayList.get(n2);
                n5 = OracleGeometry.addPolygonCoords(dArray7, n5, dArray8);
                ++n2;
            }
            arrayList3.add(new Argument(102, dArray7));
        }
        if (arrayList3.size() > 1) {
            int n8 = 0;
            boolean bl = true;
            n = 1;
            for (int i = 0; i < arrayList3.size(); ++i) {
                Argument argument2 = (Argument)arrayList3.get(i);
                n8 += argument2.getGeometryValue().length;
                double d = argument2.getGeometryValue()[0];
                if (d != 101.0) {
                    bl = false;
                }
                if (d == 102.0) continue;
                n = 0;
            }
            double[] dArray9 = new double[2 + n8];
            dArray9[0] = bl ? 104.0 : (n != 0 ? 105.0 : 106.0);
            dArray9[1] = arrayList3.size();
            int n9 = 2;
            for (int i = 0; i < arrayList3.size(); ++i) {
                Argument argument3 = (Argument)arrayList3.get(i);
                double[] dArray10 = argument3.getGeometryValue();
                for (int j = 0; j < dArray10.length; ++j) {
                    dArray9[n9++] = dArray10[j];
                }
            }
            argument = new Argument(106, dArray9);
        } else {
            argument = (Argument)arrayList3.get(0);
        }
        return argument;
    }

    private static int addPolygonCoords(double[] dArray, int n, double[] dArray2) {
        for (int i = 0; i < dArray2.length; i += 2) {
            dArray[n] = i == 0 ? 0.0 : 1.0;
            int n2 = ++n;
            dArray[n2] = dArray2[i];
            int n3 = ++n;
            ++n;
            dArray[n3] = dArray2[i + 1];
        }
        return n;
    }
}

