/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.function;

import java.io.IOException;
import java.util.ArrayList;
import org.mapyrus.Argument;
import org.mapyrus.ContextStack;
import org.mapyrus.Interpreter;
import org.mapyrus.MapyrusException;
import org.mapyrus.Statement;
import org.mapyrus.function.Function;

public class UserFunction
implements Function {
    private String m_funcName;
    private ArrayList m_formalParameters;
    private ArrayList m_statements;
    private Interpreter m_interpreter;

    public UserFunction(String string, ArrayList arrayList, ArrayList arrayList2, Interpreter interpreter) {
        this.m_funcName = string;
        this.m_formalParameters = arrayList;
        this.m_statements = arrayList2;
        this.m_interpreter = interpreter;
    }

    public Argument evaluate(ContextStack contextStack, ArrayList arrayList) throws MapyrusException, InterruptedException {
        Argument argument = null;
        boolean bl = false;
        try {
            Object object;
            int n;
            contextStack.saveState(this.m_funcName);
            bl = true;
            for (n = 0; n < arrayList.size(); ++n) {
                object = (String)this.m_formalParameters.get(n);
                contextStack.setLocalScope((String)object);
                Argument argument2 = (Argument)arrayList.get(n);
                contextStack.defineVariable((String)object, argument2);
            }
            for (n = 0; n < this.m_statements.size(); ++n) {
                object = (Statement)this.m_statements.get(n);
                argument = this.m_interpreter.executeStatement((Statement)object);
                if (argument == null) continue;
                break;
            }
        }
        catch (IOException iOException) {
            throw new MapyrusException(iOException.getMessage());
        }
        finally {
            try {
                if (bl) {
                    contextStack.restoreState();
                }
            }
            catch (IOException iOException) {
                throw new MapyrusException(iOException.getMessage());
            }
        }
        if (argument == null) {
            argument = Argument.emptyString;
        }
        return argument;
    }

    public int getMaxArgumentCount() {
        return this.m_formalParameters.size();
    }

    public int getMinArgumentCount() {
        return this.m_formalParameters.size();
    }

    public String getName() {
        return this.m_funcName;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.m_funcName);
        stringBuffer.append(" ");
        for (int i = 0; i < this.m_formalParameters.size(); ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.m_formalParameters.get(i));
        }
        return stringBuffer.toString();
    }

    public void setStatements(ArrayList arrayList) {
        this.m_statements = arrayList;
    }

    public UserFunction clone(Interpreter interpreter) {
        UserFunction userFunction = new UserFunction(this.m_funcName, this.m_formalParameters, this.m_statements, interpreter);
        return userFunction;
    }
}

